/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceCellRenderer;
import com.ibm.as400.vaccess.ResourceHeaderRenderer;
import com.ibm.as400.vaccess.ResourceListDetailsModel;
import com.ibm.as400.vaccess.ResourceListPopupMenuAdapter;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ResourceListDetailsPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String ACTION_PROPERTIES_ = ResourceLoader.getText("ACTION_PROPERTIES");
    private static final String ACTION_LIST_PROPERTIES_ = ResourceLoader.getText("ACTION_LIST_PROPERTIES");
    private boolean allowActions_ = true;
    private ResourceListDetailsModel model_ = null;
    private ResourceProperties resourceProperties_ = null;
    private transient JScrollPane scrollPane_ = null;
    private transient JTable table_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    private transient ListSelectionEventSupport listSelectionEventSupport_;
    private transient ResourceListPopupMenuAdapter popupMenuAdapter_;
    private transient PropertyChangeSupport propertyChangeSupport_;

    public ResourceListDetailsPane() {
        this.initializeCommon();
        this.resourceProperties_ = new ResourceProperties();
    }

    public ResourceListDetailsPane(ResourceList resourceList, Object[] objectArray, ResourceProperties resourceProperties) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        if (objectArray == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        if (resourceProperties == null) {
            throw new NullPointerException("resourceProperties");
        }
        this.initializeCommon();
        this.resourceProperties_ = resourceProperties;
        this.model_.setResourceList(resourceList);
        this.model_.setColumnAttributeIDs(objectArray);
        this.refreshColumns();
        this.popupMenuAdapter_.setResourceList(resourceList);
        this.popupMenuAdapter_.setResourceProperties(resourceProperties);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionEventSupport_.addListSelectionListener(listSelectionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public boolean getAllowActions() {
        return this.allowActions_;
    }

    public Object[] getColumnAttributeIDs() {
        return this.model_.getColumnAttributeIDs();
    }

    public TableColumnModel getColumnModel() {
        return this.table_.getColumnModel();
    }

    public TableModel getModel() {
        return this.model_;
    }

    public Resource getResourceAtPoint(Point point) {
        Resource resource = null;
        int n = this.table_.rowAtPoint(point);
        if (n != -1) {
            resource = this.model_.getResourceAt(n);
        }
        return resource;
    }

    public ResourceList getResourceList() {
        return this.model_.getResourceList();
    }

    public ResourceProperties getResourceProperties() {
        return this.resourceProperties_;
    }

    public Resource getSelectedResource() {
        Resource resource = null;
        int[] nArray = this.table_.getSelectedRows();
        if (nArray.length > 0) {
            resource = this.model_.getResourceAt(nArray[0]);
        }
        return resource;
    }

    public Resource[] getSelectedResources() {
        int[] nArray = this.table_.getSelectedRows();
        Resource[] resourceArray = new Resource[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            resourceArray[i] = this.model_.getResourceAt(nArray[i]);
        }
        return resourceArray;
    }

    public ListSelectionModel getSelectionModel() {
        return this.table_.getSelectionModel();
    }

    private void initializeCommon() {
        this.model_ = new ResourceListDetailsModel();
        this.initializeTransient();
        this.setAllowActions(true);
    }

    private void initializeTransient() {
        this.addFocusListener(new SerializationListener(this));
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listSelectionEventSupport_ = new ListSelectionEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.table_ = new JTable(this.model_);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setAutoResizeMode(0);
        this.table_.setColumnSelectionAllowed(false);
        this.table_.setRowSelectionAllowed(true);
        this.table_.setShowGrid(false);
        this.model_.addErrorListener(this.errorEventSupport_);
        this.model_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.table_.getSelectionModel().addListSelectionListener(this.listSelectionEventSupport_);
        this.setLayout(new BorderLayout());
        this.scrollPane_ = new JScrollPane(this.table_);
        this.add("Center", this.scrollPane_);
        this.table_.setDoubleBuffered(true);
        this.scrollPane_.getViewport().setBackingStoreEnabled(true);
        this.scrollPane_.setDoubleBuffered(true);
        this.scrollPane_.getViewport().setDoubleBuffered(true);
        this.scrollPane_.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        this.popupMenuAdapter_ = new ResourceListPopupMenuAdapter(this, this.model_.getResourceList(), this.resourceProperties_, this.errorEventSupport_);
        this.model_.addWorkingListener(new WorkingCursorAdapter(this.table_));
        this.setAllowActions(this.allowActions_);
    }

    public boolean isSelected(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        int[] nArray = this.table_.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            Resource resource2 = this.model_.getResourceAt(nArray[i]);
            if (resource2 == null || !resource2.equals(resource)) continue;
            return true;
        }
        return false;
    }

    public void load() {
        this.table_.clearSelection();
        this.model_.load();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    private void refreshColumns() {
        Object object;
        Serializable serializable;
        TableColumnModel tableColumnModel = this.table_.getColumnModel();
        Vector<TableColumn> vector = new Vector<TableColumn>();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumnModel.removeColumn(tableColumn);
        }
        enumeration = this.getColumnAttributeIDs();
        if (enumeration != null) {
            for (int i = 0; i < ((Enumeration<TableColumn>)enumeration).length; ++i) {
                block10: {
                    serializable = null;
                    if (enumeration[i] != null) {
                        try {
                            serializable = this.getResourceList().getAttributeMetaData(enumeration[i]);
                        }
                        catch (Exception exception) {
                            if (!Trace.isTraceErrorOn()) break block10;
                            Trace.log(2, "Column attribute ID not valid:" + enumeration[i], (Throwable)exception);
                        }
                    }
                }
                object = new VTableColumn(i, enumeration[i]);
                ((TableColumn)object).setCellRenderer(new ResourceCellRenderer((ResourceMetaData)serializable));
                ((TableColumn)object).setHeaderValue(this.model_.getColumnName(i));
                ((TableColumn)object).setHeaderRenderer(new ResourceHeaderRenderer((ResourceMetaData)serializable));
                ((VTableColumn)object).setPreferredCharWidth(15);
                tableColumnModel.addColumn((TableColumn)object);
            }
        }
        int n = 0;
        serializable = this.table_.getFont();
        if (serializable != null) {
            n = this.table_.getFontMetrics((Font)serializable).charWidth('M');
        }
        if (n > 0) {
            object = this.table_.getColumnModel();
            int n2 = object.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                TableColumn tableColumn = object.getColumn(i);
                tableColumn.setPreferredWidth(this.model_.getColumnWidth(i) * n + 10);
            }
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionEventSupport_.removeListSelectionListener(listSelectionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAllowActions(boolean bl) {
        Boolean bl2 = new Boolean(this.allowActions_);
        this.allowActions_ = bl;
        if (this.allowActions_) {
            this.scrollPane_.getViewport().addMouseListener(this.popupMenuAdapter_);
            this.table_.addMouseListener(this.popupMenuAdapter_);
        } else {
            this.scrollPane_.getViewport().removeMouseListener(this.popupMenuAdapter_);
            this.table_.removeMouseListener(this.popupMenuAdapter_);
        }
        this.propertyChangeSupport_.firePropertyChange("allowActions", bl2, new Boolean(bl));
    }

    public void setColumnAttributeIDs(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        this.table_.clearSelection();
        this.model_.setColumnAttributeIDs(objectArray);
        this.refreshColumns();
    }

    public void setResourceList(ResourceList resourceList) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        this.table_.clearSelection();
        this.model_.setResourceList(resourceList);
        this.refreshColumns();
        this.popupMenuAdapter_.setResourceList(resourceList);
    }

    public void setResourceProperties(ResourceProperties resourceProperties) {
        if (resourceProperties == null) {
            throw new NullPointerException("resourceProperties");
        }
        ResourceProperties resourceProperties2 = this.resourceProperties_;
        this.resourceProperties_ = resourceProperties;
        this.popupMenuAdapter_.setResourceProperties(resourceProperties);
        this.propertyChangeSupport_.firePropertyChange("resourceProperties", resourceProperties2, resourceProperties);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new NullPointerException("selectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.table_.getSelectionModel();
        if (listSelectionModel2 != null) {
            listSelectionModel2.removeListSelectionListener(this.listSelectionEventSupport_);
        }
        this.table_.setSelectionModel(listSelectionModel);
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this.listSelectionEventSupport_);
        }
    }
}

