/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.CommTraceListener;
import com.ibm.as400.util.commtrace.CommTracePropertyListener;
import com.ibm.as400.util.commtrace.FormatDisplay;
import com.ibm.as400.util.commtrace.FormatRemote;
import com.ibm.as400.util.commtrace.Read;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import com.ibm.as400.vaccess.FileFilter;
import com.ibm.as400.vaccess.IFSFileDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CommTrace
extends WindowAdapter {
    private AS400 sys_;
    private FormatDisplay format;
    private static JFrame MainFrame_;
    private static Locale currentLocale_;
    private static final String ALL = "*ALL";
    private static final String YES = "*YES";
    private static final String VERSION = "1.0";
    private static final String CLASS = "CommTrace";
    private static final String NO = "*NO";
    private String path;
    private String verbose_;
    private String[] pargs;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private JOptionPane optionPane;
    private JDialog dialog;
    private JTextField[] args;
    private JCheckBox fmtbox_;
    private String btnString1;
    private String btnString2;
    private JMenuItem disconnect;
    private JMenuItem exit;
    private JMenuItem display;
    private JMenuItem transfer;
    private JMenuItem mformat;
    private JMenuItem about;
    private JFrame fabout;
    private JButton aokay;
    private JButton[] b = new JButton[5];
    static final int TRANSFER = 0;
    static final int FORMAT = 1;
    static final int OPEN = 2;
    static final int FMTRMT = 3;
    static final int OPENRMT = 4;
    private JRadioButton remote;
    private JRadioButton local;
    private FormatRemote fmtcl = null;

    public CommTrace(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        vector.addElement("-verbose");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("-v", "-verbose");
        CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray, vector, hashtable);
        this.verbose_ = commandLineArguments.getOptionValue("-verbose");
        if (this.verbose_ == null) {
            this.verbose_ = "false";
        }
        if (this.verbose_ != null && this.verbose_.equals("true")) {
            Trace.setTraceErrorOn(true);
            Trace.setTraceWarningOn(true);
            Trace.setTraceInformationOn(true);
            Trace.setTraceOn(true);
        }
        this.pargs = stringArray;
        MainFrame_ = new JFrame(CLASS);
        this.gridbag = new GridBagLayout();
        MainFrame_.getContentPane().setLayout(this.gridbag);
        this.c = new GridBagConstraints();
        MainFrame_.setFont(new Font("Helvetica", 0, 14));
        this.createMenu();
        this.createPanels();
        MainFrame_.setBackground(Color.black);
        MainFrame_.setForeground(Color.white);
        MainFrame_.addWindowListener(this);
        MainFrame_.setSize(525, 300);
        MainFrame_.setVisible(true);
    }

    private void addbutton(int n, String string, GridBagConstraints gridBagConstraints, JPanel jPanel) {
        this.b[n] = new JButton(string);
        this.b[n].setBackground(Color.black);
        this.b[n].setForeground(Color.white);
        this.b[n].addActionListener(new CommTraceListener(this));
        this.b[n].addKeyListener(new CommTraceListener(this));
        this.gridbag.setConstraints(this.b[n], gridBagConstraints);
        jPanel.add(this.b[n]);
    }

    private void createPanels() {
        JPanel jPanel = new JPanel();
        this.gridbag = new GridBagLayout();
        jPanel.setLayout(this.gridbag);
        this.c.fill = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridheight = 7;
        this.c.insets = new Insets(3, 3, 3, 3);
        this.c.gridwidth = 0;
        this.c.anchor = 10;
        this.gridbag.setConstraints(jPanel, this.c);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.remote = new JRadioButton(ResourceBundleLoader_ct.getText("Remote"));
        this.remote.addActionListener(new CommTraceListener(this));
        this.local = new JRadioButton(ResourceBundleLoader_ct.getText("Local"));
        this.local.addActionListener(new CommTraceListener(this));
        this.local.setSelected(true);
        buttonGroup.add(this.local);
        buttonGroup.add(this.remote);
        this.gridbag.setConstraints(this.local, this.c);
        jPanel.add(this.local);
        this.c.gridwidth = -1;
        this.c.fill = 2;
        this.addbutton(0, ResourceBundleLoader_ct.getText("Transfer"), this.c, jPanel);
        this.c.gridwidth = 0;
        JLabel jLabel = new JLabel(ResourceBundleLoader_ct.getText("TransferDescription"));
        this.gridbag.setConstraints(jLabel, this.c);
        jPanel.add(jLabel);
        this.c.gridwidth = -1;
        this.addbutton(2, ResourceBundleLoader_ct.getText("Display"), this.c, jPanel);
        this.c.gridwidth = 0;
        JLabel jLabel2 = new JLabel(ResourceBundleLoader_ct.getText("DisplayButtonDescription"));
        this.gridbag.setConstraints(jLabel2, this.c);
        jPanel.add(jLabel2);
        this.c.gridwidth = -1;
        this.addbutton(1, ResourceBundleLoader_ct.getText("Format"), this.c, jPanel);
        this.c.gridwidth = 0;
        JLabel jLabel3 = new JLabel(ResourceBundleLoader_ct.getText("FormatDescription"));
        this.gridbag.setConstraints(jLabel3, this.c);
        jPanel.add(jLabel3);
        this.gridbag.setConstraints(this.remote, this.c);
        jPanel.add(this.remote);
        this.c.gridwidth = -1;
        this.addbutton(4, ResourceBundleLoader_ct.getText("Display"), this.c, jPanel);
        this.c.gridwidth = 0;
        JLabel jLabel4 = new JLabel(ResourceBundleLoader_ct.getText("DisplayRemoteDescription"));
        this.gridbag.setConstraints(jLabel4, this.c);
        jPanel.add(jLabel4);
        this.c.gridwidth = -1;
        this.addbutton(3, ResourceBundleLoader_ct.getText("Format"), this.c, jPanel);
        this.c.gridwidth = 0;
        JLabel jLabel5 = new JLabel(ResourceBundleLoader_ct.getText("FormatRemoteDescription"));
        this.gridbag.setConstraints(jLabel5, this.c);
        jPanel.add(jLabel5);
        this.b[3].setEnabled(false);
        this.b[4].setEnabled(false);
        MainFrame_.getContentPane().add(jPanel);
    }

    private void createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(ResourceBundleLoader_ct.getText("File"));
        JMenu jMenu2 = new JMenu(ResourceBundleLoader_ct.getText("Commtrace"));
        JMenu jMenu3 = new JMenu(ResourceBundleLoader_ct.getText("Help"));
        jMenu.setMnemonic(70);
        this.disconnect = new JMenuItem(ResourceBundleLoader_ct.getText("Disconnect"), 68);
        this.disconnect.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.exit = new JMenuItem(ResourceBundleLoader_ct.getText("Exit"), 81);
        this.exit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.display = new JMenuItem(ResourceBundleLoader_ct.getText("Display"), 77);
        this.display.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.transfer = new JMenuItem(ResourceBundleLoader_ct.getText("Transfer"), 84);
        this.transfer.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.mformat = new JMenuItem(ResourceBundleLoader_ct.getText("Format"), 82);
        this.mformat.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.about = new JMenuItem(ResourceBundleLoader_ct.getText("AboutCommtrace"));
        jMenu.add(this.disconnect);
        this.disconnect.addActionListener(new CommTraceListener(this));
        jMenu.add(this.exit);
        this.exit.addActionListener(new CommTraceListener(this));
        jMenu2.add(this.transfer);
        this.transfer.addActionListener(new CommTraceListener(this));
        jMenu2.add(this.display);
        this.display.addActionListener(new CommTraceListener(this));
        jMenu2.add(this.mformat);
        this.mformat.addActionListener(new CommTraceListener(this));
        jMenu3.add(this.about);
        this.about.addActionListener(new CommTraceListener(this));
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        MainFrame_.setJMenuBar(jMenuBar);
    }

    String isVerbose() {
        return this.verbose_;
    }

    static JFrame getMainFrame() {
        return MainFrame_;
    }

    void about() {
        this.fabout = new JFrame(ResourceBundleLoader_ct.getText("About"));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(ResourceBundleLoader_ct.getText("Commtrace"));
        jLabel.setFont(new Font("Helvetica", 1, 18));
        JLabel jLabel2 = new JLabel(ResourceBundleLoader_ct.getText("Version") + " " + VERSION);
        jLabel2.setFont(new Font("Helvetica", 0, 12));
        JLabel jLabel3 = new JLabel(ResourceBundleLoader_ct.getText("Copyright"));
        jLabel3.setFont(new Font("Helvetica", 0, 12));
        this.gridbag = new GridBagLayout();
        jPanel.setLayout(this.gridbag);
        this.c = new GridBagConstraints();
        this.aokay = new JButton(ResourceBundleLoader_ct.getText("OK"));
        this.c.gridwidth = 0;
        this.c.gridheight = -1;
        this.c.gridheight = 1;
        this.gridbag.setConstraints(jLabel, this.c);
        jPanel.add(jLabel);
        this.c.gridwidth = 0;
        this.c.gridheight = -1;
        this.c.gridheight = 1;
        this.gridbag.setConstraints(jLabel2, this.c);
        jPanel.add(jLabel2);
        this.c.gridwidth = 0;
        this.c.gridheight = -1;
        this.c.gridheight = 1;
        this.gridbag.setConstraints(jLabel3, this.c);
        jPanel.add(jLabel3);
        this.c.gridheight = 1;
        this.c.gridwidth = 0;
        this.c.gridheight = -1;
        this.gridbag.setConstraints(this.aokay, this.c);
        jPanel.add(this.aokay);
        this.aokay.addActionListener(new CommTraceListener(this));
        this.fabout.getContentPane().add(jPanel);
        this.fabout.addWindowListener(this);
        this.fabout.setSize(300, 120);
        this.fabout.setVisible(true);
        this.fabout.invalidate();
        this.fabout.validate();
        this.fabout.repaint();
    }

    void disconnect() {
        this.sys_.disconnectAllServices();
        this.sys_ = null;
    }

    void transfer() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "CommTrace.transfer() Transfering file");
        }
        if (this.sys_ == null) {
            this.sys_ = new AS400();
        }
        IFSFileDialog iFSFileDialog = new IFSFileDialog((Frame)new JFrame(), "File Open", this.sys_);
        FileFilter[] fileFilterArray = new FileFilter[]{new FileFilter(ResourceBundleLoader_ct.getText("AllFiles"), "*.*")};
        iFSFileDialog.setFileFilter(fileFilterArray, 0);
        if (this.path != null) {
            iFSFileDialog.setDirectory(this.path);
        }
        String string = "";
        if (iFSFileDialog.showDialog() == 1) {
            this.path = iFSFileDialog.getDirectory();
            string = iFSFileDialog.getAbsolutePath();
            FileDialog fileDialog = new FileDialog((Frame)MainFrame_, ResourceBundleLoader_ct.getText("SaveAs"), 1);
            fileDialog.setFile(iFSFileDialog.getFileName());
            fileDialog.show();
            String string2 = fileDialog.getDirectory();
            String string3 = fileDialog.getFile();
            if (string3 != null) {
                Read read = new Read(this, string, string2 + string3, this.sys_);
                Thread thread = new Thread((Runnable)read, "Read");
                read.setThread(thread);
                thread.start();
            }
        }
    }

    void open() {
        if (this.format != null) {
            this.format.setThread(null);
            this.format.close();
        }
        if (this.local.isSelected()) {
            this.format = new FormatDisplay("", "", "", "", 1);
        } else if (this.remote.isSelected()) {
            if (this.sys_ == null) {
                this.sys_ = new AS400();
            }
            this.format = this.fmtcl != null ? new FormatDisplay(this.fmtcl.getPath(), this.fmtcl.getFile(), this.sys_, 2) : new FormatDisplay("", "", this.sys_, 2);
        } else {
            Trace.log(2, "CommTrace.open() Neither 'local' nor 'remote' is selected.");
            throw new InternalErrorException(6);
        }
        Thread thread = new Thread((Runnable)this.format, "Format");
        this.format.setThread(thread);
        thread.start();
    }

    void formatoptions() {
        this.args = new JTextField[3];
        this.args[0] = new JTextField(ALL);
        this.args[1] = new JTextField(ALL);
        this.args[2] = new JTextField(ALL);
        this.fmtbox_ = new JCheckBox(ResourceBundleLoader_ct.getText("FmtBdcst"));
        this.fmtbox_.setSelected(true);
        this.btnString1 = ResourceBundleLoader_ct.getText("Format");
        this.btnString2 = ResourceBundleLoader_ct.getText("Cancel");
        Object[] objectArray = new Object[]{ResourceBundleLoader_ct.getText("Src/DestIPAddr"), this.args[0], ResourceBundleLoader_ct.getText("Src/DestIPAddr"), this.args[1], ResourceBundleLoader_ct.getText("IPPortnum"), this.args[2], this.fmtbox_};
        String string = "";
        Object[] objectArray2 = new Object[]{this.btnString1, this.btnString2};
        this.optionPane = new JOptionPane(objectArray, 3, 0, null, objectArray2, objectArray2[0]);
        this.dialog = new JDialog(MainFrame_, ResourceBundleLoader_ct.getText("FormatOpt"), true);
        this.dialog.setContentPane(this.optionPane);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CommTrace.this.optionPane.setValue(new Integer(-1));
            }
        });
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CommTrace.this.optionPane.setValue(CommTrace.this.btnString1);
                }
            });
        }
        this.optionPane.addPropertyChangeListener(new CommTracePropertyListener(this));
        this.dialog.setFont(new Font("Helvetica", 0, 14));
        this.dialog.setResizable(false);
        this.dialog.addWindowListener(this);
        this.dialog.setSize(300, 300);
        this.dialog.show();
    }

    void formatremote() {
        if (this.sys_ == null) {
            this.sys_ = new AS400();
        }
        String string = this.fmtbox_.isSelected() ? YES : NO;
        this.fmtcl = new FormatRemote(this.sys_, this.verbose_, this.args[0].getText(), this.args[1].getText(), this.args[2].getText(), string, this);
        this.fmtcl.setThread(new Thread((Runnable)this.fmtcl, "FormatClient"));
        this.fmtcl.getThread().start();
    }

    void format() {
        if (this.format != null) {
            this.format.setThread(null);
            this.format.close();
        }
        String string = this.fmtbox_.isSelected() ? YES : NO;
        this.format = new FormatDisplay(this.args[0].getText(), this.args[1].getText(), this.args[2].getText(), string, 3);
        Thread thread = new Thread((Runnable)this.format, "Format");
        this.format.setThread(thread);
        thread.start();
    }

    void exit() {
        if (this.format != null) {
            this.format.close();
        }
        System.exit(0);
    }

    void framerepaint() {
        MainFrame_.invalidate();
        MainFrame_.validate();
        MainFrame_.repaint();
    }

    static void error(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 0);
    }

    static void error(String string, String string2) {
        JOptionPane.showMessageDialog(MainFrame_, string2, string, 0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object == MainFrame_) {
            this.exit();
        } else if (object == this.fabout) {
            this.fabout.setVisible(false);
        }
    }

    JOptionPane getOptionPane() {
        return this.optionPane;
    }

    JDialog getDialog() {
        return this.dialog;
    }

    JTextField[] getArguments() {
        return this.args;
    }

    String getButtonString1() {
        return this.btnString1;
    }

    String getButtonString2() {
        return this.btnString2;
    }

    JMenuItem getDisconnectMenuItem() {
        return this.disconnect;
    }

    JMenuItem getExitMenuItem() {
        return this.exit;
    }

    JMenuItem getDisplayMenuItem() {
        return this.display;
    }

    JMenuItem getTransferMenuItem() {
        return this.transfer;
    }

    JMenuItem getFormatMenuItem() {
        return this.mformat;
    }

    JMenuItem getAboutMenuItem() {
        return this.about;
    }

    JFrame getAboutFrame() {
        return this.fabout;
    }

    JButton getAboutOkayButton() {
        return this.aokay;
    }

    JButton[] getButtons() {
        return this.b;
    }

    JRadioButton getRemoteButton() {
        return this.remote;
    }

    JRadioButton getLocalButton() {
        return this.local;
    }

    void setFormatRemote(FormatRemote formatRemote) {
        this.fmtcl = formatRemote;
    }

    public static void main(String[] stringArray) {
        CommTrace commTrace = new CommTrace(stringArray);
    }
}

