/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlMessageLog;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlStruct;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class PcmlProgram
extends PcmlDocNode {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 7278339230268347333L;
    private static final String[] PROGRAMATTRIBUTES = new String[]{"name", "path", "parseorder", "entrypoint", "returnvalue", "threadsafe", "epccsid"};
    private static final int VERSION_1_ATTRIBUTE_COUNT = 3;
    private static final int VERSION_2_ATTRIBUTE_COUNT = 5;
    private static final int VERSION_3_ATTRIBUTE_COUNT = 6;
    private static final int VERSION_4_ATTRIBUTE_COUNT = 7;
    private String m_Path;
    private String m_Parseorder;
    private String m_EntrypointStr;
    private String m_ReturnvalueStr;
    private String m_ThreadsafeStr;
    private boolean m_ThreadsafeOverride;
    private boolean m_ThreadsafeOverrideCalled;
    private String m_EpCcsidStr;
    private int m_EpCcsid;
    private ProgramCall m_pgmCall;
    private boolean m_pgmRc;
    private int m_pgmCCSID;
    private AS400Message[] msgList;
    private int m_IntReturnValue;
    private int m_Errno;

    public PcmlProgram() {
        this.m_pgmRc = false;
        this.m_pgmCCSID = -1;
        this.msgList = null;
        this.m_IntReturnValue = 0;
        this.m_Errno = 0;
        this.m_ThreadsafeOverrideCalled = false;
    }

    public PcmlProgram(PcmlAttributeList pcmlAttributeList) {
        super(pcmlAttributeList);
        this.setNodeType(2);
        this.m_pgmRc = false;
        this.m_pgmCCSID = -1;
        this.msgList = null;
        this.m_IntReturnValue = 0;
        this.m_Errno = 0;
        this.m_ThreadsafeOverrideCalled = false;
        this.setPath(this.getAttributeValue("path"));
        this.setParseorder(this.getAttributeValue("parseorder"));
        this.setEntrypoint(this.getAttributeValue("entrypoint"));
        this.setReturnvalue(this.getAttributeValue("returnvalue"));
        this.setThreadsafe(this.getAttributeValue("threadsafe"));
        this.setEpCcsid(this.getAttributeValue("epccsid"));
    }

    public Object clone() {
        PcmlProgram pcmlProgram = (PcmlProgram)super.clone();
        pcmlProgram.m_pgmRc = false;
        pcmlProgram.m_pgmCCSID = -1;
        pcmlProgram.msgList = null;
        pcmlProgram.m_IntReturnValue = 0;
        pcmlProgram.m_Errno = 0;
        return pcmlProgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        PcmlProgram pcmlProgram = this;
        synchronized (pcmlProgram) {
            boolean bl = this.m_pgmRc;
            int n = this.m_pgmCCSID;
            AS400Message[] aS400MessageArray = this.msgList;
            int n2 = this.m_IntReturnValue;
            int n3 = this.m_Errno;
            if (!this.getDoc().isSerializingWithData()) {
                this.m_pgmRc = false;
                this.m_pgmCCSID = -1;
                this.msgList = null;
                this.m_IntReturnValue = 0;
                this.m_Errno = 0;
            }
            objectOutputStream.defaultWriteObject();
            this.m_pgmRc = bl;
            this.m_pgmCCSID = n;
            this.msgList = aS400MessageArray;
            this.m_IntReturnValue = n2;
            this.m_Errno = n3;
        }
    }

    String getEntrypoint() {
        return this.m_EntrypointStr;
    }

    String getPath() {
        if (this.m_Path != null) {
            return this.m_Path;
        }
        return "/QSYS.LIB/" + this.getName() + ".PGM";
    }

    String getParseorder() {
        return this.m_Parseorder;
    }

    String getReturnvalue() {
        return this.m_ReturnvalueStr;
    }

    String getThreadsafe() {
        return this.m_ThreadsafeStr;
    }

    int getEpCcsid() {
        return this.m_EpCcsid;
    }

    String[] getAttributeList() {
        int n = 0;
        if (this.getDoc().getVersion().compareTo("2.0") < 0) {
            n = 3;
        } else if (this.getDoc().getVersion().compareTo("3.0") < 0) {
            n = 5;
        } else if (this.getDoc().getVersion().compareTo("4.0") < 0) {
            n = 6;
        } else {
            return PROGRAMATTRIBUTES;
        }
        String[] stringArray = new String[n];
        System.arraycopy(PROGRAMATTRIBUTES, 0, stringArray, 0, n);
        return stringArray;
    }

    boolean getThreadsafeOverride() {
        return this.m_ThreadsafeOverride;
    }

    void setEntrypoint(String string) {
        if (string == null || string.equals("")) {
            this.m_EntrypointStr = null;
            return;
        }
        this.m_EntrypointStr = string;
    }

    void setEpCcsid(String string) {
        if (string == null || string.equals("")) {
            this.m_EpCcsidStr = null;
            this.m_EpCcsid = 0;
            return;
        }
        this.m_EpCcsidStr = string;
        this.m_EpCcsid = Integer.parseInt(string);
    }

    void setPath(String string) {
        this.m_Path = string;
    }

    void setParseorder(String string) {
        if (string == null || string.equals("")) {
            this.m_Parseorder = null;
            return;
        }
        this.m_Parseorder = string;
    }

    ProgramCall getProgramCall() {
        return this.m_pgmCall;
    }

    void setReturnvalue(String string) {
        if (string == null || string.equals("")) {
            this.m_ReturnvalueStr = null;
            return;
        }
        this.m_ReturnvalueStr = string;
    }

    void setThreadsafe(String string) {
        if (string == null || string.equals("")) {
            this.m_ThreadsafeStr = null;
            this.m_ThreadsafeOverride = false;
            return;
        }
        this.m_ThreadsafeOverride = string.equals("true");
        this.m_ThreadsafeStr = string;
    }

    void setThreadsafeOverride(boolean bl) {
        this.m_ThreadsafeOverrideCalled = true;
        this.m_ThreadsafeOverride = bl;
    }

    protected void checkAttributes() {
        super.checkAttributes();
        String string = this.getParseorder();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = this.getQualifiedName() + "." + string2;
                PcmlNode pcmlNode = this.getRootNode().getElement(string3);
                if (pcmlNode == null) {
                    this.getDoc().addPcmlSpecificationError("PARSEORDER_NOT_FOUND", new Object[]{PcmlProgram.makeQuotedAttr("parseorder", string), string3, this.getBracketedTagName(), this.getNameForException()});
                    continue;
                }
                if (pcmlNode.getParent() == this) continue;
                this.getDoc().addPcmlSpecificationError("PARSEORDER_NOT_CHILD", new Object[]{PcmlProgram.makeQuotedAttr("parseorder", string), string3, this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_EntrypointStr != null && this.getDoc().getVersion().compareTo("2.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlProgram.makeQuotedAttr("entrypoint", this.m_EntrypointStr), "2.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_ReturnvalueStr != null && this.getDoc().getVersion().compareTo("2.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlProgram.makeQuotedAttr("returnvalue", this.m_ReturnvalueStr), "2.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_ThreadsafeStr != null && this.getDoc().getVersion().compareTo("3.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlProgram.makeQuotedAttr("threadsafe", this.m_ThreadsafeStr), "3.0", this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_EpCcsidStr != null && this.getDoc().getVersion().compareTo("4.0") < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_PCML_VERSION", new Object[]{PcmlProgram.makeQuotedAttr("epccsid", this.m_EpCcsidStr), "4.0", this.getBracketedTagName(), this.getNameForException()});
        }
    }

    public boolean callProgram(AS400 aS400) throws AS400SecurityException, ObjectDoesNotExistException, InterruptedException, ErrorCompletingRequestException, IOException, PcmlException {
        String string;
        byte[] byArray;
        PcmlDocNode pcmlDocNode;
        PcmlDimensions pcmlDimensions = new PcmlDimensions();
        Hashtable hashtable = new Hashtable();
        if (this.getReturnvalue() != null && !this.getPath().toUpperCase().endsWith(".SRVPGM")) {
            throw new PcmlException("NOT_SRVPGM", new Object[]{PcmlProgram.makeQuotedAttr("returnvalue", this.m_ReturnvalueStr), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.getPath().toUpperCase().endsWith(".SRVPGM")) {
            if (this.getEntrypoint() == null) {
                throw new PcmlException("NO_ENTRYPOINT", new Object[]{PcmlProgram.makeQuotedAttr("entrypoint", this.m_EntrypointStr), this.getBracketedTagName(), this.getNameForException()});
            }
            if (this.getNbrChildren() > 7) {
                throw new PcmlException("TOO_MANY_PARMS", new Object[]{PcmlProgram.makeQuotedAttr("entrypoint", this.m_EntrypointStr), new Integer(7), this.getBracketedTagName(), this.getNameForException()});
            }
        } else if (this.getEntrypoint() != null) {
            throw new PcmlException("NOT_SRVPGM", new Object[]{PcmlProgram.makeQuotedAttr("entrypoint", this.m_EntrypointStr), this.getBracketedTagName(), this.getNameForException()});
        }
        this.m_pgmRc = false;
        this.msgList = null;
        this.m_IntReturnValue = 0;
        this.m_Errno = 0;
        this.m_pgmCCSID = aS400.getCcsid();
        int n = 0;
        Enumeration enumeration = this.getChildren();
        int n2 = 0;
        int n3 = 2;
        ProgramParameter[] programParameterArray = new ProgramParameter[this.getNbrChildren()];
        while (enumeration.hasMoreElements()) {
            pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
            int n4 = pcmlDocNode.getUsage();
            int n5 = 0;
            boolean bl = false;
            byArray = null;
            switch (pcmlDocNode.getNodeType()) {
                case 3: {
                    PcmlStruct pcmlStruct = (PcmlStruct)pcmlDocNode;
                    if (!pcmlStruct.isSupportedAtHostVRM()) break;
                    bl = true;
                    n3 = 2;
                    n5 = pcmlStruct.getOutputsize(pcmlDimensions);
                    if (n4 != 2 && n4 != 4) break;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5);
                    pcmlStruct.toBytes(byteArrayOutputStream, 0, pcmlDimensions);
                    byArray = byteArrayOutputStream.toByteArray();
                    PcmlMessageLog.traceParameter(this.getPath(), pcmlDocNode.getNameForException(), byArray);
                    break;
                }
                case 4: {
                    PcmlData pcmlData = (PcmlData)pcmlDocNode;
                    if (!pcmlData.isSupportedAtHostVRM()) break;
                    bl = true;
                    n3 = pcmlData.getPassby();
                    n5 = pcmlData.getOutputsize(pcmlDimensions);
                    if (n4 != 2 && n4 != 4) break;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5);
                    pcmlData.toBytes(byteArrayOutputStream, 0, pcmlDimensions);
                    byArray = byteArrayOutputStream.toByteArray();
                    PcmlMessageLog.traceParameter(this.getPath(), pcmlDocNode.getNameForException(), byArray);
                    break;
                }
                default: {
                    throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(pcmlDocNode.getNodeType()), pcmlDocNode.getNameForException()});
                }
            }
            if (bl) {
                switch (n4) {
                    case 2: {
                        programParameterArray[n] = new ProgramParameter(n3, byArray);
                        break;
                    }
                    case 3: {
                        programParameterArray[n] = new ProgramParameter(n3, n5);
                        break;
                    }
                    case 4: {
                        programParameterArray[n] = new ProgramParameter(n3, byArray, n5);
                    }
                }
                ++n2;
            } else {
                programParameterArray[n] = null;
            }
            ++n;
        }
        ProgramParameter[] programParameterArray2 = new ProgramParameter[n2];
        int n6 = 0;
        for (n = 0; n < this.getNbrChildren(); ++n) {
            if (programParameterArray[n] == null) continue;
            programParameterArray2[n6++] = programParameterArray[n];
        }
        if (this.isServiceProgram()) {
            int n7 = this.m_ReturnvalueStr != null && this.m_ReturnvalueStr.equals("integer") ? 1 : 0;
            this.m_pgmCall = new ServiceProgramCall(aS400, this.getPath(), this.getEntrypoint(), n7, programParameterArray2);
            if (this.getEpCcsid() != 0) {
                try {
                    ((ServiceProgramCall)this.m_pgmCall).setProcedureName(this.getEntrypoint(), this.getEpCcsid());
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else {
            this.m_pgmCall = new ProgramCall(aS400, this.getPath(), programParameterArray2);
        }
        if (this.m_ThreadsafeOverrideCalled || this.getThreadsafe() != null) {
            this.m_pgmCall.setThreadSafe(this.getThreadsafeOverride());
        }
        this.m_pgmRc = this.m_pgmCall.run();
        if (!this.m_pgmRc) {
            this.msgList = this.m_pgmCall.getMessageList();
            return this.m_pgmRc;
        }
        this.m_IntReturnValue = 0;
        this.m_Errno = 0;
        if (this.isServiceProgram() && this.m_ReturnvalueStr != null && this.m_ReturnvalueStr.equals("integer")) {
            this.m_IntReturnValue = ((ServiceProgramCall)this.m_pgmCall).getIntegerReturnValue();
            this.m_Errno = ((ServiceProgramCall)this.m_pgmCall).getErrno();
        }
        if ((string = this.getParseorder()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<PcmlNode> vector = new Vector<PcmlNode>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                PcmlNode pcmlNode = this.getRootNode().getElement(this.getQualifiedName() + "." + string2);
                if (pcmlNode == null) {
                    throw new PcmlException("PARSEORDER_NOT_FOUND", new Object[]{PcmlProgram.makeQuotedAttr("parseorder", string), string2, this.getBracketedTagName(), this.getNameForException()});
                }
                if (pcmlNode.getParent() != this) {
                    throw new PcmlException("PARSEORDER_NOT_CHILD", new Object[]{PcmlProgram.makeQuotedAttr("parseorder", string), string2, this.getBracketedTagName(), this.getNameForException()});
                }
                if (pcmlNode instanceof PcmlStruct) {
                    if (!((PcmlStruct)pcmlNode).isSupportedAtHostVRM()) continue;
                    vector.addElement(pcmlNode);
                    continue;
                }
                if (pcmlNode instanceof PcmlData) {
                    if (!((PcmlData)pcmlNode).isSupportedAtHostVRM()) continue;
                    vector.addElement(pcmlNode);
                    continue;
                }
                vector.addElement(pcmlNode);
            }
            enumeration = vector.elements();
        } else {
            enumeration = this.getChildren();
        }
        block18: while (enumeration.hasMoreElements()) {
            pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
            n = pcmlDocNode.getChildNbr();
            if (!(programParameterArray[n] instanceof ProgramParameter) || programParameterArray[n].getOutputDataLength() <= 0) continue;
            byArray = programParameterArray[n].getOutputData();
            PcmlMessageLog.traceParameter(this.getPath(), pcmlDocNode.getNameForException(), byArray);
            switch (pcmlDocNode.getNodeType()) {
                case 3: {
                    ((PcmlStruct)pcmlDocNode).parseBytes(byArray, 0, hashtable, new PcmlDimensions());
                    continue block18;
                }
                case 4: {
                    ((PcmlData)pcmlDocNode).parseBytes(byArray, 0, hashtable, new PcmlDimensions());
                    continue block18;
                }
            }
            throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(pcmlDocNode.getNodeType()), pcmlDocNode.getNameForException()});
        }
        return true;
    }

    int getProgramCCSID() {
        if (this.m_pgmCCSID == -1) {
            return 65535;
        }
        return this.m_pgmCCSID;
    }

    int getErrno() throws PcmlException {
        if (this.isServiceProgram()) {
            if (this.m_ReturnvalueStr.equals("integer")) {
                return this.m_Errno;
            }
            throw new PcmlException("NOT_SERVICE_PGM", new Object[]{this.getBracketedTagName(), PcmlProgram.makeQuotedAttr("returnvalue", "integer"), this.getBracketedTagName(), this.getNameForException()});
        }
        throw new PcmlException("NOT_SERVICE_PGM", new Object[]{this.getBracketedTagName(), PcmlProgram.makeQuotedAttr("entrypoint", ""), this.getBracketedTagName(), this.getNameForException()});
    }

    int getIntReturnValue() throws PcmlException {
        if (this.isServiceProgram()) {
            if (this.m_ReturnvalueStr.equals("integer")) {
                return this.m_IntReturnValue;
            }
            throw new PcmlException("NOT_SERVICE_PGM", new Object[]{this.getBracketedTagName(), PcmlProgram.makeQuotedAttr("returnvalue", "integer"), this.getBracketedTagName(), this.getNameForException()});
        }
        throw new PcmlException("NOT_SERVICE_PGM", new Object[]{this.getBracketedTagName(), PcmlProgram.makeQuotedAttr("entrypoint", ""), this.getBracketedTagName(), this.getNameForException()});
    }

    AS400Message[] getMessageList() {
        return this.msgList;
    }

    private boolean isServiceProgram() {
        return this.getEntrypoint() != null;
    }
}

