/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400UnsignedBin2;
import com.ibm.as400.access.AS400UnsignedBin4;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlDocRoot;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XmlException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Enumeration;

class PcmlDocument
extends PcmlDocRoot {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    boolean compareSucceeded = true;
    static final long serialVersionUID = -8169008879805188674L;
    private static final String[] PCMLATTRIBUTES = new String[]{"version"};
    private static final int VERSION_1_ATTRIBUTE_COUNT = 1;
    private String m_docName;
    private String m_XsdName;
    private String m_Version;
    private static AS400Bin2 m_Bin2 = new AS400Bin2();
    private static AS400UnsignedBin2 m_UBin2 = new AS400UnsignedBin2();
    private static AS400Bin4 m_Bin4 = new AS400Bin4();
    private static AS400UnsignedBin4 m_UBin4 = new AS400UnsignedBin4();
    private static AS400Bin8 m_Bin8 = new AS400Bin8();
    private static AS400Float4 m_Float4 = new AS400Float4();
    private static AS400Float8 m_Float8 = new AS400Float8();
    private static AS400PackedDecimal m_Packed_15_5 = new AS400PackedDecimal(15, 5);
    private static AS400ZonedDecimal m_Zoned_15_5 = new AS400ZonedDecimal(15, 5);
    private long correlationID_ = 0L;
    protected transient AS400Text m_Text_1 = null;
    protected transient AS400Text m_Text_10 = null;
    protected transient AS400ByteArray m_Byte_1 = null;
    protected transient AS400ByteArray m_Byte_2 = null;
    protected transient AS400ByteArray m_Byte_3 = null;
    protected transient AS400ByteArray m_Byte_4 = null;
    private AS400 m_as400;
    private int m_as400Vrm = -1;
    private transient PcmlSpecificationException m_PcmlSpecificationException = null;
    private transient boolean m_bSerializingWithData = false;
    private transient long m_DeserializationTs = 0L;
    private transient PcmlProgram m_pcmlProgram;
    private transient Object correlationIDLock_ = new Object();
    private static final String XMLNS_STRING = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n       xsi:noNamespaceSchemaLocation=";

    PcmlDocument(PcmlAttributeList pcmlAttributeList, String string) {
        this.setNodeType(1);
        this.m_XmlAttrs = pcmlAttributeList;
        this.m_docName = string;
        this.m_XsdName = "";
        this.m_Version = this.getAttributeValue("version");
    }

    public Object clone() {
        PcmlDocument pcmlDocument = (PcmlDocument)super.clone();
        pcmlDocument.addToHashtable(pcmlDocument);
        return pcmlDocument;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.correlationIDLock_ = new Object();
        this.m_DeserializationTs = this.getCorrelationID();
        objectInputStream.defaultReadObject();
        if (this.m_as400 == null) {
            this.m_as400Vrm = -1;
        }
        this.readObjectPostprocessing();
    }

    AS400 getAs400() {
        return this.m_as400;
    }

    long getDeserializationTimestamp() {
        return this.m_DeserializationTs;
    }

    String[] getAttributeList() {
        return PCMLATTRIBUTES;
    }

    boolean isSerializingWithData() {
        return this.m_bSerializingWithData;
    }

    void setSerializingWithData(boolean bl) {
        this.m_bSerializingWithData = bl;
    }

    int getAs400VRM() throws PcmlException {
        if (this.m_as400Vrm == -1) {
            try {
                this.m_as400Vrm = this.getAs400().getVRM();
            }
            catch (AS400SecurityException aS400SecurityException) {
                throw new PcmlException(aS400SecurityException);
            }
            catch (UnknownHostException unknownHostException) {
                throw new PcmlException(unknownHostException);
            }
            catch (IOException iOException) {
                throw new PcmlException(iOException);
            }
        }
        return this.m_as400Vrm;
    }

    String getDocName() {
        return this.m_docName;
    }

    String getVersion() {
        return this.m_Version;
    }

    synchronized void setAs400(AS400 aS400) {
        this.m_as400 = aS400;
        this.m_as400Vrm = -1;
        this.m_Text_1 = null;
        this.m_Text_10 = null;
    }

    protected AS400DataType getConverter(int n, int n2, int n3, int n4) throws PcmlException {
        switch (n) {
            case 1: {
                if (n4 != this.m_as400.getCcsid()) {
                    return new AS400Text(n2, n4, this.m_as400);
                }
                switch (n2) {
                    case 1: {
                        if (this.m_Text_1 == null) {
                            this.m_Text_1 = new AS400Text(n2, n4, this.m_as400);
                        }
                        return this.m_Text_1;
                    }
                    case 10: {
                        if (this.m_Text_10 == null) {
                            this.m_Text_10 = new AS400Text(n2, n4, this.m_as400);
                        }
                        return this.m_Text_10;
                    }
                }
                return new AS400Text(n2, n4, this.m_as400);
            }
            case 2: {
                if (n2 == 2) {
                    if (n3 == 16) {
                        return m_UBin2;
                    }
                    return m_Bin2;
                }
                if (n2 == 4) {
                    if (n3 == 32) {
                        return m_UBin4;
                    }
                    return m_Bin4;
                }
                return m_Bin8;
            }
            case 3: {
                if (n2 == 15 && n3 == 5) {
                    return m_Packed_15_5;
                }
                return new AS400PackedDecimal(n2, n3);
            }
            case 4: {
                if (n2 == 15 && n3 == 5) {
                    return m_Zoned_15_5;
                }
                return new AS400ZonedDecimal(n2, n3);
            }
            case 5: {
                if (n2 == 4) {
                    return m_Float4;
                }
                return m_Float8;
            }
            case 6: {
                switch (n2) {
                    case 1: {
                        if (this.m_Byte_1 == null) {
                            this.m_Byte_1 = new AS400ByteArray(n2);
                        }
                        return this.m_Byte_1;
                    }
                    case 2: {
                        if (this.m_Byte_2 == null) {
                            this.m_Byte_2 = new AS400ByteArray(n2);
                        }
                        return this.m_Byte_2;
                    }
                    case 3: {
                        if (this.m_Byte_3 == null) {
                            this.m_Byte_3 = new AS400ByteArray(n2);
                        }
                        return this.m_Byte_3;
                    }
                    case 4: {
                        if (this.m_Byte_4 == null) {
                            this.m_Byte_4 = new AS400ByteArray(n2);
                        }
                        return this.m_Byte_4;
                    }
                }
                return new AS400ByteArray(n2);
            }
        }
        throw new PcmlException("BAD_DATA_TYPE", new Object[]{new Integer(n), "*"});
    }

    synchronized boolean callProgram(String string) throws AS400SecurityException, ObjectDoesNotExistException, InterruptedException, ErrorCompletingRequestException, IOException, PcmlException {
        this.m_pcmlProgram = this.getProgramNode(string);
        return this.m_pcmlProgram.callProgram(this.m_as400);
    }

    synchronized int getErrno(String string) throws PcmlException {
        return this.getProgramNode(string).getErrno();
    }

    synchronized int getIntReturnValue(String string) throws PcmlException {
        return this.getProgramNode(string).getIntReturnValue();
    }

    synchronized int getIntValue(String string) throws PcmlException {
        return this.getIntValue(string, new PcmlDimensions());
    }

    synchronized int getIntValue(String string, PcmlDimensions pcmlDimensions) throws PcmlException {
        Object object = this.getValue(string, pcmlDimensions);
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
    }

    synchronized String getStringValue(String string, int n) throws PcmlException {
        return this.getStringValue(string, new PcmlDimensions(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCorrelationID() {
        Object object = this.correlationIDLock_;
        synchronized (object) {
            return ++this.correlationID_;
        }
    }

    synchronized String getStringValue(String string, PcmlDimensions pcmlDimensions, int n) throws PcmlException {
        return this.getDataNode(string).getStringValue(pcmlDimensions, n);
    }

    synchronized int getOutputsize(String string) throws PcmlException {
        return this.getOutputsize(string, new PcmlDimensions());
    }

    synchronized int getOutputsize(String string, PcmlDimensions pcmlDimensions) throws PcmlException {
        PcmlDocNode pcmlDocNode = (PcmlDocNode)this.getElement(string);
        if (pcmlDocNode != null && pcmlDocNode instanceof PcmlData) {
            return ((PcmlData)pcmlDocNode).getOutputsize(pcmlDimensions);
        }
        if (pcmlDocNode != null && pcmlDocNode instanceof PcmlStruct) {
            return ((PcmlStruct)pcmlDocNode).getOutputsize(pcmlDimensions);
        }
        return 0;
    }

    synchronized AS400Message[] getMessageList(String string) throws PcmlException {
        return this.getProgramNode(string).getMessageList();
    }

    ProgramCall getProgramCall() {
        return this.m_pcmlProgram == null ? null : this.m_pcmlProgram.getProgramCall();
    }

    synchronized Object getValue(String string) throws PcmlException {
        return this.getValue(string, new PcmlDimensions());
    }

    synchronized Object getValue(String string, PcmlDimensions pcmlDimensions) throws PcmlException {
        return this.getDataNode(string).getValue(pcmlDimensions);
    }

    synchronized boolean isArray(String string) throws PcmlException {
        return this.getDataNode(string).isArray();
    }

    synchronized boolean isInArray(String string) throws PcmlException {
        return this.getDataNode(string).isInArray();
    }

    synchronized void setValue(String string, Object object) throws PcmlException {
        this.setValue(string, object, new PcmlDimensions());
    }

    synchronized void setValue(String string, Object object, PcmlDimensions pcmlDimensions) throws PcmlException {
        this.getDataNode(string).setValue(object, pcmlDimensions);
    }

    synchronized void setStringValue(String string, String string2, int n) throws PcmlException {
        this.setStringValue(string, string2, new PcmlDimensions(), n);
    }

    synchronized void setStringValue(String string, String string2, PcmlDimensions pcmlDimensions, int n) throws PcmlException {
        this.getDataNode(string).setStringValue(string2, pcmlDimensions, n);
    }

    void setThreadsafeOverride(String string, boolean bl) throws PcmlException {
        this.getProgramNode(string).setThreadsafeOverride(bl);
    }

    void setPath(String string, String string2) throws PcmlException {
        this.getProgramNode(string).setPath(string2);
    }

    boolean getThreadsafeOverride(String string) throws PcmlException {
        return this.getProgramNode(string).getThreadsafeOverride();
    }

    void addToHashtable(PcmlDocNode pcmlDocNode) {
        Enumeration enumeration = pcmlDocNode.getChildren();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
            String string = pcmlDocNode2.getQualifiedName();
            if (!string.equals("")) {
                if (this.containsElement(string)) {
                    this.addPcmlSpecificationError("MULTIPLE_DEFINE", new Object[]{string});
                }
                this.addElement(pcmlDocNode2);
            }
            this.addToHashtable(pcmlDocNode2);
        }
    }

    private PcmlProgram getProgramNode(String string) throws PcmlException {
        PcmlNode pcmlNode = this.getElement(string);
        if (pcmlNode instanceof PcmlProgram) {
            return (PcmlProgram)pcmlNode;
        }
        if (pcmlNode == null) {
            throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{string, "<program>"});
        }
        throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{string, "<program>"});
    }

    private PcmlData getDataNode(String string) throws PcmlException {
        PcmlNode pcmlNode = this.getElement(string);
        if (pcmlNode instanceof PcmlData) {
            return (PcmlData)pcmlNode;
        }
        if (pcmlNode == null) {
            throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{string, "<data>"});
        }
        throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{string, "<data>"});
    }

    PcmlSpecificationException getPcmlSpecificationException() {
        return this.m_PcmlSpecificationException;
    }

    void addPcmlSpecificationError(String string, Object[] objectArray) {
        if (this.m_PcmlSpecificationException == null) {
            this.m_PcmlSpecificationException = new PcmlSpecificationException(SystemResourceFinder.format("FAILED_TO_VALIDATE", new Object[]{this.m_docName}));
        }
        this.m_PcmlSpecificationException.addMessage(SystemResourceFinder.format(string, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateXPCML(String string, OutputStream outputStream) throws IOException, XmlException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        PcmlDimensions pcmlDimensions = new PcmlDimensions(nArray);
        try {
            printWriter.println("<?xml version=\"1.0\" ?>");
            printWriter.print("<xpcml version=\"4.0\"");
            printWriter.print(XMLNS_STRING);
            if (this.getXsdName() != "") {
                printWriter.println("'" + this.getXsdName() + "' >");
            } else {
                printWriter.println("'xpcml.xsd' >");
            }
            printWriter.println();
            if (string == null) {
                this.generateXPCML(this, this, printWriter, "", n, n2, pcmlDimensions);
            } else {
                this.generateXPCML(this, this.getProgramNode(string), printWriter, "", n, n2, pcmlDimensions);
            }
            printWriter.println("</xpcml>");
            if (printWriter.checkError()) {
                Trace.log(2, "Error when writing PCML to OutputStream.");
            }
        }
        finally {
            printWriter.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void generateXPCML(PcmlDocument var1_1, PcmlDocNode var2_2, PrintWriter var3_3, String var4_4, int var5_5, int var6_6, PcmlDimensions var7_7) throws IOException, XmlException {
        block230: {
            block227: {
                block229: {
                    block228: {
                        block226: {
                            block225: {
                                var9_8 = "";
                                var10_9 = false;
                                var11_10 = new PcmlDimensions();
                                var11_10.add(0);
                                if (var2_2.getNodeType() == 2 || var2_2.getNodeType() == 1) {
                                    for (var12_11 = 0; var12_11 < var7_7.size(); ++var12_11) {
                                        var7_7.set(var12_11, 0);
                                    }
                                    var6_6 = 0;
                                    var5_5 = 0;
                                }
                                if (var2_2.getCountReps() == -10) {
                                    var12_11 = var2_2.getNodeType();
                                    var8_13 = var12_11 == 4 && ((PcmlData)var2_2).getXPCMLCount(var11_10) != 0 ? ((PcmlData)var2_2).getXPCMLCount(var11_10) : (var12_11 == 3 && ((PcmlStruct)var2_2).getXPCMLCount(var11_10) != 0 ? ((PcmlStruct)var2_2).getXPCMLCount(var11_10) : 1);
                                    var2_2.setCountReps(var8_13);
                                    var7_7.set(var6_6, 0);
                                }
                                if (var2_2.getNodeType() != 4) break block225;
                                var12_11 = ((PcmlData)var2_2).getDataType();
                                switch (var12_11) {
                                    case 1: {
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl32
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfStringParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfStringParm");
                                            var9_8 = "arrayOfStringParm";
                                            break;
                                        }
                                        break block226;
lbl32:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<stringParm");
                                        var9_8 = "stringParm";
                                        break;
                                    }
                                    case 7: {
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl54
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfStructParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfStructParm");
                                            var9_8 = "arrayOfStructParm";
                                            break;
                                        }
                                        break block226;
lbl54:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<structParm");
                                        var9_8 = "structParm";
                                        break;
                                    }
                                    case 6: {
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl76
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfHexBinaryParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfHexBinaryParm");
                                            var9_8 = "arrayOfHexBinaryParm";
                                            break;
                                        }
                                        break block226;
lbl76:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<hexBinaryParm");
                                        var9_8 = "hexBinaryParm";
                                        break;
                                    }
                                    case 2: {
                                        if (!var2_2.getAttributeValue("length").equals("4")) ** GOTO lbl130
                                        if (var2_2.getAttributeValue("precision") == null || !var2_2.getAttributeValue("precision").equals("32")) ** GOTO lbl109
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl100
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfUnsignedIntParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfUnsignedIntParm");
                                            var9_8 = "arrayOfUnsignedIntParm";
                                            break;
                                        }
                                        break block226;
lbl100:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<unsignedIntParm");
                                        var9_8 = "unsignedIntParm";
                                        break;
lbl109:
                                        // 1 sources

                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl121
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfIntParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfIntParm");
                                            var9_8 = "arrayOfIntParm";
                                            break;
                                        }
                                        break block226;
lbl121:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<intParm");
                                        var9_8 = "intParm";
                                        break;
lbl130:
                                        // 1 sources

                                        if (!var2_2.getAttributeValue("length").equals("2")) ** GOTO lbl174
                                        if (var2_2.getAttributeValue("precision") == null || !var2_2.getAttributeValue("precision").equals("16")) ** GOTO lbl153
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl144
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfUnsignedShortParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfUnsignedShortParm");
                                            var9_8 = "arrayOfUnsignedShortParm";
                                            break;
                                        }
                                        break block226;
lbl144:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<unsignedShortParm");
                                        var9_8 = "unsignedShortParm";
                                        break;
lbl153:
                                        // 1 sources

                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl165
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfShortParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfShortParm");
                                            var9_8 = "arrayOfShortParm";
                                            break;
                                        }
                                        break block226;
lbl165:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<shortParm");
                                        var9_8 = "shortParm";
                                        break;
lbl174:
                                        // 1 sources

                                        if (!var2_2.getAttributeValue("length").equals("8")) break block226;
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl187
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfLongParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfLongParm");
                                            var9_8 = "arrayOfLongParm";
                                            break;
                                        }
                                        break block226;
lbl187:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<longParm");
                                        var9_8 = "longParm";
                                        break;
                                    }
                                    case 5: {
                                        if (!var2_2.getAttributeValue("length").equals("4")) ** GOTO lbl219
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl210
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfFloatParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfFloatParm");
                                            var9_8 = "arrayOfFloatParm";
                                            break;
                                        }
                                        break block226;
lbl210:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<floatParm");
                                        var9_8 = "floatParm";
                                        break;
lbl219:
                                        // 1 sources

                                        if (!var2_2.getAttributeValue("length").equals("8")) break block226;
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl232
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfDoubleParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfDoubleParm");
                                            var9_8 = "arrayOfDoubleParm";
                                            break;
                                        }
                                        break block226;
lbl232:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<doubleParm");
                                        var9_8 = "doubleParm";
                                        break;
                                    }
                                    case 4: {
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl254
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfZonedDecimalParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfZonedDecimalParm");
                                            var9_8 = "arrayOfZonedDecimalParm";
                                            break;
                                        }
                                        break block226;
lbl254:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<zonedDecimalParm");
                                        var9_8 = "zonedDecimalParm";
                                        break;
                                    }
                                    case 3: {
                                        if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) ** GOTO lbl276
                                        if (var7_7.at(var6_6) == 0) {
                                            if (var2_2.getCondensedName() != "") {
                                                var3_3.print(var4_4);
                                                var3_3.print("<" + var2_2.getCondensedName());
                                                var9_8 = "arrayOfPackedDecimalParm";
                                                break;
                                            }
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfPackedDecimalParm");
                                            var9_8 = "arrayOfPackedDecimalParm";
                                            break;
                                        }
                                        break block226;
lbl276:
                                        // 1 sources

                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = var2_2.getCondensedName();
                                            break;
                                        }
                                        var3_3.print(var4_4);
                                        var3_3.print("<packedDecimalParm");
                                        var9_8 = "packedDecimalParm";
                                        break;
                                    }
                                    default: {
                                        throw new PcmlException("BAD_DATA_TYPE", new Object[]{new Integer(var12_11), "*"});
                                    }
                                }
                                break block226;
                            }
                            if (var2_2.getNodeType() == 3) {
                                if (((PcmlStruct)var2_2).getXPCMLCount(var11_10) > 0) {
                                    if (var7_7.at(var6_6) == 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print(var4_4);
                                            var3_3.print("<" + var2_2.getCondensedName());
                                            var9_8 = "arrayOfStruct";
                                        } else {
                                            var3_3.print(var4_4);
                                            var3_3.print("<arrayOfStruct");
                                            var9_8 = "arrayOfStruct";
                                        }
                                    }
                                } else if (var2_2.getCondensedName() != "") {
                                    var3_3.print(var4_4);
                                    var3_3.print("<" + var2_2.getCondensedName());
                                    var9_8 = var2_2.getCondensedName();
                                } else {
                                    var3_3.print(var4_4);
                                    var3_3.print("<struct");
                                    var9_8 = "struct";
                                }
                            } else if (var2_2.getNodeType() == 2) {
                                var3_3.println();
                                var3_3.print(var4_4 + "<program");
                                var9_8 = "program";
                            } else if (var2_2.getNodeType() == 1) {
                                // empty if block
                            }
                        }
                        var12_12 = var2_2.getAttributeList();
                        if (!(var2_2.getCondensedName() != "" && !var2_2.getIsExtendedType() || var2_2.getNodeType() == 4 && var7_7.at(var6_6) > 0 || var2_2.getNodeType() == 3 && var7_7.at(var6_6) > 0)) {
                            for (var13_14 = 0; var13_14 < var12_12.length; ++var13_14) {
                                if (var2_2.getAttributeValue(var12_12[var13_14]) == null) continue;
                                if (var12_12[var13_14].equals("usage")) {
                                    if (var2_2.getAttributeValue(var12_12[var13_14]).equals("input")) {
                                        var3_3.print(" passDirection=\"in\"");
                                        continue;
                                    }
                                    if (var2_2.getAttributeValue(var12_12[var13_14]).equals("output")) {
                                        var3_3.print(" passDirection=\"out\"");
                                        continue;
                                    }
                                    if (!var2_2.getAttributeValue(var12_12[var13_14]).equals("inputoutput")) continue;
                                    var3_3.print(" passDirection=\"inout\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("passby")) {
                                    var3_3.print(" passMode=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("type") || var12_12[var13_14].equals("length") && var2_2.getAttributeValue("type") != null && (var2_2.getAttributeValue("type").equals("int") || var2_2.getAttributeValue("type").equals("float"))) continue;
                                if (var12_12[var13_14].equals("length") && var2_2.getAttributeValue("type") != null && var2_2.getAttributeValue("type").equals("byte")) {
                                    var3_3.print(" totalBytes=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("length") && var2_2.getAttributeValue("type") != null && (var2_2.getAttributeValue("type").equals("zoned") || var2_2.getAttributeValue("type").equals("packed"))) {
                                    var3_3.print(" totalDigits=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("precision") && var2_2.getAttributeValue("type") != null && (var2_2.getAttributeValue("type").equals("zoned") || var2_2.getAttributeValue("type").equals("packed"))) {
                                    var3_3.print(" fractionDigits=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("version") || var12_12[var13_14].equals("init") || var12_12[var13_14].equals("precision")) continue;
                                if (var12_12[var13_14].equals("offsetfrom")) {
                                    var3_3.print(" offsetFrom=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("outputsize")) {
                                    var3_3.print(" outputSize=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("bidistringtype")) {
                                    var3_3.print(" bidiStringType=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("chartype")) {
                                    var3_3.print(" bytesPerChar=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("parseorder")) {
                                    var3_3.print(" parseOrder=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("entrypoint")) {
                                    var3_3.print(" entryPoint=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("threadsafe")) {
                                    var3_3.print(" threadSafe=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                if (var12_12[var13_14].equals("returnvalue")) {
                                    var3_3.print(" returnValue=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                                    continue;
                                }
                                var3_3.print(" " + var12_12[var13_14] + "=\"" + var2_2.getAttributeValue(var12_12[var13_14]) + "\"");
                            }
                        }
                        if (var2_2.getCountReps() != 0) {
                            var2_2.setCountReps(var2_2.getCountReps() - 1);
                        }
                        if (!var2_2.hasChildren()) break block227;
                        if (var2_2.getNodeType() != 1 && var7_7.at(var6_6) == 0) {
                            var3_3.println(">");
                        }
                        if (var2_2.getNodeType() == 4 && ((PcmlData)var2_2).getDataType() == 7 && ((PcmlData)var2_2).getXPCMLCount(var11_10) > 0) {
                            if (var7_7.at(var6_6) > 0) {
                                var3_3.println(var4_4 + "  <struct_i index=" + "\"" + var7_7.at(var6_6) + "\"" + ">");
                            } else {
                                var3_3.println(var4_4 + "  <struct_i index=" + "\"" + var7_7.at(var6_6) + "\"" + ">");
                            }
                            var9_8 = "struct_i";
                        }
                        if (var2_2.getNodeType() == 3 && ((PcmlStruct)var2_2).getXPCMLCount(var11_10) > 0) {
                            if (var7_7.at(var6_6) > 0) {
                                var3_3.println(var4_4 + "  <struct_i index=" + "\"" + var7_7.at(var6_6) + "\"" + ">");
                            } else {
                                var3_3.println(var4_4 + "  <struct_i index=" + "\"" + var7_7.at(var6_6) + "\"" + ">");
                            }
                            var9_8 = "struct_i";
                        }
                        if (var2_2.getNodeType() == 2) {
                            var3_3.println(var4_4 + "<parameterList>");
                        }
                        var13_15 = var2_2.getChildren();
                        while (var13_15.hasMoreElements()) {
                            var14_17 = (PcmlDocNode)var13_15.nextElement();
                            if (var14_17.getNodeType() == 2) {
                                for (var15_22 = 0; var15_22 < var7_7.size(); ++var15_22) {
                                    var7_7.set(var15_22, 0);
                                }
                                var6_6 = 0;
                                var5_5 = 0;
                            }
                            if (var14_17.getNodeType() == 3 && var14_17.getParent().getName().trim().length() == 0) {
                                for (var15_22 = 0; var15_22 < var7_7.size(); ++var15_22) {
                                    var7_7.set(var15_22, 0);
                                }
                                var6_6 = 0;
                                var5_5 = 0;
                            }
                            if (var14_17.getChildNbr() == 0 && (var2_2.getNodeType() == 4 && ((PcmlData)var2_2).getXPCMLCount(var11_10) > 0 || var2_2.getNodeType() == 3 && ((PcmlStruct)var2_2).getXPCMLCount(var11_10) > 0)) {
                                ++var6_6;
                                if (++var5_5 > 9) {
                                    var7_7.add(0);
                                }
                            }
                            this.generateXPCML(var1_1, var14_17, var3_3, var4_4 + "    ", var5_5, var6_6, var7_7);
                        }
                        if (var2_2.getNodeType() == 2) {
                            var3_3.println(var4_4 + "</parameterList>");
                        }
                        if (var2_2.getNodeType() != 4) break block228;
                        var14_18 = ((PcmlData)var2_2).getDataType();
                        var3_3.print(var4_4);
                        switch (var14_18) {
                            case 1: {
                                if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print("</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.print("</stringParm>");
                                    break;
                                }
                                var3_3.println("  </i>");
                                if (var2_2.getCountReps() == 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print("</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.println("</arrayOfStringParm>");
                                    break;
                                }
                                break block229;
                            }
                            case 7: {
                                if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print("</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.println("</structParm>");
                                    break;
                                }
                                var3_3.println("  </struct_i>");
                                if (var2_2.getCountReps() == 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print(var4_4 + "</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.println(var4_4 + "</arrayOfStructParm>");
                                    break;
                                }
                                break block229;
                            }
                            case 6: {
                                if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print("</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.print("</hexBinaryParm>");
                                    break;
                                }
                                var3_3.println("  </i>");
                                if (var2_2.getCountReps() == 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print("</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.println("</arrayOfHexBinaryParm>");
                                    break;
                                }
                                break block229;
                            }
                            case 2: {
                                if (var2_2.getAttributeValue("length").equals("4") && var2_2.getAttributeValue("precision") != null && var2_2.getAttributeValue("precision").equals("32")) {
                                    if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.print("</unsignedIntParm>");
                                        break;
                                    }
                                    var3_3.println("  </i>");
                                    if (var2_2.getCountReps() == 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.println("</arrayOfUnsignedIntParm>");
                                        break;
                                    }
                                } else if (var2_2.getAttributeValue("length").equals("4")) {
                                    if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.print("</intParm>");
                                        break;
                                    }
                                    var3_3.println("  </i>");
                                    if (var2_2.getCountReps() == 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.println("</arrayOfIntParm>");
                                        break;
                                    }
                                } else if (var2_2.getAttributeValue("length").equals("2") && var2_2.getAttributeValue("precision") != null && var2_2.getAttributeValue("precision").equals("16")) {
                                    if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.print("</unsignedShortParm>");
                                        break;
                                    }
                                    var3_3.println("  </i>");
                                    if (var2_2.getCountReps() == 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.println("</arrayOfUnsignedShortParm>");
                                        break;
                                    }
                                } else if (var2_2.getAttributeValue("length").equals("2")) {
                                    if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.print("</shortParm>");
                                        break;
                                    }
                                    var3_3.println("  </i>");
                                    if (var2_2.getCountReps() == 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.println("</arrayOfShortParm>");
                                        break;
                                    }
                                } else if (var2_2.getAttributeValue("length").equals("8")) {
                                    if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.print("</longParm>");
                                        break;
                                    }
                                    var3_3.println("  </i>");
                                    if (var2_2.getCountReps() == 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.println("</arrayOfLongParm>");
                                        break;
                                    }
                                }
                                break block229;
                            }
                            case 5: {
                                if (var2_2.getAttributeValue("length").equals("4")) {
                                    if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.print("</floatParm>");
                                        break;
                                    }
                                    var3_3.println("  </i>");
                                    if (var2_2.getCountReps() == 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.println("</arrayOfFloatParm>");
                                        break;
                                    }
                                } else if (var2_2.getAttributeValue("length").equals("8")) {
                                    if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.print("</doubleParm>");
                                        break;
                                    }
                                    var3_3.println("  </i>");
                                    if (var2_2.getCountReps() == 0) {
                                        if (var2_2.getCondensedName() != "") {
                                            var3_3.print("</" + var2_2.getCondensedName() + ">");
                                            break;
                                        }
                                        var3_3.println("</arrayOfDoubleParm>");
                                        break;
                                    }
                                }
                                break block229;
                            }
                            case 4: {
                                if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print("</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.print("</zonedDecimalParm>");
                                    break;
                                }
                                var3_3.println("  </i>");
                                if (var2_2.getCountReps() == 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print("</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.println("</arrayOfZonedDecimalParm>");
                                    break;
                                }
                                break block229;
                            }
                            case 3: {
                                if (((PcmlData)var2_2).getXPCMLCount(var11_10) <= 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print("</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.print("</packedDecimalParm>");
                                    break;
                                }
                                var3_3.println("  </i>");
                                if (var2_2.getCountReps() == 0) {
                                    if (var2_2.getCondensedName() != "") {
                                        var3_3.print("</" + var2_2.getCondensedName() + ">");
                                        break;
                                    }
                                    var3_3.println("</arrayOfPackedDecimalParm>");
                                    break;
                                }
                                break block229;
                            }
                            default: {
                                throw new PcmlException("BAD_DATA_TYPE", new Object[]{new Integer(var14_18), "*"});
                            }
                        }
                        break block229;
                    }
                    if (var2_2.getNodeType() == 3) {
                        var3_3.print(var4_4);
                        if (((PcmlStruct)var2_2).getXPCMLCount(var11_10) <= 0) {
                            if (var2_2.getCondensedName() != "") {
                                var3_3.print("</" + var2_2.getCondensedName() + ">");
                            } else {
                                var3_3.println("</struct>");
                            }
                        } else {
                            var3_3.println("  </struct_i>");
                            if (var2_2.getCountReps() == 0) {
                                if (var2_2.getCondensedName() != "") {
                                    var3_3.print(var4_4 + "</" + var2_2.getCondensedName() + ">");
                                } else {
                                    var3_3.println(var4_4 + "</arrayOfStruct>");
                                }
                            }
                        }
                    } else if (var2_2.getNodeType() != 1) {
                        var3_3.println(var4_4 + "</" + var2_2.getTagName() + ">");
                    }
                }
                if (var2_2.getNodeType() == 2) {
                    var3_3.println();
                }
                if (var2_2.getNodeType() == 4 && ((PcmlData)var2_2).getXPCMLCount(var11_10) > 0 || var2_2.getNodeType() == 3 && ((PcmlStruct)var2_2).getXPCMLCount(var11_10) > 0) {
                    --var6_6;
                    --var5_5;
                }
                if (var2_2.getCountReps() > 0) {
                    var14_19 = new Integer(0);
                    if (var2_2.getNodeType() == 4 && ((PcmlData)var2_2).getXPCMLCount(var11_10) != 0) {
                        var14_19 = new Integer(((PcmlData)var2_2).getXPCMLCount(var11_10));
                    }
                    if (var2_2.getNodeType() == 3 && ((PcmlStruct)var2_2).getXPCMLCount(var11_10) != 0) {
                        var14_19 = new Integer(((PcmlStruct)var2_2).getXPCMLCount(var11_10));
                    }
                    if (var2_2.getNodeType() != 4 && var2_2.getNodeType() != 3) {
                        var14_19 = new Integer(0);
                    }
                    var7_7.set(var6_6, var14_19 - var2_2.getCountReps());
                    this.generateXPCML(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
                } else {
                    var2_2.setCountReps(-10);
                }
                break block230;
            }
            if (var2_2.getNodeType() == 4 && !var2_2.getAttributeValue("type").equals("struct")) {
                var13_16 = "";
                var14_20 = "";
                var16_24 = new int[]{var2_2.getCountReps()};
                if (var2_2.getQualifiedName().trim().equals("")) {
                    var13_16 = "";
                } else {
                    try {
                        if (var2_2.getAttributeValue("type").equals("byte")) {
                            var17_25 = ((PcmlData)var2_2).getLength(var7_7);
                            var18_28 = new byte[var17_25];
                            var18_28 = (byte[])var1_1.getValue(var2_2.getQualifiedName(), var7_7);
                            if (var18_28 != null) {
                                var13_16 = BinaryConverter.bytesToString(var18_28);
                            }
                        } else {
                            var13_16 = "";
                            var15_23 = var1_1.getValue(var2_2.getQualifiedName(), var7_7);
                            if (var15_23 != null) {
                                var13_16 = var15_23.toString();
                            }
                        }
                    }
                    catch (PcmlException var17_26) {
                        Trace.log(7, "No value for node: " + var2_2.getQualifiedName());
                    }
                    catch (IllegalArgumentException var17_27) {
                        Trace.log(7, "Bad count value for node: " + var2_2.getQualifiedName());
                    }
                }
                if (((PcmlData)var2_2).getXPCMLCount(var11_10) > 0) {
                    if (var9_8.equals("arrayOfStringParm") || var9_8.equals("arrayOfIntParm") || var9_8.equals("arrayOfLongParm") || var9_8.equals("arrayOfUnsignedIntParm") || var9_8.equals("arrayOfShortParm") || var9_8.equals("arrayOfUnsignedShortParm") || var9_8.equals("arrayOfFloatParm") || var9_8.equals("arrayOfDoubleParm") || var9_8.equals("arrayOfZonedDecimalParm") || var9_8.equals("arrayOfPackedDecimalParm") || var9_8.equals("arrayOfHexBinaryParm")) {
                        var3_3.println(">");
                    }
                    if (var7_7.at(var6_6) > 0) {
                        var3_3.print(var4_4 + "  <i index=" + "\"" + var7_7.at(var6_6) + "\"" + ">" + var13_16);
                    } else {
                        var3_3.print(var4_4 + "  <i index=" + "\"" + var7_7.at(var6_6) + "\"" + ">" + var13_16);
                    }
                } else {
                    var3_3.print(">" + var13_16);
                }
                if (((PcmlData)var2_2).getXPCMLCount(var11_10) > 0) {
                    var3_3.println("</i>");
                    var10_9 = true;
                } else {
                    var3_3.println("</" + var9_8 + ">");
                    var10_9 = true;
                }
            }
            if (!var10_9) {
                var3_3.println("/>");
            }
            if (var2_2.getCountReps() > 0) {
                var13_14 = var2_2.getNodeType() == 4 && ((PcmlData)var2_2).getXPCMLCount(var11_10) != 0 ? ((PcmlData)var2_2).getXPCMLCount(var11_10) : (var2_2.getNodeType() == 3 && ((PcmlStruct)var2_2).getXPCMLCount(var11_10) != 0 ? ((PcmlStruct)var2_2).getXPCMLCount(var11_10) : 0);
                var14_21 = var13_14 - var2_2.getCountReps();
                var7_7.set(var6_6, var13_14 - var2_2.getCountReps());
                this.generateXPCML(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
            } else {
                if (((PcmlData)var2_2).getXPCMLCount(var11_10) > 0) {
                    var13_14 = ((PcmlData)var2_2).getDataType();
                    var3_3.print(var4_4);
                    switch (var13_14) {
                        case 1: {
                            if (var2_2.getCondensedName() != "") {
                                var3_3.println("</" + var2_2.getCondensedName() + ">");
                                break;
                            }
                            var3_3.println("</arrayOfStringParm>");
                            break;
                        }
                        case 2: {
                            if (var2_2.getAttributeValue("length").equals("4") && var2_2.getAttributeValue("precision") != null && var2_2.getAttributeValue("precision").equals("32")) {
                                if (var2_2.getCondensedName() != "") {
                                    var3_3.println("</" + var2_2.getCondensedName() + ">");
                                    break;
                                }
                                var3_3.println("</arrayOfUnsignedIntParm>");
                                break;
                            }
                            if (var2_2.getAttributeValue("length").equals("4")) {
                                if (var2_2.getCondensedName() != "") {
                                    var3_3.println("</" + var2_2.getCondensedName() + ">");
                                    break;
                                }
                                var3_3.println("</arrayOfIntParm>");
                                break;
                            }
                            if (var2_2.getAttributeValue("length").equals("2") && var2_2.getAttributeValue("precision") != null && var2_2.getAttributeValue("precision").equals("16")) {
                                if (var2_2.getCondensedName() != "") {
                                    var3_3.println("</" + var2_2.getCondensedName() + ">");
                                    break;
                                }
                                var3_3.println("</arrayOfUnsignedShortParm>");
                                break;
                            }
                            if (var2_2.getAttributeValue("length").equals("2")) {
                                if (var2_2.getCondensedName() != "") {
                                    var3_3.println("</" + var2_2.getCondensedName() + ">");
                                    break;
                                }
                                var3_3.println("</arrayOfShortParm>");
                                break;
                            }
                            if (!var2_2.getAttributeValue("length").equals("8")) break;
                            if (var2_2.getCondensedName() != "") {
                                var3_3.println("</" + var2_2.getCondensedName() + ">");
                                break;
                            }
                            var3_3.println("</arrayOfLongParm>");
                            break;
                        }
                        case 5: {
                            if (var2_2.getAttributeValue("length").equals("8")) {
                                if (var2_2.getCondensedName() != "") {
                                    var3_3.println("</" + var2_2.getCondensedName() + ">");
                                    break;
                                }
                                var3_3.println("</arrayOfDoubleParm>");
                                break;
                            }
                            if (!var2_2.getAttributeValue("length").equals("4")) break;
                            if (var2_2.getCondensedName() != "") {
                                var3_3.println("</" + var2_2.getCondensedName() + ">");
                                break;
                            }
                            var3_3.println("</arrayOfFloatParm>");
                            break;
                        }
                        case 4: {
                            if (var2_2.getCondensedName() != "") {
                                var3_3.println("</" + var2_2.getCondensedName() + ">");
                                break;
                            }
                            var3_3.println("</arrayOfZonedDecimalParm>");
                            break;
                        }
                        case 3: {
                            if (var2_2.getCondensedName() != "") {
                                var3_3.println("</" + var2_2.getCondensedName() + ">");
                                break;
                            }
                            var3_3.println("</arrayOfPackedDecimalParm>");
                            break;
                        }
                        case 6: {
                            if (var2_2.getCondensedName() != "") {
                                var3_3.println("</" + var2_2.getCondensedName() + ">");
                                break;
                            }
                            var3_3.println("</arrayOfHexBinaryParm>");
                            break;
                        }
                    }
                }
                var2_2.setCountReps(-10);
            }
        }
        var3_3.flush();
    }

    void setXsdName(String string) {
        this.m_XsdName = string;
    }

    String getXsdName() {
        return this.m_XsdName;
    }

    void copyValues(PcmlDocNode pcmlDocNode, PcmlDocNode pcmlDocNode2) throws IOException, XmlException {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        PcmlDimensions pcmlDimensions = new PcmlDimensions(nArray);
        String[] stringArray = new String[30];
        String[] stringArray2 = new String[30];
        int n3 = 0;
        this.copyValues(pcmlDocNode, pcmlDocNode2, n, n2, pcmlDimensions, stringArray, stringArray2, n3);
    }

    void copyValues(PcmlDocNode pcmlDocNode, PcmlDocNode pcmlDocNode2, int n, int n2, PcmlDimensions pcmlDimensions, String[] stringArray, String[] stringArray2, int n3) throws IOException, XmlException {
        PcmlDimensions pcmlDimensions2 = new PcmlDimensions();
        pcmlDimensions2.add(0);
        if (n3 < 0) {
            n3 = 0;
        }
        if (pcmlDocNode2.getNodeType() == 2 || pcmlDocNode2.getNodeType() == 1) {
            int n4;
            for (n4 = 0; n4 < pcmlDimensions.size(); ++n4) {
                pcmlDimensions.set(n4, 0);
            }
            n2 = 0;
            n = 0;
            for (n4 = 0; n4 < 10; ++n4) {
                stringArray[n4] = "";
                stringArray2[n4] = "";
            }
            n3 = 0;
        }
        if (pcmlDocNode2.getNodeType() == 4 && pcmlDocNode2.getAttributeValue("type").equals("struct")) {
            PcmlDocNode pcmlDocNode3 = (PcmlDocNode)pcmlDocNode2.getParent();
            n3 = pcmlDocNode3.getNodeType() == 4 && pcmlDocNode3.getAttributeValue("type").equals("struct") ? ++n3 : 0;
            stringArray2[n3] = pcmlDocNode2.getName();
            stringArray[n3] = pcmlDocNode2.getAttributeValue("struct");
        }
        if (pcmlDocNode2.getCountReps() == -10) {
            int n5 = pcmlDocNode2.getNodeType();
            int n6 = n5 == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) : (n5 == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) : 1);
            pcmlDocNode2.setCountReps(n6);
            pcmlDimensions.set(n2, 0);
        }
        if (pcmlDocNode2.getCountReps() != 0) {
            pcmlDocNode2.setCountReps(pcmlDocNode2.getCountReps() - 1);
        }
        if (pcmlDocNode2.hasChildren()) {
            Serializable serializable;
            Enumeration enumeration = pcmlDocNode2.getChildren();
            while (enumeration.hasMoreElements()) {
                int n7;
                serializable = (PcmlDocNode)enumeration.nextElement();
                if (((PcmlDocNode)serializable).getNodeType() == 2) {
                    for (n7 = 0; n7 < pcmlDimensions.size(); ++n7) {
                        pcmlDimensions.set(n7, 0);
                    }
                    n2 = 0;
                    n = 0;
                    for (n7 = 0; n7 < 30; ++n7) {
                        stringArray[n7] = "";
                        stringArray2[n7] = "";
                    }
                    n3 = 0;
                }
                if (((PcmlDocNode)serializable).getNodeType() == 3 && ((PcmlNode)serializable).getParent().getName().trim().length() == 0) {
                    for (n7 = 0; n7 < pcmlDimensions.size(); ++n7) {
                        pcmlDimensions.set(n7, 0);
                    }
                    n2 = 0;
                    n = 0;
                    for (n7 = 0; n7 < 30; ++n7) {
                        stringArray[n7] = "";
                        stringArray2[n7] = "";
                    }
                    n3 = 0;
                }
                if (((PcmlNode)serializable).getChildNbr() == 0 && (pcmlDocNode2.getNodeType() == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) > 0 || pcmlDocNode2.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) > 0)) {
                    ++n2;
                    if (++n > 9) {
                        pcmlDimensions.add(0);
                    }
                }
                this.copyValues(pcmlDocNode, (PcmlDocNode)serializable, n, n2, pcmlDimensions, stringArray, stringArray2, n3);
            }
            if (pcmlDocNode2.getNodeType() == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) > 0 || pcmlDocNode2.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) > 0) {
                --n2;
                --n;
                --n3;
            }
            if (pcmlDocNode2.getCountReps() > 0) {
                serializable = new Integer(0);
                if (pcmlDocNode2.getNodeType() == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0) {
                    serializable = new Integer(((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2));
                }
                if (pcmlDocNode2.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0) {
                    serializable = new Integer(((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2));
                }
                if (pcmlDocNode2.getNodeType() != 4 && pcmlDocNode2.getNodeType() != 3) {
                    serializable = new Integer(0);
                }
                pcmlDimensions.set(n2, (Integer)serializable - pcmlDocNode2.getCountReps());
                this.copyValues(pcmlDocNode, pcmlDocNode2, n, n2, pcmlDimensions, stringArray, stringArray2, n3);
            } else {
                pcmlDocNode2.setCountReps(-10);
            }
        } else if (pcmlDocNode2.getNodeType() == 4 && !pcmlDocNode2.getAttributeValue("type").equals("struct")) {
            int n8;
            block39: {
                String string = "";
                String string2 = "";
                int[] nArray = new int[]{pcmlDocNode2.getCountReps()};
                if (pcmlDocNode2.getQualifiedName().trim().equals("")) {
                    Object var13_19 = null;
                } else {
                    try {
                        int n9;
                        Object object = null;
                        if (pcmlDocNode2.getUsage() == 3 || (object = ((PcmlData)pcmlDocNode2).getValue(pcmlDimensions)) != null || (((PcmlDocNode)pcmlDocNode2.getParent()).getNodeType() != 4 || !((PcmlDocNode)pcmlDocNode2.getParent()).getAttributeValue("type").equals("struct")) && ((PcmlDocNode)pcmlDocNode2.getParent()).getNodeType() != 3) break block39;
                        n8 = 0;
                        for (PcmlDocNode pcmlDocNode4 = (PcmlDocNode)pcmlDocNode2.getParent(); pcmlDocNode4 != null && pcmlDocNode4.getNodeType() != 2 && n8 == 0; pcmlDocNode4 = (PcmlDocNode)pcmlDocNode4.getParent()) {
                            if (pcmlDocNode4.getNodeType() != 4 || !pcmlDocNode4.getAttributeValue("type").equals("struct")) continue;
                            n8 = 1;
                        }
                        if (n8 == 0) break block39;
                        String[] stringArray3 = new String[n3 + 1];
                        for (n9 = 0; n9 <= n3; ++n9) {
                            stringArray3[n9] = "";
                        }
                        n9 = 0;
                        for (int i = 0; i <= n3 && n9 == 0; ++i) {
                            stringArray3[i] = stringArray[i];
                            for (int j = i + 1; j <= n3; ++j) {
                                stringArray3[i] = stringArray3[i] + "." + stringArray2[j];
                            }
                            String string3 = pcmlDocNode2.getQualifiedName();
                            String string4 = string3.substring(string3.indexOf(stringArray2[n3]) + stringArray2[n3].length() + 1);
                            stringArray3[i] = stringArray3[i] + "." + string4;
                            String string5 = stringArray3[i];
                            PcmlDocRoot pcmlDocRoot = pcmlDocNode.getRootNode();
                            PcmlData pcmlData = null;
                            try {
                                pcmlData = (PcmlData)pcmlDocRoot.getElement(string5);
                            }
                            catch (NullPointerException nullPointerException) {
                                pcmlData = null;
                            }
                            if (pcmlData == null) continue;
                            int n10 = pcmlData.getNbrOfDimensions();
                            int[] nArray2 = new int[n10];
                            for (int j = 0; j < n10; ++j) {
                                nArray2[j] = pcmlDimensions.at(((PcmlData)pcmlDocNode2).getNbrOfDimensions() - n10 + j);
                            }
                            PcmlDimensions pcmlDimensions3 = new PcmlDimensions(nArray2);
                            object = pcmlData.getValue(pcmlDimensions3);
                            if (object == null) continue;
                            ((PcmlData)pcmlDocNode2).setValue(object, pcmlDimensions);
                            n9 = 1;
                        }
                    }
                    catch (PcmlException pcmlException) {
                        Trace.log(7, "No value for node: " + pcmlDocNode2.getQualifiedName());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Trace.log(7, "Bad count value for node: " + pcmlDocNode2.getQualifiedName());
                    }
                }
            }
            if (pcmlDocNode2.getCountReps() > 0) {
                n8 = pcmlDocNode2.getNodeType() == 4 && ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlData)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) : (pcmlDocNode2.getNodeType() == 3 && ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) != 0 ? ((PcmlStruct)pcmlDocNode2).getXPCMLCount(pcmlDimensions2) : 0);
                int n11 = n8 - pcmlDocNode2.getCountReps();
                pcmlDimensions.set(n2, n8 - pcmlDocNode2.getCountReps());
                this.copyValues(pcmlDocNode, pcmlDocNode2, n, n2, pcmlDimensions, stringArray, stringArray2, n3);
            } else {
                pcmlDocNode2.setCountReps(-10);
            }
        }
    }
}

