/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDWriter;
import com.ibm.as400.access.OutputQueue;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.WriterJobImpl;
import java.io.IOException;

public class WriterJob
extends PrintObject {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;

    WriterJob(AS400 aS400, NPCPIDWriter nPCPIDWriter, NPCPAttribute nPCPAttribute) {
        super(aS400, nPCPIDWriter, nPCPAttribute, 2);
    }

    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use WriterJob before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (WriterJobImpl)aS400.loadImpl2("com.ibm.as400.access.WriterJobImplRemote", "com.ibm.as400.access.WriterJobImplProxy");
        super.setImpl();
    }

    public void end(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((WriterJobImpl)this.impl_).end(string);
    }

    public String getName() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(121);
    }

    public static WriterJob start(AS400 aS400, Printer printer, PrintParameterList printParameterList, OutputQueue outputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (printer == null) {
            Trace.log(2, "Parameter 'printer' is null.");
            throw new NullPointerException("printer");
        }
        if (printer.getImpl() == null) {
            printer.chooseImpl();
        }
        OutputQueueImpl outputQueueImpl = null;
        if (outputQueue != null) {
            if (outputQueue.getImpl() == null) {
                outputQueue.chooseImpl();
            }
            outputQueueImpl = (OutputQueueImpl)outputQueue.getImpl();
        }
        WriterJobImpl writerJobImpl = (WriterJobImpl)aS400.loadImpl2("com.ibm.as400.access.WriterJobImplRemote", "com.ibm.as400.access.WriterJobImplProxy");
        NPCPIDWriter nPCPIDWriter = writerJobImpl.start(aS400.getImpl(), printer.getImpl(), printParameterList, outputQueueImpl);
        return new WriterJob(aS400, nPCPIDWriter, null);
    }
}

