/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400File;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Record;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class SequentialFile
extends AS400File
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;

    public SequentialFile() {
    }

    public SequentialFile(AS400 aS400, String string) {
        super(aS400, string);
    }

    public void deleteRecord(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursor(n);
        this.deleteCurrentRecord();
    }

    public void positionCursor(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(n);
        this.impl_.doIt("positionCursor", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public void positionCursorAfter(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursor(n);
        this.positionCursorToNext();
    }

    public void positionCursorBefore(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(n);
        this.impl_.doIt("positionCursorBefore", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public Record read(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(n);
        return this.fillInRecord(this.impl_.doItRecord("read", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}));
    }

    public Record readAfter(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(n);
        return this.fillInRecord(this.impl_.doItRecord("readAfter", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}));
    }

    public Record[] readAll() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record[] recordArray;
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        this.chooseImpl();
        this.recordFormat_.initializeTextObjects(this.system_);
        int n = 2048 / (this.recordFormat_.getNewRecord().getRecordLength() + 16);
        if (n <= 1) {
            n = 100;
        }
        if ((recordArray = this.impl_.doItRecordArray("readAll", new Class[]{String.class, Integer.TYPE}, new Object[]{"seq", new Integer(n)})) != null) {
            for (int i = 0; i < recordArray.length; ++i) {
                recordArray[i] = this.fillInRecord(recordArray[i]);
            }
        }
        return recordArray;
    }

    public Record readBefore(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.verifyState(n);
        return this.fillInRecord(this.impl_.doItRecord("readBefore", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}));
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void update(int n, Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(n);
        this.update(record);
    }

    private void verifyState(int n) {
        if (!this.isOpen_) {
            throw new ExtendedIllegalStateException(3);
        }
        if (n < 1) {
            throw new ExtendedIllegalArgumentException("recordNumber", 2);
        }
    }
}

