/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLInteger
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private int truncated_ = 0;
    private int value_ = 0;
    private int scale_;
    private BigDecimal bigDecimalValue_ = null;
    private int vrm_;

    SQLInteger(int n) {
        this(0, n);
    }

    SQLInteger(int n, int n2) {
        this.scale_ = n;
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Integer.toString(this.value_));
        }
        this.vrm_ = n2;
    }

    public Object clone() {
        return new SQLInteger(this.scale_, this.vrm_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToInt(byArray, n);
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Integer.toString(this.value_)).movePointLeft(this.scale_);
            this.value_ = this.bigDecimalValue_.intValue();
        }
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.value_, byArray, n);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.truncated_ = 0;
        if (object instanceof String) {
            boolean bl = false;
            try {
                long l = Long.parseLong((String)object);
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    this.truncated_ = 4;
                    if (this.vrm_ >= JDUtilities.vrm610) {
                        JDError.throwSQLException(this, "07006");
                    }
                }
                this.value_ = (int)l;
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (bl) {
                try {
                    double d = Double.valueOf((String)object);
                    if (d > 2.147483647E9 || d < -2.147483648E9) {
                        this.truncated_ = 4;
                        if (this.vrm_ >= JDUtilities.vrm610) {
                            JDError.throwSQLException(this, "07006");
                        }
                    }
                    this.value_ = (int)d;
                }
                catch (NumberFormatException numberFormatException) {
                    JDError.throwSQLException(this, "07006");
                }
            }
        } else if (object instanceof Number) {
            long l = ((Number)object).longValue();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                this.truncated_ = 4;
            }
            this.value_ = (int)l;
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object == true ? 1 : 0;
        } else {
            JDError.throwSQLException(this, "07006");
        }
        if (this.scale_ > 0) {
            this.bigDecimalValue_ = new BigDecimal(Integer.toString(this.value_)).movePointLeft(this.scale_);
            this.value_ = this.bigDecimalValue_.intValue();
        }
    }

    public void set(int n) {
        this.value_ = n;
    }

    public int getSQLType() {
        return 18;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 11;
    }

    public String getJavaClassName() {
        return "java.lang.Integer";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "INTEGER";
    }

    public int getMaximumPrecision() {
        return 10;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 496;
    }

    public int getPrecision() {
        return 10;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return this.scale_;
    }

    public int getType() {
        return 4;
    }

    public String getTypeName() {
        return "INTEGER";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return 4;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        if (this.scale_ > 0) {
            if (n >= 0) {
                return this.bigDecimalValue_.setScale(n);
            }
            return this.bigDecimalValue_;
        }
        if (n <= 0) {
            return BigDecimal.valueOf(this.value_);
        }
        return BigDecimal.valueOf(this.value_).setScale(n);
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        return this.value_ != 0;
    }

    public byte getByte() throws SQLException {
        if (this.value_ > 127 || this.value_ < -128) {
            this.truncated_ = this.value_ > Short.MAX_VALUE || this.value_ < Short.MIN_VALUE ? 3 : 1;
        }
        return (byte)this.value_;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Clob getClob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.doubleValue();
        }
        return this.value_;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.floatValue();
        }
        return this.value_;
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        return this.value_;
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        return this.value_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return new Integer(this.value_);
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > Short.MAX_VALUE || this.value_ < Short.MIN_VALUE) {
            this.truncated_ = 2;
        }
        return (short)this.value_;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.toString();
        }
        return Integer.toString(this.value_);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Reader getNCharacterStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public NClob getNClob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        if (this.scale_ > 0) {
            return this.bigDecimalValue_.toString();
        }
        return Integer.toString(this.value_);
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

