/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDBClobLocator
implements SQLLocator {
    private static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private SQLConversionSettings settings_;
    private int truncated_;
    private int columnIndex_;
    private Object savedObject_;
    private int scale_;

    SQLDBClobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.locator_ = new JDLobLocator(aS400JDBCConnection, n, n2, true);
        this.maxLength_ = n2;
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
    }

    public Object clone() {
        return new SQLDBClobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (!(object instanceof String || object instanceof Reader || object instanceof InputStream || object instanceof Clob || object instanceof SQLXML)) {
            JDError.throwSQLException("07006");
        }
        this.savedObject_ = object;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToServer() throws SQLException {
        Object object = this.savedObject_;
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = this.converter_.stringToByteArray(string);
            this.locator_.writeData(0L, byArray, true);
        } else if (object instanceof Reader) {
            int n = this.scale_ * 2;
            if (n == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (n > 0) {
                try {
                    int n2 = n < 262144 ? n : 262144;
                    int n3 = this.settings_.getBidiStringType();
                    if (n3 == -1) {
                        n3 = this.converter_.bidiStringType_;
                    }
                    BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n3);
                    bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                    bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                    ReaderInputStream readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, n2);
                    byte[] byArray = new byte[n2];
                    int n4 = 0;
                    int n5 = readerInputStream.read(byArray, 0, n2);
                    while (n5 > -1 && n4 < n) {
                        this.locator_.writeData(n4 / 2, byArray, 0, n5, true);
                        int n6 = n - (n4 += n5);
                        if (n6 < n2) {
                            n2 = n6;
                            if (readerInputStream.available() == 0 && n2 != 0) {
                                readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), bidiConversionProperties, n2);
                            }
                        }
                        n5 = readerInputStream.read(byArray, 0, n2);
                    }
                    if (n4 < n) {
                        JDError.throwSQLException(this, "07006");
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (object instanceof InputStream) {
            int n = this.scale_ * 2;
            if (n == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (n > 0) {
                InputStream inputStream = (InputStream)this.savedObject_;
                int n7 = n < 262144 ? n : 262144;
                byte[] byArray = new byte[n7];
                try {
                    int n8 = 0;
                    int n9 = inputStream.read(byArray, 0, n7);
                    while (n9 > -1 && n8 < n) {
                        this.locator_.writeData(n8 / 2, byArray, 0, n9, true);
                        int n10 = n - (n8 += n9);
                        if (n10 < n7) {
                            n7 = n10;
                        }
                        n9 = inputStream.read(byArray, 0, n7);
                    }
                    if (n8 < n) {
                        JDError.throwSQLException(this, "07006");
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Clob) {
            Clob clob;
            boolean bl = false;
            if (object instanceof AS400JDBCClobLocator) {
                clob = (AS400JDBCClobLocator)object;
                AS400JDBCClobLocator aS400JDBCClobLocator = clob;
                synchronized (aS400JDBCClobLocator) {
                    if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                        this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                        ((AS400JDBCClobLocator)clob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!bl) {
                int n;
                clob = (Clob)object;
                int n11 = (int)clob.length();
                if (n11 < (n = 262144)) {
                    n = n11;
                }
                int n12 = 1;
                AS400JDBCClobLocator aS400JDBCClobLocator = (AS400JDBCClobLocator)this.getClob();
                while (n12 <= n11) {
                    String string = clob.getSubString(n12, n);
                    aS400JDBCClobLocator.setString(n12, string);
                    if (n11 - (n12 += n) >= n) continue;
                    n = n11 - n12 + 1;
                }
                bl = true;
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (object instanceof SQLXML) {
            SQLXML sQLXML = (SQLXML)object;
            String string = sQLXML.getString();
            this.locator_.writeData(0L, this.converter_.stringToByteArray(string), 0, string.length(), true);
        } else {
            JDError.throwSQLException(this, "07006");
        }
    }

    public int getSQLType() {
        return 12;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_ / 2;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCClobLocator";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "DBCLOB";
    }

    public int getMaximumPrecision() {
        return 0x3FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 968;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2005;
    }

    public String getTypeName() {
        return "DBCLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 819);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new HexReaderInputStream(new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.getString()), this.maxLength_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        Clob clob = this.getClob();
        return clob.getSubString(1L, (int)clob.length());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(this.locator_), this.converter_.getCcsid()), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        return new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        return string;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        return new AS400JDBCSQLXML(this.getString().toCharArray());
    }
}

