/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBlobLocator
implements SQLLocator {
    private static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private SQLConversionSettings settings_;
    private int truncated_;
    private int columnIndex_;
    private Object savedObject_;
    private int scale_;

    SQLBlobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.locator_ = new JDLobLocator(aS400JDBCConnection, n, n2, false);
        this.maxLength_ = n2;
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
    }

    public Object clone() {
        return new SQLBlobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToServer() throws SQLException {
        if (this.savedObject_ instanceof byte[]) {
            byte[] byArray = (byte[])this.savedObject_;
            this.locator_.writeData(0L, byArray, true);
        } else if (this.savedObject_ instanceof InputStream) {
            int n = this.scale_;
            if (n == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (n > 0) {
                InputStream inputStream = (InputStream)this.savedObject_;
                int n2 = n < 262144 ? n : 262144;
                byte[] byArray = new byte[n2];
                try {
                    int n3 = 0;
                    int n4 = inputStream.read(byArray, 0, n2);
                    while (n4 > -1 && n3 < n) {
                        this.locator_.writeData(n3, byArray, 0, n4, true);
                        int n5 = n - (n3 += n4);
                        if (n5 < n2) {
                            n2 = n5;
                        }
                        n4 = inputStream.read(byArray, 0, n2);
                    }
                    if (n3 < n) {
                        JDError.throwSQLException(this, "07006");
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (JDUtilities.JDBCLevel_ >= 20 && this.savedObject_ instanceof Blob) {
            Blob blob;
            boolean bl = false;
            if (this.savedObject_ instanceof AS400JDBCBlobLocator) {
                blob = (AS400JDBCBlobLocator)this.savedObject_;
                AS400JDBCBlobLocator aS400JDBCBlobLocator = blob;
                synchronized (aS400JDBCBlobLocator) {
                    if (((AS400JDBCBlobLocator)blob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCBlobLocator)blob).savedObject_;
                        this.scale_ = ((AS400JDBCBlobLocator)blob).savedScale_;
                        ((AS400JDBCBlobLocator)blob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!bl) {
                blob = (Blob)this.savedObject_;
                int n = (int)blob.length();
                byte[] byArray = blob.getBytes(1L, n);
                this.locator_.writeData(0L, byArray, 0, n, true);
            }
        } else {
            JDError.throwSQLException(this, "07006");
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.truncated_ = byArray.length > this.maxLength_ ? byArray.length - this.maxLength_ : 0;
        } else if (object instanceof String) {
            byte[] byArray = null;
            try {
                byArray = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
            object = byArray;
            this.truncated_ = 0;
        } else if (object instanceof Reader) {
            int n2 = n;
            byte[] byArray = null;
            if (n2 >= 0) {
                try {
                    int n3;
                    int n4 = n2 < 262144 ? n2 : 262144;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    HexReaderInputStream hexReaderInputStream = new HexReaderInputStream((Reader)object);
                    byte[] byArray2 = new byte[n4];
                    int n5 = 0;
                    int n6 = hexReaderInputStream.read(byArray2, 0, n4);
                    while (n6 > -1 && n5 < n2) {
                        byteArrayOutputStream.write(byArray2, 0, n6);
                        n3 = n2 - (n5 += n6);
                        if (n3 < n4) {
                            n4 = n3;
                        }
                        n6 = hexReaderInputStream.read(byArray2, 0, n4);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    if (byArray.length < n2) {
                        JDError.throwSQLException(this, "07006");
                    }
                    n3 = byArray.length;
                    if (byArray.length > this.maxLength_) {
                        byte[] byArray3 = new byte[this.maxLength_];
                        System.arraycopy(byArray, 0, byArray3, 0, this.maxLength_);
                        byArray = byArray3;
                    }
                    object = byArray;
                    this.truncated_ = n3 - byArray.length;
                }
                catch (ExtendedIOException extendedIOException) {
                    JDError.throwSQLException((Object)this, "07006", extendedIOException);
                }
                catch (IOException iOException) {
                    JDError.throwSQLException("HY000", iOException);
                }
            } else {
                JDError.throwSQLException("07006");
            }
        } else if (!(object instanceof String || JDUtilities.JDBCLevel_ < 20 || object instanceof Blob || object instanceof Reader || object instanceof InputStream)) {
            JDError.throwSQLException(this, "07006");
        }
        this.savedObject_ = object;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    public int getSQLType() {
        return 4;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCBlobLocator";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "BLOB";
    }

    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 960;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2004;
    }

    public String getTypeName() {
        return "BLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        return new AS400JDBCInputStream(new JDLobLocator(this.locator_));
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        return new AS400JDBCBlobLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        int n = (int)this.locator_.getLength();
        if (n == 0) {
            return new byte[0];
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, n);
        int n2 = dBLobData.getLength();
        byte[] byArray = new byte[n2];
        System.arraycopy(dBLobData.getRawBytes(), dBLobData.getOffset(), byArray, 0, n2);
        this.truncated_ = 0;
        return byArray;
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        return new StringReader(BinaryConverter.bytesToString(this.getBytes()));
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        String string = BinaryConverter.bytesToString(this.getBytes());
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return new AS400JDBCBlobLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        return BinaryConverter.bytesToString(this.getBytes());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        return new StringReader(BinaryConverter.bytesToString(this.getBytes()));
    }

    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        String string = BinaryConverter.bytesToString(this.getBytes());
        return new AS400JDBCNClob(string, string.length());
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        return BinaryConverter.bytesToString(this.getBytes());
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

