/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AFPResourceImplRemote;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPData;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPResHandle;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.NPCPSplFHandle;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.NPConversation;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.PrintObjectImpl;
import com.ibm.as400.access.PrintObjectInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.SpooledFileImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class PrintObjectInputStreamImplRemote
implements PrintObjectInputStreamImpl {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private NPConversation conversation_;
    private NPCodePoint cpObjHndl_;
    private NPCPID cpObjID_;
    private NPCPAttribute cpCPFMsg_;
    private int markLimit_ = 0;
    private boolean markSet_ = false;
    private NPSystem npSystem_;
    private int numBytes_ = 0;
    private int objectType_;
    private int offset_ = 0;
    private int offsetFromMark_ = 0;

    PrintObjectInputStreamImplRemote() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPrintObjectInputStream(SpooledFileImpl spooledFileImpl, PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.objectType_ = 1;
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        this.npSystem_ = NPSystem.getSystem(((SpooledFileImplRemote)spooledFileImpl).getSystem());
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjID_ = ((SpooledFileImplRemote)spooledFileImpl).getIDCodePoint();
        this.cpObjHndl_ = new NPCPSplFHandle();
        nPDataStream.setAction(2);
        nPDataStream.addCodePoint(this.cpObjID_);
        NPCPSelection nPCPSelection = new NPCPSelection();
        if (printParameterList != null) {
            nPCPSelection.addUpdateAttributes(printParameterList.getAttrCodePoint());
        }
        nPCPSelection.setAttrValue(184, "*YES");
        nPDataStream.addCodePoint(nPCPSelection);
        nPDataStream2.addCodePoint(this.cpObjHndl_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean bl = false;
        try {
            int n = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            if (n != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + n);
                throw new ErrorCompletingRequestException(1);
            }
            this.retrieveNumberOfBytes();
            bl = true;
        }
        finally {
            if (!bl) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPrintObjectInputStream(SpooledFileImpl spooledFileImpl, PrintParameterList printParameterList, String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.objectType_ = 1;
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        this.npSystem_ = NPSystem.getSystem(((SpooledFileImplRemote)spooledFileImpl).getSystem());
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjID_ = ((SpooledFileImplRemote)spooledFileImpl).getIDCodePoint();
        this.cpObjHndl_ = new NPCPSplFHandle();
        nPDataStream.setAction(2);
        nPDataStream.addCodePoint(this.cpObjID_);
        NPCPSelection nPCPSelection = new NPCPSelection();
        nPCPSelection.setAttrValue(315, string);
        if (printParameterList != null) {
            nPCPSelection.addUpdateAttributes(printParameterList.getAttrCodePoint());
        }
        nPCPSelection.setAttrValue(184, "*YES");
        nPDataStream.addCodePoint(nPCPSelection);
        nPDataStream2.addCodePoint(this.cpObjHndl_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean bl = false;
        try {
            int n = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            if (n != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + n);
                throw new ErrorCompletingRequestException(1);
            }
            this.retrieveNumberOfBytes();
            bl = true;
        }
        finally {
            if (!bl) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createPrintObjectInputStream(PrintObjectImpl printObjectImpl, PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.objectType_ = 7;
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        this.npSystem_ = NPSystem.getSystem(((AFPResourceImplRemote)printObjectImpl).getSystem());
        this.cpCPFMsg_ = new NPCPAttribute();
        this.cpObjID_ = ((AFPResourceImplRemote)printObjectImpl).getIDCodePoint();
        this.cpObjHndl_ = new NPCPResHandle();
        nPDataStream.setAction(2);
        nPDataStream.addCodePoint(this.cpObjID_);
        if (printParameterList != null) {
            nPDataStream.addCodePoint(printParameterList.getAttrCodePoint());
        }
        nPDataStream2.addCodePoint(this.cpObjHndl_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        this.conversation_ = this.npSystem_.getConversation();
        boolean bl = false;
        try {
            int n = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            if (n != 0) {
                String string = this.conversation_.getAttribute(141);
                Trace.log(2, "Error opening AFP Resource; rc = " + n);
                switch (n) {
                    case 4: {
                        throw new RequestNotSupportedException(string, 1);
                    }
                }
            } else {
                this.retrieveNumberOfBytes();
                bl = true;
            }
        }
        finally {
            if (!bl) {
                if (this.npSystem_ != null) {
                    this.npSystem_.returnConversation(this.conversation_);
                }
                this.conversation_ = null;
            }
        }
    }

    public int available() throws IOException {
        return this.numBytes_ - this.offset_;
    }

    public void close() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        nPDataStream.setAction(5);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            int n = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            if (n != 0) {
                Trace.log(2, "Error opening SpooledFile; rc = " + n);
                this.npSystem_.returnConversation(this.conversation_);
                this.conversation_ = null;
            }
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
        finally {
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.conversation_ != null) {
            NPDataStream nPDataStream = new NPDataStream(this.objectType_);
            nPDataStream.setAction(5);
            nPDataStream.addCodePoint(this.cpObjHndl_);
            AS400Server aS400Server = this.conversation_.getServer();
            if (aS400Server != null) {
                nPDataStream.setConverter(this.conversation_.getConverter());
                aS400Server.sendAndDiscardReply(nPDataStream);
            }
            if (this.npSystem_ != null) {
                this.npSystem_.returnConversation(this.conversation_);
                this.npSystem_ = null;
            }
            this.conversation_ = null;
        }
        super.finalize();
    }

    public synchronized void mark(int n) {
        this.offsetFromMark_ = 0;
        this.markLimit_ = n;
        this.markSet_ = true;
    }

    public boolean markSupported() {
        return true;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        NPCPData nPCPData = new NPCPData();
        nPCPAttribute.setAttrValue(125, n2);
        nPDataStream.setAction(3);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream.addCodePoint(nPCPAttribute);
        nPCPData.setDataBuffer(byArray, 0, n);
        nPDataStream2.addCodePoint(nPCPData);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            int n4 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            switch (n4) {
                case 0: 
                case 18: {
                    n3 = nPCPData.getDataLength();
                    this.offsetFromMark_ += n3;
                    this.offset_ += n3;
                    break;
                }
                case 19: {
                    n3 = -1;
                    break;
                }
                default: {
                    Trace.log(2, "Error received on read : " + Integer.toString(n4));
                    throw new IOException(Integer.toString(n4));
                }
            }
        }
        catch (Exception exception) {
            Trace.log(2, "PrintObjectInputStream::read() - caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        if (!this.markSet_) {
            Trace.log(2, "Mark not set.");
            throw new IOException();
        }
        if (this.markLimit_ == 0 || this.offsetFromMark_ > this.markLimit_) {
            Trace.log(4, "Stream has not been marked or mark has been invalidated.");
            throw new IOException();
        }
        if (this.offsetFromMark_ != 0) {
            this.seekFromCur(-this.offsetFromMark_);
        }
    }

    private void retrieveNumberOfBytes() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        Integer n;
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        NPCPAttributeIDList nPCPAttributeIDList = new NPCPAttributeIDList();
        nPCPAttributeIDList.addAttrID(125);
        nPDataStream.addCodePoint(this.cpObjID_);
        nPDataStream.addCodePoint(nPCPAttributeIDList);
        nPDataStream.setAction(15);
        nPDataStream2.addCodePoint(nPCPAttribute);
        int n2 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
        if (n2 == 0) {
            n = nPCPAttribute.getIntValue(125);
            if (n == null) {
                Trace.log(2, " Network Print Server does not support retrieving splf/resource length");
                throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
            }
        } else {
            Trace.log(2, " Network Print Server error retrieving splf/resource length. RC =" + n2);
            throw new RequestNotSupportedException(this.conversation_.getAttribute(141), 1);
        }
        this.numBytes_ = n;
    }

    public long skip(long l) throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        int n = this.numBytes_ - this.offset_;
        if (l > (long)n) {
            l = n;
        }
        this.seekFromCur((int)l);
        return l;
    }

    private void seekFromCur(int n) throws IOException {
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPCPAttribute.setAttrValue(127, 2);
        nPCPAttribute.setAttrValue(126, n);
        nPDataStream.setAction(23);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream.addCodePoint(nPCPAttribute);
        nPDataStream2.addCodePoint(this.cpCPFMsg_);
        try {
            int n2 = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            switch (n2) {
                case 0: {
                    this.offsetFromMark_ += n;
                    this.offset_ += n;
                    break;
                }
                default: {
                    Trace.log(2, "Seek from cur error " + Integer.toString(n2));
                    throw new IOException(Integer.toString(n2));
                }
            }
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
    }

    long tell() throws IOException {
        if (this.conversation_ == null) {
            Trace.log(2, "Conversation is null.");
            throw new IOException();
        }
        NPDataStream nPDataStream = new NPDataStream(this.objectType_);
        NPDataStream nPDataStream2 = new NPDataStream(this.objectType_);
        NPCPAttributeIDList nPCPAttributeIDList = new NPCPAttributeIDList();
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPCPAttributeIDList.addAttrID(126);
        nPDataStream.setAction(24);
        nPDataStream.addCodePoint(this.cpObjHndl_);
        nPDataStream2.addCodePoint(nPCPAttribute);
        try {
            int n = this.conversation_.makeRequest(nPDataStream, nPDataStream2);
            switch (n) {
                case 0: {
                    Integer n2 = nPCPAttribute.getIntValue(126);
                    if (n2 == null) {
                        Trace.log(2, " tell() returned null!");
                        throw new InternalErrorException(4);
                    }
                    return n2.intValue();
                }
            }
            Trace.log(2, " NPServer.Tell() returned " + n);
            throw new InternalErrorException(4);
        }
        catch (Exception exception) {
            Trace.log(2, "Caught an Exception." + exception.toString());
            throw new IOException(exception.toString());
        }
    }
}

