/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileInputStreamImpl;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class IFSFileInputStream
extends InputStream
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final int SHARE_ALL = -1;
    public static final int SHARE_NONE = -4;
    public static final int SHARE_READERS = -3;
    public static final int SHARE_WRITERS = -2;
    protected IFSFileDescriptor fd_;
    private transient PropertyChangeSupport changes_;
    private transient Vector fileListeners_;
    private transient VetoableChangeSupport vetos_;
    transient IFSFileInputStreamImpl impl_;

    public IFSFileInputStream() {
        this.fd_ = new IFSFileDescriptor(-1, this);
        this.initializeTransient();
    }

    public IFSFileInputStream(AS400 aS400, String string) throws AS400SecurityException, IOException {
        this(aS400, string, -1);
    }

    public IFSFileInputStream(AS400 aS400, String string, int n) throws AS400SecurityException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        IFSFileInputStream.validateShareOption(n);
        this.initializeTransient();
        this.fd_ = new IFSFileDescriptor(aS400, string, n, this);
        this.connectAndOpen();
    }

    public IFSFileInputStream(IFSFile iFSFile) throws AS400SecurityException, IOException {
        this(iFSFile == null ? null : iFSFile.getSystem(), iFSFile, -1);
    }

    public IFSFileInputStream(AS400 aS400, IFSFile iFSFile, int n) throws AS400SecurityException, IOException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        IFSFileInputStream.validateShareOption(n);
        this.initializeTransient();
        this.fd_ = new IFSFileDescriptor(aS400, iFSFile.getAbsolutePath(), n, this);
        this.connectAndOpen();
    }

    public IFSFileInputStream(IFSFile iFSFile, int n) throws AS400SecurityException, IOException {
        this(iFSFile == null ? null : iFSFile.getSystem(), iFSFile, n);
    }

    public IFSFileInputStream(IFSFileDescriptor iFSFileDescriptor) {
        if (iFSFileDescriptor == null) {
            throw new NullPointerException("fd");
        }
        IFSFileInputStream.validateShareOption(iFSFileDescriptor.getShareOption());
        this.initializeTransient();
        this.fd_ = iFSFileDescriptor;
    }

    public IFSFileInputStream(IFSJavaFile iFSJavaFile) throws AS400SecurityException, IOException {
        this(iFSJavaFile == null ? null : iFSJavaFile.getSystem(), iFSJavaFile, -1);
    }

    public IFSFileInputStream(AS400 aS400, IFSJavaFile iFSJavaFile, int n) throws AS400SecurityException, IOException {
        if (iFSJavaFile == null) {
            throw new NullPointerException("file");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        IFSFileInputStream.validateShareOption(n);
        this.initializeTransient();
        this.fd_ = new IFSFileDescriptor(aS400, iFSJavaFile.getAbsolutePath().replace(IFSJavaFile.separatorChar, '/'), n, this);
        this.connectAndOpen();
    }

    public IFSFileInputStream(IFSJavaFile iFSJavaFile, int n) throws AS400SecurityException, IOException {
        this(iFSJavaFile == null ? null : iFSJavaFile.getSystem(), iFSJavaFile, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.addElement(fileListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public int available() throws IOException {
        this.open();
        return this.impl_.available();
    }

    private void chooseImpl() {
        if (this.impl_ == null) {
            AS400 aS400 = this.fd_.getSystem();
            if (aS400 == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (IFSFileInputStreamImpl)aS400.loadImpl2("com.ibm.as400.access.IFSFileInputStreamImplRemote", "com.ibm.as400.access.IFSFileInputStreamImplProxy");
            this.impl_.setFD(this.fd_.getImpl());
        }
    }

    public void close() throws IOException {
        if (!this.fd_.isClosed() && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireClosedEvents(this, this.fileListeners_);
            }
        }
    }

    private void connectAndOpen() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            this.fd_.getSystem().connectService(0);
        }
        this.impl_.connectAndOpen();
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    protected void finalize() throws IOException {
        if (this.fd_ != null && this.fd_.isOpen()) {
            if (this.impl_ != null) {
                this.impl_.close();
            } else {
                this.fd_.close();
            }
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            Trace.log(2, "Error during finalization.");
            throw new IOException(throwable.toString());
        }
    }

    public final IFSFileDescriptor getFD() throws IOException {
        return this.fd_;
    }

    IFSFileInputStreamImpl getImpl() {
        return this.impl_;
    }

    public String getPath() {
        return this.fd_.getPath();
    }

    public int getShareOption() {
        return this.fd_.getShareOption();
    }

    public AS400 getSystem() {
        return this.fd_.getSystem();
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.fileListeners_ = new Vector();
        this.vetos_ = new VetoableChangeSupport(this);
        this.impl_ = null;
    }

    public IFSKey lock(int n) throws IOException {
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("length (" + Integer.toString(n) + ")", 2);
        }
        this.open();
        return this.impl_.lock(n);
    }

    protected void open() throws IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
            try {
                this.fd_.getSystem().connectService(0);
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, "Access to byte stream server on '" + this.fd_.getSystem().getSystemName() + "' denied.", (Throwable)aS400SecurityException);
                throw new ExtendedIOException(5);
            }
        }
        if (this.fd_.isOpen()) {
            return;
        }
        this.impl_.open();
        if (this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireOpenedEvents(this, this.fileListeners_);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public int read() throws IOException {
        int n;
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        if (n2 == 1) {
            n = byArray[0];
            n &= 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("dataOffset", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (n2 == 0) {
            return 0;
        }
        this.open();
        return this.impl_.read(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        Vector vector = this.fileListeners_;
        synchronized (vector) {
            this.fileListeners_.removeElement(fileListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void reset() throws IOException {
        if (this.fd_.isClosed()) {
            Trace.log(2, "The stream has been closed.");
            throw new IOException();
        }
        this.rewind();
    }

    public void rewind() {
        if (this.fd_.isOpen()) {
            this.fd_.setFileOffset(0L);
        }
    }

    public void setFD(IFSFileDescriptor iFSFileDescriptor) throws PropertyVetoException {
        if (iFSFileDescriptor == null) {
            throw new NullPointerException("fd");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("FD", 5);
        }
        IFSFileDescriptor iFSFileDescriptor2 = this.fd_;
        this.vetos_.fireVetoableChange("FD", iFSFileDescriptor2, iFSFileDescriptor);
        this.fd_ = iFSFileDescriptor;
        this.changes_.firePropertyChange("FD", iFSFileDescriptor2, this.fd_);
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String string2 = string.length() == 0 || string.charAt(0) != '/' ? "/" + string : string;
        String string3 = this.fd_.getPath();
        this.vetos_.fireVetoableChange("path", string3, string2);
        this.fd_.setPath(string2);
        this.changes_.firePropertyChange("path", string3, string2);
    }

    public void setShareOption(int n) throws PropertyVetoException {
        IFSFileInputStream.validateShareOption(n);
        if (this.fd_.valid()) {
            throw new ExtendedIllegalStateException("shareOption", 5);
        }
        Integer n2 = null;
        Integer n3 = null;
        n2 = new Integer(this.fd_.getShareOption());
        n3 = new Integer(n);
        this.vetos_.fireVetoableChange("shareOption", n2, n3);
        this.fd_.setShareOption(n);
        this.changes_.firePropertyChange("shareOption", n2, n3);
    }

    static final void validateShareOption(int n) {
        if (n < -4 || n > -1) {
            throw new ExtendedIllegalArgumentException("shareOption (" + Integer.toString(n) + ")", 2);
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.fd_.valid()) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.fd_.getSystem();
        this.vetos_.fireVetoableChange("system", aS4002, aS400);
        this.fd_.setSystem(aS400);
        this.changes_.firePropertyChange("system", aS4002, aS400);
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException("bytesToSkip (" + Long.toString(l) + ")", 2);
        }
        this.open();
        return this.impl_.skip(l);
    }

    public void unlock(IFSKey iFSKey) throws IOException {
        if (iFSKey == null) {
            throw new NullPointerException("key");
        }
        this.open();
        this.impl_.unlock(iFSKey);
    }
}

