/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.EnvironmentVariable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class EnvironmentVariableList
implements Serializable {
    private static final String copyright = "Copyright (C) 2000-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private AS400 system_ = null;
    private transient ServiceProgramCall spc_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;

    public EnvironmentVariableList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing EnvironmentVariableList object.");
        }
    }

    public EnvironmentVariableList(AS400 aS400) {
        this();
        if (Trace.traceOn_) {
            Trace.log(1, " system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        EnvironmentVariableList environmentVariableList = this;
        synchronized (environmentVariableList) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public Enumeration getEnvironmentVariables() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variables.");
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(2, 4096), new ProgramParameter(2, new byte[]{0, 0, 16, 0}, 4), new ProgramParameter(2, 1024), new ProgramParameter(2, new byte[]{0, 0, 4, 0}, 4), EnvironmentVariable.nullParameter};
        int n = EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zGetAllSysEnv", programParameterArray, 3404, 3025);
        int n2 = BinaryConverter.byteArrayToInt(programParameterArray[1].getOutputData(), 0);
        int n3 = BinaryConverter.byteArrayToInt(programParameterArray[3].getOutputData(), 0);
        if (n == 3404) {
            if (Trace.traceOn_) {
                Trace.log(3, "ENOSPC returned, getting environment variable list again with " + n2 + " bytes for the list and " + n3 + " bytes for the ccsids.");
            }
            try {
                programParameterArray[0].setOutputDataLength(n2);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n2));
                programParameterArray[2].setOutputDataLength(n3);
                programParameterArray[3].setInputData(BinaryConverter.intToByteArray(n3));
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
                throw new InternalErrorException(10);
            }
            EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zGetAllSysEnv", programParameterArray, 0, 0);
        } else if (n == 3025) {
            return new Vector().elements();
        }
        Vector<EnvironmentVariable> vector = new Vector<EnvironmentVariable>();
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = programParameterArray[0].getOutputData();
        byte[] byArray2 = programParameterArray[2].getOutputData();
        do {
            int n6 = n4;
            while (byArray[n6] != 126) {
                ++n6;
            }
            int n7 = n6;
            while (byArray[n7] != 0) {
                ++n7;
            }
            byte[] byArray3 = new byte[n6 - n4 + 1];
            System.arraycopy(byArray, n4, byArray3, 0, byArray3.length - 1);
            byte[] byArray4 = new byte[n7 - n6];
            System.arraycopy(byArray, n6 + 1, byArray4, 0, byArray4.length - 1);
            int n8 = BinaryConverter.byteArrayToInt(byArray2, n5);
            vector.addElement(new EnvironmentVariable(this.system_, this.spc_, byArray3, byArray4, n8));
            n4 = n7 + 1;
            n5 += 4;
        } while (byArray[n4] != 0);
        return vector.elements();
    }

    public Properties getProperties() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variables as Properties.");
        }
        Properties properties = new Properties();
        Enumeration enumeration = this.getEnvironmentVariables();
        while (enumeration.hasMoreElements()) {
            EnvironmentVariable environmentVariable = (EnvironmentVariable)enumeration.nextElement();
            properties.put(environmentVariable.getName(), environmentVariable.getValue());
        }
        return properties;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void setProperties(Properties properties) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setProperties(properties, -1);
    }

    public void setProperties(Properties properties, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting environment variables from Properties.");
        }
        if (properties == null) {
            Trace.log(2, "Parameter 'properties' is null.");
            throw new NullPointerException("properties");
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        if (n == -1) {
            n = AS400BidiTransform.getStringType(this.system_.getCcsid());
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EnvironmentVariable environmentVariable = new EnvironmentVariable(this.system_, this.spc_, string);
            environmentVariable.setValue(properties.getProperty(string), 0, n);
        }
    }

    public void setSystem(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.spc_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002;
            AS400 aS4003 = this.system_;
            this.system_ = aS4002 = aS400;
            this.propertyChangeListeners_.firePropertyChange("system", aS4003, aS4002);
        }
    }
}

