/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import java.io.IOException;
import java.io.InputStream;
import java.sql.DriverManager;
import java.sql.SQLException;

class AS400JDBCInputStream
extends InputStream {
    private static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private boolean closed_;
    private JDLobLocator locator_;
    private long offset_;
    private long length_;
    private long mark_ = 0L;

    AS400JDBCInputStream(JDLobLocator jDLobLocator) {
        this.locator_ = jDLobLocator;
        this.offset_ = 0L;
        this.closed_ = false;
        try {
            this.length_ = jDLobLocator.getLength();
        }
        catch (SQLException sQLException) {
            this.length_ = 0L;
            this.closed_ = true;
        }
    }

    AS400JDBCInputStream(JDLobLocator jDLobLocator, long l, long l2) {
        long l3;
        this.locator_ = jDLobLocator;
        this.offset_ = l;
        this.length_ = l2;
        this.closed_ = false;
        try {
            l3 = jDLobLocator.getLength();
        }
        catch (SQLException sQLException) {
            l3 = 0L;
            this.closed_ = true;
        }
        if (this.length_ > l3) {
            this.length_ = l3;
        }
    }

    public synchronized int available() throws IOException {
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        long l = 0L;
        l = this.length_ - this.offset_;
        if (l < 0L) {
            l = 0L;
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public synchronized void close() throws IOException {
        this.closed_ = true;
    }

    public void mark(int n) {
        this.mark_ = this.offset_;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() throws IOException {
        int n = -1;
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) > 0) {
            n = byArray[0] & 0xFF;
        }
        return n;
    }

    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        if (n < 0 || n > byArray.length) {
            throw new ExtendedIllegalArgumentException("start", 2);
        }
        if (n2 < 0 || n + n2 > byArray.length) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            DBLobData dBLobData;
            int n3;
            if (this.offset_ >= this.length_) {
                return -1;
            }
            if (this.locator_.isGraphic()) {
                n2 /= 2;
            }
            if ((n3 = (dBLobData = this.locator_.retrieveData(this.offset_, n2)).getLength()) == 0) {
                this.closed_ = true;
                return -1;
            }
            System.arraycopy(dBLobData.getRawBytes(), dBLobData.getOffset(), byArray, n, n3);
            this.offset_ += this.locator_.isGraphic() ? (long)(n3 / 2) : (long)n3;
            return n3;
        }
        catch (SQLException sQLException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Error in read");
                sQLException.printStackTrace(DriverManager.getLogStream());
                this.closed_ = true;
            }
            throw new IOException(sQLException.getMessage());
        }
    }

    public void reset() throws IOException {
        this.offset_ = this.mark_;
    }

    public synchronized long skip(long l) throws IOException {
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = l + this.offset_;
        long l3 = this.length_;
        if (l2 > l3) {
            l = l3 - this.offset_;
            this.offset_ = l3;
        } else {
            this.offset_ += l;
        }
        return l;
    }
}

