/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class AS400JDBCDriver
implements Driver {
    private static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    static final int MAJOR_VERSION_ = 8;
    static final int MINOR_VERSION_ = 4;
    static final String DATABASE_PRODUCT_NAME_ = "DB2 UDB for AS/400";
    static final String DRIVER_NAME_ = "AS/400 Toolbox for Java JDBC Driver";
    static final String DRIVER_LEVEL_ = "06010004";
    public static final int JDBC_MAJOR_VERSION_ = 4;
    public static final int JDBC_MINOR_VERSION_ = 0;
    private static final String MRI_NOT_FOUND_ = "9999:9999";
    private static ResourceBundle resources_;
    private static ResourceBundle resources2_;

    public boolean acceptsURL(String string) throws SQLException {
        JDDataSourceURL jDDataSourceURL = new JDDataSourceURL(string);
        return jDDataSourceURL.isValid();
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        JDDataSourceURL jDDataSourceURL = new JDDataSourceURL(string);
        Properties properties2 = jDDataSourceURL.getProperties();
        if (JDProperties.isTraceSet(properties2, properties) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(properties2, properties) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(properties2, properties) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(properties2, properties) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        JDProperties jDProperties = new JDProperties(properties2, properties);
        Connection connection = null;
        if (jDDataSourceURL.isValid()) {
            connection = this.initializeConnection(jDDataSourceURL, jDProperties, properties);
        }
        return connection;
    }

    public Connection connect(AS400 aS400) throws SQLException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (aS400 instanceof SecureAS400) {
            return this.initializeConnection(new SecureAS400(aS400));
        }
        return this.initializeConnection(new AS400(aS400));
    }

    public Connection connect(AS400 aS400, boolean bl) throws SQLException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (!bl) {
            return this.initializeConnection(aS400);
        }
        return this.connect(aS400);
    }

    public Connection connect(AS400 aS400, Properties properties, String string, boolean bl) throws SQLException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        if (JDProperties.isTraceSet(null, properties) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(null, properties) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(null, properties) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        if (!bl) {
            return this.initializeConnection(string, properties, aS400);
        }
        if (aS400 instanceof SecureAS400) {
            return this.initializeConnection(string, properties, new SecureAS400(aS400));
        }
        return this.initializeConnection(string, properties, new AS400(aS400));
    }

    public Connection connect(AS400 aS400, Properties properties, String string) throws SQLException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        if (JDProperties.isTraceSet(null, properties) == "TRUE") {
            if (!JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
        } else if (JDProperties.isTraceSet(null, properties) == "FALSE" && JDTrace.isTraceOn()) {
            JDTrace.setTraceOn(false);
        }
        if (JDProperties.isToolboxTraceSet(null, properties) == "datastream") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDatastreamOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "diagnostic") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceDiagnosticOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "error") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceErrorOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "information") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceInformationOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "warning") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceWarningOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "conversion") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceConversionOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "proxy") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceProxyOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "pcml") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTracePCMLOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "jdbc") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceJDBCOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "all") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "thread") {
            if (!Trace.isTraceOn()) {
                Trace.setTraceOn(true);
            }
            Trace.setTraceThreadOn(true);
        } else if (JDProperties.isToolboxTraceSet(null, properties) == "none" && Trace.isTraceOn()) {
            Trace.setTraceOn(false);
        }
        if (aS400 instanceof SecureAS400) {
            return this.initializeConnection(string, properties, new SecureAS400(aS400));
        }
        return this.initializeConnection(string, properties, new AS400(aS400));
    }

    public int getMajorVersion() {
        return 8;
    }

    public int getMinorVersion() {
        return 4;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        JDDataSourceURL jDDataSourceURL = new JDDataSourceURL(string);
        DriverPropertyInfo[] driverPropertyInfoArray = null;
        if (jDDataSourceURL.isValid()) {
            JDProperties jDProperties = new JDProperties(jDDataSourceURL.getProperties(), properties);
            driverPropertyInfoArray = jDProperties.getInfo();
        }
        return driverPropertyInfoArray;
    }

    static String getResource(String string) {
        String string2;
        if (resources_ == null) {
            string2 = MRI_NOT_FOUND_;
        } else {
            try {
                string2 = resources_.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (resources2_ == null) {
                    string2 = MRI_NOT_FOUND_;
                }
                try {
                    string2 = resources2_.getString(string);
                }
                catch (MissingResourceException missingResourceException2) {
                    JDTrace.logInformation(AS400JDBCDriver.class, "Missing resource [" + string + "]");
                    string2 = MRI_NOT_FOUND_;
                }
            }
        }
        return string2;
    }

    static AS400 initializeAS400(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, Properties properties) {
        String string = jDDataSourceURL.getServerName();
        String string2 = jDProperties.getString(29);
        String string3 = jDProperties.getString(16);
        String string4 = jDProperties.getString(18);
        boolean bl = jDProperties.getBoolean(32);
        String string5 = jDProperties.getString(43);
        String string6 = jDProperties.getString(44);
        boolean bl2 = jDProperties.getBoolean(38);
        AS400 aS400 = null;
        if (bl) {
            aS400 = string.length() == 0 ? new SecureAS400() : (string2.length() == 0 ? new SecureAS400(string) : (string3.length() == 0 ? new SecureAS400(string, string2) : new SecureAS400(string, string2, string3)));
            if (string5 != null && string6 != null && string5 != "") {
                try {
                    ((SecureAS400)aS400).setKeyRingName(string5, string6);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else {
            aS400 = string.length() == 0 ? new AS400() : (string2.length() == 0 ? new AS400(string) : (string3.length() == 0 ? new AS400(string, string2) : new AS400(string, string2, string3)));
        }
        try {
            if (!string4.equals("")) {
                aS400.setGuiAvailable(jDProperties.getBoolean(18));
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            if (!bl2) {
                aS400.setThreadUsed(bl2);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return aS400;
    }

    private Connection initializeConnection(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, Properties properties) throws SQLException {
        Object object;
        AS400 aS400 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = jDProperties.getString(41);
        if (!string.equals("toolbox")) {
            try {
                object = (Driver)Class.forName("com.ibm.db2.jdbc.app.DB2Driver").newInstance();
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Native IBM Developer Kit for Java JDBC driver implementation was loaded");
                }
            }
            catch (Throwable throwable) {
                object = null;
            }
            if (object != null && jDDataSourceURL.getSecondaryURL().length() == 0) {
                Object object2;
                boolean bl4 = false;
                String string2 = jDDataSourceURL.getServerName();
                if (string2.length() == 0) {
                    bl4 = true;
                } else {
                    try {
                        object2 = InetAddress.getLocalHost();
                        InetAddress[] inetAddressArray = InetAddress.getAllByName(string2);
                        for (int i = 0; i < inetAddressArray.length; ++i) {
                            if (!((InetAddress)object2).equals(inetAddressArray[i])) continue;
                            bl4 = true;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (bl4) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Connection is local");
                    }
                    object2 = jDDataSourceURL.getNativeURL();
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Using native IBM Developer Kit for Java JDBC driver implementation (" + (String)object2 + ")");
                    }
                    return object.connect((String)object2, properties);
                }
            }
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Using IBM Toolbox for Java JDBC driver implementation");
        }
        if (jDProperties.getString(34).length() != 0) {
            bl = true;
        }
        if (SystemProperties.getProperty("com.ibm.as400.access.AS400.proxyServer") != null) {
            bl2 = true;
        }
        if (bl || bl2) {
            bl3 = true;
        }
        if (!bl3 && ((String)(object = jDDataSourceURL.getSecondaryURL())).length() != 0) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Secondary URL [" + (String)object + "]");
            }
            return DriverManager.getConnection((String)object, properties);
        }
        aS400 = AS400JDBCDriver.initializeAS400(jDDataSourceURL, jDProperties, properties);
        if (bl) {
            object = jDProperties.getString(34);
            try {
                aS400.setProxyServer((String)object);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return this.prepareConnection(aS400, jDDataSourceURL, properties, jDProperties);
    }

    private Connection initializeConnection(AS400 aS400) throws SQLException {
        JDDataSourceURL jDDataSourceURL = new JDDataSourceURL(null);
        Properties properties = new Properties();
        JDProperties jDProperties = new JDProperties(null, properties);
        return this.prepareConnection(aS400, jDDataSourceURL, properties, jDProperties);
    }

    private Connection initializeConnection(String string, Properties properties, AS400 aS400) throws SQLException {
        boolean bl = false;
        String string2 = null;
        string2 = string != null ? "jdbc:as400://" + aS400.getSystemName() + "/" + string : "jdbc:as400://" + aS400.getSystemName();
        JDDataSourceURL jDDataSourceURL = new JDDataSourceURL(string2);
        JDProperties jDProperties = new JDProperties(null, properties);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Using IBM Toolbox for Java JDBC driver implementation");
        }
        if (jDProperties.getString(34).length() != 0) {
            bl = true;
        }
        if (bl) {
            String string3 = jDProperties.getString(34);
            try {
                aS400.setProxyServer(string3);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return this.prepareConnection(aS400, jDDataSourceURL, properties, jDProperties);
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private Connection prepareConnection(AS400 aS400, JDDataSourceURL jDDataSourceURL, Properties properties, JDProperties jDProperties) throws SQLException {
        Connection connection;
        SocketProperties socketProperties = null;
        if (!jDProperties.getString(67).equals("")) {
            if (socketProperties == null) {
                socketProperties = aS400.getSocketProperties();
            }
            socketProperties.setKeepAlive(jDProperties.getBoolean(67));
        }
        if (!jDProperties.getString(68).equals("")) {
            if (socketProperties == null) {
                socketProperties = aS400.getSocketProperties();
            }
            socketProperties.setReceiveBufferSize(jDProperties.getInt(68));
        }
        if (!jDProperties.getString(69).equals("")) {
            if (socketProperties == null) {
                socketProperties = aS400.getSocketProperties();
            }
            socketProperties.setSendBufferSize(jDProperties.getInt(69));
        }
        if (socketProperties == null) {
            socketProperties = aS400.getSocketProperties();
        }
        socketProperties.setSoTimeout(DriverManager.getLoginTimeout() * 1000);
        if (!jDProperties.getString(58).equals("")) {
            if (socketProperties == null) {
                socketProperties = aS400.getSocketProperties();
            }
            socketProperties.setSoTimeout(jDProperties.getInt(58) * 1000);
        }
        if (socketProperties != null) {
            aS400.setSocketProperties(socketProperties);
        }
        if ((connection = (Connection)aS400.loadImpl2("com.ibm.as400.access.AS400JDBCConnection", "com.ibm.as400.access.JDConnectionProxy")) != null) {
            Class<?> clazz = connection.getClass();
            String string = clazz.getName();
            if (string.equals("com.ibm.as400.access.AS400JDBCConnection")) {
                ((AS400JDBCConnection)connection).setSystem(aS400);
                ((AS400JDBCConnection)connection).setProperties(jDDataSourceURL, jDProperties, aS400);
            } else if (string.equals("com.ibm.as400.access.JDConnectionProxy")) {
                ((JDConnectionProxy)connection).setSystem(aS400);
                ((JDConnectionProxy)connection).setProperties(jDDataSourceURL, jDProperties, aS400);
            }
        }
        return connection;
    }

    public String toString() {
        return DRIVER_NAME_;
    }

    static {
        try {
            DriverManager.registerDriver(new AS400JDBCDriver());
            resources_ = ResourceBundle.getBundle("com.ibm.as400.access.JDMRI");
            resources2_ = ResourceBundle.getBundle("com.ibm.as400.access.JDMRI2");
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

