/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCClobOutputStream;
import com.ibm.as400.access.AS400JDBCWriter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class AS400JDBCClob
implements Clob {
    private static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    protected char[] data_;
    protected int maxLength_;
    static final int MAX_LOB_SIZE = Integer.MAX_VALUE;

    AS400JDBCClob(String string, int n) {
        this.data_ = string.toCharArray();
        this.maxLength_ = n;
    }

    AS400JDBCClob(char[] cArray) {
        this.data_ = cArray;
    }

    public synchronized InputStream getAsciiStream() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        try {
            return new ByteArrayInputStream(new String(this.data_).getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public synchronized Reader getCharacterStream() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        return new CharArrayReader(this.data_);
    }

    public synchronized String getSubString(long l, int n) throws SQLException {
        int n2;
        int n3;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if ((n3 = (int)l - 1) < 0 || n < 0 || n3 + n > this.data_.length) {
            JDError.throwSQLException(this, "HY024");
        }
        if ((n2 = this.data_.length - n3) < 0) {
            return "";
        }
        if (n2 > n) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.data_, n3, cArray, 0, n2);
        return new String(cArray);
    }

    public long length() throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        return this.data_.length;
    }

    public synchronized long position(String string, long l) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        int n = (int)l - 1;
        if (string == null || n < 0 || n >= this.data_.length) {
            JDError.throwSQLException(this, "HY024");
        }
        char[] cArray = string.toCharArray();
        int n2 = this.data_.length - cArray.length;
        for (int i = n; i <= n2; ++i) {
            int n3;
            for (n3 = 0; n3 < cArray.length && this.data_[i + n3] == cArray[n3]; ++n3) {
            }
            if (n3 != cArray.length) continue;
            return i + 1;
        }
        return -1L;
    }

    public synchronized long position(Clob clob, long l) throws SQLException {
        int n;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        int n2 = (int)l - 1;
        if (clob == null || n2 < 0 || n2 >= this.data_.length) {
            JDError.throwSQLException(this, "HY024");
        }
        if ((n = (int)clob.length()) > this.data_.length || n < 0) {
            return -1L;
        }
        int n3 = this.data_.length - n;
        char[] cArray = clob.getSubString(1L, n).toCharArray();
        for (int i = n2; i <= n3; ++i) {
            int n4;
            for (n4 = 0; n4 < cArray.length && this.data_[i + n4] == cArray[n4]; ++n4) {
            }
            if (n4 != cArray.length) continue;
            return i + 1;
        }
        return -1L;
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if (l <= 0L || l > (long)this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        try {
            return new AS400JDBCClobOutputStream(this, l, ConvTable.getTable(819, null));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException("HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Writer setCharacterStream(long l) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if (l <= 0L || l > (long)this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        return new AS400JDBCWriter(this, l);
    }

    public synchronized int setString(long l, String string) throws SQLException {
        char[] cArray;
        int n;
        int n2;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if ((n2 = (int)l - 1) < 0 || n2 >= this.maxLength_ || string == null) {
            JDError.throwSQLException(this, "HY024");
        }
        if ((n = n2 + (cArray = string.toCharArray()).length) < 0) {
            n = Integer.MAX_VALUE;
        }
        if (n > this.data_.length) {
            char[] cArray2 = this.data_;
            this.data_ = new char[n];
            System.arraycopy(cArray2, 0, this.data_, 0, cArray2.length);
            int n3 = n2 - cArray2.length;
            for (int i = 0; i < n3; ++i) {
                this.data_[i + cArray2.length] = 32;
            }
        }
        int n4 = n - n2;
        System.arraycopy(cArray, 0, this.data_, n2, n4);
        return n4;
    }

    public synchronized int setString(long l, String string, int n, int n2) throws SQLException {
        int n3;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if ((n3 = (int)l - 1) < 0 || n3 >= this.maxLength_ || string == null || n < 0 || n2 < 0 || n + n2 > string.length() || n3 + n2 > this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        char[] cArray = string.toCharArray();
        int n4 = n3 + n2;
        if (n4 < 0) {
            n4 = Integer.MAX_VALUE;
        }
        if (n4 > this.data_.length) {
            char[] cArray2 = this.data_;
            this.data_ = new char[n4];
            System.arraycopy(cArray2, 0, this.data_, 0, cArray2.length);
            int n5 = n - cArray2.length;
            for (int i = 0; i < n5; ++i) {
                this.data_[i + cArray2.length] = 32;
            }
        }
        int n6 = n4 - n3;
        System.arraycopy(cArray, n, this.data_, n3, n6);
        return n6;
    }

    public synchronized void truncate(long l) throws SQLException {
        int n;
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if ((n = (int)l) < 0 || n > this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        char[] cArray = this.data_;
        this.data_ = new char[n];
        int n2 = n < cArray.length ? n : cArray.length;
        System.arraycopy(cArray, 0, this.data_, 0, n2);
    }

    public synchronized void free() throws SQLException {
        this.data_ = null;
    }

    public synchronized Reader getCharacterStream(long l, long l2) throws SQLException {
        if (this.data_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        return new CharArrayReader(this.data_, (int)l - 1, (int)l2);
    }
}

