/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

public class TIMESTAMPLTZ
extends Datum {
    private static int SIZE_TIMESTAMPLTZ = 11;
    private static int SIZE_TIMESTAMPLTZ_NOFRAC = 7;
    private static int SIZE_DATE = 7;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int JAVA_YEAR = 1970;
    private static int JAVA_MONTH = 0;
    private static int JAVA_DATE = 1;
    private static int MINYEAR = -4712;
    private static int MAXYEAR = 9999;
    private static boolean cached = false;
    private static Calendar dbtz;
    static final long serialVersionUID = 2045880772054757133L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    public TIMESTAMPLTZ() {
        super(TIMESTAMPLTZ.initTimestampltz());
    }

    public TIMESTAMPLTZ(byte[] timestampltz) {
        super(timestampltz);
    }

    public TIMESTAMPLTZ(Connection conn, Time time, Calendar dbtz) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, time, dbtz));
    }

    public TIMESTAMPLTZ(Connection conn, Date date, Calendar dbtz) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, date, dbtz));
    }

    public TIMESTAMPLTZ(Connection conn, Timestamp timestamp, Calendar dbtz) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, timestamp, dbtz));
    }

    public TIMESTAMPLTZ(Connection conn, DATE date, Calendar dbtz) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, date, dbtz));
    }

    public TIMESTAMPLTZ(Connection conn, String str, Calendar dbtz) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, str, dbtz));
    }

    public TIMESTAMPLTZ(Connection conn, Calendar sess, Time time) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, sess, time));
    }

    public TIMESTAMPLTZ(Connection conn, Calendar sess, Date date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, sess, date));
    }

    public TIMESTAMPLTZ(Connection conn, Calendar sess, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, sess, timestamp));
    }

    public TIMESTAMPLTZ(Connection conn, Calendar sess, DATE date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, sess, date));
    }

    public TIMESTAMPLTZ(Connection conn, Calendar sess, String str) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, TIMESTAMPLTZ.getSessCalendar(conn), str));
    }

    public TIMESTAMPLTZ(Connection conn, Time time) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, TIMESTAMPLTZ.getSessCalendar(conn), time));
    }

    public TIMESTAMPLTZ(Connection conn, Date date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, TIMESTAMPLTZ.getSessCalendar(conn), date));
    }

    public TIMESTAMPLTZ(Connection conn, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, TIMESTAMPLTZ.getSessCalendar(conn), timestamp));
    }

    public TIMESTAMPLTZ(Connection conn, DATE date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, TIMESTAMPLTZ.getSessCalendar(conn), date));
    }

    public TIMESTAMPLTZ(Connection conn, String str) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(conn, TIMESTAMPLTZ.getSessCalendar(conn), Timestamp.valueOf(str)));
    }

    public static Date toDate(Connection conn, byte[] timestamp, Calendar dbtz) throws SQLException {
        Calendar cal = TIMESTAMPLTZ.toCalendar(conn, Calendar.getInstance(), timestamp, dbtz);
        long millis = cal.getTime().getTime();
        return new Date(millis);
    }

    public static Time toTime(Connection conn, byte[] timestamp, Calendar dbtz) throws SQLException {
        Calendar cal = TIMESTAMPLTZ.toCalendar(conn, Calendar.getInstance(), timestamp, dbtz);
        return new Time(cal.get(11), cal.get(12), cal.get(13));
    }

    public static Timestamp toTimestamp(Connection conn, byte[] timestamp, Calendar dbtz) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(conn, Calendar.getInstance(), timestamp, dbtz);
    }

    public static DATE toDATE(Connection conn, byte[] timestamp, Calendar dbtz) throws SQLException {
        return new DATE(TIMESTAMPLTZ.toTimestamp(conn, TIMESTAMPLTZ.getSessCalendar(conn), timestamp, null));
    }

    public Timestamp timestampValue(Connection conn, Calendar dbtz) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(conn, this.getBytes(), dbtz);
    }

    public static String toString(Connection conn, byte[] timestamp, Calendar dbtz) throws SQLException {
        Calendar cal = TIMESTAMPLTZ.toCalendar(conn, null, timestamp, dbtz);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int seconds = cal.get(13);
        int nanos = -1;
        if (timestamp.length == SIZE_TIMESTAMPLTZ) {
            nanos = TIMESTAMP.getNanos(timestamp, 7);
        }
        return TIMESTAMPTZ.toString(year, month, date, hour, minute, seconds, nanos, cal.getTimeZone().getID());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Time time, Calendar dbtz) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(time) + ", " + OracleLog.argument(dbtz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (time == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            int defaultYear = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
            cal.set(1, defaultYear);
            cal.set(2, 0);
            cal.set(5, 1);
            byte[] result = TIMESTAMPLTZ.toBytes(conn, cal, dbtz, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Date date, Calendar dbtz) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(date) + ", " + OracleLog.argument(dbtz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (date == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            byte[] result = TIMESTAMPLTZ.toBytes(conn, cal, dbtz, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Timestamp timestamp, Calendar dbtz) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(timestamp) + ", " + OracleLog.argument(dbtz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (timestamp == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(timestamp);
            int nanos = timestamp.getNanos();
            byte[] result = TIMESTAMPLTZ.toBytes(conn, cal, dbtz, nanos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, DATE date, Calendar dbtz) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(date) + ", " + OracleLog.argument(dbtz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (date == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(DATE.toDate(date.toBytes()));
            byte[] result = TIMESTAMPLTZ.toBytes(conn, cal, dbtz, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static byte[] toBytes(Connection conn, String str, Calendar dbtz) throws SQLException {
        return TIMESTAMPLTZ.toBytes(conn, Timestamp.valueOf(str), dbtz);
    }

    public static Date toDate(Connection conn, byte[] timestamp) throws SQLException {
        Calendar cal = TIMESTAMPLTZ.toCalendar(conn, null, timestamp, null);
        long millis = cal.getTime().getTime();
        return new Date(millis);
    }

    public static Time toTime(Connection conn, byte[] timestamp) throws SQLException {
        Calendar cal = TIMESTAMPLTZ.toCalendar(conn, null, timestamp, null);
        return new Time(cal.get(11), cal.get(12), cal.get(13));
    }

    public static Timestamp toTimestamp(Connection conn, byte[] timestamptz) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(conn, null, timestamptz, null);
    }

    public static DATE toDATE(Connection conn, byte[] timestamp) throws SQLException {
        Calendar cal = TIMESTAMPLTZ.toCalendar(conn, null, timestamp, null);
        long millis = cal.getTime().getTime();
        return new DATE(new Timestamp(millis));
    }

    public static TIMESTAMP toTIMESTAMP(Connection conn, byte[] timestamp) throws SQLException {
        return new TIMESTAMP(TIMESTAMPLTZ.toTimestamp(conn, TIMESTAMPLTZ.getSessCalendar(conn), timestamp, null));
    }

    public static TIMESTAMPTZ toTIMESTAMPTZ(Connection conn, byte[] timestamp) throws SQLException {
        return new TIMESTAMPTZ(conn, TIMESTAMPLTZ.toTimestamp(conn, TIMESTAMPLTZ.getSessCalendar(conn), timestamp, null), TIMESTAMPLTZ.getSessCalendar(conn));
    }

    public static String toString(Connection conn, byte[] timestamp) throws SQLException {
        return TIMESTAMPLTZ.toString(conn, timestamp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Calendar cal, Time time) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cal) + ", " + OracleLog.argument(time));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (time == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            cal.setTime(time);
            int defaultYear = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
            cal.set(1, defaultYear);
            cal.set(2, 0);
            cal.set(5, 1);
            TIMESTAMPLTZ.initDbTimeZone(conn);
            Calendar dbclone = (Calendar)dbtz.clone();
            byte[] result = TIMESTAMPLTZ.toBytes(conn, cal, dbclone, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Calendar cal, Date date) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cal) + ", " + OracleLog.argument(date));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (date == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            cal.setTime(date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            TIMESTAMPLTZ.initDbTimeZone(conn);
            Calendar dbclone = (Calendar)dbtz.clone();
            byte[] result = TIMESTAMPLTZ.toBytes(conn, cal, dbclone, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Calendar cal, Timestamp timestamp) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cal) + ", " + OracleLog.argument(timestamp));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (timestamp == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            cal.setTime(timestamp);
            int nanos = timestamp.getNanos();
            TIMESTAMPLTZ.initDbTimeZone(conn);
            Calendar dbclone = (Calendar)dbtz.clone();
            byte[] result = TIMESTAMPLTZ.toBytes(conn, cal, dbclone, nanos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Connection conn, Calendar cal, DATE date) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cal) + ", " + OracleLog.argument(date));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (date == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            cal.setTime(DATE.toDate(date.toBytes()));
            TIMESTAMPLTZ.initDbTimeZone(conn);
            Calendar dbclone = (Calendar)dbtz.clone();
            byte[] result = TIMESTAMPLTZ.toBytes(conn, cal, dbclone, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static byte[] toBytes(Connection conn, Calendar sess, String str) throws SQLException {
        return TIMESTAMPLTZ.toBytes(conn, sess, Timestamp.valueOf(str));
    }

    @Override
    public String stringValue(Connection conn) throws SQLException {
        return TIMESTAMPLTZ.toString(conn, this.getBytes());
    }

    public String stringValue(Connection conn, Calendar cal) throws SQLException {
        return TIMESTAMPLTZ.toString(conn, this.getBytes(), cal);
    }

    public Date dateValue(Connection conn, Calendar cal) throws SQLException {
        return TIMESTAMPLTZ.toDate(conn, this.getBytes(), cal);
    }

    public Date dateValue(Connection conn) throws SQLException {
        return TIMESTAMPLTZ.toDate(conn, this.getBytes());
    }

    public Time timeValue(Connection conn) throws SQLException {
        return TIMESTAMPLTZ.toTime(conn, this.getBytes());
    }

    public Time timeValue(Connection conn, Calendar cal) throws SQLException {
        return TIMESTAMPLTZ.toTime(conn, this.getBytes(), cal);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return null;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        Timestamp[] ts = new Timestamp[arraySize];
        return ts;
    }

    @Override
    public boolean isConvertibleTo(Class cls) {
        return cls.getName().compareTo("java.sql.Date") == 0 || cls.getName().compareTo("java.sql.Time") == 0 || cls.getName().compareTo("java.sql.Timestamp") == 0 || cls.getName().compareTo("java.lang.String") == 0;
    }

    private static byte[] initTimestampltz() {
        byte[] tmp = new byte[SIZE_TIMESTAMPLTZ];
        tmp[0] = 119;
        tmp[1] = -86;
        tmp[2] = 1;
        tmp[3] = 1;
        tmp[4] = 1;
        tmp[5] = 1;
        tmp[6] = 1;
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toBytes(Connection conn, Calendar cal, Calendar dbclone, int nanos) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cal) + ", " + OracleLog.argument(dbclone) + ", " + OracleLog.argument(nanos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] result = nanos == 0 ? new byte[SIZE_TIMESTAMPLTZ_NOFRAC] : new byte[SIZE_TIMESTAMPLTZ];
            TIMESTAMPLTZ.TimeZoneAdjust(conn, cal, dbclone);
            int year = dbclone.get(1);
            if (year < MINYEAR || year > MAXYEAR) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMPLTZ.logger().log(Level.SEVERE, "         Throwing SQLException: 268");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 268);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            result[0] = (byte)(dbclone.get(1) / 100 + 100);
            result[1] = (byte)(dbclone.get(1) % 100 + 100);
            result[2] = (byte)(dbclone.get(2) + 1);
            result[3] = (byte)dbclone.get(5);
            result[4] = (byte)(dbclone.get(11) + 1);
            result[5] = (byte)(dbclone.get(12) + 1);
            result[6] = (byte)(dbclone.get(13) + 1);
            if (nanos != 0) {
                result[7] = (byte)(nanos >> 24);
                result[8] = (byte)(nanos >> 16 & 0xFF);
                result[9] = (byte)(nanos >> 8 & 0xFF);
                result[10] = (byte)(nanos & 0xFF);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMPLTZ.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Timestamp toTimestamp(Connection conn, Calendar incal, byte[] timestampltz, Calendar dbtz) throws SQLException {
        Calendar cal = TIMESTAMPLTZ.toCalendar(conn, incal, timestampltz, dbtz);
        long millis = cal.getTime().getTime();
        Timestamp ts = new Timestamp(millis);
        int nanos = 0;
        if (timestampltz.length == SIZE_TIMESTAMPLTZ) {
            nanos = TIMESTAMP.getNanos(timestampltz, 7);
        }
        ts.setNanos(nanos);
        return ts;
    }

    private static final Calendar toCalendar(Connection conn, Calendar cal, byte[] timestamp, Calendar databaseTimezone) throws SQLException {
        int arrlength = timestamp.length;
        int[] result = arrlength == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (int i2 = 0; i2 < timestamp.length; ++i2) {
            result[i2] = timestamp[i2] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        if (databaseTimezone == null) {
            TIMESTAMPLTZ.initDbTimeZone(conn);
            databaseTimezone = (Calendar)dbtz.clone();
        }
        databaseTimezone.set(1, year);
        databaseTimezone.set(2, result[2] - 1);
        databaseTimezone.set(5, result[3]);
        databaseTimezone.set(11, result[4] - 1);
        databaseTimezone.set(12, result[5] - 1);
        databaseTimezone.set(13, result[6] - 1);
        databaseTimezone.set(14, 0);
        if (cal == null) {
            cal = TIMESTAMPLTZ.getSessCalendar(conn);
        }
        TIMESTAMPLTZ.TimeZoneAdjust(conn, databaseTimezone, cal);
        return cal;
    }

    static void TimeZoneAdjust(Connection conn, Calendar cal1, Calendar cal2) throws SQLException {
        TimeZone zone = cal1.getTimeZone();
        String cal1String = new String(cal1.getTimeZone().getID());
        String cal2String = new String(cal2.getTimeZone().getID());
        if (!(cal2String.equals(cal1String) || cal2String.equals("Custom") && cal1String.equals("Custom"))) {
            int Offset_gmt;
            OffsetDST trans_db = new OffsetDST();
            byte dbolap = TIMESTAMPLTZ.getZoneOffset(conn, cal1, trans_db);
            int offset = trans_db.getOFFSET();
            boolean addendInDST = zone.inDaylightTime(cal1.getTime());
            cal1.add(11, -(offset / HOUR_MILLISECOND));
            cal1.add(12, -(offset % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
            boolean resultInDST = zone.inDaylightTime(cal1.getTime());
            if (addendInDST && !resultInDST) {
                cal1.add(14, 3600000);
            } else if (!addendInDST && resultInDST) {
                cal1.add(14, -3600000);
            }
            if (cal2String.equals("Custom")) {
                Offset_gmt = cal2.getTimeZone().getRawOffset();
            } else {
                int regionID = ZONEIDMAP.getID(cal2String);
                if (!ZONEIDMAP.isValidID(regionID)) {
                    if (cal2.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported");
                    }
                    Offset_gmt = cal2.getTimeZone().getRawOffset();
                } else {
                    TIMEZONETAB tzTab = TIMESTAMPLTZ.getTIMEZONETAB(conn);
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(conn, regionID);
                    }
                    Offset_gmt = tzTab.getOffset(cal1, regionID);
                }
            }
            addendInDST = zone.inDaylightTime(cal1.getTime());
            cal1.add(11, Offset_gmt / HOUR_MILLISECOND);
            cal1.add(12, Offset_gmt % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            resultInDST = zone.inDaylightTime(cal1.getTime());
            if (addendInDST && !resultInDST) {
                cal1.add(14, 3600000);
            } else if (!addendInDST && resultInDST) {
                cal1.add(14, -3600000);
            }
        }
        if (cal2String.equals("Custom") && cal1String.equals("Custom")) {
            int offset1 = cal1.getTimeZone().getRawOffset();
            int offset2 = cal2.getTimeZone().getRawOffset();
            int net_offset = 0;
            if (offset1 != offset2) {
                net_offset = offset1 - offset2;
                int n2 = net_offset = net_offset > 0 ? net_offset : -net_offset;
            }
            if (offset1 > offset2) {
                net_offset = -net_offset;
            }
            cal1.add(11, net_offset / HOUR_MILLISECOND);
            cal1.add(12, net_offset % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        }
        int year = cal1.get(1);
        int month = cal1.get(2);
        int day = cal1.get(5);
        int hour = cal1.get(11);
        int minute = cal1.get(12);
        int second = cal1.get(13);
        int msecond = cal1.get(14);
        cal2.set(1, year);
        cal2.set(2, month);
        cal2.set(5, day);
        cal2.set(11, hour);
        cal2.set(12, minute);
        cal2.set(13, second);
        cal2.set(14, msecond);
    }

    private static byte getZoneOffset(Connection conn, Calendar cal, OffsetDST tempVar) throws SQLException {
        byte olap = 0;
        if (cal.getTimeZone().getID() == "Custom") {
            tempVar.setOFFSET(cal.getTimeZone().getRawOffset());
        } else {
            String timeZone = new String(cal.getTimeZone().getID());
            int regionID = ZONEIDMAP.getID(timeZone);
            if (!ZONEIDMAP.isValidID(regionID)) {
                if (cal.getTimeZone().useDaylightTime()) {
                    throw new SQLException("Timezone not supported");
                }
                tempVar.setOFFSET(cal.getTimeZone().getRawOffset());
            } else {
                TIMEZONETAB tzTab = TIMESTAMPLTZ.getTIMEZONETAB(conn);
                if (tzTab.checkID(regionID)) {
                    tzTab.updateTable(conn, regionID);
                }
                olap = tzTab.getLocalOffset(cal, regionID, tempVar);
            }
        }
        return olap;
    }

    private static Calendar getDbTzCalendar(String dbTzStr) {
        char sign = dbTzStr.charAt(0);
        String offset_str = sign == '+' || sign == '-' ? "GMT" + dbTzStr : dbTzStr;
        TimeZone tz = TimeZone.getTimeZone(offset_str);
        return new GregorianCalendar(tz);
    }

    static Calendar getSessCalendar(Connection conn) {
        Calendar sessTzCal;
        String locTimeZone = ((oracle.jdbc.OracleConnection)conn).getSessionTimeZone();
        if (locTimeZone == null) {
            sessTzCal = Calendar.getInstance();
        } else {
            TimeZone zone = TimeZone.getTimeZone(locTimeZone);
            sessTzCal = Calendar.getInstance(zone);
        }
        return sessTzCal;
    }

    private static synchronized void initDbTimeZone(Connection conn) throws SQLException {
        if (!cached) {
            OracleConnection oconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
            String db_tz_str = oconn.getDatabaseTimeZone();
            dbtz = TIMESTAMPLTZ.getDbTzCalendar(db_tz_str);
            cached = true;
        }
    }

    static TIMEZONETAB getTIMEZONETAB(Connection conn) throws SQLException {
        OracleConnection oconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        return oconn.getTIMEZONETAB();
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.TIMESTAMPLTZ"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

