/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;

public class TIMESTAMP
extends Datum
implements Serializable {
    static final int CENTURY_DEFAULT = 119;
    static final int DECADE_DEFAULT = 100;
    static final int MONTH_DEFAULT = 1;
    static final int DAY_DEFAULT = 1;
    static final int DECADE_INIT = 170;
    static final int JAVA_YEAR = 1970;
    static final int JAVA_MONTH = 0;
    static final int JAVA_DATE = 1;
    public static final int SIZE_DATE = 7;
    public static final int SIZE_TIMESTAMP = 11;
    public static final int SIZE_TIMESTAMP_NOFRAC = 7;
    static final int SIZE_TIMESTAMPTZ = 13;
    static final int MINYEAR = -4712;
    static final int MAXYEAR = 9999;
    static final int JANMONTH = 1;
    static final int DECMONTH = 12;
    static final int MINDAYS = 1;
    static final int MAXDAYS = 31;
    static final int MINHOURS = 1;
    static final int MAXHOURS = 24;
    static final int MINMINUTES = 1;
    static final int MAXMINUTES = 60;
    static final int MINSECONDS = 1;
    static final int MAXSECONDS = 60;
    static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final long serialVersionUID = -7964732752952728545L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public TIMESTAMP() {
        super(TIMESTAMP.initTimestamp());
    }

    public TIMESTAMP(byte[] timestamp) {
        super(timestamp);
    }

    public TIMESTAMP(Time time) {
        super(TIMESTAMP.toBytes(time));
    }

    public TIMESTAMP(Date date) {
        super(TIMESTAMP.toBytes(date));
    }

    public TIMESTAMP(Timestamp timestamp) {
        super(TIMESTAMP.toBytes(timestamp));
    }

    public TIMESTAMP(Timestamp timestamp, Calendar cal) {
        super(TIMESTAMP.toBytes(timestamp, cal));
    }

    public TIMESTAMP(DATE date) {
        super(TIMESTAMP.toBytes(date));
    }

    public static final int getNanos(byte[] buffer, int off) {
        int nanos = (buffer[off] & 0xFF) << 24;
        nanos |= (buffer[off + 1] & 0xFF) << 16;
        nanos |= (buffer[off + 2] & 0xFF) << 8;
        return nanos |= buffer[off + 3] & 0xFF & 0xFF;
    }

    public TIMESTAMP(String str) {
        super(TIMESTAMP.toBytes(str));
    }

    public static Date toDate(byte[] timestamp) throws SQLException {
        int arrlength = timestamp.length;
        int[] result = arrlength == 11 ? new int[11] : new int[7];
        for (int i2 = 0; i2 < timestamp.length; ++i2) {
            result[i2] = timestamp[i2] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, result[2] - 1);
        cal.set(5, result[3]);
        cal.set(11, result[4] - 1);
        cal.set(12, result[5] - 1);
        cal.set(13, result[6] - 1);
        cal.set(14, 0);
        long millis = cal.getTime().getTime();
        return new Date(millis);
    }

    public static Time toTime(byte[] timestamp) throws SQLException {
        int hour = timestamp[4] & 0xFF;
        int minute = timestamp[5] & 0xFF;
        int second = timestamp[6] & 0xFF;
        return new Time(hour - 1, minute - 1, second - 1);
    }

    public static Timestamp toTimestamp(byte[] timestamp) throws SQLException {
        int arrlength = timestamp.length;
        int[] result = arrlength == 11 ? new int[11] : new int[7];
        for (int i2 = 0; i2 < timestamp.length; ++i2) {
            result[i2] = timestamp[i2] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, result[2] - 1);
        cal.set(5, result[3]);
        cal.set(11, result[4] - 1);
        cal.set(12, result[5] - 1);
        cal.set(13, result[6] - 1);
        cal.set(14, 0);
        long millis = cal.getTime().getTime();
        Timestamp ts = new Timestamp(millis);
        int nanos = 0;
        if (arrlength == 11) {
            nanos = TIMESTAMP.getNanos(timestamp, 7);
        }
        ts.setNanos(nanos);
        return ts;
    }

    public static Timestamp toTimestamp(byte[] timestamp, Calendar cal) throws SQLException {
        int arrlength = timestamp.length;
        int[] result = arrlength == 11 ? new int[11] : new int[7];
        for (int i2 = 0; i2 < timestamp.length; ++i2) {
            result[i2] = timestamp[i2] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.set(1, year);
        cal.set(2, result[2] - 1);
        cal.set(5, result[3]);
        cal.set(11, result[4] - 1);
        cal.set(12, result[5] - 1);
        cal.set(13, result[6] - 1);
        cal.set(14, 0);
        long millis = cal.getTime().getTime();
        Timestamp ts = new Timestamp(millis);
        int nanos = 0;
        if (arrlength == 11) {
            nanos = TIMESTAMP.getNanos(timestamp, 7);
        }
        ts.setNanos(nanos);
        return ts;
    }

    public static DATE toDATE(byte[] timestamp) throws SQLException {
        byte[] date = new byte[7];
        System.arraycopy(timestamp, 0, date, 0, 7);
        return new DATE(date);
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes());
    }

    @Override
    public Timestamp timestampValue(Calendar cal) throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes(), cal);
    }

    public static String toString(byte[] bytes) {
        int[] result = new int[bytes.length];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            result[i2] = bytes[i2] < 0 ? bytes[i2] + 256 : bytes[i2];
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        int month = result[2];
        int day = result[3];
        int hours = result[4] - 1;
        int minutes = result[5] - 1;
        int seconds = result[6] - 1;
        int nanos = 0;
        if (bytes.length > 7) {
            nanos = TIMESTAMP.getNanos(bytes, 7);
        }
        return TIMESTAMPTZ.toString(year, month, day, hours, minutes, seconds, nanos, null);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Time time) {
        if (time == null) {
            return null;
        }
        byte[] result = new byte[7];
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        result[0] = 119;
        result[1] = -86;
        result[2] = 1;
        result[3] = 1;
        result[4] = (byte)(cal.get(11) + 1);
        result[5] = (byte)(cal.get(12) + 1);
        result[6] = (byte)(cal.get(13) + 1);
        return result;
    }

    public static byte[] toBytes(Date date) {
        if (date == null) {
            return null;
        }
        byte[] result = new byte[7];
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        result[0] = (byte)(cal.get(1) / 100 + 100);
        result[1] = (byte)(cal.get(1) % 100 + 100);
        result[2] = (byte)(cal.get(2) + 1);
        result[3] = (byte)cal.get(5);
        result[4] = 1;
        result[5] = 1;
        result[6] = 1;
        return result;
    }

    public static byte[] toBytes(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        int nanos = timestamp.getNanos();
        byte[] result = nanos == 0 ? new byte[7] : new byte[11];
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        result[0] = (byte)(cal.get(1) / 100 + 100);
        result[1] = (byte)(cal.get(1) % 100 + 100);
        result[2] = (byte)(cal.get(2) + 1);
        result[3] = (byte)cal.get(5);
        result[4] = (byte)(cal.get(11) + 1);
        result[5] = (byte)(cal.get(12) + 1);
        result[6] = (byte)(cal.get(13) + 1);
        if (nanos != 0) {
            result[7] = (byte)(nanos >> 24);
            result[8] = (byte)(nanos >> 16 & 0xFF);
            result[9] = (byte)(nanos >> 8 & 0xFF);
            result[10] = (byte)(nanos & 0xFF);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Timestamp timestamp, Calendar cal) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMP.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(timestamp) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (timestamp == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMP.logger().log(Level.FINER, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = null;
                return byArray;
            }
            int nanos = timestamp.getNanos();
            byte[] result = nanos == 0 ? new byte[7] : new byte[11];
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            cal.clear();
            cal.setTime(timestamp);
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                year = -(year - 1);
            }
            if (year < -4712 || year > 9999) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TIMESTAMP.logger().log(Level.SEVERE, "         Throwing IllegalArgumentException: Invalid year value");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalArgumentException("Invalid year value");
            }
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            result[4] = (byte)(cal.get(11) + 1);
            result[5] = (byte)(cal.get(12) + 1);
            result[6] = (byte)(cal.get(13) + 1);
            if (nanos != 0) {
                result[7] = (byte)(nanos >> 24);
                result[8] = (byte)(nanos >> 16 & 0xFF);
                result[9] = (byte)(nanos >> 8 & 0xFF);
                result[10] = (byte)(nanos & 0xFF);
            }
            byte[] __result__ = result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMP.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMP.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static byte[] toBytes(DATE date) {
        if (date == null) {
            return null;
        }
        byte[] result = new byte[7];
        System.arraycopy(date.getBytes(), 0, result, 0, 7);
        return result;
    }

    public static byte[] toBytes(String str) {
        return TIMESTAMP.toBytes(Timestamp.valueOf(str));
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.timestampValue();
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        Timestamp[] ts = new Timestamp[arraySize];
        return ts;
    }

    @Override
    public boolean isConvertibleTo(Class cls) {
        return cls.getName().compareTo("java.sql.Date") == 0 || cls.getName().compareTo("java.sql.Time") == 0 || cls.getName().compareTo("java.sql.Timestamp") == 0 || cls.getName().compareTo("java.lang.String") == 0;
    }

    public static TIMESTAMP TimeZoneConvert(Connection conn, TIMESTAMP tstamp, TimeZone tz1, TimeZone tz2) throws SQLException {
        byte[] timestamp = tstamp.getBytes();
        int arrlength = timestamp.length;
        int[] result = arrlength == 11 ? new int[11] : new int[7];
        for (int i2 = 0; i2 < arrlength; ++i2) {
            result[i2] = timestamp[i2] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        int month = result[2] - 1;
        int day = result[3];
        int hours = result[4] - 1;
        int minutes = result[5] - 1;
        int seconds = result[6] - 1;
        Calendar cal1 = Calendar.getInstance(tz1);
        cal1.set(1, year);
        cal1.set(2, month);
        cal1.set(5, day);
        cal1.set(11, hours);
        cal1.set(12, minutes);
        cal1.set(13, seconds);
        cal1.set(14, 0);
        long millis = cal1.getTimeInMillis();
        Timestamp ts = new Timestamp(millis);
        int nanos = 0;
        if (arrlength == 11) {
            nanos = TIMESTAMP.getNanos(timestamp, 7);
        }
        ts.setNanos(nanos);
        Calendar cal2 = Calendar.getInstance(tz2);
        return new TIMESTAMP(ts, cal2);
    }

    @Override
    public String stringValue() {
        return TIMESTAMP.toString(this.getBytes());
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public Date dateValue() throws SQLException {
        return TIMESTAMP.toDate(this.getBytes());
    }

    @Override
    public Time timeValue() throws SQLException {
        return TIMESTAMP.toTime(this.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getJavaYear(int cent, int decade) {
        long __ol_nanos__ = 0L;
        try {
            int year;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMP.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(cent) + ", " + OracleLog.argument(decade));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((year = (cent - 100) * 100 + (decade - 100)) <= 0) {
                ++year;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMP.logger().log(Level.FINER, "         Return: " + year);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = year;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TIMESTAMP.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static byte[] initTimestamp() {
        byte[] tmp = new byte[11];
        tmp[0] = 119;
        tmp[1] = -86;
        tmp[2] = 1;
        tmp[3] = 1;
        tmp[4] = 1;
        tmp[5] = 1;
        tmp[6] = 1;
        return tmp;
    }

    private boolean isLeapYear(int y) {
        return y % 4 == 0 && (y <= 1582 ? y != -4712 : y % 100 != 0 || y % 400 == 0);
    }

    private boolean isValid() {
        byte[] ts = this.getBytes();
        if (ts.length != 11 && ts.length != 7) {
            return false;
        }
        int year = ((ts[0] & 0xFF) - 100) * 100 + ((ts[1] & 0xFF) - 100);
        if (year < -4712 || year > 9999) {
            return false;
        }
        if (year == 0) {
            return false;
        }
        int month = ts[2] & 0xFF;
        if (month < 1 || month > 12) {
            return false;
        }
        int day = ts[3] & 0xFF;
        if (day < 1 || day > 31) {
            return false;
        }
        if (!(day <= daysInMonth[month - 1] || this.isLeapYear(year) && month == 2 && day == 29)) {
            return false;
        }
        if (year == 1582 && month == 10 && day >= 5 && day < 15) {
            return false;
        }
        int hour = ts[4] & 0xFF;
        if (hour < 1 || hour > 24) {
            return false;
        }
        int minutes = ts[5] & 0xFF;
        if (minutes < 1 || minutes > 60) {
            return false;
        }
        int seconds = ts[6] & 0xFF;
        return seconds >= 1 && seconds <= 60;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.isValid()) {
            throw new IOException("Invalid TIMESTAMP");
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.TIMESTAMP"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

