/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import oracle.core.lmx.CoreException;
import oracle.sql.Datum;
import oracle.sql.LnxLib;
import oracle.sql.LnxLibServer;
import oracle.sql.LnxLibThin;

public class NUMBER
extends Datum {
    static byte[] MAX_LONG = NUMBER.toBytes(Long.MAX_VALUE);
    static byte[] MIN_LONG = NUMBER.toBytes(Long.MIN_VALUE);
    private static final int CHARACTER_ZERO = 48;
    private static final BigDecimal BIGDEC_NEGZERO = new BigDecimal("-0");
    private static final BigDecimal BIGDEC_ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal BIGDEC_ONE = BigDecimal.valueOf(1L);
    private static final BigInteger BIGINT_ZERO = BigInteger.valueOf(0L);
    private static final BigInteger BIGINT_HUND = BigInteger.valueOf(100L);
    private static final byte DIGEND = 21;
    private static final byte ODIGEND = 9;
    private static final int HUNDIGMAX = 66;
    private static final int BIGINTARRAYMAX = 54;
    private static final double BIGRATIO = 0.1505149978319906;
    private static final int BIGLENMAX = 22;
    static final byte LNXM_NUM = 22;
    static final int LNXSGNBT = 128;
    static final byte LNXDIGS = 20;
    static final byte LNXEXPBS = 64;
    static final double ORANUM_FBASE = 100.0;
    static final int LNXBASE = 100;
    static final byte IEEE_DBL_DIG = 15;
    private static final byte IEEE_FLT_DIG = 6;
    static final int LNXEXPMX = 127;
    static final int LNXEXPMN = 0;
    static final int LNXMXOUT = 40;
    static final int LNXMXFMT = 64;
    private static final byte BYTE_MAX_VALUE = 127;
    private static final byte BYTE_MIN_VALUE = -128;
    private static final short SHORT_MAX_VALUE = Short.MAX_VALUE;
    private static final short SHORT_MIN_VALUE = Short.MIN_VALUE;
    private static final byte[] PI = new byte[]{-63, 4, 15, 16, 93, 66, 36, 90, 80, 33, 39, 47, 27, 44, 39, 33, 80, 51, 29, 85, 21};
    private static final byte[] E = new byte[]{-63, 3, 72, 83, 82, 83, 85, 60, 5, 53, 36, 37, 3, 88, 48, 14, 53, 67, 25, 98, 77};
    private static final byte[] LN10 = new byte[]{-63, 3, 31, 26, 86, 10, 30, 95, 5, 57, 85, 2, 80, 92, 46, 47, 85, 37, 43, 8, 61};
    private static LnxLib _slnxlib;
    private static LnxLib _thinlib;
    private static int DBL_MAX;
    private static int INT_MAX;
    private static float FLOAT_MAX_INT;
    private static float FLOAT_MIN_INT;
    private static double DOUBLE_MAX_INT;
    private static double DOUBLE_MIN_INT;
    private static double DOUBLE_MAX_INT_2;
    private static double DOUBLE_MIN_INT_2;
    private static Object drvType;
    private static String LANGID;
    static final long serialVersionUID = -1656085588913430059L;

    public NUMBER() {
        super(NUMBER._makeZero());
    }

    public NUMBER(byte[] num) {
        super(num);
    }

    public NUMBER(byte byteNum) {
        super(NUMBER.toBytes(byteNum));
    }

    public NUMBER(int intNum) {
        super(NUMBER.toBytes(intNum));
    }

    public NUMBER(long longNum) {
        super(NUMBER.toBytes(longNum));
    }

    public NUMBER(short shortNum) {
        super(NUMBER.toBytes(shortNum));
    }

    public NUMBER(float floatNum) {
        super(NUMBER.toBytes(floatNum));
    }

    public NUMBER(double doubleNum) throws SQLException {
        super(NUMBER.toBytes(doubleNum));
    }

    public NUMBER(BigDecimal BigDecNum) throws SQLException {
        super(NUMBER.toBytes(BigDecNum));
    }

    public NUMBER(BigInteger BigIntNum) throws SQLException {
        super(NUMBER.toBytes(BigIntNum));
    }

    public NUMBER(String StringNum, int scale) throws SQLException {
        super(NUMBER.toBytes(StringNum, scale));
    }

    public NUMBER(boolean boolNum) {
        super(NUMBER.toBytes(boolNum));
    }

    public NUMBER(Object obj) throws SQLException {
        if (obj instanceof Integer) {
            this.setShareBytes(NUMBER.toBytes((Integer)obj));
        } else if (obj instanceof Long) {
            this.setShareBytes(NUMBER.toBytes((Long)obj));
        } else if (obj instanceof Float) {
            this.setShareBytes(NUMBER.toBytes(((Float)obj).floatValue()));
        } else if (obj instanceof Double) {
            this.setShareBytes(NUMBER.toBytes((Double)obj));
        } else if (obj instanceof BigInteger) {
            this.setShareBytes(NUMBER.toBytes((BigInteger)obj));
        } else if (obj instanceof BigDecimal) {
            this.setShareBytes(NUMBER.toBytes((BigDecimal)obj));
        } else if (obj instanceof Boolean) {
            this.setShareBytes(NUMBER.toBytes((Boolean)obj));
        } else if (obj instanceof String) {
            this.setShareBytes(this.stringToBytes((String)obj));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public static double toDouble(byte[] num) {
        if (NUMBER._isZero(num)) {
            return 0.0;
        }
        if (NUMBER._isPosInf(num)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NUMBER._isNegInf(num)) {
            return Double.NEGATIVE_INFINITY;
        }
        String dblStr = null;
        try {
            dblStr = drvType == null ? _slnxlib.lnxnuc(num, DBL_MAX, null) : _slnxlib.lnxnuc(num, DBL_MAX, LANGID);
        }
        catch (Exception e2) {
            // empty catch block
        }
        double f2 = Double.valueOf(dblStr);
        return f2;
    }

    public static float toFloat(byte[] num) {
        return (float)NUMBER.toDouble(num);
    }

    public static long toLong(byte[] num) throws SQLException {
        if (NUMBER._isZero(num)) {
            return 0L;
        }
        if (NUMBER._isInf(num) || NUMBER.compareBytes(num, MAX_LONG) > 0 || NUMBER.compareBytes(num, MIN_LONG) < 0) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return NUMBER._getLnxLib().lnxsni(num);
    }

    public static int toInt(byte[] num) throws SQLException {
        if (NUMBER._isInf(num)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        String intStr = drvType == null ? _slnxlib.lnxnuc(num, INT_MAX, null) : _slnxlib.lnxnuc(num, INT_MAX, LANGID);
        double f2 = Double.valueOf(intStr);
        if ((float)f2 > FLOAT_MAX_INT || (float)f2 < FLOAT_MIN_INT) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (f2 > DOUBLE_MAX_INT && f2 <= DOUBLE_MAX_INT_2) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (f2 < DOUBLE_MIN_INT && f2 >= DOUBLE_MIN_INT_2) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        int result = (int)f2;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short toShort(byte[] num) throws SQLException {
        long temp = 0L;
        temp = NUMBER.toLong(num);
        if (temp > 32767L || temp < -32768L) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return (short)temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte toByte(byte[] num) throws SQLException {
        long temp = 0L;
        temp = NUMBER.toLong(num);
        if (temp > 127L || temp < -128L) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        return (byte)temp;
    }

    public static BigInteger toBigInteger(byte[] num) throws SQLException {
        int mantlen;
        long[] digit = new long[10];
        int digidx = 9;
        int oidx = 1;
        int arycnt = 0;
        if (NUMBER._isZero(num)) {
            return BIGINT_ZERO;
        }
        if (NUMBER._isInf(num)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean positive = NUMBER._isPositive(num);
        byte[] temp = NUMBER._fromLnxFmt(num);
        if (temp[0] < 0) {
            return BIGINT_ZERO;
        }
        int clen = mantlen = Math.min(temp[0] + 1, temp.length - 1);
        if ((mantlen & 1) == 1) {
            digit[digidx] = temp[oidx];
            oidx = (byte)(oidx + 1);
            --clen;
        } else {
            digit[digidx] = temp[oidx] * 100 + temp[oidx + 1];
            oidx = (byte)(oidx + 2);
            clen -= 2;
        }
        int cnt = digidx;
        while (clen != 0) {
            long value = temp[oidx] * 100 + temp[oidx + 1];
            for (digidx = 9; digidx >= cnt; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] * 10000L) & 0xFFFFL;
                value >>= 16;
            }
            if (value != 0L) {
                // empty if block
            }
            cnt = (byte)(cnt - 1);
            digit[cnt] = value;
            oidx = (byte)(oidx + 2);
            clen -= 2;
        }
        int numbytes = digit[cnt] >> 8 != 0L ? 2 * (9 - cnt) + 2 : 2 * (9 - cnt) + 1;
        byte[] barray = new byte[numbytes];
        if ((numbytes & 1) == 1) {
            barray[arycnt] = (byte)digit[cnt];
            ++arycnt;
        } else {
            barray[arycnt] = (byte)(digit[cnt] >> 8);
            barray[++arycnt] = (byte)(digit[cnt] & 0xFFL);
            ++arycnt;
        }
        for (cnt = (int)((byte)(cnt + 1)); cnt <= 9; cnt = (int)((byte)(cnt + 1))) {
            barray[arycnt] = (byte)(digit[cnt] >> 8);
            barray[arycnt + 1] = (byte)(digit[cnt] & 0xFFL);
            arycnt += 2;
        }
        BigInteger result = new BigInteger(positive ? 1 : -1, barray);
        int lhd = temp[0] - (mantlen - 1);
        return result.multiply(BIGINT_HUND.pow(lhd));
    }

    public static BigDecimal toBigDecimal(byte[] num) throws SQLException {
        int mantlen;
        long[] digit = new long[10];
        int digidx = 9;
        int oidx = 1;
        int arycnt = 0;
        if (NUMBER._isZero(num)) {
            return BIGDEC_ZERO;
        }
        if (NUMBER._isInf(num)) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        boolean positive = NUMBER._isPositive(num);
        byte[] temp = NUMBER._fromLnxFmt(num);
        int clen = mantlen = temp.length - 1;
        if ((mantlen & 1) == 1) {
            digit[digidx] = temp[oidx];
            oidx = (byte)(oidx + 1);
            --clen;
        } else {
            digit[digidx] = temp[oidx] * 100 + temp[oidx + 1];
            oidx = (byte)(oidx + 2);
            clen -= 2;
        }
        int cnt = digidx;
        while (clen != 0) {
            long value = temp[oidx] * 100 + temp[oidx + 1];
            for (digidx = 9; digidx >= cnt; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] * 10000L) & 0xFFFFL;
                value >>= 16;
            }
            if (value != 0L) {
                // empty if block
            }
            cnt = (byte)(cnt - 1);
            digit[cnt] = value;
            oidx = (byte)(oidx + 2);
            clen -= 2;
        }
        int numbytes = digit[cnt] >> 8 != 0L ? 2 * (9 - cnt) + 2 : 2 * (9 - cnt) + 1;
        byte[] barray = new byte[numbytes];
        if ((numbytes & 1) == 1) {
            barray[arycnt] = (byte)digit[cnt];
            ++arycnt;
        } else {
            barray[arycnt] = (byte)(digit[cnt] >> 8);
            barray[++arycnt] = (byte)(digit[cnt] & 0xFFL);
            ++arycnt;
        }
        for (cnt = (int)((byte)(cnt + 1)); cnt <= 9; cnt = (int)((byte)(cnt + 1))) {
            barray[arycnt] = (byte)(digit[cnt] >> 8);
            barray[arycnt + 1] = (byte)(digit[cnt] & 0xFFL);
            arycnt += 2;
        }
        BigInteger bigtemp = new BigInteger(positive ? 1 : -1, barray);
        BigDecimal result = new BigDecimal(bigtemp);
        int scale = temp[0] - mantlen + 1;
        result = result.movePointRight(scale * 2);
        if (scale < 0 && temp[mantlen] % 10 == 0) {
            result = result.setScale(-(scale * 2 + 1));
        }
        return result;
    }

    public static String toString(byte[] num) {
        int mantlen;
        int ci = 0;
        if (NUMBER._isZero(num)) {
            return "0";
        }
        if (NUMBER._isPosInf(num)) {
            return new Double(Double.POSITIVE_INFINITY).toString();
        }
        if (NUMBER._isNegInf(num)) {
            return new Double(Double.NEGATIVE_INFINITY).toString();
        }
        byte[] oranum = NUMBER._fromLnxFmt(num);
        int exponent = oranum[0];
        int lhd = exponent - ((mantlen = oranum.length - 1) - 1);
        int char_space = lhd >= 0 ? 2 * (exponent + 1) + 1 : (exponent >= 0 ? 2 * (mantlen + 1) : 2 * (mantlen - exponent) + 3);
        char[] chars = new char[char_space];
        if (!NUMBER._isPositive(num)) {
            chars[ci++] = 45;
        }
        if (lhd >= 0) {
            ci += NUMBER._byteToChars(oranum[1], chars, ci);
            int i2 = 2;
            while (i2 <= mantlen) {
                NUMBER._byteTo2Chars(oranum[i2], chars, ci);
                ci += 2;
                ++i2;
                --exponent;
            }
            if (exponent > 0) {
                while (exponent > 0) {
                    chars[ci++] = 48;
                    chars[ci++] = 48;
                    --exponent;
                }
            }
        } else {
            int point = mantlen + lhd;
            if (point > 0) {
                int i3;
                ci += NUMBER._byteToChars(oranum[1], chars, ci);
                if (point == 1) {
                    chars[ci++] = 46;
                }
                for (i3 = 2; i3 < mantlen; ++i3) {
                    NUMBER._byteTo2Chars(oranum[i3], chars, ci);
                    ci += 2;
                    if (point != i3) continue;
                    chars[ci++] = 46;
                }
                if (oranum[i3] % 10 == 0) {
                    ci += NUMBER._byteToChars((byte)(oranum[i3] / 10), chars, ci);
                } else {
                    NUMBER._byteTo2Chars(oranum[i3], chars, ci);
                    ci += 2;
                }
            } else {
                int i4;
                chars[ci++] = 48;
                chars[ci++] = 46;
                while (point < 0) {
                    chars[ci++] = 48;
                    chars[ci++] = 48;
                    ++point;
                }
                for (i4 = 1; i4 < mantlen; ++i4) {
                    NUMBER._byteTo2Chars(oranum[i4], chars, ci);
                    ci += 2;
                }
                if (oranum[i4] % 10 == 0) {
                    ci += NUMBER._byteToChars((byte)(oranum[i4] / 10), chars, ci);
                } else {
                    NUMBER._byteTo2Chars(oranum[i4], chars, ci);
                    ci += 2;
                }
            }
        }
        return new String(chars, 0, ci);
    }

    public static boolean toBoolean(byte[] num) {
        return !NUMBER._isZero(num);
    }

    public static byte[] toBytes(double doubleNum) throws SQLException {
        if (Double.isNaN(doubleNum)) {
            throw new IllegalArgumentException(CoreException.getMessage((byte)11));
        }
        if (doubleNum == 0.0 || doubleNum == -0.0) {
            return NUMBER._makeZero();
        }
        if (doubleNum == Double.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (doubleNum == Double.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        return NUMBER._getThinLib().lnxren(doubleNum);
    }

    public static byte[] toBytes(float floatNum) {
        if (Float.isNaN(floatNum)) {
            throw new IllegalArgumentException(CoreException.getMessage((byte)11));
        }
        if (floatNum == 0.0f || floatNum == -0.0f) {
            return NUMBER._makeZero();
        }
        if (floatNum == Float.POSITIVE_INFINITY) {
            return NUMBER._makePosInf();
        }
        if (floatNum == Float.NEGATIVE_INFINITY) {
            return NUMBER._makeNegInf();
        }
        String floatStr = Float.toString(floatNum);
        try {
            return NUMBER._getLnxLib().lnxcpn(floatStr, false, 0, false, 0, "AMERICAN_AMERICA");
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static byte[] toBytes(long longNum) {
        return NUMBER._getLnxLib().lnxmin(longNum);
    }

    public static byte[] toBytes(int intNum) {
        return NUMBER.toBytes((long)intNum);
    }

    public static byte[] toBytes(short shortNum) {
        return NUMBER.toBytes((long)shortNum);
    }

    public static byte[] toBytes(byte byteNum) {
        return NUMBER.toBytes((long)byteNum);
    }

    public static byte[] toBytes(BigInteger BigIntNum) throws SQLException {
        int mantlen;
        long value;
        int i2;
        int exponent;
        byte[] temp;
        byte[] mantissa = new byte[66];
        long[] bnum = new long[54];
        long[] digit = new long[22];
        int digidx = 21;
        int bidx = 0;
        int dstart = 21;
        boolean arycnt = false;
        int oidx = 0;
        boolean positive = true;
        if (BigIntNum.signum() == 0) {
            return NUMBER._makeZero();
        }
        if (BigIntNum.signum() == -1) {
            BigInteger Num = BigIntNum.abs();
            positive = false;
            temp = Num.toByteArray();
            exponent = (int)Math.floor((double)Num.bitLength() * 0.1505149978319906);
        } else {
            temp = BigIntNum.toByteArray();
            exponent = (int)Math.floor((double)BigIntNum.bitLength() * 0.1505149978319906);
        }
        if (BigIntNum.abs().compareTo(BIGINT_HUND.pow(exponent)) < 0) {
            --exponent;
        }
        if (temp.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        for (i2 = 0; i2 < temp.length; ++i2) {
            bnum[i2] = temp[i2] < 0 ? (long)(temp[i2] + 256) : (long)temp[i2];
        }
        int blen = temp.length;
        switch (blen % 3) {
            case 2: {
                digit[digidx] = (bnum[bidx] << 8) + bnum[bidx + 1];
                bidx = (byte)(bidx + 2);
                blen -= 2;
                break;
            }
            case 1: {
                digit[digidx] = bnum[bidx];
                bidx = (byte)(bidx + 1);
                --blen;
                break;
            }
            default: {
                value = (bnum[bidx] << 16) + (bnum[bidx + 1] << 8) + bnum[bidx + 2];
                digit[digidx] = value % 1000000L;
                digit[digidx - 1] = value / 1000000L;
                dstart = (byte)(dstart - (digit[digidx - 1] != 0L ? 1 : 0));
                bidx = (byte)(bidx + 3);
                blen -= 3;
            }
        }
        while (blen != 0) {
            value = (bnum[bidx] << 4) + (bnum[bidx + 1] >> 4);
            for (digidx = 21; digidx >= dstart; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] << 12) % 1000000L;
                value /= 1000000L;
            }
            if (value != 0L) {
                dstart = (byte)(dstart - 1);
                digit[dstart] = value;
            }
            value = ((bnum[bidx + 1] & 0xFL) << 8) + bnum[bidx + 2];
            for (digidx = 21; digidx >= dstart; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] << 12) % 1000000L;
                value /= 1000000L;
            }
            if (value != 0L) {
                dstart = (byte)(dstart - 1);
                digit[dstart] = value;
            }
            bidx = (byte)(bidx + 3);
            blen -= 3;
        }
        mantissa[oidx] = (byte)(digit[dstart] / 10000L);
        if (mantissa[oidx] != 0) {
            mantlen = 3 * (21 - dstart) + 3;
            mantissa[oidx + 1] = (byte)(digit[dstart] % 10000L / 100L);
            mantissa[oidx + 2] = (byte)(digit[dstart] % 100L);
            oidx += 3;
        } else {
            mantissa[oidx] = (byte)(digit[dstart] % 10000L / 100L);
            if (mantissa[oidx] != 0) {
                mantlen = 3 * (21 - dstart) + 2;
                mantissa[oidx + 1] = (byte)(digit[dstart] % 100L);
                oidx += 2;
            } else {
                mantissa[oidx] = (byte)digit[dstart];
                mantlen = 3 * (21 - dstart) + 1;
                ++oidx;
            }
        }
        for (digidx = (int)((byte)(dstart + 1)); digidx <= 21; digidx = (int)((byte)(digidx + 1))) {
            mantissa[oidx] = (byte)(digit[digidx] / 10000L);
            mantissa[oidx + 1] = (byte)(digit[digidx] % 10000L / 100L);
            mantissa[oidx + 2] = (byte)(digit[digidx] % 100L);
            oidx += 3;
        }
        for (i2 = oidx - 1; i2 >= 0 && mantissa[i2] == 0; --i2) {
            --mantlen;
        }
        if (mantlen > 19) {
            i2 = 20;
            mantlen = 19;
            if (mantissa[i2] >= 50) {
                int n2 = --i2;
                mantissa[n2] = (byte)(mantissa[n2] + 1);
                while (mantissa[i2] == 100) {
                    if (i2 == 0) {
                        ++exponent;
                        mantissa[i2] = 1;
                        break;
                    }
                    mantissa[i2] = 0;
                    int n3 = --i2;
                    mantissa[n3] = (byte)(mantissa[n3] + 1);
                }
                for (i2 = mantlen - 1; i2 >= 0 && mantissa[i2] == 0; --i2) {
                    --mantlen;
                }
            }
        }
        if (exponent > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        byte[] oranum = new byte[mantlen + 1];
        oranum[0] = (byte)exponent;
        System.arraycopy(mantissa, 0, oranum, 1, mantlen);
        return NUMBER._toLnxFmt(oranum, positive);
    }

    public static byte[] toBytes(BigDecimal BigDecNum) throws SQLException {
        int mantlen;
        long value;
        int i2;
        BigDecimal DBTMP;
        byte[] mantissa = new byte[66];
        long[] bnum = new long[54];
        long[] digit = new long[22];
        int digidx = 21;
        int bidx = 0;
        int dstart = 21;
        int oidx = 0;
        int exponent = 0;
        BigDecimal BDABS = BigDecNum.abs();
        int leftdigs = 0;
        if (BigDecNum.signum() == 0) {
            return NUMBER._makeZero();
        }
        boolean positive = BigDecNum.signum() != -1;
        int scale = BigDecNum.scale();
        if (scale < 0) {
            BigDecNum = BigDecNum.setScale(0);
            scale = 0;
        }
        int rad = BDABS.compareTo(BIGDEC_ONE);
        int moves = 0;
        if (rad == -1) {
            while ((DBTMP = BDABS.movePointRight(++moves)).compareTo(BIGDEC_ONE) < 0) {
            }
            leftdigs = -moves;
        } else {
            while ((DBTMP = BDABS.movePointLeft(++moves)).compareTo(BIGDEC_ONE) >= 0) {
            }
            leftdigs = moves;
        }
        byte[] temp = BDABS.movePointRight(scale).toBigInteger().toByteArray();
        if (temp.length > 54) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        for (i2 = 0; i2 < temp.length; ++i2) {
            bnum[i2] = temp[i2] < 0 ? (long)(temp[i2] + 256) : (long)temp[i2];
        }
        int blen = temp.length;
        switch (blen % 3) {
            case 2: {
                digit[digidx] = (bnum[bidx] << 8) + bnum[bidx + 1];
                bidx = (byte)(bidx + 2);
                blen -= 2;
                break;
            }
            case 1: {
                digit[digidx] = bnum[bidx];
                bidx = (byte)(bidx + 1);
                --blen;
                break;
            }
            default: {
                value = (bnum[bidx] << 16) + (bnum[bidx + 1] << 8) + bnum[bidx + 2];
                digit[digidx] = value % 1000000L;
                digit[digidx - 1] = value / 1000000L;
                dstart = (byte)(dstart - (digit[digidx - 1] != 0L ? 1 : 0));
                bidx = (byte)(bidx + 3);
                blen -= 3;
            }
        }
        while (blen != 0) {
            value = (bnum[bidx] << 4) + (bnum[bidx + 1] >> 4);
            for (digidx = 21; digidx >= dstart; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] << 12) % 1000000L;
                value /= 1000000L;
            }
            if (value != 0L) {
                dstart = (byte)(dstart - 1);
                digit[dstart] = value;
            }
            value = ((bnum[bidx + 1] & 0xFL) << 8) + bnum[bidx + 2];
            for (digidx = 21; digidx >= dstart; digidx = (int)((byte)(digidx - 1))) {
                digit[digidx] = (value += digit[digidx] << 12) % 1000000L;
                value /= 1000000L;
            }
            if (value != 0L) {
                dstart = (byte)(dstart - 1);
                digit[dstart] = value;
            }
            bidx = (byte)(bidx + 3);
            blen -= 3;
        }
        mantissa[oidx] = (byte)(digit[dstart] / 10000L);
        if (mantissa[oidx] != 0) {
            mantlen = 3 * (21 - dstart) + 3;
            mantissa[oidx + 1] = (byte)(digit[dstart] % 10000L / 100L);
            mantissa[oidx + 2] = (byte)(digit[dstart] % 100L);
            oidx += 3;
        } else {
            mantissa[oidx] = (byte)(digit[dstart] % 10000L / 100L);
            if (mantissa[oidx] != 0) {
                mantlen = 3 * (21 - dstart) + 2;
                mantissa[oidx + 1] = (byte)(digit[dstart] % 100L);
                oidx += 2;
            } else {
                mantissa[oidx] = (byte)digit[dstart];
                mantlen = 3 * (21 - dstart) + 1;
                ++oidx;
            }
        }
        for (digidx = (int)((byte)(dstart + 1)); digidx <= 21; digidx = (int)((byte)(digidx + 1))) {
            mantissa[oidx] = (byte)(digit[digidx] / 10000L);
            mantissa[oidx + 1] = (byte)(digit[digidx] % 10000L / 100L);
            mantissa[oidx + 2] = (byte)(digit[digidx] % 100L);
            oidx += 3;
        }
        for (i2 = oidx - 1; i2 >= 0 && mantissa[i2] == 0; --i2) {
            --mantlen;
        }
        if (scale > 0 && (scale & 1) != 0) {
            int len = mantlen;
            byte[] buf = new byte[len + 1];
            if (mantissa[0] <= 9) {
                for (i2 = 0; i2 < len - 1; ++i2) {
                    buf[i2] = (byte)(mantissa[i2] % 10 * 10 + mantissa[i2 + 1] / 10);
                }
                buf[i2] = (byte)(mantissa[i2] % 10 * 10);
                if (buf[len - 1] == 0) {
                    --mantlen;
                }
            } else {
                buf[len] = (byte)(mantissa[len - 1] % 10 * 10);
                for (i2 = len - 1; i2 > 0; --i2) {
                    buf[i2] = (byte)(mantissa[i2] / 10 + mantissa[i2 - 1] % 10 * 10);
                }
                buf[i2] = (byte)(mantissa[i2] / 10);
                if (buf[len] > 0) {
                    ++mantlen;
                }
            }
            System.arraycopy(buf, 0, mantissa, 0, mantlen);
        }
        if (mantlen > 20) {
            i2 = 20;
            mantlen = 20;
            if (mantissa[i2] >= 50) {
                int n2 = --i2;
                mantissa[n2] = (byte)(mantissa[n2] + 1);
                while (mantissa[i2] == 100) {
                    if (i2 == 0) {
                        ++leftdigs;
                        mantissa[i2] = 1;
                        break;
                    }
                    mantissa[i2] = 0;
                    int n3 = --i2;
                    mantissa[n3] = (byte)(mantissa[n3] + 1);
                }
            }
            for (i2 = mantlen - 1; i2 >= 0 && mantissa[i2] == 0; --i2) {
                --mantlen;
            }
        }
        exponent = leftdigs <= 0 ? (mantissa[0] < 10 ? -(2 - leftdigs) / 2 + 1 : -(2 - leftdigs) / 2) : (leftdigs - 1) / 2;
        if (exponent > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (exponent <= -65) {
            throw new SQLException(CoreException.getMessage((byte)2));
        }
        byte[] oranum = new byte[mantlen + 1];
        oranum[0] = (byte)exponent;
        System.arraycopy(mantissa, 0, oranum, 1, mantlen);
        return NUMBER._toLnxFmt(oranum, positive);
    }

    public static byte[] toBytes(String StringNum, int scale) throws SQLException {
        int temp;
        int i2;
        int end = 0;
        int start = 0;
        byte[] mantissa = new byte[22];
        int mantIndex = 0;
        boolean sign = true;
        boolean roundit = false;
        boolean radix = false;
        int exponent = 0;
        int mantlen = 0;
        int leadingzeros = 0;
        int decdigs = 40;
        int lastCharIdx = 0;
        int intVal = 0;
        int offset = 0;
        int zero_bef_radix = 0;
        int eIndex = StringNum.indexOf("E");
        if (eIndex != -1 || (eIndex = StringNum.indexOf("e")) != -1) {
            StringBuffer s2 = new StringBuffer(StringNum.length() + 5);
            int digits = 0;
            BigDecimal val2 = null;
            boolean isValueNegative = StringNum.charAt(0) == '-';
            String eValue = StringNum.substring(eIndex + 1);
            String iVal = StringNum.substring(isValueNegative ? 1 : 0, eIndex);
            val2 = new BigDecimal(iVal);
            boolean isExponentNegative = eValue.charAt(0) == '-';
            eValue = eValue.substring(1);
            digits = Integer.parseInt(eValue);
            String StringNum2 = val2.toString();
            int dotIndex = StringNum2.indexOf(".");
            int StringNum2Length = StringNum2.length();
            int suggestedDotIndex = StringNum2Length--;
            if (dotIndex != -1) {
                StringNum2 = StringNum2.substring(0, dotIndex) + StringNum2.substring(dotIndex + 1);
                if (isExponentNegative) {
                    digits -= dotIndex;
                } else {
                    suggestedDotIndex = ++digits;
                }
            } else if (isExponentNegative) {
                digits -= StringNum2Length;
            } else {
                suggestedDotIndex = ++digits;
            }
            if (isValueNegative) {
                s2.append("-");
            }
            if (isExponentNegative) {
                s2.append("0.");
                for (int index = 0; index < digits; ++index) {
                    s2.append("0");
                }
                s2.append(StringNum2);
            } else {
                int maxLen = digits > StringNum2Length ? digits : StringNum2Length;
                for (int index = 0; index < maxLen; ++index) {
                    if (suggestedDotIndex == index) {
                        s2.append(".");
                    }
                    s2.append(StringNum2Length > index ? StringNum2.charAt(index) : (char)'0');
                }
            }
            StringNum = s2.toString();
        }
        StringNum = StringNum.trim();
        int chars_len = StringNum.length();
        if (StringNum.charAt(0) == '-') {
            --chars_len;
            sign = false;
            offset = 1;
        }
        end = chars_len;
        char[] chars = new char[chars_len];
        StringNum.getChars(offset, chars_len + offset, chars, 0);
        for (i2 = 0; i2 < chars_len; ++i2) {
            if (chars[i2] != '.') continue;
            radix = true;
            break;
        }
        if (!radix) {
            scale = 0;
        }
        while (start < end && chars[start] == '0') {
            ++start;
            if (!radix) continue;
            ++zero_bef_radix;
        }
        if (start == end) {
            return NUMBER._makeZero();
        }
        if (chars_len >= 2 && chars[start] == '.') {
            while (end > 0 && chars[end - 1] == '0') {
                --end;
            }
            if (++start == end) {
                return NUMBER._makeZero();
            }
            --exponent;
            while (start < end - 1 && chars[start] == '0' && chars[start + 1] == '0') {
                --exponent;
                leadingzeros += 2;
                start += 2;
            }
            if (exponent < -65) {
                throw new SQLException(CoreException.getMessage((byte)2));
            }
            if (end - start > decdigs) {
                temp = 2 + decdigs;
                if (leadingzeros > 0) {
                    temp += leadingzeros;
                }
                if (temp <= end) {
                    end = temp;
                }
                lastCharIdx = end;
                roundit = true;
            }
            mantIndex = end - start >> 1;
            if ((end - start) % 2 != 0) {
                mantissa[mantIndex] = (byte)(Integer.parseInt(new String(chars, end - 1, 1)) * 10);
                ++mantlen;
                --end;
            }
            while (end > start) {
                mantissa[--mantIndex] = (byte)Integer.parseInt(new String(chars, end - 2, 2));
                end -= 2;
                ++mantlen;
            }
        } else {
            int wholeDigs;
            while (scale > 0 && end > 0 && chars[end - 1] == '0') {
                --end;
                --scale;
            }
            if (scale == 0 && end > 1) {
                if (chars[end - 1] == '.') {
                    --end;
                }
                if (start == end) {
                    return NUMBER._makeZero();
                }
                while (end > 1 && chars[end - 2] == '0' && chars[end - 1] == '0') {
                    end -= 2;
                    ++exponent;
                }
            }
            if (exponent > 62) {
                throw new SQLException(CoreException.getMessage((byte)3));
            }
            if (end - start - (radix ? 1 : 0) > decdigs) {
                temp = decdigs + (radix ? 1 : 0);
                int diff = end - temp;
                end = temp;
                if ((scale -= diff) < 0) {
                    scale = 0;
                }
                roundit = true;
                lastCharIdx = end;
            }
            int n2 = wholeDigs = scale == 0 ? end - start : end - scale - 1;
            if (zero_bef_radix > 0) {
                wholeDigs -= zero_bef_radix;
            }
            if (wholeDigs % 2 != 0) {
                intVal = Integer.parseInt(new String(chars, start, 1));
                ++start;
                --wholeDigs;
                if (end - 1 == decdigs) {
                    --scale;
                    roundit = true;
                    lastCharIdx = --end;
                }
            } else {
                intVal = Integer.parseInt(new String(chars, start, 2));
                start += 2;
                wholeDigs -= 2;
            }
            mantissa[mantIndex] = (byte)intVal;
            ++mantIndex;
            ++mantlen;
            while (wholeDigs > 0) {
                mantissa[mantIndex] = (byte)Integer.parseInt(new String(chars, start, 2));
                ++mantIndex;
                start += 2;
                ++exponent;
                wholeDigs -= 2;
                ++mantlen;
            }
            if (start < end) {
                if (scale % 2 != 0) {
                    mantissa[mantIndex += scale / 2] = (byte)(Integer.parseInt(new String(chars, end - 1, 1)) * 10);
                    --end;
                    --scale;
                } else {
                    mantissa[mantIndex += scale / 2 - 1] = (byte)Integer.parseInt(new String(chars, end - 2, 2));
                    end -= 2;
                    scale -= 2;
                }
                ++mantlen;
                --mantIndex;
            }
            while (scale > 0) {
                mantissa[mantIndex] = (byte)Integer.parseInt(new String(chars, end - 2, 2));
                --mantIndex;
                end -= 2;
                scale -= 2;
                ++mantlen;
            }
        }
        if (roundit) {
            int tempindex = mantlen;
            intVal = Integer.parseInt(new String(chars, lastCharIdx, 1));
            if (intVal >= 5) {
                int n3 = --tempindex;
                mantissa[n3] = (byte)(mantissa[n3] + 1);
                while (mantissa[tempindex] == 100) {
                    if (tempindex == 0) {
                        ++exponent;
                        mantissa[tempindex] = 1;
                        break;
                    }
                    mantissa[tempindex] = 0;
                    int n4 = --tempindex;
                    mantissa[n4] = (byte)(mantissa[n4] + 1);
                }
                for (i2 = mantlen - 1; i2 >= 0 && mantissa[i2] == 0; --i2) {
                    --mantlen;
                }
            }
        }
        byte[] oranum = new byte[mantlen + 1];
        oranum[0] = (byte)exponent;
        System.arraycopy(mantissa, 0, oranum, 1, mantlen);
        return NUMBER._toLnxFmt(oranum, sign);
    }

    public static byte[] toBytes(boolean boolNum) {
        if (boolNum) {
            return NUMBER.toBytes(1L);
        }
        return NUMBER.toBytes(0L);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    @Override
    public double doubleValue() {
        return NUMBER.toDouble(this.shareBytes());
    }

    @Override
    public float floatValue() {
        return NUMBER.toFloat(this.shareBytes());
    }

    @Override
    public long longValue() throws SQLException {
        return NUMBER.toLong(this.shareBytes());
    }

    @Override
    public int intValue() throws SQLException {
        return NUMBER.toInt(this.shareBytes());
    }

    public short shortValue() throws SQLException {
        return NUMBER.toShort(this.shareBytes());
    }

    @Override
    public byte byteValue() throws SQLException {
        return NUMBER.toByte(this.shareBytes());
    }

    public BigInteger bigIntegerValue() throws SQLException {
        return NUMBER.toBigInteger(this.shareBytes());
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return NUMBER.toBigDecimal(this.shareBytes());
    }

    @Override
    public String stringValue() {
        return NUMBER.toString(this.shareBytes());
    }

    @Override
    public boolean booleanValue() {
        return NUMBER.toBoolean(this.shareBytes());
    }

    @Override
    public Object toJdbc() throws SQLException {
        try {
            return this.bigDecimalValue();
        }
        catch (SQLException e2) {
            return new SQLException(e2.getMessage());
        }
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        BigDecimal[] bd = new BigDecimal[arraySize];
        return bd;
    }

    @Override
    public boolean isConvertibleTo(Class cls) {
        String cls_name = cls.getName();
        return cls_name.compareTo("java.lang.Integer") == 0 || cls_name.compareTo("java.lang.Long") == 0 || cls_name.compareTo("java.lang.Float") == 0 || cls_name.compareTo("java.lang.Double") == 0 || cls_name.compareTo("java.math.BigInteger") == 0 || cls_name.compareTo("java.math.BigDecimal") == 0 || cls_name.compareTo("java.lang.String") == 0 || cls_name.compareTo("java.lang.Boolean") == 0;
    }

    public NUMBER abs() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxabs(this.shareBytes()));
    }

    public NUMBER acos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxacos(this.shareBytes()));
    }

    public NUMBER add(NUMBER n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxadd(this.shareBytes(), n2.shareBytes()));
    }

    public NUMBER asin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxasin(this.shareBytes()));
    }

    public NUMBER atan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan(this.shareBytes()));
    }

    public NUMBER atan2(NUMBER x) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxatan2(this.shareBytes(), x.shareBytes()));
    }

    public NUMBER ceil() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxceil(this.shareBytes()));
    }

    public NUMBER cos() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcos(this.shareBytes()));
    }

    public NUMBER cosh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcsh(this.shareBytes()));
    }

    public NUMBER decrement() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdec(this.shareBytes()));
    }

    public NUMBER div(NUMBER n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxdiv(this.shareBytes(), n2.shareBytes()));
    }

    public NUMBER exp() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxexp(this.shareBytes()));
    }

    public NUMBER floatingPointRound(int precision) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfpr(this.shareBytes(), precision));
    }

    public NUMBER floor() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxflo(this.shareBytes()));
    }

    public NUMBER increment() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxinc(this.shareBytes()));
    }

    public NUMBER ln() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxln(this.shareBytes()));
    }

    public NUMBER log(NUMBER base) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxlog(this.shareBytes(), base.shareBytes()));
    }

    public NUMBER mod(NUMBER n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmod(this.shareBytes(), n2.shareBytes()));
    }

    public NUMBER mul(NUMBER n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxmul(this.shareBytes(), n2.shareBytes()));
    }

    public NUMBER negate() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxneg(this.shareBytes()));
    }

    public NUMBER pow(NUMBER exp) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxbex(this.shareBytes(), exp.shareBytes()));
    }

    public NUMBER pow(int exp) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxpow(this.shareBytes(), exp));
    }

    public NUMBER round(int decimal_place) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxrou(this.shareBytes(), decimal_place));
    }

    public NUMBER scale(int left, int right, boolean[] big) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsca(this.shareBytes(), left, right, big));
    }

    public NUMBER shift(int digits) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxshift(this.shareBytes(), digits));
    }

    public NUMBER sin() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsin(this.shareBytes()));
    }

    public NUMBER sinh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsnh(this.shareBytes()));
    }

    public NUMBER sqroot() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsqr(this.shareBytes()));
    }

    public NUMBER sub(NUMBER n2) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxsub(this.shareBytes(), n2.shareBytes()));
    }

    public NUMBER tan() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtan(this.shareBytes()));
    }

    public NUMBER tanh() throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtnh(this.shareBytes()));
    }

    public NUMBER truncate(int decimal_place) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxtru(this.shareBytes(), decimal_place));
    }

    public static NUMBER formattedTextToNumber(String num, String fmt, String lang) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxfcn(num, fmt, lang));
    }

    public static NUMBER textToPrecisionNumber(String num, boolean precflag, int preclen, boolean scaleflag, int scalelen, String lang) throws SQLException {
        return new NUMBER(NUMBER._getLnxLib().lnxcpn(num, precflag, preclen, scaleflag, scalelen, lang));
    }

    public String toFormattedText(String fmt, String lang) throws SQLException {
        return NUMBER._getLnxLib().lnxnfn(this.shareBytes(), fmt, lang);
    }

    public String toText(int outStringLength, String lang) throws SQLException {
        return NUMBER._getLnxLib().lnxnuc(this.shareBytes(), outStringLength, lang);
    }

    public int compareTo(NUMBER n2) {
        return NUMBER.compareBytes(this.shareBytes(), n2.shareBytes());
    }

    public boolean isInf() {
        return NUMBER._isInf(this.shareBytes());
    }

    public boolean isNegInf() {
        return NUMBER._isNegInf(this.shareBytes());
    }

    public boolean isPosInf() {
        return NUMBER._isPosInf(this.shareBytes());
    }

    public boolean isInt() {
        return NUMBER._isInt(this.shareBytes());
    }

    public static boolean isValid(byte[] num) {
        int numlen = num.length;
        if (NUMBER._isPositive(num)) {
            if (numlen == 1) {
                return NUMBER._isZero(num);
            }
            if (num[0] == -1 && num[1] == 101) {
                return numlen == 2;
            }
            if (numlen > 21) {
                return false;
            }
            if (num[1] < 2 || num[numlen - 1] < 2) {
                return false;
            }
            for (int i2 = 1; i2 < numlen; ++i2) {
                byte digit = num[i2];
                if (digit >= 1 && digit <= 100) continue;
                return false;
            }
            return true;
        }
        if (numlen < 3) {
            return NUMBER._isNegInf(num);
        }
        if (numlen > 21) {
            return false;
        }
        if (num[numlen - 1] != 102) {
            if (numlen <= 20) {
                return false;
            }
        } else {
            numlen = (byte)(numlen - 1);
        }
        if (num[1] > 100 || num[numlen - 1] > 100) {
            return false;
        }
        for (int i3 = 1; i3 < numlen; ++i3) {
            byte digit = num[i3];
            if (digit >= 2 && digit <= 101) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        return NUMBER._isZero(this.shareBytes());
    }

    public static NUMBER e() {
        return new NUMBER(E);
    }

    public static NUMBER ln10() {
        return new NUMBER(LN10);
    }

    public static NUMBER negInf() {
        return new NUMBER(NUMBER._makeNegInf());
    }

    public static NUMBER pi() {
        return new NUMBER(PI);
    }

    public static NUMBER posInf() {
        return new NUMBER(NUMBER._makePosInf());
    }

    public static NUMBER zero() {
        return new NUMBER(NUMBER._makeZero());
    }

    public int sign() {
        if (NUMBER._isZero(this.shareBytes())) {
            return 0;
        }
        return NUMBER._isPositive(this.shareBytes()) ? 1 : -1;
    }

    static boolean _isInf(byte[] num) {
        return num.length == 2 && num[0] == -1 && num[1] == 101 || num[0] == 0 && num.length == 1;
    }

    private static boolean _isInt(byte[] num) {
        byte exponent;
        if (NUMBER._isZero(num)) {
            return true;
        }
        if (NUMBER._isInf(num)) {
            return false;
        }
        byte[] oranum = NUMBER._fromLnxFmt(num);
        byte mantlen = (byte)(oranum.length - 1);
        return mantlen <= (exponent = oranum[0]) + 1;
    }

    static boolean _isNegInf(byte[] num) {
        return num[0] == 0 && num.length == 1;
    }

    static boolean _isPosInf(byte[] num) {
        return num.length == 2 && num[0] == -1 && num[1] == 101;
    }

    static boolean _isPositive(byte[] num) {
        return (num[0] & 0xFFFFFF80) != 0;
    }

    static boolean _isZero(byte[] num) {
        return num[0] == -128 && num.length == 1;
    }

    static byte[] _makePosInf() {
        byte[] num = new byte[]{-1, 101};
        return num;
    }

    static byte[] _makeNegInf() {
        byte[] num = new byte[]{0};
        return num;
    }

    static byte[] _makeZero() {
        byte[] num = new byte[]{-128};
        return num;
    }

    static byte[] _fromLnxFmt(byte[] num) {
        byte[] tmp;
        int numl = num.length;
        if (NUMBER._isPositive(num)) {
            tmp = new byte[numl];
            tmp[0] = (byte)((num[0] & 0xFFFFFF7F) - 65);
            for (int i2 = 1; i2 < numl; ++i2) {
                tmp[i2] = (byte)(num[i2] - 1);
            }
        } else {
            tmp = numl - 1 == 20 && num[numl - 1] != 102 ? new byte[numl] : new byte[numl - 1];
            tmp[0] = (byte)((~num[0] & 0xFFFFFF7F) - 65);
            for (int i3 = 1; i3 < tmp.length; ++i3) {
                tmp[i3] = (byte)(101 - num[i3]);
            }
        }
        return tmp;
    }

    static byte[] _toLnxFmt(byte[] num, boolean pos) {
        byte[] tmp;
        int numl = num.length;
        if (pos) {
            tmp = new byte[numl];
            tmp[0] = (byte)(num[0] + 128 + 64 + 1);
            for (int i2 = 1; i2 < numl; ++i2) {
                tmp[i2] = (byte)(num[i2] + 1);
            }
        } else {
            int i3;
            tmp = numl - 1 < 20 ? new byte[numl + 1] : new byte[numl];
            tmp[0] = (byte)(~(num[0] + 128 + 64 + 1));
            for (i3 = 1; i3 < numl; ++i3) {
                tmp[i3] = (byte)(101 - num[i3]);
            }
            if (i3 <= 20) {
                tmp[i3] = 102;
            }
        }
        return tmp;
    }

    private static LnxLib _getLnxLib() {
        if (_slnxlib == null) {
            try {
                _slnxlib = System.getProperty("oracle.jserver.version") != null ? new LnxLibServer() : new LnxLibThin();
            }
            catch (SecurityException e2) {
                _slnxlib = new LnxLibThin();
            }
        }
        return _slnxlib;
    }

    private static LnxLib _getThinLib() {
        if (_thinlib == null) {
            _thinlib = new LnxLibThin();
        }
        return _thinlib;
    }

    private static int _byteToChars(byte inByte, char[] chars, int offset) {
        if (inByte < 0) {
            return 0;
        }
        if (inByte < 10) {
            chars[offset] = (char)(48 + inByte);
            return 1;
        }
        if (inByte < 100) {
            chars[offset] = (char)(48 + inByte / 10);
            chars[offset + 1] = (char)(48 + inByte % 10);
            return 2;
        }
        chars[offset] = 49;
        chars[offset + 1] = (char)(48 + inByte / 10 - 10);
        chars[offset + 2] = (char)(48 + inByte % 10);
        return 3;
    }

    private static void _byteTo2Chars(byte inByte, char[] chars, int offset) {
        if (inByte < 0) {
            chars[offset] = 48;
            chars[offset + 1] = 48;
        } else if (inByte < 10) {
            chars[offset] = 48;
            chars[offset + 1] = (char)(48 + inByte);
        } else if (inByte < 100) {
            chars[offset] = (char)(48 + inByte / 10);
            chars[offset + 1] = (char)(48 + inByte % 10);
        } else {
            chars[offset] = 48;
            chars[offset + 1] = 48;
        }
    }

    private static void _printBytes(byte[] num) {
        int numl = num.length;
        System.out.print(numl + ": ");
        for (int i2 = 0; i2 < numl; ++i2) {
            System.out.print(num[i2] + " ");
        }
        System.out.println();
    }

    private byte[] stringToBytes(String str) throws SQLException {
        int scale = 0;
        if ((str = str.trim()).indexOf(46) >= 0) {
            scale = str.length() - 1 - str.indexOf(46);
        }
        return NUMBER.toBytes(str, scale);
    }

    static {
        _thinlib = null;
        DBL_MAX = 40;
        INT_MAX = 15;
        FLOAT_MAX_INT = 2.1474836E9f;
        FLOAT_MIN_INT = -2.1474836E9f;
        DOUBLE_MAX_INT = 2.147483647E9;
        DOUBLE_MIN_INT = -2.147483648E9;
        DOUBLE_MAX_INT_2 = 2.147483649E9;
        DOUBLE_MIN_INT_2 = -2.147483649E9;
        drvType = null;
        try {
            drvType = System.getProperty("oracle.jserver.version");
        }
        catch (SecurityException e2) {
            drvType = null;
        }
        LANGID = "AMERICAN";
    }
}

