/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import oracle.sql.Datum;
import oracle.sql.utilpack;

public class INTERVALYM
extends Datum {
    private static int MASKVAL = 255;
    private static int INTYMYEAROFFSET = Integer.MIN_VALUE;
    private static int INTYMMONTHOFFSET = 60;
    private static int INTERVALYMMAXLENGTH = 5;
    private static int MAXYEARPREC = 9;
    private static int MAXMONTH = 12;
    static final long serialVersionUID = 8393284561907159296L;

    public INTERVALYM() {
        super(INTERVALYM._initIntervalYM());
    }

    public INTERVALYM(byte[] intervalYM) {
        super(intervalYM);
    }

    public INTERVALYM(String str) {
        super(INTERVALYM.toBytes(str));
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(String str) {
        int indexOfhiphen;
        String interStr;
        byte[] intarr = new byte[INTERVALYMMAXLENGTH];
        char sign = (interStr = str.trim()).charAt(0);
        int startIndex = sign != '-' && sign != '+' ? 0 : 1;
        String yearStr = (interStr = interStr.substring(startIndex)).substring(0, indexOfhiphen = interStr.indexOf(45));
        if (yearStr.length() > MAXYEARPREC) {
            throw new NumberFormatException();
        }
        int intervalyear = Integer.valueOf(yearStr);
        String monthStr = interStr.substring(indexOfhiphen + 1);
        int intervalmonth = Integer.valueOf(monthStr);
        if (intervalmonth >= MAXMONTH) {
            throw new NumberFormatException();
        }
        if (sign == '-') {
            intervalyear = -1 * intervalyear;
            intervalmonth = -1 * intervalmonth;
        }
        intarr[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(intervalyear += INTYMYEAROFFSET);
        intarr[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(intervalyear);
        intarr[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(intervalyear);
        intarr[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(intervalyear);
        intarr[4] = (byte)(intervalmonth + INTYMMONTHOFFSET);
        return intarr;
    }

    public static String toString(byte[] inparray) {
        boolean positive = true;
        int intervalYear = utilpack.LEFTSHIFTFIRSTNIBBLE(inparray[0]);
        intervalYear |= utilpack.LEFTSHIFTSECONDNIBBLE(inparray[1]);
        intervalYear |= utilpack.LEFTSHIFTTHIRDNIBBLE(inparray[2]);
        intervalYear |= inparray[3] & 0xFF;
        int intervalMonth = inparray[4] - INTYMMONTHOFFSET;
        if ((intervalYear -= INTYMYEAROFFSET) < 0) {
            positive = false;
            intervalYear = -intervalYear;
        }
        if (intervalMonth < 0) {
            positive = false;
            intervalMonth = -intervalMonth;
        }
        String result = positive ? intervalYear + "-" + intervalMonth : "-" + intervalYear + "-" + intervalMonth;
        return result;
    }

    @Override
    public Object toJdbc() {
        return this;
    }

    @Override
    public String stringValue() {
        return INTERVALYM.toString(this.getBytes());
    }

    public String toString() {
        return INTERVALYM.toString(this.getBytes());
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        INTERVALYM[] intym = new INTERVALYM[arraySize];
        return intym;
    }

    @Override
    public boolean isConvertibleTo(Class cls) {
        return cls.getName().compareTo("java.lang.String") == 0;
    }

    private static byte[] _initIntervalYM() {
        byte[] intarr = new byte[INTERVALYMMAXLENGTH];
        int year = 0;
        int month = 0;
        intarr[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(year += INTYMYEAROFFSET);
        intarr[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(year);
        intarr[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(year);
        intarr[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(year);
        intarr[4] = (byte)(month + INTYMMONTHOFFSET);
        return intarr;
    }
}

