/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetZHTEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterZHTEUC";
    static final int MAX_7BIT = 127;
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetZHTEUC(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.m_leadingCodes = charConverter.getLeadingCodes();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSetZHTEUC getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (charConverter.getGroupId() == 5) {
                CharacterSetZHTEUC __result__ = new CharacterSetZHTEUC(oracleId, charConverter);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetZHTEUC.logger().log(Level.FINER, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetZHTEUC characterSetZHTEUC = __result__;
                return characterSetZHTEUC;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(Level.FINER, "         Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharacterSetZHTEUC characterSetZHTEUC = null;
            return characterSetZHTEUC;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(walker));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (walker.next + 1 < walker.bytes.length) {
                int leadingCode = walker.bytes[walker.next] << 8 | walker.bytes[walker.next + 1];
                for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                    if (leadingCode != this.m_leadingCodes[i2]) continue;
                    if (walker.bytes.length - walker.next < 4) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                CharacterSetZHTEUC.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "destination too small");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    int c2 = 0;
                    for (int j2 = 0; j2 < 4; ++j2) {
                        c2 = c2 << 8 | walker.bytes[walker.next++];
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSetZHTEUC.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + c2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n2 = c2;
                    return n2;
                }
            }
            int c3 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (c3 > 127) {
                if (walker.bytes.length > walker.next) {
                    c3 = c3 << 8 | walker.bytes[walker.next];
                    ++walker.next;
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSetZHTEUC.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + c3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = c3;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int leadingCode = c2 >> 16;
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                if (leadingCode != this.m_leadingCodes[i2]) continue;
                CharacterSetZHTEUC.need(buffer, 4);
                for (int j2 = 0; j2 < 4; ++j2) {
                    buffer.bytes[buffer.next++] = (byte)c2;
                    c2 >>= 8;
                }
                return;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 181 + "Failed to find valid leading code");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 181, "Failed to find valid leading code");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetZHTEUC.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetZHTEUC"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

