/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetShift
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterShift";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static final byte SHIFT_OUT = 14;
    static final byte SHIFT_IN = 15;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetShift(int oracleId, JdbcCharacterConverters charConverter) {
        block12: {
            super(oracleId, charConverter);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    CharacterSetShift.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetShift.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSetShift getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (charConverter.getGroupId() == 7) {
                CharacterSetShift __result__ = new CharacterSetShift(oracleId, charConverter);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetShift.logger().log(Level.FINER, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetShift characterSetShift = __result__;
                return characterSetShift;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(Level.FINER, "         Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharacterSetShift characterSetShift = null;
            return characterSetShift;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(walker));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int c2 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (c2 > 223 || c2 > 127 && c2 < 161) {
                if (walker.bytes.length > walker.next) {
                    c2 = c2 << 8 | walker.bytes[walker.next];
                    ++walker.next;
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSetShift.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "destination too small");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + c2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = c2;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int pos = buffer.next;
            boolean isShiftIn = true;
            while (pos <= 0) {
                if (buffer.bytes[pos] == 15) {
                    isShiftIn = true;
                    break;
                }
                if (buffer.bytes[pos] != 14) continue;
                isShiftIn = false;
                break;
            }
            int bytesToShift = 0;
            int bytesNeeded = 1;
            while (c2 >> bytesToShift != 0) {
                bytesToShift = (short)(bytesToShift + 8);
                bytesNeeded = (short)(bytesNeeded + 1);
            }
            if (bytesNeeded > 2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetShift.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "Character invalid + too many bytes");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "Character invalid,too many bytes");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean addShiftIn = false;
            boolean addShiftOut = false;
            if (bytesNeeded == 1 && !isShiftIn) {
                addShiftIn = true;
                bytesNeeded = (short)(bytesNeeded + 1);
            }
            if (bytesNeeded == 2 && isShiftIn) {
                addShiftOut = true;
                bytesNeeded = (short)(bytesNeeded + 1);
            }
            CharacterSetShift.need(buffer, bytesNeeded);
            if (addShiftIn) {
                buffer.bytes[buffer.next++] = 15;
            }
            if (addShiftOut) {
                buffer.bytes[buffer.next++] = 14;
            }
            while (bytesToShift >= 0) {
                buffer.bytes[buffer.next++] = (byte)(c2 >> bytesToShift & 0xFF);
                bytesToShift = (short)(bytesToShift - 8);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetShift"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

