/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetLCFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterLCFixed";
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetLCFixed(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.m_leadingCodes = charConverter.getLeadingCodes();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSetLCFixed getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (charConverter.getGroupId() == 3) {
                CharacterSetLCFixed __result__ = new CharacterSetLCFixed(oracleId, charConverter);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetLCFixed.logger().log(Level.FINER, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetLCFixed characterSetLCFixed = __result__;
                return characterSetLCFixed;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(Level.FINER, "         Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharacterSetLCFixed characterSetLCFixed = null;
            return characterSetLCFixed;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(walker));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (walker.bytes.length - walker.next < 4) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetLCFixed.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "destination too small");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int leadingCode = walker.bytes[walker.next] << 8 | walker.bytes[walker.next + 1];
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                if (leadingCode != this.m_leadingCodes[i2]) continue;
                int c2 = 0;
                for (int j2 = 0; j2 < 4; ++j2) {
                    c2 = c2 << 8 | walker.bytes[walker.next++];
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetLCFixed.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + c2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = c2;
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 181 + "Leading code invalid");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 181, "Leading code invalid");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int leadingCode = c2 >> 16;
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                if (leadingCode != this.m_leadingCodes[i2]) continue;
                CharacterSetLCFixed.need(buffer, 4);
                for (int j2 = 3; j2 >= 0; --j2) {
                    buffer.bytes[buffer.next++] = (byte)(c2 >> 8 * j2 & 0xFF);
                }
                return;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 181 + "Leading code invalid");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 181, "Leading code invalid");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetLCFixed.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetLCFixed"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

