/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetGB18030
extends CharacterSetWithConverter {
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetGB18030(int oracleId, JdbcCharacterConverters charConverter) {
        block12: {
            super(oracleId, charConverter);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    CharacterSetGB18030.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetGB18030.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSetGB18030 getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetGB18030.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (charConverter.getGroupId() == 9) {
                CharacterSetGB18030 __result__ = new CharacterSetGB18030(oracleId, charConverter);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetGB18030.logger().log(Level.FINER, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharacterSetGB18030 characterSetGB18030 = __result__;
                return characterSetGB18030;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetGB18030.logger().log(Level.FINER, "         Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharacterSetGB18030 characterSetGB18030 = null;
            return characterSetGB18030;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetGB18030.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    int decode(CharacterWalker walker) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int c2;
            block30: {
                block35: {
                    block36: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                CharacterSetGB18030.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(walker));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                            __ol_nanos__ = System.nanoTime();
                        }
                        if ((c2 = walker.bytes[walker.next] & 0xFF) <= 127) break block30;
                        if (walker.bytes.length <= walker.next + 1) break block35;
                        if ((walker.bytes[walker.next] & 0xFF) < 129 || (walker.bytes[walker.next] & 0xFF) > 254 || (walker.bytes[walker.next + 1] & 0xFF) < 48 || (walker.bytes[walker.next + 1] & 0xFF) > 57) break block36;
                        if (walker.bytes.length > walker.next + 3) {
                            if ((walker.bytes[walker.next + 2] & 0xFF) >= 129 && (walker.bytes[walker.next + 2] & 0xFF) <= 254 && (walker.bytes[walker.next + 3] & 0xFF) >= 48 && (walker.bytes[walker.next + 3] & 0xFF) <= 57) {
                                c2 = (walker.bytes[walker.next] & 0xFF) << 24 | (walker.bytes[walker.next + 1] & 0xFF) << 16 | (walker.bytes[walker.next + 2] & 0xFF) << 8 | walker.bytes[walker.next + 3] & 0xFF;
                                walker.next += 4;
                                break block30;
                            } else {
                                c2 = walker.bytes[walker.next] & 0xFF;
                                ++walker.next;
                            }
                            break block30;
                        } else {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    CharacterSetGB18030.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "destination too small");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                    c2 = (walker.bytes[walker.next] & 0xFF) << 8 | walker.bytes[walker.next + 1] & 0xFF;
                    walker.next += 2;
                    break block30;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetGB18030.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "destination too small");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetGB18030.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + c2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = c2;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetGB18030.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetGB18030.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int bytesToShift = 0;
            int bytesNeeded = 0;
            while (c2 >> bytesToShift != 0) {
                bytesToShift = (short)(bytesToShift + 8);
                bytesNeeded = (short)(bytesNeeded + 1);
            }
            if (c2 >> 16 != 0) {
                bytesToShift = 3;
                bytesNeeded = 4;
            } else if (c2 >> 8 != 0) {
                bytesToShift = 1;
                bytesNeeded = 2;
            } else {
                bytesToShift = 0;
                bytesNeeded = 1;
            }
            CharacterSetGB18030.need(buffer, bytesNeeded);
            while (bytesToShift >= 0) {
                buffer.bytes[buffer.next++] = (byte)(c2 >> bytesToShift & 0xFF);
                bytesToShift = (short)(bytesToShift - 8);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetGB18030.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetGB18030"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

