/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetUTF;
import oracle.sql.CharacterWalker;

class CharacterSetByte
extends CharacterSet
implements CharacterRepConstants {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetByte(int id) {
        super(id);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(id));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.rep = 1;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLossyFrom(CharacterSet from) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = from.rep != 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(source));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = source.rep <= 1024;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(byte[] bytes, int offset, int count, char replacement) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(replacement));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                String __result__ = new String(bytes, offset, count, "ASCII");
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = __result__;
                return string;
            }
            catch (UnsupportedEncodingException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetByte.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 183);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 183);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                String __result__ = this.toString(bytes, offset, count, '?');
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = __result__;
                return string;
            }
            catch (SQLException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetByte.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Error: " + "CharacterSetByte.toString");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new Error("CharacterSetByte.toString");
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = this.toString(bytes, offset, count, '\u0000');
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(String s2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int sLength = s2.length();
            char[] chars = new char[s2.length()];
            s2.getChars(0, sLength, chars, 0);
            byte[] __result__ = CharacterSetByte.charsToBytes(chars, (byte)0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convertWithReplacement(String s2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int sLength = s2.length();
            char[] chars = new char[s2.length()];
            s2.getChars(0, sLength, chars, 0);
            try {
                byte[] __result__ = CharacterSetByte.charsToBytes(chars, (byte)63);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = __result__;
                return byArray;
            }
            catch (SQLException ex) {
                byte[] __result__ = new byte[]{};
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] byArray = __result__;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return byArray;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from) + ", " + OracleLog.argument(source) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (from.rep == 1) {
                result = CharacterSetByte.useOrCopy(source, offset, count);
            } else if (from.rep == 2) {
                char[] chars = CharacterSetUTF.UTFToJavaChar(source, offset, count);
                result = CharacterSetByte.charsToBytes(chars, (byte)0);
            } else {
                String s2 = from.toString(source, offset, count);
                char[] chars = s2.toCharArray();
                result = CharacterSetByte.charsToBytes(chars, (byte)0);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int decode(CharacterWalker walker) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(walker));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int c2 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + c2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = c2;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CharacterSetByte.need(buffer, 1);
            if (c2 < 256) {
                buffer.bytes[buffer.next] = (byte)c2;
                ++buffer.next;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] charsToBytes(char[] chars, byte replacement) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(replacement));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] bytes = new byte[chars.length];
            for (int x = 0; x < chars.length; ++x) {
                if (chars[x] > '\u00ff') {
                    bytes[x] = replacement;
                    if (replacement != 0) continue;
                    CharacterSetByte.failCharacterConversion(CharacterSet.make(31));
                    continue;
                }
                bytes[x] = (byte)chars[x];
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, "         Return: " + bytes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetByte.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetByte"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

