/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetFactory;
import oracle.sql.CharacterSetFactoryDefault;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.ReadWriteCharacterSetNamesMap;
import oracle.sql.converter.CharacterConverterFactoryOGS;

public abstract class CharacterSet {
    public static final short DEFAULT_CHARSET = -1;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short UNICODE_1_CHARSET = 870;
    public static final short US7ASCII_CHARSET = 1;
    public static final short WE8DEC_CHARSET = 2;
    public static final short WE8HP_CHARSET = 3;
    public static final short US8PC437_CHARSET = 4;
    public static final short WE8EBCDIC37_CHARSET = 5;
    public static final short WE8EBCDIC500_CHARSET = 6;
    public static final short WE8EBCDIC285_CHARSET = 8;
    public static final short WE8PC850_CHARSET = 10;
    public static final short D7DEC_CHARSET = 11;
    public static final short F7DEC_CHARSET = 12;
    public static final short S7DEC_CHARSET = 13;
    public static final short E7DEC_CHARSET = 14;
    public static final short SF7ASCII_CHARSET = 15;
    public static final short NDK7DEC_CHARSET = 16;
    public static final short I7DEC_CHARSET = 17;
    public static final short NL7DEC_CHARSET = 18;
    public static final short CH7DEC_CHARSET = 19;
    public static final short YUG7ASCII_CHARSET = 20;
    public static final short SF7DEC_CHARSET = 21;
    public static final short TR7DEC_CHARSET = 22;
    public static final short IW7IS960_CHARSET = 23;
    public static final short IN8ISCII_CHARSET = 25;
    public static final short WE8ISO8859P1_CHARSET = 31;
    public static final short EE8ISO8859P2_CHARSET = 32;
    public static final short SE8ISO8859P3_CHARSET = 33;
    public static final short NEE8ISO8859P4_CHARSET = 34;
    public static final short CL8ISO8859P5_CHARSET = 35;
    public static final short AR8ISO8859P6_CHARSET = 36;
    public static final short EL8ISO8859P7_CHARSET = 37;
    public static final short IW8ISO8859P8_CHARSET = 38;
    public static final short WE8ISO8859P9_CHARSET = 39;
    public static final short NE8ISO8859P10_CHARSET = 40;
    public static final short TH8TISASCII_CHARSET = 41;
    public static final short TH8TISEBCDIC_CHARSET = 42;
    public static final short BN8BSCII_CHARSET = 43;
    public static final short VN8VN3_CHARSET = 44;
    public static final short VN8MSWIN1258_CHARSET = 45;
    public static final short WE8NEXTSTEP_CHARSET = 50;
    public static final short AR8ASMO708PLUS_CHARSET = 61;
    public static final short AR8EBCDICX_CHARSET = 70;
    public static final short AR8XBASIC_CHARSET = 72;
    public static final short EL8DEC_CHARSET = 81;
    public static final short TR8DEC_CHARSET = 82;
    public static final short WE8EBCDIC37C_CHARSET = 90;
    public static final short WE8EBCDIC500C_CHARSET = 91;
    public static final short IW8EBCDIC424_CHARSET = 92;
    public static final short TR8EBCDIC1026_CHARSET = 93;
    public static final short WE8EBCDIC871_CHARSET = 94;
    public static final short WE8EBCDIC284_CHARSET = 95;
    public static final short WE8EBCDIC1047_CHARSET = 96;
    public static final short EEC8EUROASCI_CHARSET = 110;
    public static final short EEC8EUROPA3_CHARSET = 113;
    public static final short LA8PASSPORT_CHARSET = 114;
    public static final short BG8PC437S_CHARSET = 140;
    public static final short EE8PC852_CHARSET = 150;
    public static final short RU8PC866_CHARSET = 152;
    public static final short RU8BESTA_CHARSET = 153;
    public static final short IW8PC1507_CHARSET = 154;
    public static final short RU8PC855_CHARSET = 155;
    public static final short TR8PC857_CHARSET = 156;
    public static final short CL8MACCYRILLIC_CHARSET = 158;
    public static final short CL8MACCYRILLICS_CHARSET = 159;
    public static final short WE8PC860_CHARSET = 160;
    public static final short IS8PC861_CHARSET = 161;
    public static final short EE8MACCES_CHARSET = 162;
    public static final short EE8MACCROATIANS_CHARSET = 163;
    public static final short TR8MACTURKISHS_CHARSET = 164;
    public static final short IS8MACICELANDICS_CHARSET = 165;
    public static final short EL8MACGREEKS_CHARSET = 166;
    public static final short IW8MACHEBREWS_CHARSET = 167;
    public static final short EE8MSWIN1250_CHARSET = 170;
    public static final short CL8MSWIN1251_CHARSET = 171;
    public static final short ET8MSWIN923_CHARSET = 172;
    public static final short BG8MSWIN_CHARSET = 173;
    public static final short EL8MSWIN1253_CHARSET = 174;
    public static final short IW8MSWIN1255_CHARSET = 175;
    public static final short LT8MSWIN921_CHARSET = 176;
    public static final short TR8MSWIN1254_CHARSET = 177;
    public static final short WE8MSWIN1252_CHARSET = 178;
    public static final short BLT8MSWIN1257_CHARSET = 179;
    public static final short D8EBCDIC273_CHARSET = 180;
    public static final short I8EBCDIC280_CHARSET = 181;
    public static final short DK8EBCDIC277_CHARSET = 182;
    public static final short S8EBCDIC278_CHARSET = 183;
    public static final short EE8EBCDIC870_CHARSET = 184;
    public static final short CL8EBCDIC1025_CHARSET = 185;
    public static final short F8EBCDIC297_CHARSET = 186;
    public static final short IW8EBCDIC1086_CHARSET = 187;
    public static final short CL8EBCDIC1025X_CHARSET = 188;
    public static final short N8PC865_CHARSET = 190;
    public static final short BLT8CP921_CHARSET = 191;
    public static final short LV8PC1117_CHARSET = 192;
    public static final short LV8PC8LR_CHARSET = 193;
    public static final short BLT8EBCDIC1112_CHARSET = 194;
    public static final short LV8RST104090_CHARSET = 195;
    public static final short CL8KOI8R_CHARSET = 196;
    public static final short BLT8PC775_CHARSET = 197;
    public static final short F7SIEMENS9780X_CHARSET = 201;
    public static final short E7SIEMENS9780X_CHARSET = 202;
    public static final short S7SIEMENS9780X_CHARSET = 203;
    public static final short DK7SIEMENS9780X_CHARSET = 204;
    public static final short N7SIEMENS9780X_CHARSET = 205;
    public static final short I7SIEMENS9780X_CHARSET = 206;
    public static final short D7SIEMENS9780X_CHARSET = 207;
    public static final short WE8GCOS7_CHARSET = 210;
    public static final short EL8GCOS7_CHARSET = 211;
    public static final short US8BS2000_CHARSET = 221;
    public static final short D8BS2000_CHARSET = 222;
    public static final short F8BS2000_CHARSET = 223;
    public static final short E8BS2000_CHARSET = 224;
    public static final short DK8BS2000_CHARSET = 225;
    public static final short S8BS2000_CHARSET = 226;
    public static final short WE8BS2000_CHARSET = 231;
    public static final short CL8BS2000_CHARSET = 235;
    public static final short WE8BS2000L5_CHARSET = 239;
    public static final short WE8DG_CHARSET = 241;
    public static final short WE8NCR4970_CHARSET = 251;
    public static final short WE8ROMAN8_CHARSET = 261;
    public static final short EE8MACCE_CHARSET = 262;
    public static final short EE8MACCROATIAN_CHARSET = 263;
    public static final short TR8MACTURKISH_CHARSET = 264;
    public static final short IS8MACICELANDIC_CHARSET = 265;
    public static final short EL8MACGREEK_CHARSET = 266;
    public static final short IW8MACHEBREW_CHARSET = 267;
    public static final short US8ICL_CHARSET = 277;
    public static final short WE8ICL_CHARSET = 278;
    public static final short WE8ISOICLUK_CHARSET = 279;
    public static final short WE8MACROMAN8_CHARSET = 351;
    public static final short WE8MACROMAN8S_CHARSET = 352;
    public static final short TH8MACTHAI_CHARSET = 353;
    public static final short TH8MACTHAIS_CHARSET = 354;
    public static final short HU8CWI2_CHARSET = 368;
    public static final short EL8PC437S_CHARSET = 380;
    public static final short EL8EBCDIC875_CHARSET = 381;
    public static final short EL8PC737_CHARSET = 382;
    public static final short LT8PC772_CHARSET = 383;
    public static final short LT8PC774_CHARSET = 384;
    public static final short EL8PC869_CHARSET = 385;
    public static final short EL8PC851_CHARSET = 386;
    public static final short CDN8PC863_CHARSET = 390;
    public static final short HU8ABMOD_CHARSET = 401;
    public static final short AR8ASMO8X_CHARSET = 500;
    public static final short AR8NAFITHA711T_CHARSET = 504;
    public static final short AR8SAKHR707T_CHARSET = 505;
    public static final short AR8MUSSAD768T_CHARSET = 506;
    public static final short AR8ADOS710T_CHARSET = 507;
    public static final short AR8ADOS720T_CHARSET = 508;
    public static final short AR8APTEC715T_CHARSET = 509;
    public static final short AR8NAFITHA721T_CHARSET = 511;
    public static final short AR8HPARABIC8T_CHARSET = 514;
    public static final short AR8NAFITHA711_CHARSET = 554;
    public static final short AR8SAKHR707_CHARSET = 555;
    public static final short AR8MUSSAD768_CHARSET = 556;
    public static final short AR8ADOS710_CHARSET = 557;
    public static final short AR8ADOS720_CHARSET = 558;
    public static final short AR8APTEC715_CHARSET = 559;
    public static final short AR8MSAWIN_CHARSET = 560;
    public static final short AR8NAFITHA721_CHARSET = 561;
    public static final short AR8SAKHR706_CHARSET = 563;
    public static final short AR8ARABICMAC_CHARSET = 565;
    public static final short AR8ARABICMACS_CHARSET = 566;
    public static final short AR8ARABICMACT_CHARSET = 567;
    public static final short LA8ISO6937_CHARSET = 590;
    public static final short US8NOOP_CHARSET = 797;
    public static final short WE8DECTST_CHARSET = 798;
    public static final short JA16VMS_CHARSET = 829;
    public static final short JA16EUC_CHARSET = 830;
    public static final short JA16EUCYEN_CHARSET = 831;
    public static final short JA16SJIS_CHARSET = 832;
    public static final short JA16DBCS_CHARSET = 833;
    public static final short JA16SJISYEN_CHARSET = 834;
    public static final short JA16EBCDIC930_CHARSET = 835;
    public static final short JA16MACSJIS_CHARSET = 836;
    public static final short JA16EUCTILDE_CHARSET = 837;
    public static final short JA16SJISTILDE_CHARSET = 838;
    public static final short KO16KSC5601_CHARSET = 840;
    public static final short KO16DBCS_CHARSET = 842;
    public static final short KO16KSCCS_CHARSET = 845;
    public static final short KO16MSWIN949_CHARSET = 846;
    public static final short ZHS16CGB231280_CHARSET = 850;
    public static final short ZHS16MACCGB231280_CHARSET = 851;
    public static final short ZHS16GBK_CHARSET = 852;
    public static final short ZHS16DBCS_CHARSET = 853;
    public static final short ZHS32GB18030_CHARSET = 854;
    public static final short ZHT32EUC_CHARSET = 860;
    public static final short ZHT32SOPS_CHARSET = 861;
    public static final short ZHT16DBT_CHARSET = 862;
    public static final short ZHT32TRIS_CHARSET = 863;
    public static final short ZHT16DBCS_CHARSET = 864;
    public static final short ZHT16BIG5_CHARSET = 865;
    public static final short ZHT16CCDC_CHARSET = 866;
    public static final short ZHT16MSWIN950_CHARSET = 867;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    public static final short UTFE_CHARSET = 872;
    public static final short AL32UTF8_CHARSET = 873;
    public static final short KO16TSTSET_CHARSET = 996;
    public static final short JA16TSTSET2_CHARSET = 997;
    public static final short JA16TSTSET_CHARSET = 998;
    public static final short US16TSTFIXED_CHARSET = 1001;
    public static final short AL16UTF16_CHARSET = 2000;
    public static final short AL16UTF16LE_CHARSET = 2002;
    public static final short TH8TISEBCDICS_CHARSET = 319;
    public static final short BLT8EBCDIC1112S_CHARSET = 314;
    public static final short CE8BS2000_CHARSET = 233;
    public static final short CL8EBCDIC1025R_CHARSET = 323;
    public static final short CL8EBCDIC1158R_CHARSET = 326;
    public static final short D8EBCDIC1141_CHARSET = 189;
    public static final short DK8EBCDIC1142_CHARSET = 198;
    public static final short EE8BS2000_CHARSET = 232;
    public static final short EE8EBCDIC870S_CHARSET = 316;
    public static final short EL8EBCDIC423R_CHARSET = 327;
    public static final short EL8EBCDIC875S_CHARSET = 311;
    public static final short EL8EBCDIC875R_CHARSET = 324;
    public static final short F8EBCDIC1147_CHARSET = 208;
    public static final short I8EBCDIC1144_CHARSET = 200;
    public static final short WE8BS2000E_CHARSET = 230;
    public static final short WE8EBCDIC1047E_CHARSET = 100;
    public static final short WE8EBCDIC1140_CHARSET = 7;
    public static final short WE8EBCDIC1145_CHARSET = 98;
    public static final short WE8EBCDIC1146_CHARSET = 9;
    public static final short WE8EBCDIC1148_CHARSET = 27;
    public static final short AR8EBCDIC420S_CHARSET = 320;
    public static final short IW8EBCDIC424S_CHARSET = 315;
    public static final short TR8EBCDIC1026S_CHARSET = 312;
    public static final short ZHT16HKSCS_CHARSET = 868;
    public static final short BLT8ISO8859P13_CHARSET = 47;
    public static final short WE8ISO8859P15_CHARSET = 46;
    public static final short AR8MSWIN1256_CHARSET = 560;
    public static final short S8EBCDIC1143_CHARSET = 199;
    public static final short ZHT16HKSCS31_CHARSET = 992;
    public static final short AZ8ISO8859P9E_CHARSET = 52;
    public static final short CEL8ISO8859P14_CHARSET = 48;
    public static final short CL8ISOIR111_CHARSET = 49;
    public static final short CL8KOI8U_CHARSET = 51;
    public static final short WE8PC858_CHARSET = 28;
    public static final short CL8EBCDIC1025C_CHARSET = 322;
    public static final short CL8EBCDIC1025S_CHARSET = 317;
    public static final short CL8EBCDIC1158_CHARSET = 325;
    public static final short EE8EBCDIC870C_CHARSET = 301;
    public static final short WE8EBCDIC924_CHARSET = 101;
    public static final short WE8EBCDIC1140C_CHARSET = 97;
    public static final short WE8EBCDIC1148C_CHARSET = 99;
    public static final short UNICODE_2_CHARSET = 871;
    private static CharacterSet asciiCharSet = null;
    static CharacterSetFactory factory;
    private int oracleId;
    int rep;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSet(int oracleId) {
        block12: {
            this.oracleId = oracleId;
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oracleId));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharacterSet make(int oracleId) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(oracleId));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CharacterSet __result__ = factory.make(oracleId);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharacterSet characterSet = __result__;
            return characterSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (ReadWriteCharacterSetNamesMap.cache == null) {
                this.buildCharacterSetNames();
            }
            String __result__ = ReadWriteCharacterSetNamesMap.cache.get(new Short((short)this.oracleId));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    synchronized void buildCharacterSetNames() {
        if (ReadWriteCharacterSetNamesMap.cache == null) {
            Class<CharacterSet> cls = CharacterSet.class;
            Field[] fields = cls.getFields();
            HashMap<Short, String> tempCharacterSetNames = new HashMap<Short, String>();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                try {
                    String name = fields[i2].getName();
                    int suffixIndex = name.lastIndexOf("_CHARSET");
                    if (suffixIndex == -1 || (name = name.substring(0, suffixIndex)).equals("ASCII") || name.equals("ISO_LATIN_1") || name.equals("AR8MSAWIN") || name.equals("UNICODE_1") || name.equals("UNICODE_2")) continue;
                    short id = fields[i2].getShort(CharacterSet.class);
                    int mod = fields[i2].getModifiers();
                    if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod)) continue;
                    String temp = (String)tempCharacterSetNames.get(new Short(id));
                    if (temp != null) {
                        throw new RuntimeException("duplicate field name: " + name + " for id: " + id);
                    }
                    tempCharacterSetNames.put(new Short(id), name);
                    continue;
                }
                catch (Exception e2) {
                    throw new RuntimeException("Failed for field: " + fields[i2], e2);
                }
            }
            ReadWriteCharacterSetNamesMap.cache = tempCharacterSetNames;
        }
    }

    public abstract boolean isLossyFrom(CharacterSet var1);

    public abstract boolean isConvertibleFrom(CharacterSet var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnicode() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isWellFormed(byte[] bytes, int offset, int count) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOracleId() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.oracleId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.oracleId;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRep() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rep);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.rep;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRatioTo(CharacterSet to) {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Error: " + "oracle.sql.CharacterSet.getRationTo Not Implemented");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        throw new Error("oracle.sql.CharacterSet.getRationTo Not Implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object rhs) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rhs));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = rhs instanceof CharacterSet && this.oracleId == ((CharacterSet)rhs).oracleId;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public int hashCode() {
        return this.oracleId;
    }

    public abstract String toStringWithReplacement(byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            String str;
            byte[] copy;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (count != (copy = this.convert(str = this.toStringWithReplacement(bytes, offset, count))).length) {
                CharacterSet.failCharacterConversion(this);
            }
            for (int x = 0; x < count; ++x) {
                if (copy[x] == bytes[offset + x]) continue;
                CharacterSet.failCharacterConversion(this);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public abstract byte[] convert(String var1) throws SQLException;

    public abstract byte[] convertWithReplacement(String var1);

    public abstract byte[] convert(CharacterSet var1, byte[] var2, int var3, int var4) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertUnshared(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from) + ", " + OracleLog.argument(source) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((result = this.convert(from, source, offset, count)) == source) {
                result = new byte[source.length];
                System.arraycopy(source, 0, result, 0, count);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    abstract int decode(CharacterWalker var1) throws SQLException;

    abstract void encode(CharacterBuffer var1, int var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void failCharacterConversion(CharacterSet which) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(which));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.SEVERE, "         Throwing SQLException: 55" + which);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 55, which);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final byte[] useOrCopy(byte[] bytes, int offset, int count) {
        long __ol_nanos__ = 0L;
        try {
            byte[] result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (bytes.length == count && offset == 0) {
                result = bytes;
            } else {
                result = new byte[count];
                System.arraycopy(bytes, offset, result, 0, count);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void need(CharacterBuffer buffer, int n2) {
        long __ol_nanos__ = 0L;
        try {
            int wanted;
            int needed;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(n2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((needed = n2 + buffer.next) <= (wanted = buffer.bytes.length)) {
                return;
            }
            while (needed > wanted) {
                wanted = 2 * wanted;
            }
            byte[] old = buffer.bytes;
            buffer.bytes = new byte[wanted];
            System.arraycopy(old, 0, buffer.bytes, 0, buffer.next);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String UTFToString(byte[] bytes, int offset, int nbytes, boolean useReplacementChar) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(nbytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = new String(CharacterSet.UTFToJavaChar(bytes, offset, nbytes, useReplacementChar));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String UTFToString(byte[] bytes, int offset, int nbytes) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(nbytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = CharacterSet.UTFToString(bytes, offset, nbytes, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char[] UTFToJavaChar(byte[] bytes, int offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] __result__ = CharacterSet.UTFToJavaChar(bytes, offset, count, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char[] cArray = __result__;
            return cArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char[] UTFToJavaChar(byte[] bytes, int offset, int count, boolean useReplacementChar) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(useReplacementChar));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] chars = null;
            chars = new char[count];
            int[] countArr = new int[]{count};
            int chars_index = CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, 0, countArr, useReplacementChar);
            char[] rchars = new char[chars_index];
            System.arraycopy(chars, 0, rchars, 0, chars_index);
            chars = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + rchars);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char[] cArray = rchars;
            return cArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char[] UTFToJavaCharWithReplacement(byte[] bytes, int offset, int count) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] chars = null;
            try {
                chars = new char[count];
                int[] countArr = new int[]{count};
                int chars_index = CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, 0, countArr, true);
                char[] rchars = new char[chars_index];
                System.arraycopy(chars, 0, rchars, 0, chars_index);
                chars = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.FINER, "         Return: " + rchars);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                char[] cArray = rchars;
                return cArray;
            }
            catch (SQLException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.SEVERE, "         Throwing java.lang.IllegalStateException: " + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new IllegalStateException(e2.getMessage());
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertUTFBytesToJavaChars(byte[] bytes, int offset, char[] chars, int chars_offset, int[] countArr, boolean convertWithReplacement) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(countArr) + ", " + OracleLog.argument(convertWithReplacement));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, chars_offset, countArr, convertWithReplacement, chars.length - chars_offset);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertUTFBytesToJavaChars(byte[] bytes, int offset, char[] chars, int chars_offset, int[] countArr, boolean convertWithReplacement, int charSize) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(countArr) + ", " + OracleLog.argument(convertWithReplacement) + ", " + OracleLog.argument(charSize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CharacterConverterBehavior ccb = convertWithReplacement ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
            int count = countArr[0];
            countArr[0] = 0;
            int bytes_index = offset;
            int bytes_end = offset + count;
            int chars_index = chars_offset;
            int charsLength = chars_offset + charSize;
            while (bytes_index < bytes_end) {
                char c2;
                byte bb;
                byte c3 = bytes[bytes_index++];
                b2 = c3 & 0xF0;
                if (c3 >= 0) {
                    if (chars_index < charsLength) {
                        chars[chars_index++] = (char)(c3 & 0xFFFFFFFF);
                        if (bytes_end > bytes.length || charsLength > chars.length || bytes_index >= bytes_end || chars_index >= charsLength || bytes_index < 0 || chars_index < 0) continue;
                        while (bytes_index < bytes_end && chars_index < charsLength && (bb = bytes[bytes_index]) >= 0) {
                            chars[chars_index] = (char)(bb & 0xFFFFFFFF);
                            ++chars_index;
                            ++bytes_index;
                        }
                        continue;
                    }
                    countArr[0] = bytes_end - bytes_index + 2;
                    break;
                }
                bb = c3;
                if ((bb = (byte)(bb << 2)) >= 0) {
                    if (bytes_index >= bytes_end) {
                        countArr[0] = 1;
                        ccb.onFailConversion();
                        break;
                    }
                    c2 = CharacterSet.conv2ByteUTFtoUTF16(c3, bytes[bytes_index++]);
                    if (chars_index >= charsLength) {
                        countArr[0] = bytes_end - bytes_index + 3;
                        break;
                    }
                    chars[chars_index++] = c2;
                    ccb.onFailConversion(c2);
                    continue;
                }
                if ((bb = (byte)(bb << 1)) >= 0) {
                    if (bytes_index + 1 >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + 1;
                        ccb.onFailConversion();
                        break;
                    }
                    char c1 = CharacterSet.conv3ByteUTFtoUTF16(c3, bytes[bytes_index++], bytes[bytes_index++]);
                    if (b2 != 244 && bytes[bytes_index - 2] != -65 && bytes[bytes_index - 1] != -67) {
                        ccb.onFailConversion(c1);
                    }
                    if (CharacterSet.isHiSurrogate(c1)) {
                        if (chars_index > charsLength - 2) {
                            countArr[0] = bytes_end - bytes_index + 4;
                            break;
                        }
                        if (bytes_index >= bytes_end) continue;
                        c3 = bytes[bytes_index];
                        if ((byte)(c3 & 0xF0) != -32) {
                            chars[chars_index++] = 65533;
                            ccb.onFailConversion();
                            continue;
                        }
                        if (++bytes_index + 1 >= bytes_end) {
                            countArr[0] = bytes_end - bytes_index + 1;
                            ccb.onFailConversion();
                            break;
                        }
                        if (CharacterSet.isLoSurrogate(c2 = CharacterSet.conv3ByteUTFtoUTF16(c3, bytes[bytes_index++], bytes[bytes_index++]))) {
                            chars[chars_index++] = c1;
                        } else {
                            chars[chars_index++] = 65533;
                            ccb.onFailConversion();
                        }
                        chars[chars_index++] = c2;
                        continue;
                    }
                    if (chars_index < charsLength) {
                        chars[chars_index++] = c1;
                        continue;
                    }
                    countArr[0] = bytes_end - bytes_index + 4;
                    break;
                }
                if (chars_index >= charsLength) {
                    countArr[0] = bytes_end - bytes_index + 2;
                    break;
                }
                chars[chars_index++] = 65533;
                ccb.onFailConversion();
            }
            b2 = chars_index - chars_offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + b2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = b2;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] stringToUTF(String str) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] chararr = str.toCharArray();
            int maxNbBytes = chararr.length * 3;
            byte[] bytearr = null;
            byte[] rbytearr = null;
            bytearr = new byte[maxNbBytes];
            int byte_len = CharacterSet.convertJavaCharsToUTFBytes(chararr, 0, bytearr, 0, chararr.length);
            rbytearr = new byte[byte_len];
            System.arraycopy(bytearr, 0, rbytearr, 0, byte_len);
            bytearr = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + rbytearr);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = rbytearr;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertJavaCharsToUTFBytes(char[] chars, int chars_offset, byte[] bytes, int bytes_begin, int chars_count) {
        long __ol_nanos__ = 0L;
        try {
            int c2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytes_begin) + ", " + OracleLog.argument(chars_count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int chars_begin = chars_offset;
            int chars_end = chars_offset + chars_count;
            int byte_index = bytes_begin;
            for (int i2 = chars_begin; i2 < chars_end; ++i2) {
                c2 = chars[i2];
                if (c2 >= 0 && c2 <= 127) {
                    bytes[byte_index++] = (byte)c2;
                    continue;
                }
                if (c2 > 2047) {
                    bytes[byte_index++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                    bytes[byte_index++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                    bytes[byte_index++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                    continue;
                }
                bytes[byte_index++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
                bytes[byte_index++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
            }
            c2 = byte_index - bytes_begin;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + c2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = c2;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int UTFStringLength(byte[] bytes, int offset, int count) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int strlen = 0;
            int bytes_index = offset;
            int bytes_end = offset + count;
            while (bytes_index < bytes_end) {
                byte b2 = bytes[bytes_index];
                if (b2 >= 0) {
                    ++bytes_index;
                    ++strlen;
                    continue;
                }
                if ((b2 = (byte)(b2 << 2)) >= 0) {
                    if (bytes_index + 1 >= bytes_end) {
                        bytes_index = bytes_end;
                        continue;
                    }
                    ++strlen;
                    bytes_index += 2;
                    continue;
                }
                if ((b2 = (byte)(b2 << 1)) >= 0) {
                    if (bytes_index + 2 >= bytes_end) {
                        bytes_index = bytes_end;
                        continue;
                    }
                    ++strlen;
                    bytes_index += 3;
                    continue;
                }
                if ((b2 = (byte)(b2 << 1)) >= 0) {
                    if (bytes_index + 3 >= bytes_end) {
                        bytes_index = bytes_end;
                        continue;
                    }
                    strlen += 2;
                    bytes_index += 4;
                    continue;
                }
                ++bytes_index;
                ++strlen;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + strlen);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = strlen;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int stringUTFLength(String s2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(s2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] carr = s2.toCharArray();
            int __result__ = CharacterSet.charArrayUTF8Length(carr);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int charArrayUTF8Length(char[] carr) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(carr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int utflen = 0;
            for (char c2 : carr) {
                if (c2 >= '\u0000' && c2 <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c2 > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + utflen);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = utflen;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String AL32UTF8ToString(byte[] bytes, int offset, int nbytes) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(nbytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = CharacterSet.AL32UTF8ToString(bytes, offset, nbytes, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String AL32UTF8ToString(byte[] bytes, int offset, int nbytes, boolean useReplacementCharacter) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(useReplacementCharacter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] chars = null;
            try {
                chars = CharacterSet.AL32UTF8ToJavaChar(bytes, offset, nbytes, useReplacementCharacter);
            }
            catch (SQLException e2) {
                // empty catch block
            }
            String __result__ = new String(chars);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char[] AL32UTF8ToJavaChar(byte[] bytes, int offset, int count, boolean useReplacementCharacter) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(useReplacementCharacter));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] chars = null;
            try {
                chars = new char[count];
                int[] countArr = new int[]{count};
                int clen = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, offset, chars, 0, countArr, useReplacementCharacter);
                char[] rchars = new char[clen];
                System.arraycopy(chars, 0, rchars, 0, clen);
                chars = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.FINER, "         Return: " + rchars);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                char[] cArray = rchars;
                return cArray;
            }
            catch (SQLException e2) {
                CharacterSet.failUTFConversion();
                char[] __result__ = new char[]{};
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                char[] cArray = __result__;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return cArray;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertAL32UTF8BytesToJavaChars(byte[] bytes, int offsetBytes, char[] chars, int offsetChars, int[] countArr, boolean convertWithReplacement) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offsetBytes) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(offsetChars) + ", " + OracleLog.argument(countArr) + ", " + OracleLog.argument(convertWithReplacement));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, offsetBytes, chars, offsetChars, countArr, convertWithReplacement, chars.length - offsetChars);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertAL32UTF8BytesToJavaChars(byte[] bytes, int offsetBytes, char[] chars, int offsetChars, int[] countArr, boolean convertWithReplacement, int charSize) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int w;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offsetBytes) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(offsetChars) + ", " + OracleLog.argument(countArr) + ", " + OracleLog.argument(convertWithReplacement) + ", " + OracleLog.argument(charSize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CharacterConverterBehavior ccb = convertWithReplacement ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
            int count = countArr[0];
            countArr[0] = 0;
            int bytes_index = offsetBytes;
            int bytes_end = offsetBytes + count;
            int chars_index = offsetChars;
            int charsLength = offsetChars + charSize;
            while (bytes_index < bytes_end) {
                char c2;
                byte bb;
                byte c3;
                if ((c3 = bytes[bytes_index++]) >= 0) {
                    if (chars_index < charsLength) {
                        chars[chars_index++] = (char)(c3 & 0xFFFFFFFF);
                        if (bytes_end > bytes.length || charsLength > chars.length || bytes_index >= bytes_end || chars_index >= charsLength || bytes_index < 0 || chars_index < 0) continue;
                        while (bytes_index < bytes_end && chars_index < charsLength && (bb = bytes[bytes_index]) >= 0) {
                            chars[chars_index] = (char)(bb & 0xFFFFFFFF);
                            ++chars_index;
                            ++bytes_index;
                        }
                        continue;
                    }
                    countArr[0] = bytes_end - bytes_index + 2;
                    break;
                }
                bb = c3;
                if ((bb = (byte)(bb << 2)) >= 0) {
                    if (bytes_index >= bytes_end) {
                        countArr[0] = 1;
                        ccb.onFailConversion();
                        break;
                    }
                    c2 = CharacterSet.conv2ByteUTFtoUTF16(c3, bytes[bytes_index++]);
                    if (chars_index >= charsLength) {
                        countArr[0] = bytes_end - bytes_index + 3;
                        break;
                    }
                    chars[chars_index++] = c2;
                    ccb.onFailConversion(c2);
                    continue;
                }
                if ((bb = (byte)(bb << 1)) >= 0) {
                    if (bytes_index + 1 >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + 1;
                        ccb.onFailConversion();
                        break;
                    }
                    c2 = CharacterSet.conv3ByteAL32UTF8toUTF16(c3, bytes[bytes_index++], bytes[bytes_index++]);
                    if (chars_index >= charsLength) {
                        countArr[0] = bytes_end - bytes_index + 4;
                        break;
                    }
                    chars[chars_index++] = c2;
                    ccb.onFailConversion(c2);
                    continue;
                }
                if ((bb = (byte)(bb << 1)) >= 0) {
                    if (bytes_index + 2 >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + 1;
                        ccb.onFailConversion();
                        break;
                    }
                    if (chars_index > charsLength - 2) {
                        countArr[0] = bytes_end - bytes_index + 2;
                        break;
                    }
                    if ((w = CharacterSet.conv4ByteAL32UTF8toUTF16(c3, bytes[bytes_index++], bytes[bytes_index++], bytes[bytes_index++], chars, chars_index)) == 1) {
                        ccb.onFailConversion();
                        ++chars_index;
                        continue;
                    }
                    chars_index += 2;
                    continue;
                }
                if (chars_index >= charsLength) {
                    countArr[0] = bytes_end - bytes_index + 2;
                    break;
                }
                chars[chars_index++] = 65533;
                ccb.onFailConversion();
            }
            w = chars_index - offsetChars;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + w);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = w;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] stringToAL32UTF8(String str) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] chararr = str.toCharArray();
            int maxNbBytes = chararr.length * 3;
            byte[] bytearr = null;
            byte[] rbytearr = null;
            bytearr = new byte[maxNbBytes];
            int byte_len = CharacterSet.convertJavaCharsToAL32UTF8Bytes(chararr, 0, bytearr, 0, chararr.length);
            rbytearr = new byte[byte_len];
            System.arraycopy(bytearr, 0, rbytearr, 0, byte_len);
            bytearr = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + rbytearr);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = rbytearr;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertJavaCharsToAL32UTF8Bytes(char[] chars, int chars_offset, byte[] bytes, int bytes_begin, int chars_count) {
        long __ol_nanos__ = 0L;
        try {
            int uuuuu;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytes_begin) + ", " + OracleLog.argument(chars_count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int chars_begin = chars_offset;
            int chars_end = chars_offset + chars_count;
            int byte_index = bytes_begin;
            for (int i2 = chars_begin; i2 < chars_end; ++i2) {
                char c2 = chars[i2];
                char c22 = '\u0000';
                if (c2 >= '\u0000' && c2 <= '\u007f') {
                    bytes[byte_index++] = (byte)c2;
                    continue;
                }
                if (CharacterSet.isHiSurrogate(c2)) {
                    if (i2 + 1 < chars_end && CharacterSet.isLoSurrogate(c22 = chars[i2 + 1])) {
                        uuuuu = (c2 >>> 6 & 0xF) + 1;
                        bytes[byte_index++] = (byte)(uuuuu >>> 2 | 0xF0);
                        bytes[byte_index++] = (byte)((uuuuu & 3) << 4 | c2 >>> 2 & 0xF | 0x80);
                        bytes[byte_index++] = (byte)((c2 & 3) << 4 | c22 >>> 6 & 0xF | 0x80);
                        bytes[byte_index++] = (byte)(c22 & 0x3F | 0x80);
                        ++i2;
                        continue;
                    }
                    bytes[byte_index++] = -17;
                    bytes[byte_index++] = -65;
                    bytes[byte_index++] = -67;
                    continue;
                }
                if (c2 > '\u07ff') {
                    bytes[byte_index++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                    bytes[byte_index++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                    bytes[byte_index++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                    continue;
                }
                bytes[byte_index++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
                bytes[byte_index++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
            }
            uuuuu = byte_index - bytes_begin;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + uuuuu);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = uuuuu;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int string32UTF8Length(String s2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(s2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = CharacterSet.charArray32UTF8Length(s2.toCharArray());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int charArray32UTF8Length(char[] carr) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(carr));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int utflen = 0;
            int slen = carr.length;
            for (int i2 = 0; i2 < slen; ++i2) {
                char c2 = carr[i2];
                if (c2 >= '\u0000' && c2 <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c2 > '\u07ff') {
                    if (CharacterSet.isHiSurrogate(c2)) {
                        if (i2 + 1 >= slen) continue;
                        utflen += 4;
                        ++i2;
                        continue;
                    }
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + utflen);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = utflen;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String AL16UTF16BytesToString(byte[] bytes, int nbytes) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] chars = new char[nbytes >>> 1];
            CharacterSet.AL16UTF16BytesToJavaChars(bytes, nbytes, chars);
            String __result__ = new String(chars);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int AL16UTF16BytesToJavaChars(byte[] bytes, int nbytes, char[] chars) {
        long __ol_nanos__ = 0L;
        try {
            int chars_i;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(chars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int charMax = nbytes >>> 1;
            int bytes_i = 0;
            for (chars_i = 0; chars_i < charMax; ++chars_i) {
                int hibyte = bytes[bytes_i] << 8;
                chars[chars_i] = (char)(hibyte | bytes[bytes_i + 1] & 0xFF);
                bytes_i += 2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + chars_i);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = chars_i;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertAL16UTF16BytesToJavaChars(byte[] bytes, int offset, char[] chars, int chars_offset, int count, boolean convertWithReplacement) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(convertWithReplacement));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CharacterConverterBehavior ccb = convertWithReplacement ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
            int chars_i = chars_offset;
            int bytes_i = offset;
            int bytes_end = offset + count;
            while (bytes_i + 1 < bytes_end) {
                int hibyte = bytes[bytes_i] << 8;
                char c2 = (char)(hibyte | bytes[bytes_i + 1] & 0xFF);
                chars[chars_i++] = c2;
                bytes_i += 2;
            }
            bytes_i = chars_i - chars_offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + bytes_i);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = bytes_i;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertAL16UTF16LEBytesToJavaChars(byte[] bytes, int offset, char[] chars, int chars_offset, int count, boolean convertWithReplacement) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(convertWithReplacement));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CharacterConverterBehavior ccb = convertWithReplacement ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
            int chars_i = chars_offset;
            int bytes_i = offset;
            int bytes_end = offset + count;
            while (bytes_i + 1 < bytes_end) {
                int hibyte = bytes[bytes_i + 1] << 8;
                int c2 = hibyte | bytes[bytes_i] & 0xFF;
                if (CharacterSet.isHiSurrogate((char)c2)) {
                    if ((bytes_i += 2) + 1 < bytes_end) {
                        char c22 = (char)((bytes[bytes_i + 1] << 8) + (bytes[bytes_i] & 0xFF));
                        chars[chars_i++] = CharacterSet.isLoSurrogate(c22) ? c2 : 65533;
                        chars[chars_i++] = c22;
                    }
                } else {
                    chars[chars_i++] = c2;
                }
                bytes_i += 2;
            }
            bytes_i = chars_i - chars_offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + bytes_i);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = bytes_i;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] stringToAL16UTF16Bytes(String str) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] chars = str.toCharArray();
            int nchars = chars.length;
            byte[] bytes = new byte[nchars * 2];
            CharacterSet.javaCharsToAL16UTF16Bytes(chars, nchars, bytes);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + bytes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int javaCharsToAL16UTF16Bytes(char[] chars, int nchars, byte[] bytes) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int charsMax = Math.min(nchars, bytes.length >>> 1);
            int __result__ = CharacterSet.convertJavaCharsToAL16UTF16Bytes(chars, 0, bytes, 0, charsMax);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertJavaCharsToAL16UTF16Bytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytes_offset) + ", " + OracleLog.argument(nchars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int chars_i = chars_offset;
            int bytes_i = bytes_offset;
            int char_end = chars_offset + nchars;
            while (chars_i < char_end) {
                bytes[bytes_i] = (byte)(chars[chars_i] >>> 8 & 0xFF);
                bytes[bytes_i + 1] = (byte)(chars[chars_i] & 0xFF);
                ++chars_i;
                bytes_i += 2;
            }
            int __result__ = bytes_i - bytes_offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] stringToAL16UTF16LEBytes(String str) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            char[] chars = str.toCharArray();
            byte[] bytes = new byte[chars.length * 2];
            CharacterSet.javaCharsToAL16UTF16LEBytes(chars, chars.length, bytes);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + bytes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int javaCharsToAL16UTF16LEBytes(char[] chars, int nchars, byte[] bytes) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = CharacterSet.convertJavaCharsToAL16UTF16LEBytes(chars, 0, bytes, 0, nchars);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertJavaCharsToAL16UTF16LEBytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytes_offset) + ", " + OracleLog.argument(nchars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int chars_i = chars_offset;
            int bytes_i = bytes_offset;
            int char_end = chars_offset + nchars;
            while (chars_i < char_end) {
                bytes[bytes_i] = (byte)(chars[chars_i] & 0xFF);
                bytes[bytes_i + 1] = (byte)(chars[chars_i] >>> 8);
                ++chars_i;
                bytes_i += 2;
            }
            int __result__ = bytes_i - bytes_offset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertASCIIBytesToJavaChars(byte[] bytes, int bytes_offset, char[] chars, int chars_offset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytes_offset) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int lastChar = chars_offset + count;
            int i2 = chars_offset;
            int j2 = bytes_offset;
            while (i2 < lastChar) {
                chars[i2] = (char)(0xFF & bytes[j2]);
                ++i2;
                ++j2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + count);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertJavaCharsToASCIIBytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytes_offset) + ", " + OracleLog.argument(nchars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CharacterSet.convertJavaCharsToASCIIBytes(chars, chars_offset, bytes, bytes_offset, nchars, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + nchars);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = nchars;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertJavaCharsToASCIIBytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars, boolean strictConversion) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytes_offset) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(strictConversion));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (strictConversion) {
                if (asciiCharSet == null) {
                    asciiCharSet = CharacterSet.make(1);
                }
                byte[] tempBytes = asciiCharSet.convertWithReplacement(new String(chars, chars_offset, nchars));
                System.arraycopy(tempBytes, 0, bytes, bytes_offset, tempBytes.length);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.FINER, "         Return: " + tempBytes.length);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = tempBytes.length;
                return n2;
            }
            for (int i2 = 0; i2 < nchars; ++i2) {
                bytes[bytes_offset + i2] = (byte)chars[chars_offset + i2];
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + nchars);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = nchars;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int convertJavaCharsToISOLATIN1Bytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytes_offset) + ", " + OracleLog.argument(nchars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            for (int i2 = 0; i2 < nchars; ++i2) {
                char c2 = chars[chars_offset + i2];
                bytes[bytes_offset + i2] = c2 > '\u00ff' ? -65 : (byte)c2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + nchars);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = nchars;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] stringToASCII(String str) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] bytearr = new byte[str.length()];
            bytearr = str.getBytes();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Return: " + bytearr);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = bytearr;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long convertUTF32toUTF16(long ucs4ch) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(ucs4ch));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (ucs4ch > 65535L) {
                long utf16str = 0xD8L | ucs4ch - 65536L >> 18 & 0xFFL;
                utf16str = ucs4ch - 65536L >> 10 & 0xFFL | utf16str << 8;
                utf16str = 0xDCL | (ucs4ch & 0x3FFL) >> 8 & 0xFFL | utf16str << 8;
                utf16str = ucs4ch & 0xFFL | utf16str << 8;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + utf16str);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l2 = utf16str;
                return l2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + ucs4ch);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = ucs4ch;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean isHiSurrogate(char c2) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = (char)(c2 & 0xFC00) == '\ud800';
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean isLoSurrogate(char c2) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = (char)(c2 & 0xFC00) == '\udc00';
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean check80toBF(byte b2) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(b2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = (b2 & 0xFFFFFFC0) == -128;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean check80to8F(byte b2) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(b2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = (b2 & 0xFFFFFFF0) == -128;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean check80to9F(byte b2) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(b2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = (b2 & 0xFFFFFFE0) == -128;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean checkA0toBF(byte b2) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(b2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = (b2 & 0xFFFFFFE0) == -96;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean check90toBF(byte b2) {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(b2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = __result__ = (b2 & 0xFFFFFFC0) == -128 && (b2 & 0x30) != 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final char conv2ByteUTFtoUTF16(byte c2, byte c22) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(c2) + ", " + OracleLog.argument(c22));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (c2 < -62 || c2 > -33 || !CharacterSet.check80toBF(c22)) {
                char __result__ = '\ufffd';
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                char c3 = __result__;
                return c3;
            }
            char __result__ = (char)((c2 & 0x1F) << 6 | c22 & 0x3F);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char c4 = __result__;
            return c4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final char conv3ByteUTFtoUTF16(byte c2, byte c22, byte c3) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(c2) + ", " + OracleLog.argument(c22) + ", " + OracleLog.argument(c3));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!(c2 == -32 && CharacterSet.checkA0toBF(c22) && CharacterSet.check80toBF(c3) || c2 >= -31 && c2 <= -17 && CharacterSet.check80toBF(c22) && CharacterSet.check80toBF(c3))) {
                char __result__ = '\ufffd';
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                char c4 = __result__;
                return c4;
            }
            char __result__ = (char)((c2 & 0xF) << 12 | (c22 & 0x3F) << 6 | c3 & 0x3F);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char c5 = __result__;
            return c5;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final char conv3ByteAL32UTF8toUTF16(byte c2, byte c22, byte c3) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(c2) + ", " + OracleLog.argument(c22) + ", " + OracleLog.argument(c3));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!(c2 == -32 && CharacterSet.checkA0toBF(c22) && CharacterSet.check80toBF(c3) || c2 >= -31 && c2 <= -20 && CharacterSet.check80toBF(c22) && CharacterSet.check80toBF(c3) || c2 == -19 && CharacterSet.check80to9F(c22) && CharacterSet.check80toBF(c3) || c2 >= -18 && c2 <= -17 && CharacterSet.check80toBF(c22) && CharacterSet.check80toBF(c3))) {
                char __result__ = '\ufffd';
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                char c4 = __result__;
                return c4;
            }
            char __result__ = (char)((c2 & 0xF) << 12 | (c22 & 0x3F) << 6 | c3 & 0x3F);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char c5 = __result__;
            return c5;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int conv4ByteAL32UTF8toUTF16(byte c2, byte c22, byte c3, byte c4, char[] chars, int cpos) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(c2) + ", " + OracleLog.argument(c22) + ", " + OracleLog.argument(c3) + ", " + OracleLog.argument(c4) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(cpos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean chars_count = false;
            if (!(c2 == -16 && CharacterSet.check90toBF(c22) && CharacterSet.check80toBF(c3) && CharacterSet.check80toBF(c4) || c2 >= -15 && c2 <= -13 && CharacterSet.check80toBF(c22) && CharacterSet.check80toBF(c3) && CharacterSet.check80toBF(c4) || c2 == -12 && CharacterSet.check80to8F(c22) && CharacterSet.check80toBF(c3) && CharacterSet.check80toBF(c4))) {
                chars[cpos] = 65533;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: 1");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = 1;
                return n2;
            }
            chars[cpos] = (char)((((c2 & 7) << 2 | c22 >>> 4 & 3) - 1 & 0xF) << 6 | (c22 & 0xF) << 2 | c3 >>> 4 & 3 | 0xD800);
            chars[cpos + 1] = (char)((c3 & 0xF) << 6 | c4 & 0x3F | 0xDC00);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Return: 2");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = 2;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void failUTFConversion() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.SEVERE, "         Throwing SQLException: 55");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 55);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encodedByteLength(String s2) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (s2 == null || s2.length() == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = 0;
                return n2;
            }
            int __result__ = this.convertWithReplacement(s2).length;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = __result__;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encodedByteLength(char[] carray) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(carray));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (carray == null || carray.length == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = 0;
                return n2;
            }
            int __result__ = this.convertWithReplacement(new String(carray)).length;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = __result__;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toCharWithReplacement(byte[] srcChar, int offset, char[] dstChar, int dstOffset, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(srcChar) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(dstChar));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnknown() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            Class.forName("oracle.i18n.text.converter.CharacterConverterSJIS");
            CharacterSetWithConverter.ccFactory = new CharacterConverterFactoryOGS();
        }
        catch (ClassNotFoundException e2) {
            // empty catch block
        }
        factory = new CharacterSetFactoryDefault();
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static abstract class CharacterConverterBehavior {
        public static final char[] NULL_CHARS = new char[1];
        public static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior("Report Error"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailConversion() throws SQLException {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSet.logger().log(Level.SEVERE, "         Throwing SQLException: 55");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 55);
                __ex__.fillInStackTrace();
                throw __ex__;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailConversion(char c2) throws SQLException {
                if (c2 == '\ufffd') {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSet.logger().log(Level.SEVERE, "         Throwing SQLException: 55");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 55);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior("Replacement"){

            @Override
            public void onFailConversion() throws SQLException {
            }

            @Override
            public void onFailConversion(char c2) throws SQLException {
            }
        };
        private final String m_name;

        public CharacterConverterBehavior(String name) {
            this.m_name = name;
        }

        public abstract void onFailConversion(char var1) throws SQLException;

        public abstract void onFailConversion() throws SQLException;
    }
}

