/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

public class CLOB
extends DatumWithConnection
implements OracleClob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess dbaccess;
    private int dbChunkSize;
    private short csform;
    boolean isFree;
    boolean fromObject;
    long cachedLengthOfClobInChars;
    char[] prefetchData;
    int prefetchDataSize;
    boolean activePrefetch;
    static final int KDLCTLSIZE = 16;
    static final int KDF_FLAG = 88;
    static final int KDLIDDAT = 8;
    transient CharacterSet dilCharacterSet;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected CLOB() {
        this.dbChunkSize = -1;
        this.isFree = false;
        this.fromObject = false;
        this.cachedLengthOfClobInChars = -1L;
        this.prefetchData = null;
        this.prefetchDataSize = 0;
        this.activePrefetch = false;
        this.dilCharacterSet = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB(oracle.jdbc.OracleConnection conn) throws SQLException {
        block12: {
            this(conn, null);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor, boolean fromObject) throws SQLException {
        this(conn, lob_descriptor);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob_descriptor) + ", " + OracleLog.argument(fromObject));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.fromObject = fromObject;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static final short getFormOfUseFromLocator(byte[] lob_descriptor) {
        int formOfUse = -1;
        if (lob_descriptor != null && lob_descriptor.length > 5) {
            formOfUse = (lob_descriptor[5] & 0x40) != 0 && (lob_descriptor[5] & 0xFFFFFF80) == 0 ? 2 : 1;
        }
        return (short)formOfUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(lob_descriptor);
        this.dbChunkSize = -1;
        this.isFree = false;
        this.fromObject = false;
        this.cachedLengthOfClobInChars = -1L;
        this.prefetchData = null;
        this.prefetchDataSize = 0;
        this.activePrefetch = false;
        this.dilCharacterSet = null;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob_descriptor));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (lob_descriptor != null) {
                this.csform = CLOB.getFormOfUseFromLocator(lob_descriptor);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "csform = " + this.csform);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB.assertNotNull(conn);
            this.setPhysicalConnectionOf(conn);
            this.dbaccess = ((OracleConnection)conn).createClobDBAccess();
            this.dbaccess.incrementTempLobReferenceCount(lob_descriptor);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor, short csform) throws SQLException {
        block21: {
            this(conn, lob_descriptor);
            long __ol_nanos__ = 0L;
            try {
                short tmp_csform;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob_descriptor) + ", " + OracleLog.argument(csform));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if ((tmp_csform = CLOB.getFormOfUseFromLocator(lob_descriptor)) != -1) {
                    if (csform != tmp_csform) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 184);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.csform = tmp_csform;
                    break block21;
                }
                this.csform = csform;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNCLOB() {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl2 = __result__ = this.csform == 2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        long l2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long ret = -1L;
            ret = this.activePrefetch && this.cachedLengthOfClobInChars != -1L ? this.cachedLengthOfClobInChars : (this.canReadBasicLobDataInLocator() ? (long)this.dilGetChars().length : this.getDBAccess().length(this));
            long __result__ = ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long pos, int length) throws SQLException {
        long __ol_nanos__;
        block44: {
            String string;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(length));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.isFree) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (length < 0 || pos < 1L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (!this.canReadBasicLobDataInLocator()) break block44;
                String __result__ = this.dilGetSubString(pos, length);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                string = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return string;
        }
        String ret = null;
        if (length == 0 || this.activePrefetch && (this.cachedLengthOfClobInChars == 0L || this.cachedLengthOfClobInChars > 0L && pos - 1L >= this.cachedLengthOfClobInChars)) {
            ret = new String();
        } else if (this.prefetchData != null && this.prefetchDataSize > 0 && this.cachedLengthOfClobInChars == (long)this.prefetchDataSize && pos + (long)length - 1L <= this.cachedLengthOfClobInChars) {
            ret = new String(this.prefetchData, (int)pos - 1, length);
        } else {
            char[] chars_read = this.getDBAccess().getCharBufferSync(length);
            int num_chars_rd = this.getChars(pos, length, chars_read);
            ret = num_chars_rd > 0 ? new String(chars_read, 0, num_chars_rd) : new String();
            this.getDBAccess().cacheBufferSync(chars_read);
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        String string = ret;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream() throws SQLException {
        long __ol_nanos__;
        block34: {
            Reader reader;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.isFree) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (!this.canReadBasicLobDataInLocator()) break block34;
                Reader __result__ = this.dilGetCharacterStream(1L);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                reader = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return reader;
        }
        Reader __result__ = this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        Reader reader = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream() throws SQLException {
        long __ol_nanos__;
        block34: {
            InputStream inputStream;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.isFree) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (!this.canReadBasicLobDataInLocator()) break block34;
                InputStream __result__ = this.dilGetAsciiStream(1L);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
        InputStream __result__ = this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        InputStream inputStream = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(String searchstr, long start) throws SQLException {
        long l2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(searchstr) + ", " + OracleLog.argument(start));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long __result__ = this.getDBAccess().position(this, searchstr, start);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        long l2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(searchstr) + ", " + OracleLog.argument(start));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long __result__ = this.getDBAccess().position(this, (CLOB)searchstr, start);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChars(long pos, int length, char[] buffer) throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(buffer));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int __result__ = this.getDBAccess().getChars(this, pos, length, buffer);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer getCharacterOutputStream() throws SQLException {
        Writer writer;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Writer __result__ = this.setCharacterStream(1L);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            writer = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getAsciiOutputStream() throws SQLException {
        OutputStream outputStream;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OutputStream __result__ = this.setAsciiStream(1L);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            outputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getLocator() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] __result__ = this.getBytes();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocator(byte[] locator) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.setBytes(locator);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putChars(long pos, char[] chars) throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(chars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int __result__ = this.getDBAccess().putChars(this, pos, chars, 0, chars != null ? chars.length : 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int putChars(long pos, char[] chars, int length) throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int __result__ = this.getDBAccess().putChars(this, pos, chars, 0, length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putChars(long pos, char[] chars, int offset, int length) throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int __result__ = this.getDBAccess().putChars(this, pos, chars, offset, length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putString(long pos, String str) throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int __result__ = this.setString(pos, str);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChunkSize() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.dbChunkSize <= 0) {
                this.dbChunkSize = this.getDBAccess().getChunkSize(this);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dbChunkSize);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.dbChunkSize;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferSize() throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int size = this.getChunkSize();
            int ret = 0;
            ret = size >= 32768 || size <= 0 ? 32768 : 32768 / size * size;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB empty_lob() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CLOB __result__ = CLOB.getEmptyCLOB();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB = __result__;
            return cLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB getEmptyCLOB() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte[] locator = new byte[86];
            locator[1] = 84;
            locator[5] = 24;
            CLOB clob = new CLOB();
            clob.setShareBytes(locator);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Return: " + clob);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB = clob;
            return cLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmptyLob() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = __result__ = (this.shareBytes()[5] & 0x10) != 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSecureFile() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            boolean ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl2 = ret = (this.shareBytes()[7] & 0xFFFFFF80) != 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getAsciiOutputStream(long pos) throws SQLException {
        OutputStream outputStream;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OutputStream __result__ = this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            outputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer getCharacterOutputStream(long pos) throws SQLException {
        Writer writer;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Writer __result__ = this.getDBAccess().newWriter(this, this.getBufferSize(), pos, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            writer = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(long pos) throws SQLException {
        long __ol_nanos__;
        block42: {
            InputStream inputStream;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.isFree) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (pos == 0L) {
                    if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                        pos = 1L;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (!this.canReadBasicLobDataInLocator()) break block42;
                InputStream __result__ = this.dilGetAsciiStream(pos);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                inputStream = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return inputStream;
        }
        InputStream __result__ = this.getDBAccess().newInputStream(this, this.getBufferSize(), pos);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        InputStream inputStream = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(long pos) throws SQLException {
        long __ol_nanos__;
        block42: {
            Reader reader;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.isFree) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (pos == 0L) {
                    if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                        pos = 1L;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (!this.canReadBasicLobDataInLocator()) break block42;
                Reader __result__ = this.dilGetCharacterStream(pos);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                reader = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return reader;
        }
        Reader __result__ = this.getDBAccess().newReader(this, this.getBufferSize(), pos);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        Reader reader = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trim(long newlen) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(newlen));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.truncate(newlen);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB createTemporary(Connection conn, boolean cache, int _duration) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(_duration));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CLOB __result__ = CLOB.createTemporary(conn, cache, _duration, (short)1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB = __result__;
            return cLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB createTemporary(Connection conn, boolean cache, int _duration, short form_of_use) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(_duration) + ", " + OracleLog.argument(form_of_use));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int duration = _duration;
            if (_duration == 1) {
                duration = 10;
            }
            if (_duration == 2) {
                duration = 12;
            }
            if (conn == null || duration != 10 && duration != 12) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, "         Throwing SQLException: 68'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or DURATION_CALL");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or DURATION_CALL");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OracleConnection physConn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
            CLOB result = CLOB.getDBAccess(physConn).createTemporaryClob(physConn, cache, duration, form_of_use);
            result.csform = CLOB.getFormOfUseFromLocator(result.shareBytes());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB = result;
            return cLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeTemporary(CLOB temp_lob) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(temp_lob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (temp_lob == null) {
                return;
            }
            temp_lob.freeTemporary();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTemporary(CLOB lob) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(lob));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (lob == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, "         Return: false");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean __result__ = lob.isTemporary();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeTemporary() throws SQLException {
        long __ol_nanos__;
        block21: {
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.isFree) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int refCnt = this.getDBAccess().decrementTempLobReferenceCount(this.shareBytes());
                if (refCnt != 0) break block21;
                this.getDBAccess().freeTemporary(this, this.fromObject);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTemporary() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean __result__ = this.getDBAccess().isTemporary(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    @Override
    public void open(LargeObjectAccessMode mode) throws SQLException {
        this.open(mode.getCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(int mode) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.getDBAccess().open(this, mode);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.getDBAccess().close(this);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean __result__ = this.getDBAccess().isOpen(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long pos, String str) throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (pos < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "'pos' should not be < 1");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int ret = 0;
            if (str != null && str.length() != 0) {
                ret = this.putChars(pos, str.toCharArray());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        int n2;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(str) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(len));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (pos < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "'pos' should not be < 1");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (offset < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "'offset' should not be < 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'offset' should not be < 0");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (offset + len > str.length()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + " 'offset + len' should not be exceed string length. ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'offset + len' should not be exceed string length. ");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int ret = 0;
            if (str != null && str.length() != 0) {
                ret = this.putChars(pos, str.toCharArray(), offset, len);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        OutputStream outputStream;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            OutputStream __result__ = this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, true);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            outputStream = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        Writer writer;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Writer __result__ = this.getDBAccess().newWriter(this, this.getBufferSize(), pos, true);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            writer = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long len) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(len));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (len < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + " 'len' should not be < 0");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'len' should not be < 0");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.getDBAccess().trim(this, len);
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toJdbc() throws SQLException {
        CLOB cLOB;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            cLOB = this;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConvertibleTo(Class jClass) {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            String class_name;
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(jClass));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl2 = __result__ = (class_name = jClass.getName()).compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader characterStreamValue() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Reader __result__ = this.getCharacterStream();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader = __result__;
            return reader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream asciiStreamValue() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            InputStream __result__ = this.getAsciiStream();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = __result__;
            return inputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream binaryStreamValue() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            InputStream __result__ = this.getAsciiStream();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = __result__;
            return inputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stringValue() throws SQLException {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Reader r2 = this.getCharacterStream();
            int size = this.getBufferSize();
            int length = 0;
            StringWriter w = new StringWriter(size);
            char[] buffer = new char[size];
            try {
                while ((length = r2.read(buffer)) != -1) {
                    w.write(buffer, 0, length);
                }
            }
            catch (IOException ex) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (IndexOutOfBoundsException x) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 151);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String __result__ = w.getBuffer().substring(0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object makeJdbcArray(int arraySize) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(arraySize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            CLOB[] __result__ = new CLOB[arraySize];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB[] cLOBArray = __result__;
            return cLOBArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClobDBAccess getDBAccess() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.dbaccess == null) {
                if (this.isEmptyLob()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 98);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 98);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.dbaccess = this.getInternalConnection().createClobDBAccess();
            }
            if (this.getPhysicalConnection().isClosed()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dbaccess);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ClobDBAccess clobDBAccess = this.dbaccess;
            return clobDBAccess;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClobDBAccess getDBAccess(Connection conn) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            ClobDBAccess __result__ = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().createClobDBAccess();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ClobDBAccess clobDBAccess = __result__;
            return clobDBAccess;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        Connection connection;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.isFree) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Connection __result__ = super.getJavaSqlConnection();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            connection = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setLength(long _cachedLengthOfClobInChars) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_cachedLengthOfClobInChars));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cachedLengthOfClobInChars = _cachedLengthOfClobInChars;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setChunkSize(int _dbChunkSize) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_dbChunkSize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.dbChunkSize = _dbChunkSize;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPrefetchedData(char[] _prefetchData) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_prefetchData));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (_prefetchData == null) {
                this.setPrefetchedData(null, 0);
            } else {
                this.setPrefetchedData(_prefetchData, _prefetchData.length);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPrefetchedData(char[] _prefetchData, int _size) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_prefetchData) + ", " + OracleLog.argument(_size));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.prefetchData = _prefetchData;
            this.prefetchDataSize = _size;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final char[] getPrefetchedData() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.prefetchData);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char[] cArray = this.prefetchData;
            return cArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getPrefetchedDataSize() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.prefetchDataSize);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.prefetchDataSize;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setActivePrefetch(boolean _activePrefetch) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_activePrefetch));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.activePrefetch && !_activePrefetch) {
                this.clearCachedData();
            }
            this.activePrefetch = _activePrefetch;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearCachedData() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cachedLengthOfClobInChars = -1L;
            this.prefetchData = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isActivePrefetch() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.activePrefetch);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.activePrefetch;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canReadBasicLobDataInLocator() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] loc;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((loc = this.shareBytes()) == null || loc.length < 102) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (!this.getPhysicalConnection().isDataInLocatorEnabled()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            int kol_field3 = loc[6] & 0xFF;
            int kol_field4 = loc[7] & 0xFF;
            boolean hasDILBit = (kol_field3 & 8) == 8;
            boolean hasLocalBit = (kol_field4 & 0xFFFFFF80) == -128;
            boolean hasKdfBit = false;
            if (hasDILBit && !hasLocalBit) {
                int kdf_field = loc[88] & 0xFF;
                hasKdfBit = (kdf_field & 8) == 8;
            }
            boolean hasDILData = hasDILBit && !hasLocalBit && hasKdfBit;
            boolean canUseDILData = false;
            if (hasDILData) {
                this.dilGetCharacterSet();
                boolean bl = canUseDILData = !this.dilCharacterSet.isUnknown();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + canUseDILData);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = canUseDILData;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int dilGetCharSetId() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte msb = this.shareBytes()[32];
            byte lsb = this.shareBytes()[33];
            int result = (msb & 0xFF) << 8 | lsb & 0xFF;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    boolean isMigratedAL16UTF16LE() {
        int kol_field4 = this.shareBytes()[7] & 0xFF;
        return (kol_field4 & 0x40) == 64;
    }

    boolean isVariableWidth() {
        int lvar;
        int kol_field3 = this.shareBytes()[6] & 0xFF;
        return (kol_field3 & (lvar = 128)) == lvar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dilGetCharacterSet() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.dilCharacterSet == null) {
                if (this.isMigratedAL16UTF16LE()) {
                    this.dilCharacterSet = CharacterSet.make(2002);
                } else if (this.isVariableWidth()) {
                    this.dilCharacterSet = CharacterSet.make(2000);
                } else {
                    int id = this.dilGetCharSetId();
                    this.dilCharacterSet = CharacterSet.make(id);
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int dilLength() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int __result__ = this.shareBytes().length - 86 - 16;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    char[] dilGetChars() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int dilByteLength = this.dilLength();
            byte[] dilBytes = new byte[dilByteLength];
            System.arraycopy(this.shareBytes(), 102, dilBytes, 0, dilByteLength);
            String dilString = this.dilCharacterSet.toStringWithReplacement(dilBytes, 0, dilByteLength);
            char[] dilChars = dilString.toCharArray();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dilChars);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            char[] cArray = dilChars;
            return cArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream dilGetAsciiStream(long pos) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            byte[] dilBytes;
            char[] dilChars;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (pos - 1L > (long)(dilChars = this.dilGetChars()).length) {
                byte[] dilBytes2 = new byte[]{};
                ByteArrayInputStream __result__ = new ByteArrayInputStream(dilBytes2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ByteArrayInputStream byteArrayInputStream = __result__;
                return byteArrayInputStream;
            }
            if (this.dilGetCharSetId() == 1) {
                dilBytes = new byte[dilChars.length];
                for (int i2 = 0; i2 < dilChars.length; ++i2) {
                    dilBytes[i2] = (byte)dilChars[i2];
                }
            } else {
                CharacterSet asciiCharSet = CharacterSet.make(1);
                dilBytes = asciiCharSet.convertWithReplacement(new String(dilChars));
            }
            ByteArrayInputStream __result__ = new ByteArrayInputStream(dilBytes);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ByteArrayInputStream byteArrayInputStream = __result__;
            return byteArrayInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reader dilGetCharacterStream(long pos) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            char[] dilChars;
            int lobLen;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (pos - 1L > (long)(lobLen = (dilChars = this.dilGetChars()).length)) {
                char[] dilNilChar = new char[]{};
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + new CharArrayReader(dilNilChar));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CharArrayReader charArrayReader = new CharArrayReader(dilNilChar);
                return charArrayReader;
            }
            CharArrayReader __result__ = new CharArrayReader(dilChars, (int)(pos - 1L), Integer.MAX_VALUE);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharArrayReader charArrayReader = __result__;
            return charArrayReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String dilGetSubString(long pos, int length) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            char[] dilChars;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((int)pos > (dilChars = this.dilGetChars()).length) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = "";
                return string;
            }
            int lengthAvailable = (int)Math.min((long)length, (long)dilChars.length - (pos - 1L));
            if (lengthAvailable == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = "";
                return string;
            }
            String __result__ = new String(dilChars, (int)(pos - 1L), lengthAvailable);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        long __ol_nanos__;
        block22: {
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (!this.isFree) break block22;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        if (this.isOpen()) {
            this.close();
        }
        if (this.isTemporary()) {
            this.freeTemporary();
        }
        this.isFree = true;
        this.dbaccess = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        long __ol_nanos__;
        block47: {
            Reader reader;
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(length));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (this.isFree) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (pos == 0L) {
                    if (!this.getPhysicalConnection().isLobStreamPosStandardCompliant()) {
                        pos = 1L;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (!this.canReadBasicLobDataInLocator()) break block47;
                Reader __result__ = this.dilGetCharacterStream(pos, length);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                reader = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return reader;
        }
        long lobLen = this.length();
        if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        Reader __result__ = this.getDBAccess().newReader(this, this.getChunkSize(), pos, length);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        Reader reader = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CLOB.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reader dilGetCharacterStream(long pos, long length) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pos));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (pos < 1L || length < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            char[] dilChars = this.dilGetChars();
            long lobLen = dilChars.length;
            if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CLOB.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            CharArrayReader __result__ = new CharArrayReader(dilChars, (int)(pos - 1L), (int)length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharArrayReader charArrayReader = __result__;
            return charArrayReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CLOB.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CLOB"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

