/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleRow;

public class OracleCachedRowSetWriter
implements RowSetWriter,
Serializable {
    static final long serialVersionUID = 8932894189919931169L;
    private StringBuffer updateClause;
    private StringBuffer deleteClause;
    private StringBuffer insertClause;
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection connection;
    private int columnCount;
    static final int ASCII_STREAM = 1;
    static final int BINARY_STREAM = 2;
    static final int CHARACTER_STREAM = 3;
    static final int NCHARACTER_STREAM = 4;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleCachedRowSetWriter() {
        long __ol_nanos__;
        block13: {
            this.updateClause = new StringBuffer("");
            this.deleteClause = new StringBuffer("");
            this.insertClause = new StringBuffer("");
            __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSchemaName(RowSet rowset) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String __result__ = rowset.getUsername();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTableName(RowSet rowset) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            StringTokenizer st;
            String tableName;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((tableName = ((OracleCachedRowSet)rowset).getTableName()) != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tableName);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = tableName;
                return string;
            }
            String cmd = rowset.getCommand().toUpperCase();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.getTableName(RowSet)," + "cmd=" + cmd);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int index = cmd.indexOf(" FROM ");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.getTableName(RowSet)," + "index=" + index);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (index == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 343 + (cmd.length() != 0 ? cmd : "Please use RowSet.setCommand (String) to set the SQL query string."));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 343, cmd.length() != 0 ? cmd : "Please use RowSet.setCommand (String) to set the SQL query string.");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String tab = cmd.substring(index + 6).trim();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.getTableName(), tab=" + tab);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((st = new StringTokenizer(tab)).hasMoreTokens()) {
                tab = st.nextToken();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tab);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = tab;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSQLStatement(RowSet rowset) throws SQLException {
        block29: {
            long __ol_nanos__ = 0L;
            try {
                int i2;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowset) + "(");
                this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowset) + " SET ");
                this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowset) + " WHERE ");
                this.rsmd = rowset.getMetaData();
                this.columnCount = this.rsmd.getColumnCount();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.initSQLStatement(RowSet)" + ", insertClause=" + this.insertClause + ", updateClause=" + this.updateClause + ", deleteClause=" + this.deleteClause + ", rsmd=" + this.rsmd + ", columnCount=" + this.columnCount);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                for (i2 = 0; i2 < this.columnCount; ++i2) {
                    if (i2 != 0) {
                        this.insertClause.append(", ");
                    }
                    this.insertClause.append(this.rsmd.getColumnName(i2 + 1));
                    if (i2 != 0) {
                        this.updateClause.append(", ");
                    }
                    this.updateClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
                    if (i2 != 0) {
                        this.deleteClause.append(" AND ");
                    }
                    this.deleteClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
                }
                this.insertClause.append(") VALUES (");
                this.updateClause.append(" WHERE ");
                for (i2 = 0; i2 < this.columnCount; ++i2) {
                    if (i2 != 0) {
                        this.insertClause.append(", ");
                    }
                    this.insertClause.append(":" + i2);
                    if (i2 != 0) {
                        this.updateClause.append(" AND ");
                    }
                    this.updateClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
                }
                this.insertClause.append(")");
                this.insertStmt = this.connection.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
                this.updateStmt = this.connection.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
                this.deleteStmt = this.connection.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
                if (!TRACE || !OracleLog.recursiveEnter()) break block29;
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.initSQLStatement(RowSet)" + ", insertStmt=" + this.insertStmt + ", updateStmt=" + this.updateStmt + ", deleteStmt=" + this.deleteStmt);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertRow(OracleRow row) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(row));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.insertStmt.clearParameters();
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                Object o2 = null;
                Object object = o2 = row.isColumnChanged(i2) ? row.getModifiedColumn(i2) : row.getColumn(i2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.insertRow(OracleRow), o=" + o2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (o2 == null) {
                    this.insertStmt.setNull(i2, this.rsmd.getColumnType(i2));
                    row.markOriginalNull(i2, true);
                    continue;
                }
                this.insertStmt.setObject(i2, o2);
            }
            boolean bl = __result__ = this.insertStmt.executeUpdate() == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRow(RowSet rowset, OracleRow row) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.updateStmt.clearParameters();
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                Object o2 = null;
                Object object = o2 = row.isColumnChanged(i2) ? row.getModifiedColumn(i2) : row.getColumn(i2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.updateRow(OracleRow), o=" + o2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (o2 == null) {
                    this.updateStmt.setNull(i2, this.rsmd.getColumnType(i2));
                    continue;
                }
                if (o2 instanceof Reader) {
                    OraclePreparedStatement pstmt = (OraclePreparedStatement)this.updateStmt;
                    if (row.columnTypeInfo[i2 - 1][1] == 4) {
                        pstmt.setFormOfUse(i2, (short)2);
                    } else if (row.columnTypeInfo[i2 - 1][1] == 3) {
                        pstmt.setFormOfUse(i2, (short)1);
                    }
                    this.updateStmt.setCharacterStream(i2, (Reader)o2, row.columnTypeInfo[i2 - 1][0]);
                    continue;
                }
                if (o2 instanceof InputStream) {
                    if (row.columnTypeInfo[i2 - 1][1] == 2) {
                        this.updateStmt.setBinaryStream(i2, (InputStream)o2, row.columnTypeInfo[i2 - 1][0]);
                        continue;
                    }
                    if (row.columnTypeInfo[i2 - 1][1] != 1) continue;
                    this.updateStmt.setAsciiStream(i2, (InputStream)o2, row.columnTypeInfo[i2 - 1][0]);
                    continue;
                }
                this.updateStmt.setObject(i2, o2);
            }
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                if (row.isOriginalNull(i2)) {
                    boolean __result__2 = this.updateRowWithNull(rowset, row);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = __result__2;
                    return bl;
                }
                this.updateStmt.setObject(i2 + this.columnCount, row.getColumn(i2));
            }
            boolean bl = __result__ = this.updateStmt.executeUpdate() == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRowWithNull(RowSet rowset, OracleRow row) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean returnValue = false;
            StringBuffer updateClauseWithNull = new StringBuffer("UPDATE " + this.getTableName(rowset) + " SET ");
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                if (i2 != 1) {
                    updateClauseWithNull.append(", ");
                }
                updateClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
            }
            updateClauseWithNull.append(" WHERE ");
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                if (i2 != 1) {
                    updateClauseWithNull.append(" AND ");
                }
                if (row.isOriginalNull(i2)) {
                    updateClauseWithNull.append(this.rsmd.getColumnName(i2) + " IS NULL ");
                    continue;
                }
                updateClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
            }
            Statement stmt = null;
            try {
                int i3;
                stmt = this.connection.prepareStatement(updateClauseWithNull.substring(0, updateClauseWithNull.length()));
                for (i3 = 1; i3 <= this.columnCount; ++i3) {
                    Object o2 = null;
                    Object object = o2 = row.isColumnChanged(i3) ? row.getModifiedColumn(i3) : row.getColumn(i3);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.updateRowWithNull(OracleRow), o=" + o2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (o2 == null) {
                        stmt.setNull(i3, this.rsmd.getColumnType(i3));
                        continue;
                    }
                    if (o2 instanceof Reader) {
                        OraclePreparedStatement pstmt = (OraclePreparedStatement)stmt;
                        if (row.columnTypeInfo[i3 - 1][1] == 4) {
                            pstmt.setFormOfUse(i3, (short)2);
                        } else if (row.columnTypeInfo[i3 - 1][1] == 3) {
                            pstmt.setFormOfUse(i3, (short)1);
                        }
                        stmt.setCharacterStream(i3, (Reader)o2, row.columnTypeInfo[i3 - 1][0]);
                        continue;
                    }
                    if (o2 instanceof InputStream) {
                        if (row.columnTypeInfo[i3 - 1][1] == 2) {
                            stmt.setBinaryStream(i3, (InputStream)o2, row.columnTypeInfo[i3 - 1][0]);
                            continue;
                        }
                        if (row.columnTypeInfo[i3 - 1][1] != 1) continue;
                        stmt.setAsciiStream(i3, (InputStream)o2, row.columnTypeInfo[i3 - 1][0]);
                        continue;
                    }
                    stmt.setObject(i3, o2);
                }
                int columnIndex = 1;
                for (i3 = 1; i3 <= this.columnCount; ++i3) {
                    if (row.isOriginalNull(i3)) continue;
                    stmt.setObject(columnIndex + this.columnCount, row.getColumn(i3));
                    ++columnIndex;
                }
                returnValue = stmt.executeUpdate() == 1;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnValue);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = returnValue;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRow(RowSet rowset, OracleRow row) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.deleteStmt.clearParameters();
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                if (row.isOriginalNull(i2)) {
                    boolean __result__2 = this.deleteRowWithNull(rowset, row);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = __result__2;
                    return bl;
                }
                Object o2 = row.getColumn(i2);
                if (o2 == null) {
                    this.deleteStmt.setNull(i2, this.rsmd.getColumnType(i2));
                    continue;
                }
                this.deleteStmt.setObject(i2, o2);
            }
            boolean bl = __result__ = this.deleteStmt.executeUpdate() == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRowWithNull(RowSet rowset, OracleRow row) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean returnValue = false;
            StringBuffer deleteClauseWithNull = new StringBuffer("DELETE FROM " + this.getTableName(rowset) + " WHERE ");
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                if (i2 != 1) {
                    deleteClauseWithNull.append(" AND ");
                }
                if (row.isOriginalNull(i2)) {
                    deleteClauseWithNull.append(this.rsmd.getColumnName(i2) + " IS NULL ");
                    continue;
                }
                deleteClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
            }
            Statement stmt = null;
            try {
                stmt = this.connection.prepareStatement(deleteClauseWithNull.substring(0, deleteClauseWithNull.length()));
                int columnIndex = 1;
                for (int i3 = 1; i3 <= this.columnCount; ++i3) {
                    if (row.isOriginalNull(i3)) continue;
                    stmt.setObject(columnIndex++, row.getColumn(i3));
                }
                returnValue = stmt.executeUpdate() == 1;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnValue);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = returnValue;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean writeData(RowSetInternal rowsetInternal) throws SQLException {
        boolean bl;
        OracleCachedRowSet rowset;
        long __ol_nanos__;
        block56: {
            block55: {
                __ol_nanos__ = 0L;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowsetInternal));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                rowset = (OracleCachedRowSet)rowsetInternal;
                this.connection = ((OracleCachedRowSetReader)rowset.getReader()).getConnection(rowsetInternal);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.writeData(RowSetInternal)," + "connection=" + this.connection + ",columnCount=" + this.columnCount);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.connection == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 342);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 342);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
                try {
                    this.connection.setTransactionIsolation(rowset.getTransactionIsolation());
                }
                catch (Exception exc) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block55;
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.writeData(), setTransactionIsolation() throws exception: " + exc);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            this.initSQLStatement(rowset);
            if (this.columnCount >= 1) break block56;
            this.connection.close();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean exc = true;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return exc;
        }
        try {
            boolean oldFlag = rowset.getShowDeleted();
            rowset.setShowDeleted(true);
            rowset.beforeFirst();
            boolean updateFlag = true;
            boolean insertFlag = true;
            boolean deleteFlag = true;
            OracleRow row = null;
            while (rowset.next()) {
                if (rowset.rowInserted()) {
                    if (rowset.rowDeleted()) continue;
                    row = rowset.getCurrentRow();
                    insertFlag = this.insertRow(row) || insertFlag;
                    continue;
                }
                if (rowset.rowUpdated()) {
                    row = rowset.getCurrentRow();
                    updateFlag = this.updateRow(rowset, row) || updateFlag;
                    continue;
                }
                if (!rowset.rowDeleted()) continue;
                row = rowset.getCurrentRow();
                deleteFlag = this.deleteRow(rowset, row) || deleteFlag;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.writeData(RowSetInternal)," + "oldFlag=" + oldFlag + ", updateFlag=" + updateFlag + ", insertFlag=" + insertFlag + ", deleteFlag" + deleteFlag + ", row=" + row);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (updateFlag && insertFlag && deleteFlag) {
                this.connection.commit();
                rowset.setOriginal();
            } else {
                this.connection.rollback();
            }
            this.insertStmt.close();
            this.updateStmt.close();
            this.deleteStmt.close();
            if (!rowset.isConnectionStayingOpen()) {
                this.connection.close();
            }
            rowset.setShowDeleted(oldFlag);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = true;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSetWriter"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

