/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;

public class OracleCachedRowSetReader
implements RowSetReader,
Serializable {
    static final long serialVersionUID = -3565405169674271176L;
    static final transient int SETUNICODESTREAM_INTLENGTH = 1;
    static final transient int SETBINARYSTREAM_INTLENGTH = 2;
    static final transient int SETASCIISTREAM_INTLENGTH = 3;
    static final transient int SETCHARACTERSTREAM_INTLENGTH = 4;
    static final transient int SETBINARYSTREAM = 5;
    static final transient int SETBINARYSTREAM_LONGLENGTH = 6;
    static final transient int SETASCIISTREAM = 7;
    static final transient int SETASCIISTREAM_LONGLENGTH = 8;
    static final transient int SETCHARACTERSTREAM = 9;
    static final transient int SETCHARACTERSTREAM_LONGLENGTH = 10;
    static final transient int SETNCHARACTERSTREAM = 11;
    static final transient int SETNCHARACTERSTREAM_LONGLENGTH = 12;
    static final transient int SETBLOB_STREAM = 13;
    static final transient int SETBLOB_STREAM_LONG = 14;
    static final transient int SETCLOB_READER = 15;
    static final transient int SETCLOB_READER_LONG = 16;
    static final transient int SETNCLOB_READER = 17;
    static final transient int SETNCLOB_READER_LONG = 18;
    static final transient int TWO_PARAMETERS = 2;
    static final transient int THREE_PARAMETERS = 3;
    private static transient boolean driverManagerInitialized = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleCachedRowSetReader() {
        long __ol_nanos__;
        block13: {
            __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    OracleCachedRowSetReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(RowSetInternal rowsetInternal) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            Connection rowsetConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowsetInternal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Connection con = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.getConnection(RowSetInternal)," + "con=" + con);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((rowsetConnection = rowsetInternal.getConnection()) != null && !rowsetConnection.isClosed()) {
                con = rowsetConnection;
            } else if (((RowSet)((Object)rowsetInternal)).getDataSourceName() != null) {
                try {
                    InitialContext initialcontext = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.getConnection(), initialcontext=" + initialcontext);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    try {
                        Properties props = System.getProperties();
                        initialcontext = new InitialContext(props);
                    }
                    catch (SecurityException ea) {
                        // empty catch block
                    }
                    if (initialcontext == null) {
                        initialcontext = new InitialContext();
                    }
                    DataSource datasource = (DataSource)initialcontext.lookup(((RowSet)((Object)rowsetInternal)).getDataSourceName());
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.getConnection(),datasource=" + datasource);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String userName = ((RowSet)((Object)rowsetInternal)).getUsername();
                    String password = ((RowSet)((Object)rowsetInternal)).getPassword();
                    if (userName == null && password == null) {
                        con = datasource.getConnection();
                    }
                    con = datasource.getConnection(userName, password);
                }
                catch (NamingException ea) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 300 + ea.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 300, ea.getMessage());
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            } else if (((RowSet)((Object)rowsetInternal)).getUrl() != null) {
                if (!driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    driverManagerInitialized = true;
                }
                String url = ((RowSet)((Object)rowsetInternal)).getUrl();
                String userName = ((RowSet)((Object)rowsetInternal)).getUsername();
                String password = ((RowSet)((Object)rowsetInternal)).getPassword();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.getConnection(): url = " + url + ", userName = " + userName + ", password = " + password);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (url.equals("") || userName.equals("") || password.equals("")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 301);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                con = DriverManager.getConnection(url, userName, password);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + con);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = con;
            return connection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParams(Object[] paramObject, PreparedStatement preparedStatement) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(paramObject) + ", " + OracleLog.argument(preparedStatement));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            block69: for (int j2 = 0; j2 < paramObject.length; ++j2) {
                Object[] tmpParmObj;
                block105: {
                    block104: {
                        int i2;
                        block101: {
                            block103: {
                                block102: {
                                    i2 = 0;
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.setParams(Object[], PreparedStatement)" + ", inside for-loop, i=" + i2);
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                    }
                                    if (paramObject[j2] instanceof byte[]) {
                                        preparedStatement.setObject(j2 + 1, paramObject[j2]);
                                        continue;
                                    }
                                    try {
                                        i2 = Array.getLength(paramObject[j2]);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        preparedStatement.setObject(j2 + 1, paramObject[j2]);
                                        continue;
                                    }
                                    tmpParmObj = (Object[])paramObject[j2];
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.setParams(Object[], PreparedStatement)" + ", inside for-loop, Object tmpParmObj=" + tmpParmObj);
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                    }
                                    if (i2 != 2) break block101;
                                    if (tmpParmObj[0] == null) {
                                        preparedStatement.setNull(j2 + 1, (Integer)tmpParmObj[1]);
                                        continue;
                                    }
                                    if (tmpParmObj[0] instanceof Date) {
                                        if (tmpParmObj[1] instanceof Calendar) {
                                            preparedStatement.setDate(j2 + 1, (Date)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                                            continue;
                                        }
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                            }
                                            finally {
                                                OracleLog.recursiveExit();
                                            }
                                        }
                                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                                        __ex__.fillInStackTrace();
                                        throw __ex__;
                                    }
                                    if (tmpParmObj[0] instanceof Time) {
                                        if (tmpParmObj[1] instanceof Calendar) {
                                            preparedStatement.setTime(j2 + 1, (Time)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                                            continue;
                                        }
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                            }
                                            finally {
                                                OracleLog.recursiveExit();
                                            }
                                        }
                                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                                        __ex__.fillInStackTrace();
                                        throw __ex__;
                                    }
                                    if (tmpParmObj[0] instanceof Timestamp) {
                                        if (tmpParmObj[1] instanceof Calendar) {
                                            preparedStatement.setTimestamp(j2 + 1, (Timestamp)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                                            continue;
                                        }
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                            }
                                            finally {
                                                OracleLog.recursiveExit();
                                            }
                                        }
                                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                                        __ex__.fillInStackTrace();
                                        throw __ex__;
                                    }
                                    if (!(tmpParmObj[0] instanceof Reader)) break block102;
                                    switch ((Integer)tmpParmObj[1]) {
                                        case 9: {
                                            preparedStatement.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0]);
                                            continue block69;
                                        }
                                        case 11: {
                                            preparedStatement.setNCharacterStream(j2 + 1, (Reader)tmpParmObj[0]);
                                            continue block69;
                                        }
                                        case 15: {
                                            preparedStatement.setClob(j2 + 1, (Reader)tmpParmObj[0]);
                                            continue block69;
                                        }
                                        case 17: {
                                            preparedStatement.setNClob(j2 + 1, (Reader)tmpParmObj[0]);
                                            continue block69;
                                        }
                                        default: {
                                            if (TRACE && OracleLog.recursiveEnter()) {
                                                try {
                                                    OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                                }
                                                finally {
                                                    OracleLog.recursiveExit();
                                                }
                                            }
                                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                                            __ex__.fillInStackTrace();
                                            throw __ex__;
                                        }
                                    }
                                }
                                if (!(tmpParmObj[0] instanceof InputStream)) break block103;
                                switch ((Integer)tmpParmObj[1]) {
                                    case 7: {
                                        preparedStatement.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0]);
                                        continue block69;
                                    }
                                    case 5: {
                                        preparedStatement.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0]);
                                        continue block69;
                                    }
                                    case 13: {
                                        preparedStatement.setBlob(j2 + 1, (InputStream)tmpParmObj[0]);
                                        continue block69;
                                    }
                                    default: {
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                            }
                                            finally {
                                                OracleLog.recursiveExit();
                                            }
                                        }
                                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                                        __ex__.fillInStackTrace();
                                        throw __ex__;
                                    }
                                }
                            }
                            if (!(tmpParmObj[1] instanceof Integer)) continue;
                            preparedStatement.setObject(j2 + 1, tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue;
                        }
                        if (i2 != 3) continue;
                        if (tmpParmObj[0] == null) {
                            preparedStatement.setNull(j2 + 1, (Integer)tmpParmObj[1], (String)tmpParmObj[2]);
                            continue;
                        }
                        if (!(tmpParmObj[0] instanceof Reader)) break block104;
                        switch ((Integer)tmpParmObj[2]) {
                            case 4: {
                                preparedStatement.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Integer)tmpParmObj[1]);
                                continue block69;
                            }
                            case 10: {
                                preparedStatement.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                                continue block69;
                            }
                            case 12: {
                                preparedStatement.setNCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                                continue block69;
                            }
                            case 16: {
                                preparedStatement.setClob(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                                continue block69;
                            }
                            case 18: {
                                preparedStatement.setNClob(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                                continue block69;
                            }
                            default: {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                                __ex__.fillInStackTrace();
                                throw __ex__;
                            }
                        }
                    }
                    if (!(tmpParmObj[0] instanceof InputStream)) break block105;
                    switch ((Integer)tmpParmObj[2]) {
                        case 1: {
                            preparedStatement.setUnicodeStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block69;
                        }
                        case 2: {
                            preparedStatement.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block69;
                        }
                        case 3: {
                            preparedStatement.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block69;
                        }
                        case 6: {
                            preparedStatement.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block69;
                        }
                        case 8: {
                            preparedStatement.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block69;
                        }
                        case 14: {
                            preparedStatement.setBlob(j2 + 1, (InputStream)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block69;
                        }
                        default: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                }
                if (tmpParmObj[1] instanceof Integer && tmpParmObj[2] instanceof Integer) {
                    preparedStatement.setObject(j2 + 1, tmpParmObj[0], (Integer)tmpParmObj[1], (int)((Integer)tmpParmObj[2]));
                    continue;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void readData(RowSetInternal rowsetInternal) throws SQLException {
        long __ol_nanos__;
        block41: {
            __ol_nanos__ = 0L;
            try {
                Connection connection;
                OracleCachedRowSet rowset;
                block39: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowsetInternal));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    rowset = (OracleCachedRowSet)rowsetInternal;
                    connection = this.getConnection(rowsetInternal);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.readData(), connection=" + connection);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (connection == null || rowset.getCommand() == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 342);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 342);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    try {
                        connection.setTransactionIsolation(rowset.getTransactionIsolation());
                    }
                    catch (Exception ex) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block39;
                        try {
                            OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.readData(), setTransactionIsolation() throws exception: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                PreparedStatement preparedStatement = connection.prepareStatement(rowset.getCommand(), rowset.getType(), rowset.getConcurrency());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetReader.readData(), preparedStatement=" + preparedStatement);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.setParams(rowsetInternal.getParams(), preparedStatement);
                try {
                    preparedStatement.setMaxRows(rowset.getMaxRows());
                    preparedStatement.setMaxFieldSize(rowset.getMaxFieldSize());
                    preparedStatement.setEscapeProcessing(rowset.getEscapeProcessing());
                    preparedStatement.setQueryTimeout(rowset.getQueryTimeout());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ResultSet resultset = preparedStatement.executeQuery();
                rowset.populate(resultset, rowset.getCurrentPage() * rowset.getPageSize());
                resultset.close();
                preparedStatement.close();
                try {
                    connection.commit();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                if (rowset.isConnectionStayingOpen()) break block41;
                connection.close();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSetReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

