/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplayLoggerFactory {
    private static final Logger logger = Logger.getLogger(ReplayLoggerFactory.class.getCanonicalName());

    public static Logger getLogger(String name) {
        return Logger.getLogger(name);
    }

    public static synchronized void setLogLevel(Level newLogLevel) {
        try {
            Logger.getLogger("oracle.jdbc.internal.replay").setLevel(newLogLevel);
            if (newLogLevel != null) {
                Handler[] logHandler = Logger.getLogger("").getHandlers();
                for (int i2 = 0; i2 < logHandler.length; ++i2) {
                    logHandler[i2].setLevel(newLogLevel);
                }
            }
        }
        catch (Exception e2) {
            logger.log(Level.FINEST, "setLogLevel", e2);
        }
    }

    public static Level getLogLevel() {
        return Logger.getLogger("oracle.jdbc.internal.replay").getLevel();
    }
}

