/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={CallableStatement.class, PreparedStatement.class, Statement.class, OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class, oracle.jdbc.internal.OracleCallableStatement.class, oracle.jdbc.internal.OraclePreparedStatement.class, oracle.jdbc.internal.OracleStatement.class})
public abstract class NonTxnReplayableStatement
extends NonTxnReplayableBase
implements Replayable {
    private static final String STMT_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableStatement";
    private static Logger STMT_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method m2, Object receiver, Object ... args) {
        super.preForAll(m2, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected void preForExecute(Method m2, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        try {
            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
            STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, original SqlKind: {1}", new Object[]{this, sqlKind});
            if (sqlKind.isSELECT() || sqlKind.isPlsqlOrCall() || sqlKind == OracleStatement.SqlKind.ALTER_SESSION || sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.preForAll(m2, receiver, args);
            } else if (sqlKind.isDML()) {
                if (this.failoverMngr != null) {
                    this.failoverMngr.disableReplayInternal(m2, 371, "Replay disabled because of active transaction", null);
                } else {
                    STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
                }
            } else if (sqlKind.isOTHER()) {
                if (this.failoverMngr != null) {
                    this.failoverMngr.disableReplayInternal(m2, 372, "Replay disabled because of nonreplayable call", null);
                } else {
                    STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
                }
            }
        }
        catch (SQLException sqlexc) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sqlexc});
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preForExecuteUpdate(Method m2, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, preForExecuteUpdate", this);
        try {
            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
            STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, original SqlKind: {1}", new Object[]{this, sqlKind});
            if (sqlKind.isPlsqlOrCall()) {
                this.preForAll(m2, receiver, args);
            } else if (this.failoverMngr != null) {
                this.failoverMngr.disableReplayInternal(m2, 371, "Replay disabled because of active transaction", null);
            } else {
                STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
            }
        }
        catch (SQLException sqlexc) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sqlexc});
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeBatch", args={})})
    protected void preForExecuteBatch(Method m2, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, preForExecuteBatch", this);
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m2, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setAsciiStream", args={String.class, InputStream.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class, long.class})})
    protected void preForSetStreams(Method m2, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, preForSetStreams", this);
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m2, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
        }
    }

    @Override
    @Post
    protected Object postForAll(Method m2, Object result) {
        return super.postForAll(m2, result);
    }

    @Post
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected boolean postForExecute(Method m2, boolean result) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingExecutes(m2, result, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplayingExecutes(m2, result, null);
            }
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected int postForExecuteUpdate(Method m2, int result) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingExecutes(m2, result, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplayingExecutes(m2, result, null);
            }
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected ResultSet postForExecuteQuery(Method m2, ResultSet result) {
        if (result instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)((Object)result);
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingExecutes(m2, result, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplayingExecutes(m2, result, null);
            }
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method m2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.doPostWhenRecordingClose(m2, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
        }
        this.isClosedAndNoReplay = true;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m2, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m2, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m2, SQLException error) throws SQLException {
        return super.onErrorForAll(m2, error);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="close", args={})})
    protected void onErrorVoidForClose(Method m2, SQLException error) throws SQLException {
        if (error instanceof SQLRecoverableException) {
            return;
        }
        super.onErrorVoidForAll(m2, error);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected boolean onErrorForExecute(Method m2, SQLException error) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw error;
        }
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (error instanceof SQLRecoverableException && lifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            try {
                oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, original SqlKind: {1}", new Object[]{this, sqlKind});
                if (sqlKind.isPlsqlOrCall()) {
                    STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, last call is PL/SQL", this);
                    this.failoverMngr.disableReplayInternal(m2, 373, "Replay disabled because outage occurred during PL/SQL execution", null);
                } else if (sqlKind.isDML()) {
                    if (this.failoverMngr != null) {
                        this.failoverMngr.disableReplayInternal(m2, 371, "Replay disabled because of active transaction", null);
                    } else {
                        STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
                    }
                } else if (sqlKind.isOTHER() && sqlKind != OracleStatement.SqlKind.ALTER_SESSION) {
                    if (this.failoverMngr != null) {
                        this.failoverMngr.disableReplayInternal(m2, 372, "Replay disabled because of nonreplayable call", null);
                    } else {
                        STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
                    }
                }
            }
            catch (SQLException sqlexc) {
                STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sqlexc});
            }
        }
        return (Boolean)super.onErrorForAll(m2, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry entry) throws SQLException {
        oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
        long checksum = ostmt.getChecksum();
        String methodName = entry == null || entry.method == null ? "NULL METHOD" : entry.method.getName();
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On proxy {0}, method {1}, filling in checksum: {2}", new Object[]{entry.jdbcProxy, methodName, checksum});
        this.failoverMngr.update(this, entry, entry.result, entry.callStatus, checksum, entry.scn, entry.callException);
    }

    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry entry, SQLRecoverableException origError) throws SQLException {
        if (entry.scn != -1L) {
            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            ostmt.setSnapshotSCN(entry.scn);
            String methodName = entry == null || entry.method == null ? "NULL METHOD" : entry.method.getName();
            STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, replaying method {1}, set original SCN: {2}", new Object[]{entry.jdbcProxy, methodName, entry.scn});
        }
        return super.replayOneCall(entry, origError);
    }

    @Override
    protected void doPostWhenReplaying(Method m2, Object result, SQLException sqlexc) {
        try {
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case REPLAYING: {
                    if (this.replayingCallEntry.checksum == 0L) break;
                    oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    long newChecksum = ostmt.getChecksum();
                    String methodName = this.replayingCallEntry == null || this.replayingCallEntry.method == null ? "NULL METHOD" : this.replayingCallEntry.method.getName();
                    STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, replaying method {1}, new checksum: {2}, original checksum: {3}", new Object[]{this.replayingCallEntry.jdbcProxy, methodName, newChecksum, this.replayingCallEntry.checksum});
                    if (this.replayingCallEntry.checksum != newChecksum) {
                        this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 386, "Replay failed because of checksum mismatch", this.originalError);
                    }
                    break;
                }
            }
        }
        catch (SQLException exc) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, doPostWhenReplaying exception: {1}", new Object[]{this, exc});
        }
    }

    protected void doPostWhenReplayingExecutes(Method m2, Object result, SQLException sqlexc) {
        try {
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case REPLAYING: {
                    this.doPostWhenReplaying(m2, result, sqlexc);
                    break;
                }
                case REPLAYING_LASTCALL: {
                    oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                    if (!sqlKind.isPlsqlOrCall()) break;
                    STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, last call is PL/SQL", this.replayingCallEntry.jdbcProxy);
                    this.failoverMngr.disableReplayInternal(this.replayingCallEntry.method, 373, "Replay disabled because outage occurred during PL/SQL execution", this.originalError);
                }
            }
        }
        catch (SQLException exc) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, doPostWhenReplayingExecutes exception: {1}", new Object[]{this, exc});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean okToPurgeSameProxyList() {
        boolean result;
        block7: {
            result = false;
            try {
                oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                if (sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                    result = true;
                    break block7;
                }
                if (!sqlKind.isSELECT() || sqlKind == OracleStatement.SqlKind.SELECT_FOR_UPDATE) break block7;
                FailoverManagerImpl.CallHistoryEntry entry = this.headSameProxy;
                while (entry != null) {
                    String methodName;
                    String string = methodName = entry.method == null ? "NULL METHOD" : entry.method.getName();
                    if (("execute".equals(methodName) || "executeQuery".equals(methodName)) && entry.scn > 0L) {
                        result = true;
                        break;
                    }
                    entry = entry.nextEntrySameProxy;
                }
            }
            catch (SQLException sqlexc) {
                try {
                    STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sqlexc});
                    result = false;
                }
                catch (Throwable throwable) {
                    STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, ok for implicit purge: {1}", new Object[]{this, result});
                    return result;
                }
                STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, ok for implicit purge: {1}", new Object[]{this, result});
                return result;
            }
        }
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, ok for implicit purge: {1}", new Object[]{this, result});
        return result;
    }

    protected void doPostWhenRecordingClose(Method m2, SQLException sqlexc) {
        if (this.okToPurgeSameProxyList()) {
            this.purgeSameProxyList();
        }
    }

    protected void doPostWhenRecordingExecutes(Method m2, Object result, SQLException sqlexc) {
        try {
            String methodName;
            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            OracleConnection oconn = (OracleConnection)ostmt.getConnection();
            OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
            long checksum = 0L;
            long SCN = -1L;
            String string = methodName = m2 == null ? "NULL METHOD" : m2.getName();
            if (sqlKind.isSELECT() || sqlKind.isPlsqlOrCall() || sqlKind == OracleStatement.SqlKind.ALTER_SESSION) {
                EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
                STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, method {1}, transaction state: {2}", new Object[]{this, methodName, eocs});
                if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_INTENTION) || eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                    this.failoverMngr.disableReplayInternal(m2, 371, "Replay disabled because of transaction", null);
                } else {
                    checksum = 0L;
                    if (!this.failoverMngr.isReplayInCurrentMode() && sqlKind.isPlsqlOrCall()) {
                        this.failoverMngr.setReplayInCurrentMode();
                    }
                    SCN = this.failoverMngr.isReplayInCurrentMode() ? -1L : oconn.getCurrentSCN();
                    STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, method {1}, SCN to record: {2}", new Object[]{this, methodName, SCN});
                }
                if (this.failoverMngr.getReplayLifecycle() == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    this.failoverMngr.update(this, null, result, "completed", checksum, SCN, sqlexc);
                }
            } else {
                this.failoverMngr.update(this, null, result, "completed", checksum, SCN, sqlexc);
                this.failoverMngr.disableReplayInternal(m2, 372, "Replay disabled because of nonreplayable call", null);
            }
        }
        catch (SQLException exc) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, exc});
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() {
        return (Connection)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.getDelegate();
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract ResultSet executeQuery(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract ResultSet executeQuery() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Array getArray(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Array getArray(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Blob getBlob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Blob getBlob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Clob getClob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Clob getClob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract NClob getNClob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract NClob getNClob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Ref getRef(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Ref getRef(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract RowId getRowId(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract RowId getRowId(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Struct getStruct(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Struct getStruct(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract SQLXML getSQLXML(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract SQLXML getSQLXML(String var1) throws SQLException;

    static {
        if (STMT_REPLAY_LOGGER == null) {
            STMT_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(STMT_FEATURE_LOGGER_NAME);
        }
    }
}

