/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={ResultSet.class, OracleResultSet.class, oracle.jdbc.internal.OracleResultSet.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class NonTxnReplayableResultSet
extends NonTxnReplayableBase
implements Replayable {
    private static final String RSET_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableResultSet";
    private static Logger RSET_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method m2, Object receiver, Object ... args) {
        super.preForAll(m2, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="deleteRow", args={}), @Signature(name="insertRow", args={}), @Signature(name="updateRow", args={})})
    protected void preForRowUpdates(Method m2, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        RSET_REPLAY_LOGGER.log(Level.FINER, "On result set {0}, entering preForRowUpdates({1})", new Object[]{this, m2.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m2, 371, "Replay disabled because of active transaction", null);
        } else {
            RSET_REPLAY_LOGGER.log(Level.SEVERE, "On result set {0}, failover manager not set", this);
        }
        RSET_REPLAY_LOGGER.log(Level.FINER, "On result set {0}, exiting preForRowUpdates()", this);
    }

    @Pre
    @Methods(signatures={@Signature(name="updateAsciiStream", args={String.class, InputStream.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class, long.class})})
    protected void preForUpdateStreams(Method m2, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        RSET_REPLAY_LOGGER.log(Level.FINER, "On result set {0}, entering preForRowUpdates({1})", new Object[]{this, m2.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m2, 371, "Replay disabled because of active transaction", null);
        } else {
            RSET_REPLAY_LOGGER.log(Level.SEVERE, "On result set {0}, failover manager not set", this);
        }
        RSET_REPLAY_LOGGER.log(Level.FINER, "On result set {0}, exiting preForRowUpdates()", this);
    }

    @Override
    @Post
    protected void postForAll(Method m2) {
        this.postForAll(m2, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m2, Object result) {
        return super.postForAll(m2, result);
    }

    @Post
    @Methods(signatures={@Signature(name="next", args={})})
    protected boolean postForNext(Method m2, boolean result) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingNext(m2, result, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplaying(m2, result, null);
            }
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method m2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.doPostWhenRecordingClose(m2, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m2, SQLException error) throws SQLException {
        this.onErrorForAll(m2, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m2, SQLException error) throws SQLException {
        return super.onErrorForAll(m2, error);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="last", args={})})
    protected boolean onErrorForLast(Method m2, SQLException error) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw error;
        }
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (error instanceof SQLRecoverableException && lifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            RSET_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, failed call for initial outage is last()", this);
            this.failoverMngr.disableReplayInternal(m2, 372, "Replay disabled because of nonreplayable call", null);
        }
        return (Boolean)super.onErrorForAll(m2, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry entry) throws SQLException {
        OracleStatement ostmt = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
        long checksum = ostmt.getChecksum();
        RSET_REPLAY_LOGGER.log(Level.FINEST, "On proxy {0}, method {1}, filling in checksum: {2}", new Object[]{entry.jdbcProxy, entry.method, checksum});
        this.failoverMngr.update(this, entry, entry.result, entry.callStatus, checksum, entry.scn, entry.callException);
    }

    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry entry, SQLRecoverableException origError) throws SQLException {
        Object result = super.replayOneCall(entry, origError);
        return result;
    }

    protected void doPostWhenRecordingNext(Method m2, Object result, SQLException sqlexc) {
        long SCN = -1L;
        long checksum = 0L;
        OracleStatement ostmt = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
        try {
            checksum = ostmt.getChecksum();
        }
        catch (SQLException exc) {
            checksum = 0L;
            RSET_REPLAY_LOGGER.log(Level.WARNING, "On result set {0}, getChecksum() gets exception: {1}", new Object[]{this, exc});
        }
        this.failoverMngr.update(this, null, result, "completed", checksum, -1L, sqlexc);
    }

    protected void doPostWhenRecordingClose(Method m2, SQLException sqlexc) {
        NonTxnReplayableStatement stmtProxy = (NonTxnReplayableStatement)this.getCreator();
        if (stmtProxy.okToPurgeSameProxyList()) {
            this.purgeSameProxyList();
        }
        this.isClosedAndNoReplay = true;
    }

    @Override
    protected void doPostWhenReplaying(Method m2, Object result, SQLException sqlexc) {
        try {
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case REPLAYING: {
                    if (this.replayingCallEntry.checksum == 0L) break;
                    OracleStatement ostmt = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
                    long newChecksum = ostmt.getChecksum();
                    RSET_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, replaying method {1}, new checksum: {2}, original checksum: {3}", new Object[]{this.replayingCallEntry.jdbcProxy, this.replayingCallEntry.method, newChecksum, this.replayingCallEntry.checksum});
                    if (this.replayingCallEntry.checksum != newChecksum) {
                        this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 386, "Replay failed because of checksum mismatch", this.originalError);
                    }
                    break;
                }
            }
        }
        catch (SQLException exc) {
            RSET_REPLAY_LOGGER.log(Level.WARNING, "On result set {0}, doPostWhenReplaying exception: {1}", new Object[]{this, exc});
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Statement getStatement() {
        return (Statement)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.getDelegate();
    }

    static {
        if (RSET_REPLAY_LOGGER == null) {
            RSET_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(RSET_FEATURE_LOGGER_NAME);
        }
    }
}

