/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleNClob;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableClob;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={NClob.class, OracleNClob.class, oracle.jdbc.internal.OracleNClob.class})
public abstract class NonTxnReplayableNClob
extends NonTxnReplayableClob
implements Replayable {
    private static final String NCLOB_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableNClob";
    private static Logger NCLOB_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method m2, Object receiver, Object ... args) {
        super.preForAll(m2, receiver, args);
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="setString", args={long.class, String.class}), @Signature(name="setString", args={long.class, String.class, int.class, int.class}), @Signature(name="truncate", args={long.class})})
    protected void preForClobWrites(Method m2, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        NCLOB_REPLAY_LOGGER.log(Level.FINER, "On nclob {0}, entering preForClobWrites({1})", new Object[]{this, m2.getName()});
        super.preForClobWrites(m2, receiver, args);
        NCLOB_REPLAY_LOGGER.log(Level.FINER, "On nclob {0}, exiting preForClobWrites()", this);
    }

    @Override
    @Post
    protected Object postForAll(Method m2, Object result) {
        if (result instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m2, result);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m2, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m2, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m2, SQLException error) throws SQLException {
        return super.onErrorForAll(m2, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    static {
        if (NCLOB_REPLAY_LOGGER == null) {
            NCLOB_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(NCLOB_FEATURE_LOGGER_NAME);
        }
    }
}

