/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.OracleDataSource;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;

@ProxyFor(value={Connection.class, OracleConnection.class, oracle.jdbc.internal.OracleConnection.class})
@ProxyLocale
public abstract class NonTxnReplayableConnection
extends NonTxnReplayableBase
implements Replayable,
ReplayableConnection {
    private static final String CONN_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableConnection";
    private static Logger CONN_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method m2, Object receiver, Object ... args) {
        super.preForAll(m2, receiver, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Pre
    @Methods(signatures={@Signature(name="commit", args={}), @Signature(name="commit", args={EnumSet.class}), @Signature(name="rollback", args={}), @Signature(name="rollback", args={Savepoint.class}), @Signature(name="setSavepoint", args={}), @Signature(name="setSavepoint", args={String.class}), @Signature(name="releaseSavepoint", args={Savepoint.class}), @Signature(name="oracleRollback", args={OracleSavepoint.class}), @Signature(name="oracleSetSavepoint", args={}), @Signature(name="oracleSetSavepoint", args={String.class}), @Signature(name="oracleReleaseSavepoint", args={OracleSavepoint.class})})
    protected void preForTxnControl(Method m, Object receiver, Object ... args) {
        lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        methodName = m == null ? "NULL METHOD" : m.getName();
        NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, entering preForTxnControl({1})", new Object[]{this, methodName});
        if (this.failoverMngr != null) {
            disableReplayFlag = false;
            try {
                oconn = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
                eocs = oconn.getTransactionState();
                NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, method {1}, transaction state: {2}", new Object[]{this, methodName, eocs});
                if (!eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) || eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) ** GOTO lbl26
                disableReplayFlag = true;
            }
            catch (SQLException sqlexc) {
                NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.WARNING, "On connection {0}, could not get transaction state: {1}", new Object[]{this, sqlexc});
                disableReplayFlag = true;
            }
            finally {
                if (disableReplayFlag) {
                    this.failoverMngr.disableReplayInternal(m, 371, "Replay disabled because of active transaction", null);
                } else {
                    super.preForAll(m, receiver, args);
                }
            }
        } else {
            NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.SEVERE, "On connection {0}, failover manager not set", this);
        }
lbl26:
        // 4 sources

        NonTxnReplayableConnection.CONN_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, exiting preForTxnControl()", this);
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void preForClosure(Method m2, Object receiver, Object ... args) {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, preForClosure({1})", new Object[]{this, m2.getName()});
        this.isClosedAndNoReplay = true;
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method m2, Object receiver, Object ... args) {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, preForCancel({1})", new Object[]{this, m2.getName()});
    }

    @Override
    @Post
    protected void postForAll(Method m2) {
        this.postForAll(m2, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m2, Object result) {
        return super.postForAll(m2, result);
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method m2) {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, postForClosure({1})", new Object[]{this, m2.getName()});
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method m2) {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, postForCancel({1})", new Object[]{this, m2.getName()});
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m2, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m2, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m2, SQLException error) throws SQLException {
        return super.onErrorForAll(m2, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int timeout) throws SQLException {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, entering setReplayInitiationTimeout({1})", new Object[]{this, timeout});
        this.failoverMngr.setReplayInitiationTimeout(timeout);
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, exiting setReplayInitiationTimeout({1})", new Object[]{this, timeout});
    }

    @Override
    public void initialize(OracleDataSource rds) throws SQLException {
        FailoverManagerImpl failoverMngr = (FailoverManagerImpl)FailoverManagerImpl.getFailoverManager(this, rds);
        this.setFailoverManager(failoverMngr);
    }

    @Override
    public void beginRequest() throws SQLException {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, entering beginRequest()", this);
        this.failoverMngr.beginRequest();
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, exiting beginRequest()", this);
    }

    @Override
    public void endRequest() throws SQLException {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, entering endRequest()", this);
        this.failoverMngr.endRequest();
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, exiting endRequest()", this);
    }

    @Override
    public void disableReplay() throws SQLException {
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, entering disableReplay()", this);
        this.failoverMngr.disableReplay();
        CONN_REPLAY_LOGGER.log(Level.FINE, "On connection {0}, exiting disableReplay()", this);
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public ARRAY createARRAY(String typeName, Object elements) throws SQLException {
        Object[] elementsToUse;
        if (elements != null && elements instanceof Object[]) {
            Object[] arrElements = elements;
            if (arrElements.length > 0) {
                Object[] _elementsToUse = new Object[arrElements.length];
                int i2 = 0;
                for (Object elem : arrElements) {
                    _elementsToUse[i2++] = elem instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)elem).getDelegate() : elem;
                }
                elementsToUse = _elementsToUse;
            } else {
                elementsToUse = elements;
            }
        } else {
            elementsToUse = elements;
        }
        Method m2 = null;
        try {
            m2 = oracle.jdbc.internal.OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception exc) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        this.preForAll(m2, this, typeName, elementsToUse);
        try {
            oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
            ARRAY result = oconn.createARRAY(typeName, elementsToUse);
            return (ARRAY)this.postForAll(m2, result);
        }
        catch (SQLException sqlexc) {
            return (ARRAY)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createOracleArray(String arrayTypeName, Object elements) throws SQLException {
        return this.createARRAY(arrayTypeName, elements);
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Object[] elementsToUse;
        if (elements != null && elements.length > 0) {
            elementsToUse = new Object[elements.length];
            int i2 = 0;
            for (Object elem : elements) {
                elementsToUse[i2++] = elem instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)elem).getDelegate() : elem;
            }
        } else {
            elementsToUse = elements;
        }
        Method m2 = null;
        try {
            m2 = Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exc) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        this.preForAll(m2, this, typeName, elementsToUse);
        try {
            Connection oconn = (Connection)this.getDelegate();
            Array result = oconn.createArrayOf(typeName, elementsToUse);
            return (Array)this.postForAll(m2, result);
        }
        catch (SQLException sqlexc) {
            return (Array)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Object[] attributesToUse;
        if (attributes != null && attributes.length > 0) {
            attributesToUse = new Object[attributes.length];
            int i2 = 0;
            for (Object attr : attributes) {
                attributesToUse[i2++] = attr instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)attr).getDelegate() : attr;
            }
        } else {
            attributesToUse = attributes;
        }
        Method m2 = null;
        try {
            m2 = Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception exc) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        this.preForAll(m2, this, typeName, attributesToUse);
        try {
            Connection oconn = (Connection)this.getDelegate();
            Struct result = oconn.createStruct(typeName, attributesToUse);
            return (Struct)this.postForAll(m2, result);
        }
        catch (SQLException sqlexc) {
            return (Struct)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Blob createBlob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Clob createClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract NClob createNClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract SQLXML createSQLXML() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, String[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.getDelegate();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public abstract Connection _getPC();

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection unwrap() {
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).unwrap();
    }

    static {
        if (CONN_REPLAY_LOGGER == null) {
            CONN_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(CONN_FEATURE_LOGGER_NAME);
        }
    }
}

