/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.replay.OracleDataSource;
import oracle.jdbc.replay.driver.FailoverManager;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;

class FailoverManagerImpl
implements FailoverManager {
    private static final String MNGR_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.FailoverManagerImpl";
    private static Logger MNGR_REPLAY_LOGGER = null;
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
    private boolean replayInCurrentMode = false;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout = 900L;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries = 0;
    private OracleDataSource replayDataSource = null;
    private NonTxnReplayableBase connectionProxy;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private boolean doNotAbortConn = false;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";

        @Override
        public Thread newThread(Runnable r2) {
            Thread newT = new Thread(null, r2, THREAD_NAME);
            newT.setPriority(5);
            newT.setDaemon(true);
            return newT;
        }
    });

    private FailoverManagerImpl(NonTxnReplayableBase connProxy, OracleDataSource rds) throws SQLException {
        this.connectionProxy = connProxy;
        this.replayDataSource = rds;
        this.enableTxnMonitoring((OracleConnection)this.connectionProxy.getDelegate());
    }

    static FailoverManager getFailoverManager(NonTxnReplayableBase connProxy, OracleDataSource rds) throws SQLException {
        return new FailoverManagerImpl(connProxy, rds);
    }

    private void append(CallHistoryEntry entry) {
        entry.prevEntry = this.tail;
        entry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = entry;
        }
        this.tail = entry;
        if (this.head == null) {
            this.head = entry;
        }
        Replayable jdbcProxy = (Replayable)entry.jdbcProxy;
        jdbcProxy.addToSameProxyList(entry);
    }

    private void remove(CallHistoryEntry entry) {
        if (entry.nextEntry != null) {
            entry.nextEntry.prevEntry = entry.prevEntry;
        }
        if (entry.prevEntry != null) {
            entry.prevEntry.nextEntry = entry.nextEntry;
        }
        if (this.head == entry) {
            this.head = entry.nextEntry;
        }
        if (this.tail == entry) {
            this.tail = entry.prevEntry;
        }
        Replayable jdbcProxy = (Replayable)entry.jdbcProxy;
        jdbcProxy.removeFromSameProxyList(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallHistoryEntry record(Object jdbcProxy, Method m2, Object[] args, String callStatus) {
        FailoverManagerImpl failoverManagerImpl = this;
        synchronized (failoverManagerImpl) {
            String methodName = m2 == null ? "NULL METHOD" : m2.getName();
            StringBuilder argStr = new StringBuilder();
            if (args != null && args.length > 0) {
                for (int i2 = 0; i2 < args.length - 1; ++i2) {
                    argStr.append(args[i2]);
                    argStr.append(",");
                }
                argStr.append(args[args.length - 1]);
            }
            MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, recording method {1}({2})", new Object[]{this.connectionProxy, methodName, argStr.toString()});
            CallHistoryEntry entry = new CallHistoryEntry(jdbcProxy, m2, args, callStatus);
            this.append(entry);
            MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, recorded method {1}", new Object[]{this.connectionProxy, methodName});
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Object jdbcProxy, CallHistoryEntry e2, Object result, String callStatus, long checksum, long SCN, SQLException sqlexc) {
        FailoverManagerImpl failoverManagerImpl = this;
        synchronized (failoverManagerImpl) {
            CallHistoryEntry entry = e2 == null ? this.tail : e2;
            String methodName = entry == null || entry.method == null ? "NULL METHOD" : entry.method.getName();
            MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, updating entry for method {1}", new Object[]{this.connectionProxy, methodName});
            entry.result = result;
            entry.checksum = checksum;
            entry.scn = SCN;
            entry.callException = sqlexc;
            entry.callStatus = callStatus;
            MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, updated entry for method {1} - result: {2}, checksum: {3}, SCN: {4}, SQLException: {5}", new Object[]{this.connectionProxy, methodName, result, checksum, SCN, sqlexc});
        }
    }

    synchronized void purge() {
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, calling explicit purge", this.connectionProxy);
        CallHistoryEntry entry = this.head;
        while (entry != null) {
            this.remove(entry);
            entry = entry.nextEntry;
        }
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, calling explicit purge succeeds", this.connectionProxy);
    }

    synchronized void purgeForSameProxy(Set<Object> visitedProxies, CallHistoryEntry headForProxy) {
        Object jproxy = headForProxy == null ? null : headForProxy.jdbcProxy;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, calling implicit purge for {1}", new Object[]{this.connectionProxy, jproxy});
        CallHistoryEntry entry = headForProxy;
        while (entry != null) {
            Object callResult = entry.result;
            if (callResult != null && callResult instanceof Replayable && !visitedProxies.contains(callResult)) {
                Replayable resultProxy = (Replayable)callResult;
                resultProxy.purgeSameProxyList();
                visitedProxies.add(resultProxy);
            }
            MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, implicit purge {1}", new Object[]{this.connectionProxy, entry.method});
            this.remove(entry);
            entry = entry.nextEntrySameProxy;
        }
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, calling implicit purge for {1} succeeds", new Object[]{this.connectionProxy, jproxy});
    }

    synchronized boolean isEmpty() {
        return this.head == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillInAllChecksums() throws SQLException {
        FailoverManagerImpl failoverManagerImpl = this;
        synchronized (failoverManagerImpl) {
            HashSet<Object> visitedProxies = new HashSet<Object>();
            CallHistoryEntry entry = this.tail.prevEntry;
            while (entry != null) {
                if (!visitedProxies.contains(entry.jdbcProxy)) {
                    NonTxnReplayableBase jproxy = (NonTxnReplayableBase)entry.jdbcProxy;
                    jproxy.fillInChecksum(entry);
                    visitedProxies.add(entry.jdbcProxy);
                    if (entry.jdbcProxy instanceof ResultSet) {
                        visitedProxies.add(jproxy.getCreator());
                    }
                }
                entry = entry.prevEntry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object replayAll(SQLRecoverableException origError) throws SQLException {
        FailoverManagerImpl failoverManagerImpl = this;
        synchronized (failoverManagerImpl) {
            this.replayRetries = 0;
            do {
                ReplayLifecycle curLifecycle;
                try {
                    return this.replayAllInternal(origError, this.replayRetries);
                }
                catch (SQLRecoverableException newExc) {
                    curLifecycle = this.lifecycle;
                    MNGR_REPLAY_LOGGER.log(Level.FINEST, "replayAll caught new exception: {0}, current lifecycle: {1}", new Object[]{newExc, curLifecycle});
                    switch (curLifecycle) {
                        case REPLAYING: 
                        case REPLAYING_CALLBACK: 
                        case REPLAYING_LASTCALL: {
                            ++this.replayRetries;
                            MNGR_REPLAY_LOGGER.log(Level.FINEST, "NEW replay attempt {0}", this.replayRetries);
                            break;
                        }
                    }
                }
                catch (SQLException sqlexc) {
                    curLifecycle = this.lifecycle;
                    MNGR_REPLAY_LOGGER.log(Level.FINEST, "replayAll caught new exception: {0}, current lifecycle: {1}", new Object[]{sqlexc, curLifecycle});
                    switch (curLifecycle) {
                        case INTERNALLY_FAILED: {
                            ++this.replayRetries;
                            this.lifecycle = ReplayLifecycle.REPLAYING;
                            MNGR_REPLAY_LOGGER.log(Level.FINEST, "NEW replay attempt {0} after failed replay", this.replayRetries);
                            break;
                        }
                        case ALWAYS_DISABLED: 
                        case INTERNALLY_DISABLED: 
                        case EXTERNALLY_DISABLED: {
                            this.throwOriginalExceptionWithReplayError(this.replayErrorCode, this.replayErrorMessage, origError);
                        }
                        case REPLAYING_LASTCALL: {
                            MNGR_REPLAY_LOGGER.log(Level.FINEST, "Replaying last call throws: {0}, rethrowing back", sqlexc);
                            throw sqlexc;
                        }
                    }
                }
            } while (this.replayRetries <= 3);
            MNGR_REPLAY_LOGGER.log(Level.WARNING, "Maximum replay retries exceeded");
            this.disableReplayAndThrowOriginalError(null, 378, "Replay disabled because maximum number of retries is exceeded", origError);
            return null;
        }
    }

    synchronized Object replayAllInternal(SQLRecoverableException origError, int currentRetries) throws SQLException {
        OracleConnection newConn;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering replayAllInternal(connection proxy={0}, original error={1})", new Object[]{this.connectionProxy, origError});
        ReplayLifecycle curLifecycle = this.lifecycle;
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "current lifecycle:{0}", (Object)curLifecycle);
        if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
            if (this.replayErrorCode == 0) {
                this.doNotAbortConn = true;
                this.replayErrorCode = 370;
                this.replayErrorMessage = "Replay disabled";
            }
            this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, origError);
        }
        if ((newConn = (OracleConnection)this.replayDataSource.getConnectionNoProxy()) == null) {
            MNGR_REPLAY_LOGGER.log(Level.FINE, "FAILOVER_RETRIES exceeded");
            this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", origError);
        }
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Reconnect succeeded, new connection={0}", newConn);
        long currentTimestamp = System.currentTimeMillis();
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "timestamp at replay start: {0}", currentTimestamp);
        if (this.requestStartTime + this.replayInitiationTimeout * 1000L < currentTimestamp) {
            MNGR_REPLAY_LOGGER.log(Level.WARNING, "ReplayInitiationTimeout exceeded");
            this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", origError);
        }
        this.connectionProxy.setDelegate(newConn);
        this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
        ConnectionInitializationCallback initCbk = this.replayDataSource.getConnectionInitializationCallback();
        if (initCbk != null) {
            try {
                MNGR_REPLAY_LOGGER.log(Level.FINER, "Invoking Replay Driver initialization callback with {0}", this.connectionProxy);
                initCbk.initialize((Connection)((Object)this.connectionProxy));
                MNGR_REPLAY_LOGGER.log(Level.FINER, "Invoking initialization callback with {0} succeeded", this.connectionProxy);
            }
            catch (SQLException sqlexc) {
                MNGR_REPLAY_LOGGER.log(Level.FINER, "Invoking initialization callback with {0} failed", this.connectionProxy);
                this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", origError);
            }
            EnumSet<OracleConnection.TransactionState> eocs = newConn.getTransactionState();
            MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, after init-callback, transaction state={1}", new Object[]{this.connectionProxy, eocs});
            if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", origError);
            }
        }
        this.lifecycle = ReplayLifecycle.REPLAYING;
        if (currentRetries == 0) {
            this.fillInAllChecksums();
        }
        this.beginReplay(newConn, origError);
        this.replayResult = this.replayAllBeforeLastCall(origError);
        this.endReplay(newConn, origError);
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "On connection {0}, replaying last call", this.connectionProxy);
        if (this.tail != null) {
            this.replayResult = ((Replayable)this.tail.jdbcProxy).replayOneCall(this.tail, origError);
        }
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, replay succeeds", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting replayAll(connection proxy={0}, original error={1}), result={2}", new Object[]{this.connectionProxy, origError, this.replayResult});
        return this.replayResult;
    }

    private synchronized Object replayAllBeforeLastCall(SQLRecoverableException origError) throws SQLException {
        Object replayResult = null;
        CallHistoryEntry entry = this.head;
        while (entry != this.tail) {
            Replayable jproxy = (Replayable)entry.jdbcProxy;
            MNGR_REPLAY_LOGGER.log(Level.FINEST, "On proxy {0}, replaying {1}", new Object[]{jproxy, entry.method});
            replayResult = jproxy.replayOneCall(entry, origError);
            if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, origError);
            }
            entry = entry.nextEntry;
        }
        return replayResult;
    }

    boolean isReplayInCurrentMode() {
        return this.replayInCurrentMode;
    }

    void setReplayInCurrentMode() {
        this.replayInCurrentMode = true;
    }

    ReplayLifecycle getReplayLifecycle() {
        return this.lifecycle;
    }

    void setDataSource(OracleDataSource rds) {
        this.replayDataSource = rds;
    }

    void setReplayInitiationTimeout(int timeout) throws SQLException {
        this.replayInitiationTimeout = timeout;
    }

    void beginRequest() throws SQLException {
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, Entering beginRequest()", this.connectionProxy);
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting beginRequest(), MONITOR_TXN failed, no-op");
            return;
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
            throw DatabaseError.createSqlException(390);
        }
        this.requestStartTime = System.currentTimeMillis();
        MNGR_REPLAY_LOGGER.log(Level.FINEST, "Request start timestamp: {0}", this.requestStartTime);
        OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
        EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
        MNGR_REPLAY_LOGGER.log(Level.FINER, "transaction state: {0}", eocs);
        if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            SQLException sqlexc = DatabaseError.createSqlException(391);
            MNGR_REPLAY_LOGGER.throwing(this.getClass().getName(), "beginRequest", sqlexc);
            throw sqlexc;
        }
        this.replayErrorCode = 0;
        this.replayErrorMessage = "";
        this.callCausingReplayError = null;
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Recording begins on connection {0}", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting beginRequest()");
    }

    void endRequest() throws SQLException {
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering endRequest()");
        OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
        EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
        MNGR_REPLAY_LOGGER.log(Level.FINER, "transaction state: {0}", eocs);
        if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            try {
                oconn.rollback();
            }
            catch (SQLException sqlexc) {
                MNGR_REPLAY_LOGGER.log(Level.FINEST, "Rollback open transaction failed before throwing exception");
            }
            SQLException sqlexc = DatabaseError.createSqlException(392);
            MNGR_REPLAY_LOGGER.throwing(this.getClass().getName(), "endRequest", sqlexc);
            throw sqlexc;
        }
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting endRequest() -- MONITOR_TXN failed");
            return;
        }
        if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED || this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting endRequest() -- replay already disabled");
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            return;
        }
        this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting endRequest()");
    }

    void disableReplay() throws SQLException {
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering disableReplay");
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting disableReplay(), MONITOR_TXN failed, no-op");
            return;
        }
        this.disableReplayInternal(null, 370, "Replay disabled", null);
        this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, replay is externally disabled", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting disableReplay");
    }

    void disableReplayInternal(Method m2, int errCode, String errMesg, SQLRecoverableException origError) {
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering disableReplayInternal");
        ReplayLifecycle curLifecycle = this.lifecycle;
        if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
        }
        this.purge();
        this.replayErrorCode = errCode;
        this.replayErrorMessage = errMesg;
        this.callCausingReplayError = m2;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, replay is internally disabled", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting disableReplayInternal");
    }

    void failReplayInternal(Method m2, int errCode, String errMesg, SQLRecoverableException origError) {
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Entering failReplayInternal");
        ReplayLifecycle curLifecycle = this.lifecycle;
        if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
        }
        this.replayErrorCode = errCode;
        this.replayErrorMessage = errMesg;
        this.callCausingReplayError = m2;
        MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, replay failed", this.connectionProxy);
        MNGR_REPLAY_LOGGER.log(Level.FINER, "Exiting failReplayInternal");
    }

    void throwReplayExceptionInternal(int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        if (errCode == 0) {
            return;
        }
        String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
        throw replayErr;
    }

    void disableReplayAndThrowException(Method m2, int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        this.disableReplayInternal(m2, errCode, errMesg, origError);
        this.throwReplayExceptionInternal(errCode, errMesg, origError);
    }

    void disableReplayAndThrowOriginalError(Method m2, int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        this.disableReplayInternal(m2, errCode, errMesg, origError);
        this.throwOriginalExceptionWithReplayError(errCode, errMesg, origError);
    }

    void failReplayAndThrowException(Method m2, int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        this.failReplayInternal(m2, errCode, errMesg, origError);
        this.throwReplayExceptionInternal(errCode, errMesg, origError);
    }

    void throwOriginalExceptionWithReplayError(int errCode, String errMesg, SQLRecoverableException origError) throws SQLRecoverableException {
        if (!this.doNotAbortConn) {
            this.killConnectionBeforeReplayDisabledException();
        }
        String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
        origError.setNextException(replayErr);
        throw origError;
    }

    void killConnectionBeforeReplayDisabledException() {
        final OracleConnection oconn = (OracleConnection)this.connectionProxy.getDelegate();
        try {
            oconn.abort();
        }
        catch (SQLException sqlexc) {
            MNGR_REPLAY_LOGGER.log(Level.FINE, "Aborting connection failed before throwing replay-disabled exception");
        }
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    FailoverManagerImpl.this.closePhysicalConnection(oconn);
                }
            });
        }
        catch (Exception exc) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, ASYNC close() submission during replay failed", this.connectionProxy);
        }
    }

    void enableTxnMonitoring(OracleConnection oconn) throws SQLException {
        try {
            Statement stmt = oconn.createStatement();
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling MONITOR_TXN");
            stmt.execute(MONITOR_TXN);
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling MONITOR_TXN succeeded");
            stmt.close();
        }
        catch (SQLException sqlexc) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling MONITOR_TXN failed");
            this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
            this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            throw DatabaseError.createSqlException(394);
        }
    }

    void beginReplay(OracleConnection oconn, SQLRecoverableException origError) throws SQLException {
        try {
            Statement stmt = oconn.createStatement();
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling BEGIN_REPLAY");
            stmt.execute(BEGIN_REPLAY);
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling BEGIN_REPLAY succeeded");
            stmt.close();
            this.lifecycle = ReplayLifecycle.REPLAYING;
        }
        catch (SQLException sqlexc) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling BEGIN_REPLAY failed");
            this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", origError);
        }
    }

    void endReplay(OracleConnection oconn, SQLRecoverableException origError) throws SQLException {
        try {
            Statement stmt = oconn.createStatement();
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling END_REPLAY");
            stmt.execute(END_REPLAY);
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling END_REPLAY succeeded");
            stmt.close();
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        }
        catch (SQLException sqlexc) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "Calling END_REPLAY failed");
            this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", origError);
        }
    }

    Replayable getConnectionProxy() {
        return this.connectionProxy;
    }

    private boolean isReplayFailure(SQLException t) {
        int errCode;
        boolean result = false;
        if (t instanceof SQLException && (errCode = t.getErrorCode()) >= 370 && errCode < 400) {
            result = true;
        }
        return result;
    }

    private void closePhysicalConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sqlexc) {
            MNGR_REPLAY_LOGGER.log(Level.FINER, "On connection {0}, connection close() during replay failed", this.connectionProxy);
        }
    }

    static {
        if (MNGR_REPLAY_LOGGER == null) {
            MNGR_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(MNGR_FEATURE_LOGGER_NAME);
        }
    }

    static enum ReplayLifecycle {
        ENABLED_NOT_REPLAYING,
        INTERNALLY_FAILED,
        INTERNALLY_DISABLED,
        ALWAYS_DISABLED,
        EXTERNALLY_DISABLED,
        REPLAYING_CALLBACK,
        REPLAYING,
        REPLAYING_LASTCALL;

    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long scn;
        long checksum;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;

        CallHistoryEntry(Object jdbcProxy, Method m2, Object[] args, String callStatus) {
            this.jdbcProxy = jdbcProxy;
            this.method = m2;
            this.args = args;
            this.result = null;
            this.callStatus = callStatus;
        }
    }
}

