/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.OracleDataSource;
import oracle.jdbc.replay.driver.NonTxnReplayableArray;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableBfile;
import oracle.jdbc.replay.driver.NonTxnReplayableBlob;
import oracle.jdbc.replay.driver.NonTxnReplayableClob;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.NonTxnReplayableNClob;
import oracle.jdbc.replay.driver.NonTxnReplayableOpaque;
import oracle.jdbc.replay.driver.NonTxnReplayableOthers;
import oracle.jdbc.replay.driver.NonTxnReplayableRef;
import oracle.jdbc.replay.driver.NonTxnReplayableResultSet;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.NonTxnReplayableStruct;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.ReplayableConnection;

public class OracleDataSourceImpl
implements OracleDataSource,
Serializable,
Referenceable,
ObjectFactory {
    private static final long serialVersionUID = 5634196469087099680L;
    private static final String FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.OracleDataSourceImpl";
    private static final Logger RDS_LOGGER = ReplayLoggerFactory.getLogger("oracle.jdbc.internal.replay.OracleDataSourceImpl");
    private static ProxyFactory PROXY_FACTORY = null;
    private String user = null;
    private String password = null;
    private String url = null;
    private String serverName = null;
    private int portNumber = 0;
    private String databaseName = null;
    private String dataSourceName = null;
    private String description = null;
    private String networkProtocol = null;
    private String roleName = null;
    private final Properties connectionProperties = new Properties();
    private int maxStatements = 0;
    private boolean implicitCachingEnabled = false;
    private boolean explicitCachingEnabled = false;
    private ConnectionInitializationCallback connectionInitializationCallback = null;
    private AtomicBoolean isFirstConnection = new AtomicBoolean(true);
    private static final String RECONNECT_DELAY_PROPERTY = "AUTH_FAILOVER_DELAY";
    private static final String RECONNECT_RETRIES_PROPERTY = "AUTH_FAILOVER_RETRIES";
    private int reconnectDelay = 10;
    private int reconnectRetries = 18;
    private static final String CHECKSUM_PROPERTY = "oracle.jdbc.calculateChecksum";

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionInternal(username, password, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnectionNoProxy() throws SQLException {
        int retries = 1;
        Connection conn = null;
        Exception exc = null;
        do {
            try {
                if (this.reconnectDelay > 0) {
                    RDS_LOGGER.log(Level.FINER, "Reconnecting: DELAY for {0} seconds", this.reconnectDelay);
                    Thread.sleep(this.reconnectDelay * 1000);
                }
                RDS_LOGGER.log(Level.FINER, "Reconnecting: RETRY {0}", retries);
                exc = null;
                conn = this.getConnectionInternal(this.user, this.password, false);
            }
            catch (InterruptedException sleepExc) {
                conn = null;
                exc = sleepExc;
                RDS_LOGGER.log(Level.FINER, "Reconnect threw exception during DELAY: {0}", sleepExc);
            }
            catch (Exception e2) {
                conn = null;
                exc = e2;
                RDS_LOGGER.log(Level.FINER, "Reconnect FAILED, exception: {0}", e2);
            }
            finally {
                if (conn != null && exc == null) {
                    return conn;
                }
                ++retries;
            }
        } while (retries <= this.reconnectRetries);
        return null;
    }

    private Connection getConnectionInternal(String username, String passwd, boolean useProxy) throws SQLException {
        Connection conn = null;
        oracle.jdbc.pool.OracleDataSource ods = new oracle.jdbc.pool.OracleDataSource();
        ods.setUser(username);
        ods.setPassword(passwd);
        ods.setURL(this.getURL());
        this.setConnectionProperty(CHECKSUM_PROPERTY, "true");
        ods.setConnectionProperties(this.getConnectionProperties());
        ods.setMaxStatements(this.getMaxStatements());
        ods.setImplicitCachingEnabled(this.getImplicitCachingEnabled());
        ods.setExplicitCachingEnabled(this.getExplicitCachingEnabled());
        conn = ods.getConnection();
        if (this.isFirstConnection.get()) {
            short dbVersion;
            String failoverRetries;
            OracleConnection oconn = (OracleConnection)conn;
            Properties sessionProperties = oconn.getServerSessionInfo();
            String failoverDelay = sessionProperties.getProperty(RECONNECT_DELAY_PROPERTY);
            if (failoverDelay != null && !"".equals(failoverDelay)) {
                int _delay = Integer.parseInt(failoverDelay);
                if (_delay > 0) {
                    this.reconnectDelay = _delay;
                } else {
                    RDS_LOGGER.log(Level.WARNING, "Server FAILOVER_DELAY: {0}, use driver default {1} seconds instead", new Object[]{_delay, 10});
                }
            }
            if ((failoverRetries = sessionProperties.getProperty(RECONNECT_RETRIES_PROPERTY)) != null && !"".equals(failoverRetries)) {
                int _retries = Integer.parseInt(failoverRetries);
                if (_retries > 0) {
                    this.reconnectRetries = _retries;
                } else {
                    RDS_LOGGER.log(Level.WARNING, "Server FAILOVER_RETRIES: {0}, use driver default {1} instead", new Object[]{_retries, 18});
                }
            }
            if ((dbVersion = oconn.getVersionNumber()) < 11203) {
                throw DatabaseError.createSqlException(393);
            }
            this.isFirstConnection.set(false);
        }
        if (useProxy) {
            Connection connProxy = PROXY_FACTORY.proxyFor(conn);
            ReplayableConnection rconn = (ReplayableConnection)((Object)connProxy);
            rconn.initialize(this);
            return connProxy;
        }
        return conn;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String username) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "user: {0}", username);
        this.user = username;
    }

    @Override
    public void setPassword(String passwd) throws SQLException {
        this.password = passwd;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "URL: {0}", url);
        this.url = url;
    }

    @Override
    public void setServerName(String serverName) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "Server Name: {0}", serverName);
        this.serverName = serverName;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setPortNumber(int portNumber) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "Port Number: {0}", portNumber);
        this.portNumber = portNumber;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void setDatabaseName(String databaseName) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "Database Name : {0}", databaseName);
        this.databaseName = databaseName;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDataSourceName(String dataSourceName) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "DataSourceName : {0}", dataSourceName);
        this.dataSourceName = dataSourceName;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public void setDescription(String description) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "Description : {0}", description);
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setNetworkProtocol(String networkProtocol) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "networkProtocol : {0}", networkProtocol);
        this.networkProtocol = networkProtocol;
    }

    @Override
    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    @Override
    public void setRoleName(String roleName) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "RoleName : {0}", roleName);
        this.roleName = roleName;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public void registerConnectionInitializationCallback(ConnectionInitializationCallback cbk) throws SQLException {
        RDS_LOGGER.finest("Connection Initialization Callback registered");
        if (cbk == null) {
            throw new NullPointerException("callback has to be non-null");
        }
        this.connectionInitializationCallback = cbk;
    }

    @Override
    public void unregisterConnectionInitializationCallback(ConnectionInitializationCallback cbk) throws SQLException {
        RDS_LOGGER.finest("Connection Initialization Callback removed");
        this.connectionInitializationCallback = null;
    }

    @Override
    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        RDS_LOGGER.finest("connection initialization callback obtained");
        return this.connectionInitializationCallback;
    }

    @Override
    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public String getConnectionProperty(String propertyName) {
        return this.connectionProperties.getProperty(propertyName);
    }

    @Override
    public void setConnectionProperty(String name, String value) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "name: {0}, value: {1}", new Object[]{name, value});
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException();
        }
        this.connectionProperties.setProperty(name, value);
    }

    @Override
    public void setConnectionProperties(Properties connProperties) throws SQLException {
        RDS_LOGGER.log(Level.FINEST, "ConnectionProperties: {0}", connProperties);
        if (connProperties.size() <= 0) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<Object, Object> prop : connProperties.entrySet()) {
            this.connectionProperties.setProperty((String)prop.getKey(), (String)prop.getValue());
        }
    }

    @Override
    public void setMaxStatements(int max) throws SQLException {
        this.maxStatements = max;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    @Override
    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        this.implicitCachingEnabled = cache;
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.implicitCachingEnabled;
    }

    @Override
    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        this.explicitCachingEnabled = cache;
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.explicitCachingEnabled;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.replay.OracleDataSourceImpl", null);
        if (this.user != null) {
            ref.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            ref.add(new StringRefAddr("password", this.password));
        }
        if (this.url != null) {
            ref.add(new StringRefAddr("url", this.url));
        }
        if (this.serverName != null) {
            ref.add(new StringRefAddr("serverName", this.serverName));
        }
        ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        if (this.databaseName != null) {
            ref.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.dataSourceName != null) {
            ref.add(new StringRefAddr("dataSourceName", this.dataSourceName.toString()));
        }
        if (this.description != null) {
            ref.add(new StringRefAddr("description", this.description.toString()));
        }
        if (this.networkProtocol != null) {
            ref.add(new StringRefAddr("networkProtocol", this.networkProtocol.toString()));
        }
        if (this.roleName != null) {
            ref.add(new StringRefAddr("roleName", this.roleName));
        }
        if (this.connectionProperties.size() > 0) {
            ref.add(new StringRefAddr("connectionProperties", this.connectionProperties.toString()));
        }
        if (this.maxStatements != 0) {
            ref.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        }
        if (this.implicitCachingEnabled) {
            ref.add(new StringRefAddr("implicitCachingEnabled", "true"));
        }
        if (this.explicitCachingEnabled) {
            ref.add(new StringRefAddr("explicitCachingEnabled", "true"));
        }
        return ref;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, SQLException {
        in.defaultReadObject();
    }

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        String ie;
        Reference ref = (Reference)refObj;
        String cn = ref.getClassName();
        OracleDataSourceImpl pd = null;
        if (cn.equals("oracle.jdbc.replay.OracleDataSource") || cn.equals("oracle.jdbc.replay.OracleDataSourceImpl")) {
            pd = new OracleDataSourceImpl();
        }
        if (pd == null) {
            return null;
        }
        StringRefAddr ra = (StringRefAddr)ref.get("user");
        if (ra != null) {
            pd.setUser((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("password")) != null) {
            pd.setPassword((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("url")) != null) {
            pd.setURL((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("serverName")) != null) {
            pd.setServerName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("portNumber")) != null) {
            pd.setPortNumber(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("databaseName")) != null) {
            pd.setDatabaseName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("dataSourceName")) != null) {
            pd.setDataSourceName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("description")) != null) {
            pd.setDescription((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("networkProtocol")) != null) {
            pd.setNetworkProtocol((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("roleName")) != null) {
            pd.setRoleName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("connectionProperties")) != null) {
            String[] propStrs;
            String connPropsStr = (String)ra.getContent();
            Properties connProps = new Properties();
            for (String onePropStr : propStrs = connPropsStr.substring(1, connPropsStr.length() - 1).split(", ")) {
                String[] nvPair = onePropStr.split("=");
                connProps.setProperty(nvPair[0], nvPair[1]);
            }
            pd.setConnectionProperties(connProps);
        }
        if ((ra = (StringRefAddr)ref.get("maxStatements")) != null) {
            pd.setMaxStatements(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("implicitCachingEnabled")) != null) {
            ie = (String)ra.getContent();
            if (ie.equalsIgnoreCase("true")) {
                pd.setImplicitCachingEnabled(true);
            } else {
                pd.setImplicitCachingEnabled(false);
            }
        }
        if ((ra = (StringRefAddr)ref.get("explicitCachingEnabled")) != null) {
            ie = (String)ra.getContent();
            if (ie.equalsIgnoreCase("true")) {
                pd.setExplicitCachingEnabled(true);
            } else {
                pd.setExplicitCachingEnabled(false);
            }
        }
        return pd;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    static {
        if (PROXY_FACTORY == null) {
            PROXY_FACTORY = ProxyFactory.createProxyFactory(NonTxnReplayableBase.class, NonTxnReplayableConnection.class, NonTxnReplayableStatement.class, NonTxnReplayableResultSet.class, NonTxnReplayableArray.class, NonTxnReplayableBfile.class, NonTxnReplayableBlob.class, NonTxnReplayableClob.class, NonTxnReplayableNClob.class, NonTxnReplayableOpaque.class, NonTxnReplayableRef.class, NonTxnReplayableStruct.class, NonTxnReplayableOthers.class);
        }
    }
}

