/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.ExtractDelegatePermission;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.NullProxy;
import oracle.jdbc.proxy.OracleProxy;
import oracle.jdbc.proxy.WeakIdentityHashMap;
import oracle.jdbc.proxy._Proxy_;

public class ProxyFactory {
    final AnnotationsRegistry annotationsRegistry = new AnnotationsRegistry();
    private final GeneratedProxiesRegistry generatedRegistry = new GeneratedProxiesRegistry();
    private Map<Class, Class> delegateClassToProxyClass = Collections.synchronizedMap(new HashMap());
    private final Map<Object, WeakReference<Object>> delegateToProxy = Collections.synchronizedMap(new WeakIdentityHashMap());
    private final Map<Class, Class> delegateToMostSuitableIface = Collections.synchronizedMap(new HashMap());
    private static final Object STALE_DELEGATE = new Object();
    private static final Class EMPTY_VALUE = EMPTY_CLASS.class;
    private static final ExtractDelegatePermission EXTRACT_DELEGATE_PERMISSION = new ExtractDelegatePermission();

    private ProxyFactory() {
    }

    public static ProxyFactory createProxyFactory(Class ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(Class ... classes) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classes);
        return proxyFactory;
    }

    public final boolean isProxied(Class iface) {
        return this.annotationsRegistry.containsKey(iface);
    }

    public final <T> T proxyFor(T delegate) {
        return this.proxyFor(delegate, this);
    }

    public final <T> T proxyFor(T delegate, Object creator) {
        return this.proxyForCache(delegate, creator, null, null);
    }

    public final <T> T proxyForCreate(T delegate, Object creator, Map<Object, WeakReference<Object>> proxyCache, Method methodObject) {
        Class c2;
        if (null == delegate) {
            return null;
        }
        Class<?> delegateClass = delegate.getClass();
        Class mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        if (null == proxyCache) {
            Map<Object, Object> map = proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        if (null == (c2 = this.getProxyClass(mostSuitableIface, delegateClass))) {
            return this.createProxy(mostSuitableIface, delegate, creator, proxyCache);
        }
        try {
            return c2.getConstructor(mostSuitableIface, Object.class, ProxyFactory.class, Map.class).newInstance(delegate, creator, this, proxyCache);
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new RuntimeException(e4);
        }
        catch (InstantiationException e5) {
            throw new RuntimeException(e5);
        }
    }

    public final <T> T proxyForCache(T delegate, Object creator, Map<Object, WeakReference<Object>> proxyCache, Method methodObject) {
        Object proxy;
        WeakReference<Object> proxyRef;
        if (null == delegate) {
            return null;
        }
        Class<?> delegateClass = delegate.getClass();
        Class mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        if (null == proxyCache) {
            Map<Object, Object> map = proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        if (null != (proxyRef = proxyCache.get(delegate)) && null != (proxy = proxyRef.get())) {
            if (STALE_DELEGATE == proxy) {
                throw new RuntimeException("stale delegate");
            }
            return proxy;
        }
        Class c2 = this.getProxyClass(mostSuitableIface, delegateClass);
        if (null == c2) {
            T proxy2 = this.createProxy(mostSuitableIface, delegate, creator, proxyCache);
            proxyCache.put(delegate, new WeakReference<T>(proxy2));
            return proxy2;
        }
        try {
            Object proxy3 = c2.getConstructor(mostSuitableIface, Object.class, ProxyFactory.class, Map.class).newInstance(delegate, creator, this, proxyCache);
            proxyCache.put(delegate, new WeakReference(proxy3));
            return proxy3;
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new RuntimeException(e4);
        }
        catch (InstantiationException e5) {
            throw new RuntimeException(e5);
        }
    }

    public final <T> T proxyForCreateCache(T delegate, Object creator, Map<Object, WeakReference<Object>> proxyCache, Method methodObject) {
        Class c2;
        if (null == delegate) {
            return null;
        }
        Class<?> delegateClass = delegate.getClass();
        Class mostSuitableIface = this.findMostSuitableIface(delegateClass);
        if (null != methodObject && null != mostSuitableIface && !methodObject.getReturnType().isAssignableFrom(mostSuitableIface)) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        if (null == value) {
            return delegate;
        }
        if (null == proxyCache) {
            Map<Object, Object> map = proxyCache = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        if (null == (c2 = this.getProxyClass(mostSuitableIface, delegateClass))) {
            T proxy = this.createProxy(mostSuitableIface, delegate, creator, proxyCache);
            proxyCache.put(delegate, new WeakReference<T>(proxy));
            return proxy;
        }
        try {
            Object proxy = c2.getConstructor(mostSuitableIface, Object.class, ProxyFactory.class, Map.class).newInstance(delegate, creator, this, proxyCache);
            proxyCache.put(delegate, new WeakReference(proxy));
            return proxy;
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new RuntimeException(e4);
        }
        catch (InstantiationException e5) {
            throw new RuntimeException(e5);
        }
    }

    public <T> void updateDelegate(Object proxy, T oldDelegate, T newDelegate) {
        this.delegateToProxy.put(oldDelegate, new WeakReference<Object>(STALE_DELEGATE));
        this.delegateToProxy.put(newDelegate, new WeakReference<Object>(proxy));
    }

    public static final Object extractDelegate(OracleProxy proxy) {
        _Proxy_ p2;
        SecurityManager security = System.getSecurityManager();
        if (null != security) {
            security.checkPermission(EXTRACT_DELEGATE_PERMISSION);
        }
        try {
            p2 = (_Proxy_)((Object)proxy);
        }
        catch (ClassCastException e2) {
            throw new IllegalArgumentException();
        }
        return p2._getDelegate_();
    }

    private <T> T createProxy(Class mostSuitableIface, T delegate, Object creator, Map<Object, WeakReference<Object>> proxyCache) {
        if (null == mostSuitableIface) {
            return delegate;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(mostSuitableIface);
        Class superclass = value.getSuperclass();
        GeneratedProxiesRegistry.Value v = this.generatedRegistry.get(mostSuitableIface, superclass);
        Constructor c2 = null == v ? this.prepareProxy(mostSuitableIface, superclass) : v.getConstructor();
        try {
            return c2.newInstance(delegate, creator, this, proxyCache);
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2.getTargetException());
        }
        catch (IllegalAccessException e3) {
            throw new RuntimeException(e3);
        }
        catch (InstantiationException e4) {
            throw new RuntimeException(e4);
        }
    }

    private Constructor prepareProxy(Class iface, Class superclass) {
        Constructor constructor;
        Class clazz = null;
        try {
            clazz = Class.forName(new GeneratedProxiesRegistry.Key(iface, superclass).toString());
        }
        catch (ClassNotFoundException e2) {
            clazz = ClassGenerator.generate(iface, superclass, this.annotationsRegistry);
        }
        try {
            constructor = clazz.getConstructor(iface, Object.class, ProxyFactory.class, Map.class);
        }
        catch (NoSuchMethodException e3) {
            throw new RuntimeException(e3);
        }
        this.generatedRegistry.put(iface, superclass, new GeneratedProxiesRegistry.Value(null, null, clazz, constructor));
        return constructor;
    }

    private Class getProxyClass(Class mostSuitableIface, Class delegateClass) {
        if (null == delegateClass) {
            return null;
        }
        Class c2 = this.delegateClassToProxyClass.get(delegateClass);
        if (null != c2) {
            return EMPTY_VALUE != c2 ? c2 : null;
        }
        if (null == mostSuitableIface) {
            return null;
        }
        GeneratedProxiesRegistry.Value value = this.generatedRegistry.get(mostSuitableIface, this.annotationsRegistry.get(mostSuitableIface).getSuperclass());
        if (null == value) {
            return null;
        }
        Class proxyClass = value.getClazz();
        this.delegateClassToProxyClass.put(delegateClass, null != proxyClass ? proxyClass : EMPTY_VALUE);
        return proxyClass;
    }

    private Class findMostSuitableIface(Class delegateClass) {
        if (null == delegateClass) {
            return null;
        }
        Class c2 = this.delegateToMostSuitableIface.get(delegateClass);
        if (null != c2) {
            return EMPTY_VALUE != c2 ? c2 : null;
        }
        int max = -1;
        Class iface = null;
        for (Class i2 : this.annotationsRegistry.keySet()) {
            int c3 = this.intersectionCardinality(delegateClass, i2);
            if (c3 < 1 || c3 <= max) continue;
            max = c3;
            iface = i2;
        }
        this.delegateToMostSuitableIface.put(delegateClass, null != iface ? iface : EMPTY_VALUE);
        return iface;
    }

    private int intersectionCardinality(Class delegateClass, Class iface) {
        HashSet<Class> iSet = new HashSet<Class>();
        this.collectIfaces(iface, iSet);
        HashSet<Class> dSet = new HashSet<Class>();
        this.collectIfaces(delegateClass, dSet);
        int iCard = iSet.size();
        iSet.removeAll(dSet);
        if (iSet.size() > 0) {
            return -1;
        }
        return iCard;
    }

    private void collectIfaces(Class c2, Set<Class> set) {
        if (c2.isInterface()) {
            set.add(c2);
        }
        for (Class<?> iface : c2.getInterfaces()) {
            this.collectIfaces(iface, set);
        }
        Class superclass = c2.getSuperclass();
        if (null != superclass) {
            this.collectIfaces(superclass, set);
        }
    }

    private static final class EMPTY_CLASS {
        private EMPTY_CLASS() {
        }
    }
}

