/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.ProxyFactory;

public class ProxyExport {
    public static void main(String[] args) throws ClassNotFoundException, IOException {
        if (0 == args.length) {
            System.out.println("Usage:");
            System.out.println("java -classpath ojdbc6.jar oracle.jdbc.proxy.ProxyExport [-d dir] class1 class2 class3 ...");
            System.out.println("  dir - directory to store exported proxy classes");
            System.out.println("  class1 class2 class3 ... - superclasses equipped with @ProxyFor annotation");
            return;
        }
        int argsIndex = 0;
        String dir = "";
        if ("-d".equals(args[0])) {
            if (args.length < 2) {
                System.out.println("wrong directory");
                return;
            }
            dir = args[1];
            argsIndex = 2;
            if (!new File(dir).exists()) {
                System.out.println("target directory does not exist");
                return;
            }
            if (0 != dir.length() && !dir.endsWith(File.separator)) {
                dir = dir + File.separator;
            }
        }
        ArrayList clazzes = new ArrayList();
        while (argsIndex < args.length) {
            clazzes.add(Class.forName(args[argsIndex]));
            ++argsIndex;
        }
        ProxyFactory proxyFactory = ProxyFactory.createProxyFactory(clazzes.toArray(new Class[0]));
        AnnotationsRegistry annotationsRegistry = proxyFactory.annotationsRegistry;
        for (AnnotationsRegistry.Value value : annotationsRegistry.values()) {
            Class superclass = value.getSuperclass();
            for (Class iface : value.getIfacesToProxy()) {
                GeneratedProxiesRegistry.Key key = new GeneratedProxiesRegistry.Key(iface, superclass);
                byte[] bytecode = ClassGenerator.generateBytecode(key, proxyFactory.annotationsRegistry);
                String pathname = key.makePathname();
                int dirEnd = pathname.lastIndexOf(File.separator);
                if (-1 != dirEnd) {
                    String subdir = pathname.substring(0, dirEnd);
                    new File(dir + subdir).mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dir + pathname));
                out.write(bytecode);
                out.close();
            }
        }
    }
}

