/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.proxy.HashUtil;

class GeneratedProxiesRegistry {
    private Map<Key, Value> registry = Collections.synchronizedMap(new HashMap());

    GeneratedProxiesRegistry() {
    }

    void put(Class iface, Class superclass, Value value) {
        this.registry.put(new Key(iface, superclass), value);
    }

    Value get(Class iface, Class superclass) {
        return this.registry.get(new Key(iface, superclass));
    }

    int size() {
        return this.registry.size();
    }

    Set<Key> keySet() {
        return this.registry.keySet();
    }

    Collection<Value> values() {
        return this.registry.values();
    }

    static class Value {
        private final String name;
        private final String source;
        private final Class clazz;
        private final Constructor constructor;

        Value(String name, String source, Class clazz, Constructor constructor) {
            this.name = name;
            this.source = source;
            this.clazz = clazz;
            this.constructor = constructor;
        }

        String getName() {
            return this.name;
        }

        String getSource() {
            return this.source;
        }

        Class getClazz() {
            return this.clazz;
        }

        Constructor getConstructor() {
            return this.constructor;
        }
    }

    static class Key {
        private final String PREFIX = "oracle.jdbc.proxy.";
        private final String SUFFIX = "$$$Proxy";
        private final Class iface;
        private final Class superclass;
        private Integer hashCode = null;

        Key(Class iface, Class superclass) {
            this.iface = iface;
            this.superclass = superclass;
        }

        Key(String proxyClassName) {
            this.iface = this.parseIface(proxyClassName);
            this.superclass = this.parseSuperclass(proxyClassName);
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            try {
                Key that = (Key)obj;
                return this.iface.equals(that.iface) && this.superclass.equals(that.superclass);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            if (null == this.hashCode) {
                this.hashCode = 23;
                this.hashCode = HashUtil.hash((int)this.hashCode, this.iface);
                this.hashCode = HashUtil.hash((int)this.hashCode, this.superclass);
            }
            return this.hashCode;
        }

        public String toString() {
            return "oracle.jdbc.proxy." + this.superclass.getName().replace(".", "$1") + "$2" + this.iface.getName().replace(".", "$1") + "$$$Proxy";
        }

        private Class parseSuperclass(String name) {
            try {
                String s2 = name.substring("oracle.jdbc.proxy.".length());
                String ss = s2.replaceAll("\\$1", ".");
                String sss = ss.substring(0, ss.indexOf("$2"));
                return Class.forName(sss);
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        }

        private Class parseIface(String name) {
            try {
                String s2 = name.substring("oracle.jdbc.proxy.".length());
                String ss = s2.replaceAll("\\$1", ".");
                String sss = ss.substring(ss.indexOf("$2") + 2, ss.indexOf("$$$Proxy"));
                return Class.forName(sss);
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        }

        public Class getIface() {
            return this.iface;
        }

        public Class getSuperclass() {
            return this.superclass;
        }

        public String makePathname() {
            return this.toString().replace(".", "/") + ".class";
        }
    }
}

