/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

class OracleDatabaseInstance {
    String databaseUniqName = null;
    String instanceName = null;
    int percent = 0;
    int flag = 0;
    int attemptedConnRequestCount = 0;
    int numberOfConnectionsCount = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleDatabaseInstance(String dbUniqNameKey, String instNameKey) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDatabaseInstance.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(instNameKey));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.databaseUniqName = dbUniqNameKey;
            this.instanceName = instNameKey;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleDatabaseInstance.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleDatabaseInstance"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

