/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverEventHandlerThread;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.ons.ONS;
import oracle.ons.ONSException;

public class OracleConnectionCacheManager {
    private static OracleConnectionCacheManager cacheManagerInstance = null;
    protected Hashtable m_connCache = null;
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
    public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
    protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
    protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
    protected static final String EVENT_DELIMITER = "{} =";
    protected OracleFailoverEventHandlerThread failoverEventHandlerThread = null;
    private static boolean isONSInitializedForRemoteSubscription = false;
    static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected int[] fatalErrorCodes = null;
    protected int failoverEnabledCacheCount = 0;
    protected static AtomicInteger UNNAMED_CACHE_COUNT;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleConnectionCacheManager() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.m_connCache = new Hashtable();
            UNNAMED_CACHE_COUNT = new AtomicInteger();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            block24: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    if (cacheManagerInstance == null) {
                        cacheManagerInstance = new OracleConnectionCacheManager();
                    }
                }
                catch (RuntimeException re) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block24;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_10, "         Event: OracleConnectionCacheManager.getConnectionCacheManagerInstance(): RuntimeException : " + re.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, "         Return: " + cacheManagerInstance);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnectionCacheManager oracleConnectionCacheManager = cacheManagerInstance;
            return oracleConnectionCacheManager;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createCache(OracleDataSource ods, Properties cacheProperties) throws SQLException {
        String string;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(ods) + ", " + OracleLog.argument(cacheProperties));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String connectionCacheName = null;
            if (ods == null || !ods.getConnectionCachingEnabled()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 137);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            connectionCacheName = ods.connCacheName != null ? ods.connCacheName : ods.dataSourceName + "#0x" + Integer.toHexString(UNNAMED_CACHE_COUNT.getAndIncrement());
            this.createCache(connectionCacheName, ods, cacheProperties);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connectionCacheName);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = connectionCacheName;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCache(String cacheName, OracleDataSource ods, Properties cacheProperties) throws SQLException {
        long __ol_nanos__;
        block50: {
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(ods) + ", " + OracleLog.argument(cacheProperties));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (ods == null || !ods.getConnectionCachingEnabled()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 137);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 137);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (cacheName == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 138);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 138);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.m_connCache.containsKey(cacheName)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 140);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 140);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                boolean _odsIsFcfEnabled = ods.getFastConnectionFailoverEnabled();
                if (_odsIsFcfEnabled && this.failoverEventHandlerThread == null) {
                    final String onsConfigStr = ods.getONSConfiguration();
                    if (onsConfigStr != null && !onsConfigStr.equals("")) {
                        OracleConnectionCacheManager oracleConnectionCacheManager = this;
                        synchronized (oracleConnectionCacheManager) {
                            if (!isONSInitializedForRemoteSubscription) {
                                try {
                                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                        public Object run() throws ONSException {
                                            ONS ons = new ONS(onsConfigStr);
                                            return null;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException onsexc) {
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 175 + onsexc);
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                    }
                                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 175, onsexc);
                                    __ex__.fillInStackTrace();
                                    throw __ex__;
                                }
                                isONSInitializedForRemoteSubscription = true;
                            }
                        }
                    }
                    this.failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
                }
                OracleImplicitConnectionCache icc = new OracleImplicitConnectionCache(ods, cacheProperties);
                icc.cacheName = cacheName;
                ods.odsCache = icc;
                this.m_connCache.put(cacheName, icc);
                if (_odsIsFcfEnabled) {
                    this.checkAndStartThread(this.failoverEventHandlerThread);
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block50;
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String cacheName, long waitTimeout) throws SQLException {
        long __ol_nanos__;
        block28: {
            __ol_nanos__ = 0L;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(waitTimeout));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.remove(cacheName) : null;
                if (oicc != null) {
                    block27: {
                        oicc.disableConnectionCache();
                        if (waitTimeout > 0L) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(waitTimeout * 1000L);
                            }
                            catch (InterruptedException ea) {
                                if (!TRACE || !OracleLog.recursiveEnter()) break block27;
                                try {
                                    OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager." + "removeCache() - Exception Occurred : " + ea.getMessage());
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                        }
                    }
                    if (oicc.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                        this.cleanupFCFThreads(oicc);
                    }
                    oicc.closeConnectionCache(waitTimeout < 0L ? 32 : 1);
                    oicc = null;
                    break block28;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitializeCache(String cacheName, Properties cacheProperties) throws SQLException {
        long __ol_nanos__;
        block20: {
            __ol_nanos__ = 0L;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(cacheProperties));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    this.disableCache(cacheName);
                    oicc.reinitializeCacheConnections(cacheProperties);
                    this.enableCache(cacheName);
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsCache(String cacheName) throws SQLException {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean __result__ = this.m_connCache.containsKey(cacheName);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCache(String cacheName) throws SQLException {
        long __ol_nanos__;
        block20: {
            __ol_nanos__ = 0L;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    oicc.enableConnectionCache();
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCache(String cacheName) throws SQLException {
        long __ol_nanos__;
        block20: {
            __ol_nanos__ = 0L;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    oicc.disableConnectionCache();
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCache(String cacheName, int mode) throws SQLException {
        long __ol_nanos__;
        block26: {
            __ol_nanos__ = 0L;
            try {
                block29: {
                    OracleImplicitConnectionCache oicc;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(mode));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                        __ol_nanos__ = System.nanoTime();
                    }
                    OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                    if (oicc == null) break block29;
                    switch (mode) {
                        case 4096: 
                        case 8192: {
                            oicc.refreshCacheConnections(mode);
                            break block26;
                        }
                        default: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeCache(String cacheName, boolean cleanupCheckedOutConnections) throws SQLException {
        long __ol_nanos__;
        block20: {
            __ol_nanos__ = 0L;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(cleanupCheckedOutConnections));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    oicc.purgeCacheConnections(cleanupCheckedOutConnections, 1);
                    break block20;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getCacheProperties(String cacheName) throws SQLException {
        block20: {
            Properties properties;
            long __ol_nanos__ = 0L;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc == null) break block20;
                properties = oicc.getConnectionCacheProperties();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return properties;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCacheNameList() throws SQLException {
        String[] stringArray;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String[] sArray = this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sArray);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            stringArray = sArray;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableConnections(String cacheName) throws SQLException {
        block20: {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc == null) break block20;
                n2 = oicc.cacheSize;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfActiveConnections(String cacheName) throws SQLException {
        block20: {
            int n2;
            long __ol_nanos__ = 0L;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc == null) break block20;
                n2 = oicc.getNumberOfCheckedOutConnections();
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionPoolDataSource(String cacheName, ConnectionPoolDataSource ds) throws SQLException {
        long __ol_nanos__;
        block26: {
            __ol_nanos__ = 0L;
            try {
                OracleImplicitConnectionCache oicc;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName) + ", " + OracleLog.argument(ds));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc != null) {
                    if (oicc.cacheSize > 0) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 78);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 78);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    ((OracleConnectionPoolDataSource)ds).makeURL();
                    ((OracleConnectionPoolDataSource)ds).setURL(((OracleConnectionPoolDataSource)ds).url);
                    oicc.connectionPoolDS = (OracleConnectionPoolDataSource)ds;
                    break block26;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 141);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 141);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyAndHandleEvent(int eventType, byte[] eventBody) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            StringTokenizer strTokens;
            int cardinality;
            String status;
            String hostNameKey;
            String dbUniqNameKey;
            String instNameKey;
            String svcName;
            block41: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(eventType) + ", " + OracleLog.argument(eventBody));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                svcName = null;
                instNameKey = null;
                dbUniqNameKey = null;
                hostNameKey = null;
                status = null;
                cardinality = 0;
                strTokens = null;
                try {
                    strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), EVENT_DELIMITER, true);
                }
                catch (UnsupportedEncodingException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block41;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager : verifyAndHandleEvent()" + " - UTF-8 Encoding Exception" + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            String st = null;
            String val = null;
            String key = null;
            while (strTokens.hasMoreTokens()) {
                val = null;
                st = strTokens.nextToken();
                if (st.equals("=") && strTokens.hasMoreTokens()) {
                    val = strTokens.nextToken();
                } else {
                    key = st;
                }
                if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 146);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 146);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (key.equalsIgnoreCase("service") && val != null) {
                    svcName = val;
                }
                if (key.equalsIgnoreCase("instance") && val != null && !val.equals(" ")) {
                    instNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("database") && val != null) {
                    dbUniqNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("host") && val != null) {
                    hostNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("status") && val != null) {
                    status = val;
                }
                if (!key.equalsIgnoreCase("card") || val == null) continue;
                try {
                    cardinality = Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager : verifyAndHandleEvent()" + " - Cardinality value= " + val + " : Error : " + nfe.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            this.invokeFailoverProcessingThreads(eventType, svcName, instNameKey, dbUniqNameKey, hostNameKey, status, cardinality);
            strTokens = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeFailoverProcessingThreads(int eventType, String svcName, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(eventType) + ", " + OracleLog.argument(svcName) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status) + ", " + OracleLog.argument(card));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleImplicitConnectionCache oicc2 = null;
            boolean serviceEvent = false;
            boolean hostEvent = false;
            if (eventType == 256) {
                serviceEvent = true;
            }
            if (eventType == 512) {
                hostEvent = true;
            }
            for (OracleImplicitConnectionCache oicc2 : this.m_connCache.values()) {
                if ((!serviceEvent || !svcName.equalsIgnoreCase(oicc2.dataSourceServiceName)) && !hostEvent) continue;
                OracleFailoverWorkerThread workerTh = new OracleFailoverWorkerThread(oicc2, eventType, instNameKey, dbUniqNameKey, hostNameKey, status, card);
                this.checkAndStartThread(workerTh);
                oicc2.failoverWorkerThread = workerTh;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndStartThread(Thread thr) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            block24: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(thr));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    if (!thr.isAlive()) {
                        thr.setDaemon(true);
                        thr.start();
                    }
                }
                catch (IllegalThreadStateException ie) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block24;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager.checkAndStartThread()" + " - IllegalThreadStateException occurred:" + ie.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean failoverEnabledCacheExists() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.failoverEnabledCacheCount > 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRuntimeLoadBalancingEvent(String service, byte[] eventBody) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(service) + ", " + OracleLog.argument(eventBody));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            OracleImplicitConnectionCache icc = null;
            Enumeration iccSet = this.m_connCache.elements();
            while (iccSet.hasMoreElements()) {
                try {
                    icc = (OracleImplicitConnectionCache)iccSet.nextElement();
                    if (!service.equalsIgnoreCase(icc.dataSourceServiceName)) continue;
                    if (eventBody == null) {
                        icc.zapRLBInfo();
                        continue;
                    }
                    this.retrieveServiceMetrics(icc, eventBody);
                }
                catch (Exception e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleConnectionCacheManager." + "parseRuntimeLoadBalancingEvent():" + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveServiceMetrics(OracleImplicitConnectionCache icc, byte[] eventBody) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            boolean updateNecessary;
            int flag;
            int percent;
            String dbUniqNameKey;
            String instNameKey;
            StringTokenizer strTokens;
            block45: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(icc) + ", " + OracleLog.argument(eventBody));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                strTokens = null;
                instNameKey = null;
                dbUniqNameKey = null;
                percent = 0;
                flag = 0;
                updateNecessary = false;
                try {
                    strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), EVENT_DELIMITER, true);
                }
                catch (UnsupportedEncodingException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block45;
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager : retrieveServiceMetrics" + "() - (RLB)UTF-8 Encoding Exception:" + e2.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
            String st = null;
            String val = null;
            String key = null;
            while (strTokens.hasMoreTokens()) {
                block47: {
                    val = null;
                    st = strTokens.nextToken();
                    if (st.equals("=") && strTokens.hasMoreTokens()) {
                        val = strTokens.nextToken();
                    } else {
                        if (st.equals("}")) {
                            if (!updateNecessary) continue;
                            icc.updateDatabaseInstance(dbUniqNameKey, instNameKey, percent, flag);
                            updateNecessary = false;
                            continue;
                        }
                        if (st.equals("{") || st.equals(" ")) continue;
                        key = st;
                        updateNecessary = true;
                    }
                    if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleConnectionCacheManager.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 146);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 146);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (key.equalsIgnoreCase("database") && val != null) {
                        dbUniqNameKey = val.toLowerCase().intern();
                    }
                    if (key.equalsIgnoreCase("instance") && val != null) {
                        instNameKey = val.toLowerCase().intern();
                    }
                    if (key.equalsIgnoreCase("percent") && val != null) {
                        try {
                            percent = Integer.parseInt(val);
                            if (percent == 0) {
                                percent = 1;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (!TRACE || !OracleLog.recursiveEnter()) break block47;
                            try {
                                OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "(RLB)OracleConnectionCacheManager.retrieveServiceMetrics" + "() - Exception occurred : (RLB)percent value= " + val + nfe.getMessage());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                }
                if (!key.equalsIgnoreCase("flag") || val == null) continue;
                if (val.equalsIgnoreCase("good")) {
                    flag = 1;
                    continue;
                }
                if (val.equalsIgnoreCase("violating")) {
                    flag = 3;
                    continue;
                }
                if (val.equalsIgnoreCase("NO_DATA")) {
                    flag = 4;
                    continue;
                }
                if (val.equalsIgnoreCase("UNKNOWN")) {
                    flag = 2;
                    continue;
                }
                if (!val.equalsIgnoreCase("BLOCKED")) continue;
                flag = 5;
            }
            icc.processDatabaseInstances();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupFCFThreads(OracleImplicitConnectionCache oicc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.cleanupFCFWorkerThread(oicc);
            oicc.cleanupRLBThreads();
            if (this.failoverEnabledCacheCount <= 0) {
                this.cleanupFCFEventHandlerThread();
            }
            --this.failoverEnabledCacheCount;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache oicc) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oicc));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (oicc.failoverWorkerThread != null) {
                block25: {
                    try {
                        if (oicc.failoverWorkerThread.isAlive()) {
                            oicc.failoverWorkerThread.join();
                        }
                    }
                    catch (InterruptedException e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block25;
                        try {
                            OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager.cleanupFCFWorkerThread(" + ") - Exception occurred:" + e2.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                oicc.failoverWorkerThread = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupFCFEventHandlerThread() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.failoverEventHandlerThread != null) {
                block24: {
                    try {
                        this.failoverEventHandlerThread.interrupt();
                    }
                    catch (Exception e2) {
                        if (!TRACE || !OracleLog.recursiveEnter()) break block24;
                        try {
                            OracleConnectionCacheManager.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleConnectionCacheManager.cleanupFCFEventHandlerThread" + "() - Exception occurred:" + e2.getMessage());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                }
                this.failoverEventHandlerThread = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFatalConnectionError(SQLException se) {
        boolean bl;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(se));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean retCode = false;
            int errCode = se.getErrorCode();
            if (errCode == 3113 || errCode == 3114 || errCode == 1033 || errCode == 1034 || errCode == 1089 || errCode == 1090 || errCode == 17002) {
                retCode = true;
            }
            if (!retCode && this.fatalErrorCodes != null) {
                for (int i2 = 0; i2 < this.fatalErrorCodes.length; ++i2) {
                    if (errCode != this.fatalErrorCodes[i2]) continue;
                    retCode = true;
                    break;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + retCode);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bl = retCode;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setConnectionErrorCodes(int[] fatalErrorCodes) throws SQLException {
        long __ol_nanos__;
        block19: {
            __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(fatalErrorCodes));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                if (fatalErrorCodes != null) {
                    this.fatalErrorCodes = fatalErrorCodes;
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block19;
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getConnectionErrorCodes() throws SQLException {
        int[] nArray;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.fatalErrorCodes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            nArray = this.fatalErrorCodes;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStatistics(String cacheName) throws SQLException {
        Map map;
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cacheName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Map map2 = null;
            OracleImplicitConnectionCache icc = null;
            if (this.m_connCache != null && (icc = (OracleImplicitConnectionCache)this.m_connCache.get(cacheName)) != null) {
                map2 = icc.getStatistics();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + map2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            map = map2;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConnectionCacheManager.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionCacheManager.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

