/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeNUMBER
extends OracleType
implements Serializable {
    static final long serialVersionUID = -7182242886677299812L;
    int precision;
    int scale;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleTypeNUMBER() {
        block12: {
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleTypeNUMBER.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeNUMBER.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleTypeNUMBER(int typecode) {
        block12: {
            super(typecode);
            long __ol_nanos__ = 0L;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    OracleTypeNUMBER.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(typecode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeNUMBER.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            NUMBER __result__ = OracleTypeNUMBER.toNUMBER(value, conn);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER nUMBER = __result__;
            return nUMBER;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Datum[] __result__ = OracleTypeNUMBER.toNUMBERArray(obj, conn, beginIdx, count);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = __result__;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tdsReader));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.precision = tdsReader.readUnsignedByte();
            this.scale = tdsReader.readByte();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object unpickle81NativeArray(PickleContext context, long beginIdx, int size, int style) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(style));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            int i2 = 1;
            while ((long)i2 < beginIdx && size > 0) {
                context.skipDataValue();
                ++i2;
            }
            byte[] val = null;
            switch (style) {
                case 4: {
                    int[] holder = new int[size];
                    for (int i3 = 0; i3 < size; ++i3) {
                        val = context.readDataValue();
                        if (val == null) continue;
                        holder[i3] = NUMBER.toInt(val);
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + holder);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int[] i3 = holder;
                    return i3;
                }
                case 5: {
                    double[] holder = new double[size];
                    for (int i4 = 0; i4 < size; ++i4) {
                        val = context.readDataValue();
                        if (val == null) continue;
                        holder[i4] = NUMBER.toDouble(val);
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + holder);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    double[] i4 = holder;
                    return i4;
                }
                case 7: {
                    long[] holder = new long[size];
                    for (int i5 = 0; i5 < size; ++i5) {
                        val = context.readDataValue();
                        if (val == null) continue;
                        holder[i5] = NUMBER.toLong(val);
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + holder);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long[] i5 = holder;
                    return i5;
                }
                case 6: {
                    float[] holder = new float[size];
                    for (int i6 = 0; i6 < size; ++i6) {
                        val = context.readDataValue();
                        if (val == null) continue;
                        holder[i6] = NUMBER.toFloat(val);
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + holder);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    float[] i6 = holder;
                    return i6;
                }
                case 8: {
                    short[] holder = new short[size];
                    for (int i7 = 0; i7 < size; ++i7) {
                        val = context.readDataValue();
                        if (val == null) continue;
                        holder[i7] = NUMBER.toShort(val);
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + holder);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    short[] sArray = holder;
                    return sArray;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(Level.SEVERE, "         Throwing SQLException: 23");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 23);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object toObject(byte[] bytes, int style, Map map) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Object __result__ = OracleTypeNUMBER.toNumericObject(bytes, style, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = __result__;
            return object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object toNumericObject(byte[] bytes, int style, Map map) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (bytes == null || bytes.length == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object var5_5 = null;
                return var5_5;
            }
            switch (style) {
                case 1: {
                    NUMBER __result__ = new NUMBER(bytes);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    NUMBER nUMBER = __result__;
                    return nUMBER;
                }
                case 2: {
                    BigDecimal __result__ = NUMBER.toBigDecimal(bytes);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    BigDecimal bigDecimal = __result__;
                    return bigDecimal;
                }
                case 3: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + bytes);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    byte[] __result__ = bytes;
                    return __result__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(Level.SEVERE, "         Throwing SQLException: 23");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 23);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NUMBER toNUMBER(Object value, OracleConnection conn) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            NUMBER datum = null;
            if (value != null) {
                try {
                    datum = value instanceof NUMBER ? (NUMBER)value : new NUMBER(value);
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(Level.SEVERE, "         Throwing SQLException: 59" + value);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 59, value);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + datum);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER nUMBER = datum;
            return nUMBER;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datum[] toNUMBERArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Datum[] datumArray = null;
            if (obj != null) {
                if (obj instanceof Object[] && !(obj instanceof char[][])) {
                    Object[] objArray = (Object[])obj;
                    int length = (int)(count == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[length];
                    for (int i2 = 0; i2 < length; ++i2) {
                        datumArray[i2] = OracleTypeNUMBER.toNUMBER(objArray[(int)beginIdx + i2 - 1], conn);
                    }
                } else {
                    datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(obj, conn, beginIdx, count);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + datumArray);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray2 = datumArray;
            return datumArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Datum[] cArrayToNUMBERArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            Datum[] datumArray = null;
            if (obj != null) {
                Object parray;
                if (obj instanceof short[]) {
                    parray = (short[])obj;
                    int len = (int)(count == -1 ? (long)((short[])parray).length : Math.min((long)((short[])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i2 = 0; i2 < len; ++i2) {
                        datumArray[i2] = new NUMBER(parray[(int)beginIdx + i2 - 1]);
                    }
                } else if (obj instanceof int[]) {
                    parray = (int[])obj;
                    int len = (int)(count == -1 ? (long)((short[])parray).length : Math.min((long)((short[])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i3 = 0; i3 < len; ++i3) {
                        datumArray[i3] = new NUMBER((int)parray[(int)beginIdx + i3 - 1]);
                    }
                } else if (obj instanceof long[]) {
                    parray = (long[])obj;
                    int len = (int)(count == -1 ? (long)((short[])parray).length : Math.min((long)((short[])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i4 = 0; i4 < len; ++i4) {
                        datumArray[i4] = new NUMBER((long)parray[(int)beginIdx + i4 - 1]);
                    }
                } else if (obj instanceof float[]) {
                    parray = (float[])obj;
                    int len = (int)(count == -1 ? (long)((short[])parray).length : Math.min((long)((short[])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i5 = 0; i5 < len; ++i5) {
                        datumArray[i5] = new NUMBER((float)parray[(int)beginIdx + i5 - 1]);
                    }
                } else if (obj instanceof double[]) {
                    parray = (double[])obj;
                    int len = (int)(count == -1 ? (long)((short[])parray).length : Math.min((long)((short[])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i6 = 0; i6 < len; ++i6) {
                        datumArray[i6] = new NUMBER((double)parray[(int)beginIdx + i6 - 1]);
                    }
                } else if (obj instanceof boolean[]) {
                    parray = (boolean[])obj;
                    int len = (int)(count == -1 ? (long)((short[])parray).length : Math.min((long)((short[])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i7 = 0; i7 < len; ++i7) {
                        datumArray[i7] = new NUMBER((Object)parray[(int)beginIdx + i7 - 1]);
                    }
                } else if (obj instanceof char[][]) {
                    parray = (char[][])obj;
                    int len = (int)(count == -1 ? (long)((short[])parray).length : Math.min((long)((short[])parray).length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[len];
                    for (int i8 = 0; i8 < len; ++i8) {
                        datumArray[i8] = new NUMBER(new String((char[])parray[(int)beginIdx + i8 - 1]));
                    }
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeNUMBER.logger().log(Level.SEVERE, "         Throwing SQLException: 59" + obj);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 59, obj);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Return: " + datumArray);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray2 = datumArray;
            return datumArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, "         Exit [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPrecision() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.precision);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.precision;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScale() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.scale);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.scale;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(out));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            out.writeInt(this.scale);
            out.writeInt(this.precision);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(in));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.scale = in.readInt();
            this.precision = in.readInt();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleTypeNUMBER.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeNUMBER"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

