/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestampltzAccessor
extends DateTimeCommonAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestampltzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, 231, 231, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestampltzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.init(stmt, 231, 231, form, false);
            this.initForDescribe(231, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = 11;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = this.internalTypeMaxLength;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String __ex__ = null;
                return __ex__;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 198);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            TimeZone zone = TimeZone.getTimeZone(sessTzStr);
            Calendar sessTzCal = Calendar.getInstance(zone);
            int off = this.columnIndex + this.byteLength * currentRow;
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            int year = this.oracleYear(off);
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(off));
            dbTzCal.set(5, this.oracleDay(off));
            dbTzCal.set(11, this.oracleHour(off));
            dbTzCal.set(12, this.oracleMin(off));
            dbTzCal.set(13, this.oracleSec(off));
            dbTzCal.set(14, 0);
            this.TimeZoneAdjust(dbTzCal, sessTzCal);
            year = sessTzCal.get(1);
            int month = sessTzCal.get(2) + 1;
            int date = sessTzCal.get(5);
            int hour = sessTzCal.get(11);
            int minute = sessTzCal.get(12);
            int second = sessTzCal.get(13);
            int nanos = 0;
            boolean am = hour < 12;
            String regname = sessTzCal.getTimeZone().getID();
            if (regname.length() > 3 && regname.startsWith("GMT")) {
                regname = regname.substring(3);
            }
            if (len == 11) {
                nanos = this.oracleNanos(off);
            }
            String __result__ = this.toText(year, month, date, hour, minute, second, nanos, am, regname);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    Date getDate(int currentRow, Calendar cal) throws SQLException {
        return this.getDate(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Date getDate(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Date __ex__ = null;
                return __ex__;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 198);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            TimeZone zone = TimeZone.getTimeZone(sessTzStr);
            Calendar sessTzCal = Calendar.getInstance(zone);
            int off = this.columnIndex + this.byteLength * currentRow;
            int year = this.oracleYear(off);
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(off));
            dbTzCal.set(5, this.oracleDay(off));
            dbTzCal.set(11, this.oracleHour(off));
            dbTzCal.set(12, this.oracleMin(off));
            dbTzCal.set(13, this.oracleSec(off));
            dbTzCal.set(14, 0);
            long millis = this.TimeZoneAdjustUTC(dbTzCal);
            Date __result__ = new Date(millis);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date = __result__;
            return date;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    Time getTime(int currentRow, Calendar cal) throws SQLException {
        return this.getTime(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Time getTime(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Time __ex__ = null;
                return __ex__;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 198);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            TimeZone zone = TimeZone.getTimeZone(sessTzStr);
            Calendar sessTzCal = Calendar.getInstance(zone);
            int off = this.columnIndex + this.byteLength * currentRow;
            int year = this.oracleYear(off);
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(off));
            dbTzCal.set(5, this.oracleDay(off));
            dbTzCal.set(11, this.oracleHour(off));
            dbTzCal.set(12, this.oracleMin(off));
            dbTzCal.set(13, this.oracleSec(off));
            dbTzCal.set(14, 0);
            long millis = this.TimeZoneAdjustUTC(dbTzCal);
            Time __result__ = new Time(millis);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = __result__;
            return time;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    Timestamp getTimestamp(int currentRow, Calendar cal) throws SQLException {
        return this.getTimestamp(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Timestamp __ex__ = null;
                return __ex__;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 198);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            TimeZone zone = TimeZone.getTimeZone(sessTzStr);
            Calendar sessTzCal = Calendar.getInstance(zone);
            int off = this.columnIndex + this.byteLength * currentRow;
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            int year = this.oracleYear(off);
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(off));
            dbTzCal.set(5, this.oracleDay(off));
            dbTzCal.set(11, this.oracleHour(off));
            dbTzCal.set(12, this.oracleMin(off));
            dbTzCal.set(13, this.oracleSec(off));
            dbTzCal.set(14, 0);
            long millis = this.TimeZoneAdjustUTC(dbTzCal);
            Timestamp result = new Timestamp(millis);
            if (len == 11) {
                result.setNanos(this.oracleNanos(off));
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = __result__;
            return tIMESTAMPLTZ;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = __result__;
            return tIMESTAMPLTZ;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow, Map map) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = __result__;
            return tIMESTAMPLTZ;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            TIMESTAMPLTZ result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                byte[] data = new byte[len];
                System.arraycopy(this.rowSpaceByte, off, data, 0, len);
                result = new TIMESTAMPLTZ(data);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = result;
            return tIMESTAMPLTZ;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            TIMESTAMPTZ result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                byte[] data = new byte[len];
                System.arraycopy(this.rowSpaceByte, off, data, 0, len);
                result = oracle.sql.TIMESTAMPLTZ.toTIMESTAMPTZ(this.statement.connection, data);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ tIMESTAMPTZ = result;
            return tIMESTAMPTZ;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        TIMESTAMPTZ tmtz = this.getTIMESTAMPTZ(currentRow);
        return oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tmtz.getBytes());
    }

    @Override
    DATE getDATE(int currentRow) throws SQLException {
        TIMESTAMPTZ tmtz = this.getTIMESTAMPTZ(currentRow);
        return oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tmtz.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void TimeZoneAdjust(Calendar cal1, Calendar cal2) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cal1) + ", " + OracleLog.argument(cal2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            String cal1String = cal1.getTimeZone().getID();
            String cal2String = cal2.getTimeZone().getID();
            if (!cal2String.equals(cal1String)) {
                int Offset_gmt;
                OffsetDST trans_db = new OffsetDST();
                byte dbolap = this.getZoneOffset(cal1, trans_db);
                int offset = trans_db.getOFFSET();
                cal1.add(11, -(offset / 3600000));
                cal1.add(12, -(offset % 3600000) / 60000);
                if (cal2String.equals("Custom") || cal2String.startsWith("GMT") && cal2String.length() > 3) {
                    Offset_gmt = cal2.getTimeZone().getRawOffset();
                } else {
                    int regionID = ZONEIDMAP.getID(cal2String);
                    if (!ZONEIDMAP.isValidID(regionID)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 199);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 199);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(this.statement.connection, regionID);
                    }
                    Calendar calUTC = this.statement.getGMTCalendar();
                    calUTC.set(1, cal1.get(1));
                    calUTC.set(2, cal1.get(2));
                    calUTC.set(5, cal1.get(5));
                    calUTC.set(11, cal1.get(11));
                    calUTC.set(12, cal1.get(12));
                    calUTC.set(13, cal1.get(13));
                    calUTC.set(14, cal1.get(14));
                    Offset_gmt = tzTab.getOffset(calUTC, regionID);
                }
                cal1.add(11, Offset_gmt / 3600000);
                cal1.add(12, Offset_gmt % 3600000 / 60000);
            }
            if (cal2String.equals("Custom") && cal1String.equals("Custom") || cal2String.startsWith("GMT") && cal2String.length() > 3 && cal1String.startsWith("GMT") && cal1String.length() > 3) {
                int offset1 = cal1.getTimeZone().getRawOffset();
                int offset2 = cal2.getTimeZone().getRawOffset();
                int net_offset = 0;
                if (offset1 != offset2) {
                    net_offset = offset1 - offset2;
                    int n2 = net_offset = net_offset > 0 ? net_offset : -net_offset;
                }
                if (offset1 > offset2) {
                    net_offset = -net_offset;
                }
                cal1.add(11, net_offset / 3600000);
                cal1.add(12, net_offset % 3600000 / 60000);
            }
            int year = cal1.get(1);
            int month = cal1.get(2);
            int day = cal1.get(5);
            int hour = cal1.get(11);
            int minute = cal1.get(12);
            int second = cal1.get(13);
            int msecond = cal1.get(14);
            cal2.set(1, year);
            cal2.set(2, month);
            cal2.set(5, day);
            cal2.set(11, hour);
            cal2.set(12, minute);
            cal2.set(13, second);
            cal2.set(14, msecond);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long TimeZoneAdjustUTC(Calendar cal1) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            String cal1String;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cal1));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if ((cal1String = cal1.getTimeZone().getID()).equals("Custom") || cal1String.startsWith("GMT") && cal1String.length() > 3) {
                int offset = cal1.getTimeZone().getRawOffset();
                cal1.add(11, -(offset / 3600000));
                cal1.add(12, -(offset % 3600000) / 60000);
            } else if (!cal1String.equals("GMT") && !cal1String.equals("UTC")) {
                OffsetDST trans_db = new OffsetDST();
                byte dbolap = this.getZoneOffset(cal1, trans_db);
                int offset = trans_db.getOFFSET();
                cal1.add(11, -(offset / 3600000));
                cal1.add(12, -(offset % 3600000) / 60000);
            }
            int year = cal1.get(1);
            int month = cal1.get(2);
            int day = cal1.get(5);
            int hour = cal1.get(11);
            int minute = cal1.get(12);
            int second = cal1.get(13);
            int msecond = cal1.get(14);
            Calendar calUTC = this.statement.getGMTCalendar();
            calUTC.set(1, year);
            calUTC.set(2, month);
            calUTC.set(5, day);
            calUTC.set(11, hour);
            calUTC.set(12, minute);
            calUTC.set(13, second);
            calUTC.set(14, msecond);
            long tstamp = calUTC.getTimeInMillis();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tstamp);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = tstamp;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getZoneOffset(Calendar cal, OffsetDST tempVar) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cal) + ", " + OracleLog.argument(tempVar));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            byte olap = 0;
            String timeZone = cal.getTimeZone().getID();
            if (timeZone == "Custom" || timeZone.startsWith("GMT") && timeZone.length() > 3) {
                tempVar.setOFFSET(cal.getTimeZone().getRawOffset());
            } else {
                int regionID = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionID)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 199);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 199);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID)) {
                    tzTab.updateTable(this.statement.connection, regionID);
                }
                olap = tzTab.getLocalOffset(cal, regionID, tempVar);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + olap);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = olap;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.TimestampltzAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

