/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

final class T4CTTIspfp
extends T4CTTIfun {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIspfp(T4CConnection _connection) {
        super(_connection, (byte)3);
        this.setFunCode((short)138);
    }

    void doOSPFPPUT() throws IOException, SQLException {
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalPTR();
        this.meg.marshalSWORD(100);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
    }

    @Override
    void readRPA() throws IOException, SQLException {
        int length = this.meg.unmarshalUB2();
        byte[] warning = this.meg.unmarshalNBytes(length);
        if (length > 1) {
            String warningStr = this.meg.conv.CharBytesToString(warning, length, true);
            SQLWarning newsqlwarning = new SQLWarning(warningStr);
            SQLWarning sqlwarning = this.connection.getWarnings();
            if (sqlwarning == null) {
                this.connection.setWarnings(newsqlwarning);
            } else {
                sqlwarning.setNextWarning(newsqlwarning);
            }
        }
        this.meg.unmarshalUB2();
        this.meg.unmarshalUB2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIspfp.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIspfp.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIspfp.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIspfp"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

