/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIrxd
extends T4CTTIMsg {
    static final byte[] NO_BYTES = new byte[0];
    byte[] buffer;
    byte[] bufferCHAR;
    BitSet bvcColSent = null;
    int nbOfColumns = 0;
    boolean bvcFound = false;
    boolean isFirstCol = true;
    static final byte TTICMD_UNAUTHORIZED = 1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIrxd(T4CConnection _conn) {
        super(_conn, (byte)7);
    }

    void init() {
        this.isFirstCol = true;
    }

    void setNumberOfColumns(int nbCol) {
        this.nbOfColumns = nbCol;
        this.bvcFound = false;
        if (this.bvcColSent == null || this.bvcColSent.length() < this.nbOfColumns) {
            this.bvcColSent = new BitSet(this.nbOfColumns);
        } else {
            this.bvcColSent.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmarshalBVC(int nbOfColumnSent) throws SQLException, IOException {
        int nbOfOnBits = 0;
        for (int i2 = 0; i2 < this.bvcColSent.length(); ++i2) {
            this.bvcColSent.clear(i2);
        }
        int nbOfUB1 = this.nbOfColumns / 8 + (this.nbOfColumns % 8 != 0 ? 1 : 0);
        for (int ub1 = 0; ub1 < nbOfUB1; ++ub1) {
            byte bvc = (byte)(this.meg.unmarshalUB1() & 0xFF);
            for (int bit = 0; bit < 8; ++bit) {
                if ((bvc & 1 << bit) == 0) continue;
                this.bvcColSent.set(ub1 * 8 + bit);
                ++nbOfOnBits;
            }
        }
        if (nbOfOnBits != nbOfColumnSent) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIrxd.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + -1 + "INTERNAL ERROR: oracle.jdbc.driver." + "T4CTTIrxd.unmarshalBVC: bits missing in vector");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.unmarshalBVC: bits missing in vector");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        this.bvcFound = true;
    }

    void readBitVector(byte[] bitVec) throws SQLException, IOException {
        int i2;
        for (i2 = 0; i2 < this.bvcColSent.length(); ++i2) {
            this.bvcColSent.clear(i2);
        }
        if (bitVec == null || bitVec.length == 0) {
            this.bvcFound = false;
        } else {
            for (i2 = 0; i2 < bitVec.length; ++i2) {
                byte bvc = bitVec[i2];
                for (int bit = 0; bit < 8; ++bit) {
                    if ((bvc & 1 << bit) == 0) continue;
                    this.bvcColSent.set(i2 * 8 + bit);
                }
            }
            this.bvcFound = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector<IOException> marshal(byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bindIndicatorSubRange, byte[] byteBufferForCharConversion, DBConversion conversion, InputStream[] parameterStream, byte[][] parameterDatum, OracleTypeADT[] parameterOtype, byte[] ibtBindBytes, char[] ibtBindChars, short[] ibtBindIndicators, byte[] ioVector, int rowId, int[] oacmxlArr, boolean isPlsql, int[] returnParamMeta, int[] nbPostPonedColumnsInOut, int[][] indexOfPostPonedColumnInOut, boolean sendFirstPostPonedColumnOnly) throws IOException {
        Vector<IOException> ioExceptionsFromUserStream = null;
        try {
            int offsetCharData;
            int charPitch;
            int formOfUse;
            int nbOfBytes;
            int nbOfChars;
            int nullIndicator;
            int length;
            int nullOffset;
            int valueLengthOffset;
            int type;
            int subRangeOffset;
            int nbPostPonedColumnsAdjusted;
            this.marshalTTCcode();
            int number_of_bind_positions = bindIndicators[bindIndicatorSubRange + 0] & 0xFFFF;
            int nbOfStreams = 0;
            int nbPostPonedColumns = nbPostPonedColumnsInOut[0];
            int[] indexOfPostPonedColumn = indexOfPostPonedColumnInOut[0];
            int nbOfIbt = 0;
            if (sendFirstPostPonedColumnOnly) {
                nbPostPonedColumnsAdjusted = 1;
                assert (nbPostPonedColumns > 0) : "No postoned columns in RXD";
            } else {
                for (int P = 0; P < number_of_bind_positions; ++P) {
                    if (nbOfStreams < nbPostPonedColumns && indexOfPostPonedColumn[nbOfStreams] == P) {
                        ++nbOfStreams;
                        continue;
                    }
                    boolean marshalNullObjectForDmlReturning = false;
                    subRangeOffset = bindIndicatorSubRange + 5 + 10 * P;
                    type = bindIndicators[subRangeOffset + 0] & 0xFFFF;
                    if (ioVector != null && (ioVector[P] & 0x20) == 0) {
                        if (type != 998) continue;
                        ++nbOfIbt;
                        continue;
                    }
                    valueLengthOffset = ((bindIndicators[subRangeOffset + 7] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 8] & 0xFFFF) + rowId;
                    nullOffset = ((bindIndicators[subRangeOffset + 5] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 6] & 0xFFFF) + rowId;
                    length = bindIndicators[valueLengthOffset] & 0xFFFF;
                    nullIndicator = bindIndicators[nullOffset];
                    if (type == 116) {
                        this.meg.marshalUB1((short)1);
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (type == 994) {
                        nullIndicator = -1;
                        int dty = returnParamMeta[3 + P * 4 + 0];
                        if (dty == 109) {
                            marshalNullObjectForDmlReturning = true;
                        }
                    } else if (type == 8 || type == 24 || !isPlsql && oacmxlArr != null && oacmxlArr.length > P && oacmxlArr[P] > 4000) {
                        if (nbPostPonedColumns >= indexOfPostPonedColumn.length) {
                            int[] newindexOfPostPonedColumn = new int[indexOfPostPonedColumn.length << 1];
                            System.arraycopy(indexOfPostPonedColumn, 0, newindexOfPostPonedColumn, 0, indexOfPostPonedColumn.length);
                            indexOfPostPonedColumn = newindexOfPostPonedColumn;
                        }
                        indexOfPostPonedColumn[nbPostPonedColumns++] = P;
                        continue;
                    }
                    if (nullIndicator == -1) {
                        if (type == 109 || marshalNullObjectForDmlReturning) {
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalUB2(0);
                            this.meg.marshalUB4(0L);
                            this.meg.marshalUB2(1);
                            continue;
                        }
                        if (type == 998) {
                            ++nbOfIbt;
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (type == 112 || type == 113 || type == 114) {
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (type != 8 && type != 24) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                    }
                    if (type == 998) {
                        int nbOfElem = (ibtBindIndicators[6 + nbOfIbt * 8 + 4] & 0xFFFF) << 16 & 0xFFFF000 | ibtBindIndicators[6 + nbOfIbt * 8 + 5] & 0xFFFF;
                        int offsetValue = (ibtBindIndicators[6 + nbOfIbt * 8 + 6] & 0xFFFF) << 16 & 0xFFFF000 | ibtBindIndicators[6 + nbOfIbt * 8 + 7] & 0xFFFF;
                        int typeElem = ibtBindIndicators[6 + nbOfIbt * 8] & 0xFFFF;
                        int elemMaxLen = ibtBindIndicators[6 + nbOfIbt * 8 + 1] & 0xFFFF;
                        this.meg.marshalUB4(nbOfElem);
                        for (int i2 = 0; i2 < nbOfElem; ++i2) {
                            int offsetValueElem = offsetValue + i2 * elemMaxLen;
                            if (typeElem == 9) {
                                nbOfChars = ibtBindChars[offsetValueElem] / 2;
                                nbOfBytes = 0;
                                nbOfBytes = conversion.javaCharsToCHARBytes(ibtBindChars, offsetValueElem + 1, byteBufferForCharConversion, 0, nbOfChars);
                                this.meg.marshalCLR(byteBufferForCharConversion, nbOfBytes);
                                continue;
                            }
                            length = ibtBindBytes[offsetValueElem];
                            if (length < 1) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalCLR(ibtBindBytes, offsetValueElem + 1, length);
                        }
                        ++nbOfIbt;
                        continue;
                    }
                    int bytePitch = bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    if (bytePitch != 0) {
                        int offsetByteData = ((bindIndicators[subRangeOffset + 3] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 4] & 0xFFFF) + bytePitch * rowId;
                        if (type == 6) {
                            ++offsetByteData;
                            --length;
                        } else if (type == 9) {
                            offsetByteData += 2;
                            length -= 2;
                        } else if (type == 114 || type == 113 || type == 112) {
                            this.meg.marshalUB4(length);
                        }
                        if (type == 109 || type == 111) {
                            if (parameterDatum == null) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        T4CTTIrxd.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + -1 + "INTERNAL ERROR: oracle.jdbc.driver." + "T4CTTIrxd.marshal: parameterDatum is null");
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.marshal: parameterDatum is null");
                                __ex__.fillInStackTrace();
                                throw __ex__;
                            }
                            byte[] bytes = parameterDatum[P];
                            int n2 = length = bytes == null ? 0 : bytes.length;
                            if (type == 109) {
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalUB2(0);
                                this.meg.marshalUB4(length);
                                this.meg.marshalUB2(1);
                            }
                            if (length <= 0) continue;
                            this.meg.marshalCLR(bytes, 0, length);
                            continue;
                        }
                        if (type == 104) {
                            long[] rowid = T4CRowidAccessor.stringToRowid(bindBytes, offsetByteData += 2, 18);
                            short len = 14;
                            long rba = rowid[0];
                            int partitionID = (int)rowid[1];
                            short tableID = 0;
                            long blockNumber = rowid[2];
                            int slotNumber = (int)rowid[3];
                            if (rba == 0L && partitionID == 0 && blockNumber == 0L && slotNumber == 0) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalUB1(len);
                            this.meg.marshalUB4(rba);
                            this.meg.marshalUB2(partitionID);
                            this.meg.marshalUB1(tableID);
                            this.meg.marshalUB4(blockNumber);
                            this.meg.marshalUB2(slotNumber);
                            continue;
                        }
                        if (type == 208) {
                            this.meg.marshalUB4(length -= 2);
                            this.meg.marshalCLR(bindBytes, offsetByteData += 2, length);
                            continue;
                        }
                        if (length < 1) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        this.meg.marshalCLR(bindBytes, offsetByteData, length);
                        continue;
                    }
                    formOfUse = bindIndicators[subRangeOffset + 9] & 0xFFFF;
                    charPitch = bindIndicators[subRangeOffset + 2] & 0xFFFF;
                    offsetCharData = ((bindIndicators[subRangeOffset + 3] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 4] & 0xFFFF) + charPitch * rowId + 1;
                    if (type == 996) {
                        int nbOfCHARBytes = bindChars[offsetCharData - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < nbOfCHARBytes) {
                            this.bufferCHAR = new byte[nbOfCHARBytes];
                        }
                        for (int i3 = 0; i3 < nbOfCHARBytes; ++i3) {
                            this.bufferCHAR[i3] = (byte)((bindChars[offsetCharData + i3 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (i3 >= nbOfCHARBytes - '\u0001') continue;
                            this.bufferCHAR[i3 + 1] = (byte)(bindChars[offsetCharData + i3 / 2] & 0xFF & 0xFF);
                            ++i3;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, nbOfCHARBytes);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (type == 96) {
                        nbOfChars = length / 2;
                        --offsetCharData;
                    } else {
                        nbOfChars = (length - 2) / 2;
                    }
                    nbOfBytes = 0;
                    nbOfBytes = formOfUse == 2 ? conversion.javaCharsToNCHARBytes(bindChars, offsetCharData, byteBufferForCharConversion, 0, nbOfChars) : conversion.javaCharsToCHARBytes(bindChars, offsetCharData, byteBufferForCharConversion, 0, nbOfChars);
                    this.meg.marshalCLR(byteBufferForCharConversion, nbOfBytes);
                }
                nbPostPonedColumnsAdjusted = nbPostPonedColumns;
            }
            if (nbPostPonedColumns > 0) {
                for (int j2 = 0; j2 < nbPostPonedColumnsAdjusted; ++j2) {
                    InputStream currentStream;
                    int P = indexOfPostPonedColumn[j2];
                    subRangeOffset = bindIndicatorSubRange + 5 + 10 * P;
                    type = bindIndicators[subRangeOffset + 0] & 0xFFFF;
                    valueLengthOffset = ((bindIndicators[subRangeOffset + 7] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 8] & 0xFFFF) + rowId;
                    nullOffset = ((bindIndicators[subRangeOffset + 5] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 6] & 0xFFFF) + rowId;
                    nullIndicator = bindIndicators[nullOffset];
                    length = bindIndicators[valueLengthOffset] & 0xFFFF;
                    charPitch = bindIndicators[subRangeOffset + 2] & 0xFFFF;
                    offsetCharData = ((bindIndicators[subRangeOffset + 3] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 4] & 0xFFFF) + charPitch * rowId + 1;
                    if (nullIndicator == -1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (type == 996) {
                        int nbOfCHARBytes = bindChars[offsetCharData - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < nbOfCHARBytes) {
                            this.bufferCHAR = new byte[nbOfCHARBytes];
                        }
                        for (int i4 = 0; i4 < nbOfCHARBytes; ++i4) {
                            this.bufferCHAR[i4] = (byte)((bindChars[offsetCharData + i4 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (i4 >= nbOfCHARBytes - '\u0001') continue;
                            this.bufferCHAR[i4 + 1] = (byte)(bindChars[offsetCharData + i4 / 2] & 0xFF & 0xFF);
                            ++i4;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, nbOfCHARBytes);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (type != 8 && type != 24) {
                        if (type == 96) {
                            nbOfChars = length / 2;
                            --offsetCharData;
                        } else {
                            nbOfChars = (length - 2) / 2;
                        }
                        formOfUse = bindIndicators[subRangeOffset + 9] & 0xFFFF;
                        nbOfBytes = 0;
                        nbOfBytes = formOfUse == 2 ? conversion.javaCharsToNCHARBytes(bindChars, offsetCharData, byteBufferForCharConversion, 0, nbOfChars) : conversion.javaCharsToCHARBytes(bindChars, offsetCharData, byteBufferForCharConversion, 0, nbOfChars);
                        this.meg.marshalCLR(byteBufferForCharConversion, nbOfBytes);
                        continue;
                    }
                    int positionOfStream = P;
                    if (parameterStream == null || (currentStream = parameterStream[positionOfStream]) == null) continue;
                    int bufferLength = 64;
                    if (this.buffer == null) {
                        this.buffer = new byte[bufferLength];
                    }
                    int bytesRead = 0;
                    this.meg.marshalUB1((short)254);
                    boolean endOfStream = false;
                    while (!endOfStream && !this.connection.sentCancel) {
                        try {
                            bytesRead = currentStream.read(this.buffer, 0, bufferLength);
                        }
                        catch (IOException streamIOException) {
                            bytesRead = -1;
                            if (ioExceptionsFromUserStream == null) {
                                ioExceptionsFromUserStream = new Vector<IOException>();
                            }
                            ioExceptionsFromUserStream.add(streamIOException);
                        }
                        if (bytesRead == -1) {
                            endOfStream = true;
                        }
                        if (bytesRead <= 0) continue;
                        this.meg.marshalUB1((short)(bytesRead & 0xFF));
                        this.meg.marshalB1Array(this.buffer, 0, bytesRead);
                    }
                    this.meg.marshalUB1((short)0);
                }
            }
            nbPostPonedColumnsInOut[0] = nbPostPonedColumns;
            indexOfPostPonedColumnInOut[0] = indexOfPostPonedColumn;
        }
        catch (SQLException sqlex) {
            IOException ioex = new IOException();
            ioex.initCause(sqlex);
            throw ioex;
        }
        return ioExceptionsFromUserStream;
    }

    boolean unmarshal(Accessor[] accessors, int definesLength) throws SQLException, IOException {
        return this.unmarshal(accessors, 0, definesLength);
    }

    boolean unmarshal(Accessor[] accessors, int from_col, int definesLength) throws SQLException, IOException {
        if (from_col == 0) {
            this.isFirstCol = true;
        }
        for (int i2 = from_col; i2 < definesLength && i2 < accessors.length; ++i2) {
            if (accessors[i2] == null) continue;
            if (accessors[i2].physicalColumnIndex < 0) {
                int physicalIndex = 0;
                for (int j2 = 0; j2 < definesLength && j2 < accessors.length; ++j2) {
                    if (accessors[j2] == null) continue;
                    accessors[j2].physicalColumnIndex = physicalIndex++;
                    if (accessors[j2].isUseLess) continue;
                }
            }
            if (this.bvcFound && !accessors[i2].isUseLess && !this.bvcColSent.get(accessors[i2].physicalColumnIndex)) {
                accessors[i2].copyRow();
                continue;
            }
            byte columnMetaData = 0;
            if (accessors[i2].statement.statementType != 2 && !accessors[i2].statement.sqlKind.isPlsqlOrCall()) {
                int indexmetadata = accessors[i2].metaDataIndex + accessors[i2].lastRowProcessed * 1;
                if (accessors[i2].securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
                    columnMetaData = (byte)this.meg.unmarshalUB1();
                }
                accessors[i2].rowSpaceMetaData[indexmetadata] = columnMetaData;
            }
            if (accessors[i2].unmarshalOneRow()) {
                return true;
            }
            this.isFirstCol = false;
        }
        this.bvcFound = false;
        return false;
    }

    boolean unmarshal(Accessor[] accessors, int row_number, int from_col, int to_col) throws SQLException, IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIrxd.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIrxd.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIrxd.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIrxd"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

