/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.KeywordValueLongI;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.OracleConnection;

final class T4CTTIoxssro
extends T4CTTIfun {
    private int functionId;
    private byte[] sessionId = null;
    private KeywordValueLong[] inKV = null;
    private int inFlags;
    private KeywordValueLong[] outKV = null;
    private int outFlags = -1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIoxssro(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)156);
    }

    void doOXSSRO(int _functionId, byte[] _sessionId, KeywordValueLong[] _inKV, int _inFlags) throws IOException, SQLException {
        this.functionId = _functionId;
        this.sessionId = _sessionId;
        this.inKV = _inKV;
        this.inFlags = _inFlags;
        this.outKV = null;
        this.outFlags = -1;
        if (this.inKV != null) {
            for (int i2 = 0; i2 < this.inKV.length; ++i2) {
                ((KeywordValueLongI)this.inKV[i2]).doCharConversion(this.meg.conv);
            }
        }
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB4(this.functionId);
        boolean sendSessionId = false;
        if (this.sessionId != null && this.sessionId.length > 0) {
            sendSessionId = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.sessionId.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean sendInKV = false;
        if (this.inKV != null && this.inKV.length > 0) {
            sendInKV = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.inKV.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUB4(this.inFlags);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (sendSessionId) {
            this.meg.marshalB1Array(this.sessionId);
        }
        if (sendInKV) {
            for (int i2 = 0; i2 < this.inKV.length; ++i2) {
                ((KeywordValueLongI)this.inKV[i2]).marshal(this.meg);
            }
        }
    }

    KeywordValueLong[] getOutKV() {
        return this.outKV;
    }

    int getOutFlags() {
        return this.outFlags;
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int xsssoovn = (int)this.meg.unmarshalUB4();
        this.outKV = new KeywordValueLong[xsssoovn];
        for (int i2 = 0; i2 < xsssoovn; ++i2) {
            this.outKV[i2] = KeywordValueLongI.unmarshal(this.meg);
        }
        this.outFlags = (int)this.meg.unmarshalUB4();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoxssro.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoxssro.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoxssro.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoxssro"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

