/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;

final class T4CTTIoscid
extends T4CTTIfun {
    static final int KPDUSR_CID_RESET = 1;
    static final int KPDUSR_PROXY_RESET = 2;
    static final int KPDUSR_PROXY_TKTSENT = 4;
    static final int KPDUSR_MODULE_RESET = 8;
    static final int KPDUSR_ACTION_RESET = 16;
    static final int KPDUSR_EXECID_RESET = 32;
    static final int KPDUSR_EXECSQ_RESET = 64;
    static final int KPDUSR_COLLCT_RESET = 128;
    static final int KPDUSR_CLINFO_RESET = 256;
    private byte[] cidcid = null;
    private byte[] cidmod = null;
    private byte[] cidact = null;
    private byte[] cideci = null;
    private boolean[] endToEndHasChanged = null;
    private String[] endToEndValues = null;
    private int endToEndECIDSequenceNumber;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIoscid(T4CConnection _conn) {
        super(_conn, (byte)17);
        this.setFunCode((short)135);
    }

    void doOSCID(boolean[] _endToEndHasChanged, String[] _endToEndValues, int _endToEndECIDSequenceNumber) throws IOException, SQLException {
        this.endToEndHasChanged = _endToEndHasChanged;
        this.endToEndValues = _endToEndValues;
        this.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber;
        this.cidcid = (byte[])(this.endToEndValues[1] != null ? this.meg.conv.StringToCharBytes(this.endToEndValues[1]) : null);
        this.cidmod = (byte[])(this.endToEndValues[3] != null ? this.meg.conv.StringToCharBytes(this.endToEndValues[3]) : null);
        this.cidact = (byte[])(this.endToEndValues[0] != null ? this.meg.conv.StringToCharBytes(this.endToEndValues[0]) : null);
        this.cideci = (byte[])(this.endToEndValues[2] != null ? this.meg.conv.StringToCharBytes(this.endToEndValues[2]) : null);
        this.doPigRPC();
    }

    @Override
    void marshal() throws IOException {
        int cidflag = 64;
        if (this.endToEndHasChanged[0]) {
            cidflag |= 0x10;
        }
        if (this.endToEndHasChanged[1]) {
            cidflag |= 1;
        }
        if (this.endToEndHasChanged[2]) {
            cidflag |= 0x20;
        }
        if (this.endToEndHasChanged[3]) {
            cidflag |= 8;
        }
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(cidflag);
        boolean sendClientId = false;
        boolean sendModule = false;
        boolean sendAction = false;
        boolean sendEcid = false;
        if (this.endToEndHasChanged[1]) {
            this.meg.marshalPTR();
            if (this.cidcid != null) {
                this.meg.marshalUB4(this.cidcid.length);
            } else {
                this.meg.marshalUB4(0L);
            }
            sendClientId = true;
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.endToEndHasChanged[3]) {
            this.meg.marshalPTR();
            if (this.cidmod != null) {
                this.meg.marshalUB4(this.cidmod.length);
            } else {
                this.meg.marshalUB4(0L);
            }
            sendModule = true;
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.endToEndHasChanged[0]) {
            this.meg.marshalPTR();
            if (this.cidact != null) {
                this.meg.marshalUB4(this.cidact.length);
            } else {
                this.meg.marshalUB4(0L);
            }
            sendAction = true;
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.endToEndHasChanged[2]) {
            this.meg.marshalPTR();
            if (this.cideci != null) {
                this.meg.marshalUB4(this.cideci.length);
            } else {
                this.meg.marshalUB4(0L);
            }
            sendEcid = true;
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        this.meg.marshalUB2(0);
        this.meg.marshalUB2(this.endToEndECIDSequenceNumber);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        if (sendClientId && this.cidcid != null) {
            this.meg.marshalCHR(this.cidcid);
        }
        if (sendModule && this.cidmod != null) {
            this.meg.marshalCHR(this.cidmod);
        }
        if (sendAction && this.cidact != null) {
            this.meg.marshalCHR(this.cidact);
        }
        if (sendEcid && this.cideci != null) {
            this.meg.marshalCHR(this.cideci);
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoscid"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

