/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;

class T4CTTIoer
extends T4CTTIMsg {
    final int MAXERRBUF = 512;
    long curRowNumber;
    int retCode;
    int arrayElemWError;
    int arrayElemErrno;
    int currCursorID;
    short errorPosition;
    short sqlType;
    byte oerFatal;
    short flags;
    short userCursorOpt;
    short upiParam;
    short warningFlag;
    int osError;
    short stmtNumber;
    short callNumber;
    int pad1;
    long successIters;
    int partitionId;
    int tableId;
    int slotNumber;
    long rba;
    long blockNumber;
    int warnLength = 0;
    int warnFlag = 0;
    int[] errorLength = new int[1];
    byte[] errorMsg;
    static final int ORA1403 = 1403;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIoer(T4CConnection _conn) {
        super(_conn, (byte)4);
    }

    void init() {
        this.retCode = 0;
        this.errorMsg = null;
    }

    int unmarshal() throws IOException, SQLException {
        if (this.connection.getTTCVersion() >= 3) {
            short _endToEndECIDSequenceNumber;
            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
        }
        this.curRowNumber = this.meg.unmarshalUB4();
        this.retCode = this.meg.unmarshalUB2();
        this.arrayElemWError = this.meg.unmarshalUB2();
        this.arrayElemErrno = this.meg.unmarshalUB2();
        this.currCursorID = this.meg.unmarshalUB2();
        this.errorPosition = this.meg.unmarshalSB2();
        this.sqlType = this.meg.unmarshalUB1();
        this.oerFatal = this.meg.unmarshalSB1();
        this.flags = this.meg.unmarshalSB1();
        this.userCursorOpt = this.meg.unmarshalSB1();
        this.upiParam = this.meg.unmarshalUB1();
        this.warningFlag = this.meg.unmarshalUB1();
        this.rba = this.meg.unmarshalUB4();
        this.partitionId = this.meg.unmarshalUB2();
        this.tableId = this.meg.unmarshalUB1();
        this.blockNumber = this.meg.unmarshalUB4();
        this.slotNumber = this.meg.unmarshalUB2();
        this.osError = this.meg.unmarshalSWORD();
        this.stmtNumber = this.meg.unmarshalUB1();
        this.callNumber = this.meg.unmarshalUB1();
        this.pad1 = this.meg.unmarshalUB2();
        this.successIters = this.meg.unmarshalUB4();
        byte[] oerrdd = this.meg.unmarshalDALC();
        int oerrarl = this.meg.unmarshalUB2();
        for (int i2 = 0; i2 < oerrarl; ++i2) {
            this.meg.unmarshalUB2();
        }
        int oerepal = (int)this.meg.unmarshalUB4();
        for (int i3 = 0; i3 < oerepal; ++i3) {
            this.meg.unmarshalUB4();
        }
        int oermarl = this.meg.unmarshalUB2();
        if (this.retCode != 0) {
            this.errorMsg = this.meg.unmarshalCLRforREFS();
            this.errorLength[0] = this.errorMsg.length;
        }
        return this.currCursorID;
    }

    void unmarshalWarning() throws IOException, SQLException {
        this.retCode = this.meg.unmarshalUB2();
        this.warnLength = this.meg.unmarshalUB2();
        this.warnFlag = this.meg.unmarshalUB2();
        if (this.retCode != 0 && this.warnLength > 0) {
            this.errorMsg = this.meg.unmarshalCHR(this.warnLength);
            this.errorLength[0] = this.warnLength;
        }
    }

    void print() throws SQLException {
        if (!TRACE || this.warnFlag != 0) {
            // empty if block
        }
        if (this.retCode != 0 || this.warnFlag != 0) {
            // empty if block
        }
    }

    void processError() throws SQLException {
        this.processError(true);
    }

    void processError(boolean throwException) throws SQLException {
        this.processError(throwException, null);
    }

    void processError(OracleStatement stmt) throws SQLException {
        this.processError(true, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processError(boolean throwException, OracleStatement stmt) throws SQLException {
        int wrn;
        if (stmt != null) {
            stmt.numberOfExecutedElementsInBatch = (int)this.successIters;
        }
        if (this.retCode != 0) {
            switch (this.retCode) {
                case 28: 
                case 600: 
                case 1012: 
                case 1041: 
                case 3113: 
                case 3114: {
                    this.connection.internalClose();
                    break;
                }
                case 902: {
                    this.connection.removeAllDescriptor();
                }
            }
            if (throwException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTTIoer.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true) + this.retCode);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), this.retCode);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            return;
        }
        if (!throwException) {
            return;
        }
        if ((this.warningFlag & 1) == 1 && (((wrn = this.warningFlag & 0xFFFFFFFE) & 0x20) == 32 || (wrn & 4) == 4)) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoer.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 110);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 110);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.connection != null && this.connection.plsqlCompilerWarnings && (this.flags & 4) == 4) {
            stmt.foundPlsqlCompilerWarning();
        }
    }

    void processWarning() throws SQLException {
        if (this.retCode != 0) {
            throw DatabaseError.newSqlWarning(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), this.retCode);
        }
    }

    int getCurRowNumber() throws SQLException {
        return (int)this.curRowNumber;
    }

    int getRetCode() {
        return this.retCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateChecksum(long _checkSum) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_checkSum));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            _checkSum = CRC64.updateChecksum(_checkSum, this.retCode);
            _checkSum = CRC64.updateChecksum(_checkSum, this.curRowNumber);
            _checkSum = CRC64.updateChecksum(_checkSum, this.errorPosition);
            _checkSum = CRC64.updateChecksum(_checkSum, this.sqlType);
            _checkSum = CRC64.updateChecksum(_checkSum, this.oerFatal);
            _checkSum = CRC64.updateChecksum(_checkSum, this.flags);
            _checkSum = CRC64.updateChecksum(_checkSum, this.userCursorOpt);
            _checkSum = CRC64.updateChecksum(_checkSum, this.upiParam);
            _checkSum = CRC64.updateChecksum(_checkSum, this.warningFlag);
            _checkSum = CRC64.updateChecksum(_checkSum, this.osError);
            _checkSum = CRC64.updateChecksum(_checkSum, this.successIters);
            long __result__ = _checkSum = CRC64.updateChecksum(_checkSum, this.errorMsg, 0, this.errorMsg.length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoer.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoer"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

