/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIoac {
    static final short UACFIND = 1;
    static final short UACFALN = 2;
    static final short UACFRCP = 4;
    static final short UACFBBV = 8;
    static final short UACFNCP = 16;
    static final short UACFBLP = 32;
    static final short UACFARR = 64;
    static final short UACFIGN = 128;
    static final int UACFNSCL = 1;
    static final int UACFBUC = 2;
    static final int UACFSKP = 4;
    static final int UACFCHRCNT = 8;
    static final int UACFNOADJ = 16;
    static final int UACFCUS = 4096;
    static final int UACFLSZ = 0x2000000;
    static final int UACFVFSP = 0x8000000;
    static final byte[] NO_BYTES = new byte[0];
    int oaccsi;
    short oaccsfrm;
    static int maxBindArrayLength;
    T4CMAREngine meg;
    T4CConnection connection;
    short oacdty;
    short oacflg;
    short oacpre;
    short oacscl;
    int oacmxl;
    int oacmxlc;
    int oacmal;
    int oacfl2;
    byte[] oactoid;
    int oactoidl;
    int oacvsn;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    T4CTTIoac(T4CConnection _connection) {
        this.connection = _connection;
        this.meg = this.connection.mare;
        this.oactoid = NO_BYTES;
    }

    void init(short _type, int _oacmxl) {
        this.oacdty = _type == 9 || _type == 1 || _type == 996 ? (short)1 : (_type == 104 ? (short)11 : (_type == 6 || _type == 2 ? (short)2 : (_type == 15 ? (short)23 : (_type == 116 ? (short)102 : _type))));
        if (this.oacdty == 1 || this.oacdty == 96) {
            this.oacfl2 = 16;
        }
        this.oacmxl = this.oacdty == 102 ? 1 : _oacmxl;
        this.oacflg = (short)3;
    }

    boolean isOldSufficient(T4CTTIoac _oac) {
        boolean isSame = false;
        if (this.oactoidl != 0 || _oac.oactoidl != 0) {
            return false;
        }
        if (this.oaccsi == _oac.oaccsi && this.oaccsfrm == _oac.oaccsfrm && this.oacdty == _oac.oacdty && this.oacflg == _oac.oacflg && this.oacpre == _oac.oacpre && this.oacscl <= _oac.oacscl && (this.oacmxl == _oac.oacmxl || _oac.oacmxl > this.oacmxl && _oac.oacmxl < 4000) && this.oacmxlc == _oac.oacmxlc && this.oacmal == _oac.oacmal && this.oacfl2 == _oac.oacfl2 && this.oacvsn == _oac.oacvsn) {
            isSame = true;
        }
        return isSame;
    }

    boolean isNType() {
        boolean ret = this.oaccsfrm == 2;
        return ret;
    }

    void unmarshal() throws IOException, SQLException {
        this.oacdty = this.meg.unmarshalUB1();
        this.oacflg = this.meg.unmarshalUB1();
        this.oacpre = this.meg.unmarshalUB1();
        this.oacscl = this.meg.unmarshalSB1();
        this.oacmxl = this.meg.unmarshalSB4();
        this.oacmal = this.meg.unmarshalSB4();
        this.oacfl2 = this.meg.unmarshalSB4();
        this.oactoid = this.meg.unmarshalDALC();
        this.oactoidl = this.oactoid == null ? 0 : this.oactoid.length;
        this.oacvsn = this.meg.unmarshalUB2();
        this.oaccsi = this.meg.unmarshalUB2();
        this.oaccsfrm = this.meg.unmarshalUB1();
        if (this.connection.getTTCVersion() >= 2) {
            this.oacmxlc = (int)this.meg.unmarshalUB4();
        }
        if (this.oacmxl > 0) {
            switch (this.oacdty) {
                case 2: {
                    this.oacmxl = 22;
                    break;
                }
                case 12: {
                    this.oacmxl = 7;
                    break;
                }
                case 181: {
                    this.oacmxl = 13;
                }
            }
        }
    }

    void setMal(int _oacmal) {
        this.oacmal = _oacmal;
    }

    void addFlg(short flag) {
        this.oacflg = (short)(this.oacflg | flag);
    }

    void addFlg2(int flag) {
        this.oacfl2 |= flag;
    }

    void setFormOfUse(short _oaccsfrm) {
        this.oaccsfrm = _oaccsfrm;
    }

    void setCharset(int _cs) {
        this.oaccsi = _cs;
    }

    void setMxlc(int _oacmxlc) {
        this.oacmxlc = _oacmxlc;
    }

    void setPrecision(short _oacpre) {
        this.oacpre = _oacpre;
    }

    void setTimestampFractionalSecondsPrecision(short _oacfspre) {
        this.oacscl = _oacfspre;
    }

    void setADT(OracleTypeADT otype) {
        this.oactoid = otype.getTOID();
        this.oacvsn = otype.getTypeVersion();
        this.oaccsi = 2;
        this.oaccsfrm = (short)otype.getCharSetForm();
    }

    void marshal() throws IOException {
        this.meg.marshalUB1(this.oacdty);
        this.meg.marshalUB1(this.oacflg);
        this.meg.marshalUB1(this.oacpre);
        if (this.oacdty == 2 || this.oacdty == 180 || this.oacdty == 181 || this.oacdty == 231 || this.oacdty == 183) {
            this.meg.marshalUB2(this.oacscl);
        } else {
            this.meg.marshalUB1(this.oacscl);
        }
        this.meg.marshalUB4(this.oacmxl);
        this.meg.marshalSB4(this.oacmal);
        this.meg.marshalSB4(this.oacfl2);
        this.meg.marshalDALC(this.oactoid);
        this.meg.marshalUB2(this.oacvsn);
        this.meg.marshalUB2(this.oaccsi);
        this.meg.marshalUB1(this.oaccsfrm);
        if (this.connection.getTTCVersion() >= 2) {
            this.meg.marshalUB4(this.oacmxlc);
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoac"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

