/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.NetOutputStream;

class T4CSocketOutputStreamWrapper
extends NetOutputStream {
    static final int MAX_BUFFER_SIZE = 2048;
    NetOutputStream os = null;
    byte[] buffer = new byte[2048];
    int bIndex = 0;

    T4CSocketOutputStreamWrapper(NetOutputStream _os) throws IOException {
        this.os = _os;
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.bIndex + 1 >= 2048) {
            this.flush();
        }
        this.buffer[this.bIndex++] = (byte)(b2 & 0xFF);
    }

    @Override
    public void write(byte[] b2, int offset, int length) throws IOException {
        if (length > 2048) {
            this.flush();
            this.os.write(b2, offset, length);
        } else if (this.bIndex + length < 2048) {
            System.arraycopy(b2, offset, this.buffer, this.bIndex, length);
            this.bIndex += length;
        } else {
            this.flush();
            System.arraycopy(b2, offset, this.buffer, this.bIndex, length);
            this.bIndex += length;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(false);
    }

    public void flush(boolean needToFlush) throws IOException {
        if (this.bIndex > 0) {
            this.os.write(this.buffer, 0, this.bIndex);
            this.bIndex = 0;
        }
        if (needToFlush) {
            this.os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        super.close();
    }

    @Override
    public void writeZeroCopyIO(byte[] userBuffer, int offset, int length) throws IOException, NetException, BreakNetException {
        this.flush(true);
        this.os.writeZeroCopyIO(userBuffer, offset, length);
    }
}

