/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.internal.OracleStatement;

class T4CPreparedStatement
extends OraclePreparedStatement {
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CPreparedStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn, sql, conn.defaultExecuteBatch, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.nbPostPonedColumns = new int[1];
            this.nbPostPonedColumns[0] = 0;
            this.indexOfPostPonedColumn = new int[1][3];
            this.t4Connection = (T4CConnection)conn;
            this.theRowidBinder = theStaticT4CRowidBinder;
            this.theRowidNullBinder = theStaticT4CRowidNullBinder;
            this.theURowidBinder = theStaticT4CURowidBinder;
            this.theURowidNullBinder = theStaticT4CURowidNullBinder;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOall8(boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe, boolean doDefine) throws SQLException, IOException {
        int i2;
        if (doParse || doDescribe || !doExecute) {
            this.oacdefSent = null;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.doOall8");
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 439 + "sqlKind = " + (Object)((Object)this.sqlKind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 439, "sqlKind = " + (Object)((Object)this.sqlKind));
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (doFetch) {
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
        int number_of_define_positions_local = this.numberOfDefinePositions;
        if (this.sqlKind.isDML()) {
            number_of_define_positions_local = 0;
        }
        if (this.accessors != null) {
            for (i2 = 0; i2 < this.accessors.length; ++i2) {
                if (this.accessors[i2] == null) continue;
                this.accessors[i2].lastRowProcessed = 0;
            }
        }
        if (this.outBindAccessors != null) {
            for (i2 = 0; i2 < this.outBindAccessors.length; ++i2) {
                if (this.outBindAccessors[i2] == null) continue;
                this.outBindAccessors[i2].lastRowProcessed = 0;
            }
        }
        if (this.returnParamAccessors != null) {
            for (i2 = 0; i2 < this.returnParamAccessors.length; ++i2) {
                if (this.returnParamAccessors[i2] == null) continue;
                this.returnParamAccessors[i2].lastRowProcessed = 0;
            }
        }
        if (this.bindIndicators != null) {
            int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            int maxNbBytes = 0;
            if (this.ibtBindChars != null) {
                maxNbBytes = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            for (int P = 0; P < this.numberOfBindPositions; ++P) {
                int subRangeOffset = this.bindIndicatorSubRange + 5 + 10 * P;
                int charPitch = this.bindIndicators[subRangeOffset + 2] & 0xFFFF;
                if (charPitch == 0) continue;
                int formOfUse = this.bindIndicators[subRangeOffset + 9] & 0xFFFF;
                maxNbBytes = formOfUse == 2 ? Math.max(charPitch * this.connection.conversion.maxNCharSize, maxNbBytes) : Math.max(charPitch * this.connection.conversion.cMaxCharSize, maxNbBytes);
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[maxNbBytes];
            } else if (this.tmpBindsByteArray.length < maxNbBytes) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[maxNbBytes];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
        int[] definedColumnTypeCopy = this.definedColumnType;
        int[] definedColumnSizeCopy = this.definedColumnSize;
        int[] definedColumnFormOfUseCopy = this.definedColumnFormOfUse;
        if (doDefine && doDescribe && this.sqlObject.includeRowid) {
            definedColumnTypeCopy = new int[this.definedColumnType.length + 1];
            System.arraycopy(this.definedColumnType, 0, definedColumnTypeCopy, 1, this.definedColumnType.length);
            definedColumnTypeCopy[0] = -8;
            definedColumnSizeCopy = new int[this.definedColumnSize.length + 1];
            System.arraycopy(this.definedColumnSize, 0, definedColumnSizeCopy, 1, this.definedColumnSize.length);
            definedColumnFormOfUseCopy = new int[this.definedColumnFormOfUse.length + 1];
            System.arraycopy(this.definedColumnFormOfUse, 0, definedColumnFormOfUseCopy, 1, this.definedColumnFormOfUse.length);
        }
        this.allocateTmpByteArray();
        T4C8Oall all8 = this.t4Connection.all8;
        this.t4Connection.sendPiggyBackedMessages();
        try {
            all8.doOALL(doParse, doExecute, doFetch, doDescribe, doDefine, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), this.rowPrefetch, this.outBindAccessors, this.numberOfBindPositions, this.accessors, number_of_define_positions_local, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, this.parameterDatum, this.parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, definedColumnTypeCopy, definedColumnSizeCopy, definedColumnFormOfUseCopy, this.registration);
            int tmpCursorID = all8.getCursorId();
            if (tmpCursorID != 0) {
                this.cursorId = tmpCursorID;
            }
            this.oacdefSent = all8.oacdefBindsSent;
        }
        catch (SQLException ea) {
            int tmpCursorID = all8.getCursorId();
            if (tmpCursorID != 0) {
                this.cursorId = tmpCursorID;
            }
            if (ea.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw ea;
        }
    }

    @Override
    void allocateTmpByteArray() {
        if (this.tmpByteArray == null) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else if (this.sizeTmpByteArray > this.tmpByteArray.length) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void releaseBuffers() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            super.releaseBuffers();
            this.tmpByteArray = null;
            this.tmpBindsByteArray = null;
            this.t4Connection.all8.bindChars = null;
            this.t4Connection.all8.bindBytes = null;
            this.t4Connection.all8.tmpBindsByteArray = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void allocateRowidAccessor() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reparseOnRedefineIfNeeded() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.needToParse = true;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void defineColumnTypeInternal(int column_index, int type, int size, short form, boolean sizeNotGiven, String typeName) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(sizeNotGiven) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.connection.disableDefinecolumntype) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "T4CStatement.defineColumnTypeInternal--DISABLED");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            if (type == -15 || type == -9 || type == -16) {
                form = (short)2;
            }
            if (column_index < 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (sizeNotGiven) {
                if (type == 1 || type == 12 || type == -15 || type == -9) {
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
                }
            } else if (size < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 53);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.currentResultSet != null && !this.currentResultSet.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 28);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 28);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int idx = column_index - 1;
            if (this.definedColumnType == null || this.definedColumnType.length <= idx) {
                if (this.definedColumnType == null) {
                    this.definedColumnType = new int[(idx + 1) * 4];
                } else {
                    int[] n_definedColumnType = new int[(idx + 1) * 4];
                    System.arraycopy(this.definedColumnType, 0, n_definedColumnType, 0, this.definedColumnType.length);
                    this.definedColumnType = n_definedColumnType;
                }
            }
            this.definedColumnType[idx] = type;
            if (this.definedColumnSize == null || this.definedColumnSize.length <= idx) {
                if (this.definedColumnSize == null) {
                    this.definedColumnSize = new int[(idx + 1) * 4];
                } else {
                    int[] n_definedColumnSize = new int[(idx + 1) * 4];
                    System.arraycopy(this.definedColumnSize, 0, n_definedColumnSize, 0, this.definedColumnSize.length);
                    this.definedColumnSize = n_definedColumnSize;
                }
            }
            this.definedColumnSize[idx] = size;
            if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= idx) {
                if (this.definedColumnFormOfUse == null) {
                    this.definedColumnFormOfUse = new int[(idx + 1) * 4];
                } else {
                    int[] n_definedColumnFormOfUse = new int[(idx + 1) * 4];
                    System.arraycopy(this.definedColumnFormOfUse, 0, n_definedColumnFormOfUse, 0, this.definedColumnFormOfUse.length);
                    this.definedColumnFormOfUse = n_definedColumnFormOfUse;
                }
            }
            this.definedColumnFormOfUse[idx] = form;
            if (this.accessors != null && idx < this.accessors.length && this.accessors[idx] != null) {
                this.accessors[idx].definedColumnSize = size;
                if (!(this.accessors[idx].internalType != 96 && this.accessors[idx].internalType != 1 || type != 1 && type != 12 || size > this.accessors[idx].oacmxl)) {
                    this.needToPrepareDefineBuffer = true;
                    this.columnsDefinedByUser = true;
                    this.accessors[idx].initForDataAccess(type, size, null);
                    this.accessors[idx].calculateSizeTmpByteArray();
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                super.clearDefines();
                this.definedColumnType = null;
                this.definedColumnSize = null;
                this.definedColumnFormOfUse = null;
                this.t4Connection.all8.definesAccessors = null;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void saveDefineBuffersIfRequired(char[] tmpDefineChars, byte[] tmpDefineBytes, short[] tmpDefineIndicators, boolean isIndicatorsReused) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            int i2;
            boolean growing;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tmpDefineChars) + ", " + OracleLog.argument(tmpDefineBytes) + ", " + OracleLog.argument(tmpDefineIndicators) + ", " + OracleLog.argument(isIndicatorsReused));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            boolean bl = growing = this.rowPrefetchInLastFetch < this.rowPrefetch;
            if (isIndicatorsReused) {
                int i3;
                tmpDefineIndicators = new short[this.defineIndicators.length];
                int lengthIndex = this.accessors[0].lengthIndexLastRow;
                int indicatorIndex = this.accessors[0].indicatorIndexLastRow;
                int n2 = i3 = growing ? this.accessors.length : 1;
                while (growing ? i3 >= 1 : i3 <= this.accessors.length) {
                    int length = lengthIndex + this.rowPrefetchInLastFetch * i3 - 1;
                    int indicator = indicatorIndex + this.rowPrefetchInLastFetch * i3 - 1;
                    tmpDefineIndicators[indicator] = this.defineIndicators[indicator];
                    tmpDefineIndicators[length] = this.defineIndicators[length];
                    i3 += growing ? -1 : 1;
                }
            }
            int n3 = i2 = growing ? this.accessors.length - 1 : 0;
            while (growing ? i2 > -1 : i2 < this.accessors.length) {
                this.accessors[i2].saveDataFromOldDefineBuffers(tmpDefineBytes, tmpDefineChars, tmpDefineIndicators, this.rowPrefetchInLastFetch != -1 ? this.rowPrefetchInLastFetch : this.rowPrefetch, this.rowPrefetch);
                i2 += growing ? -1 : 1;
            }
            super.saveDefineBuffersIfRequired(tmpDefineChars, tmpDefineBytes, tmpDefineIndicators, isIndicatorsReused);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doSetSnapshotSCN(long scn) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(scn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.inScn = scn;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean forBind) throws SQLException {
        __ol_nanos__ = 0L;
        try {
            if (T4CPreparedStatement.TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(col_index) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            result /* !! */  = null;
            switch (internal_type) {
                case 96: {
                    result /* !! */  = new T4CCharAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 8: {
                    if (!forBind) {
                        result /* !! */  = new T4CLongAccessor(this, col_index, max_len, form, external_type, this.t4Connection.mare);
                        break;
                    }
                }
                case 1: {
                    result /* !! */  = new T4CVarcharAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 2: {
                    result /* !! */  = new T4CNumberAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 6: {
                    result /* !! */  = new T4CVarnumAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 24: {
                    if (!forBind) {
                        result /* !! */  = new T4CLongRawAccessor(this, col_index, max_len, form, external_type, this.t4Connection.mare);
                        break;
                    }
                }
                case 23: {
                    if (!forBind || typeName == null) ** GOTO lbl47
                    if (T4CPreparedStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + external_type);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    __ex__.fillInStackTrace();
                    throw __ex__;
lbl47:
                    // 1 sources

                    if (forBind) {
                        result /* !! */  = new T4COutRawAccessor(this, max_len, form, external_type, this.t4Connection.mare);
                        break;
                    }
                    result /* !! */  = new T4CRawAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 100: {
                    result /* !! */  = new T4CBinaryFloatAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 101: {
                    result /* !! */  = new T4CBinaryDoubleAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 104: {
                    if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
                        result /* !! */  = new T4CVarcharAccessor(this, 18, form, external_type, forBind, this.t4Connection.mare);
                        result /* !! */ .definedColumnType = -8;
                        break;
                    }
                    result /* !! */  = new T4CRowidAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 102: {
                    result /* !! */  = new T4CResultSetAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 12: {
                    result /* !! */  = new T4CDateAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 113: {
                    result /* !! */  = new T4CBlobAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 112: {
                    result /* !! */  = new T4CClobAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 114: {
                    result /* !! */  = new T4CBfileAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 109: {
                    result /* !! */  = new T4CNamedTypeAccessor(this, typeName, form, external_type, forBind, this.t4Connection.mare);
                    result /* !! */ .initMetadata();
                    break;
                }
                case 111: {
                    result /* !! */  = new T4CRefTypeAccessor(this, typeName, form, external_type, forBind, this.t4Connection.mare);
                    result /* !! */ .initMetadata();
                    break;
                }
                case 180: {
                    result /* !! */  = new T4CTimestampAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 181: {
                    result /* !! */  = new T4CTimestamptzAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 231: {
                    result /* !! */  = new T4CTimestampltzAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 182: {
                    result /* !! */  = new T4CIntervalymAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 183: {
                    result /* !! */  = new T4CIntervaldsAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 995: {
                    if (T4CPreparedStatement.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 89);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (T4CPreparedStatement.TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result /* !! */ );
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var11_14 = result /* !! */ ;
            return var11_14;
        }
        finally {
            if (T4CPreparedStatement.TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doDescribe(boolean includeNames) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(includeNames));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (!this.isOpen) {
                this.connection.open(this);
                this.isOpen = true;
            }
            try {
                this.t4Connection.needLine();
                this.t4Connection.sendPiggyBackedMessages();
                this.t4Connection.describe.doODNY(this, 0, this.accessors, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals));
                this.accessors = this.t4Connection.describe.getAccessors();
                this.numberOfDefinePositions = this.t4Connection.describe.numuds;
                for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                    this.accessors[i2].initMetadata();
                }
            }
            catch (IOException ex) {
                ((T4CConnection)this.connection).handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.describedWithNames = true;
            this.described = true;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForDescribe() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.execute_for_describe");
            try {
                if (this.t4Connection.useFetchSizeWithLongColumn) {
                    this.doOall8(true, true, true, true, false);
                } else {
                    this.doOall8(true, true, false, true, this.definedColumnType != null);
                }
            }
            catch (SQLException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "oracle.jdbc.driver.T4CPreparedStatement.parseExecuteDescribe: throwing " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw e2;
            }
            catch (IOException e3) {
                ((T4CConnection)this.connection).handleIOException(e3);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
                this.validRows = this.t4Connection.all8.getNumRows();
            }
            this.needToParse = false;
            if (this.connection.calculateChecksum) {
                if (this.validRows > 0) {
                    this.calculateCheckSum();
                } else if (this.rowsProcessed > 0) {
                    long _checkSum;
                    this.checkSum = _checkSum = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
                }
            }
            if (this.definedColumnType == null) {
                this.implicitDefineForLobPrefetchDone = false;
            }
            this.aFetchWasDoneDuringDescribe = false;
            if (this.t4Connection.all8.aFetchWasDone) {
                this.aFetchWasDoneDuringDescribe = true;
                this.rowPrefetchInLastFetch = this.rowPrefetch;
            }
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                this.accessors[i2].initMetadata();
            }
            this.needToPrepareDefineBuffer = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForRows(boolean executed_for_describe) throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(executed_for_describe));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            try {
                try {
                    boolean sendDefine = false;
                    if (this.columnsDefinedByUser) {
                        this.needToPrepareDefineBuffer = false;
                    } else if (this.t4Connection.useLobPrefetch && this.accessors != null && this.defaultLobPrefetchSize != -1 && !this.implicitDefineForLobPrefetchDone && !this.aFetchWasDoneDuringDescribe && this.definedColumnType == null) {
                        boolean oneColumnIsALob = false;
                        int[] tempDefinedColumnType = new int[this.accessors.length];
                        int[] tempDefinedColumnSize = new int[this.accessors.length];
                        for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                            tempDefinedColumnType[i2] = this.getJDBCType(this.accessors[i2].internalType);
                            if (this.accessors[i2].internalType != 113 && this.accessors[i2].internalType != 112 && this.accessors[i2].internalType != 114) continue;
                            oneColumnIsALob = true;
                            this.accessors[i2].lobPrefetchSizeForThisColumn = this.defaultLobPrefetchSize;
                            tempDefinedColumnSize[i2] = this.defaultLobPrefetchSize;
                        }
                        if (oneColumnIsALob) {
                            this.definedColumnType = tempDefinedColumnType;
                            this.definedColumnSize = tempDefinedColumnSize;
                            sendDefine = true;
                        }
                    }
                    this.doOall8(this.needToParse, !executed_for_describe, true, false, sendDefine);
                    this.needToParse = false;
                    if (sendDefine) {
                        this.implicitDefineForLobPrefetchDone = true;
                    }
                }
                finally {
                    this.validRows = this.t4Connection.all8.getNumRows();
                }
            }
            catch (SQLException e2) {
                throw e2;
            }
            catch (IOException e3) {
                ((T4CConnection)this.connection).handleIOException(e3);
                this.calculateCheckSum();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void fetch() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.streamList != null) {
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        ((T4CConnection)this.connection).handleIOException(exc);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            try {
                this.doOall8(false, false, true, false, false);
                this.validRows = this.t4Connection.all8.getNumRows();
            }
            catch (IOException ex) {
                ((T4CConnection)this.connection).handleIOException(ex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
        this.calculateCheckSum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void continueReadRow(int start) throws SQLException {
        block23: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(start));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                try {
                    if (!this.connection.useFetchSizeWithLongColumn) {
                        T4C8Oall all8 = this.t4Connection.all8;
                        all8.continueReadRow(start, this);
                    }
                }
                catch (IOException ex) {
                    ((T4CConnection)this.connection).handleIOException(ex);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + ex);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (SQLException ea) {
                    if (ea.getErrorCode() == DatabaseError.getVendorCode(110)) {
                        this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
                        break block23;
                    }
                    throw ea;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doClose() throws SQLException {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.do_close");
            if (this.cursorId != 0) {
                this.t4Connection.closeCursor(this.cursorId);
            }
            this.tmpByteArray = null;
            this.tmpBindsByteArray = null;
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
            this.oacdefSent = null;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeQuery() throws SQLException {
        block21: {
            long __ol_nanos__ = 0L;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    __ol_nanos__ = System.nanoTime();
                }
                this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.closeQuery");
                if (this.streamList == null) break block21;
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        ((T4CConnection)this.connection).handleIOException(exc);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + exc);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Binder getRowidNullBinder(int index) {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(index));
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
                this.currentRowCharLens[index] = 1;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.theVarcharNullBinder);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Binder binder = this.theVarcharNullBinder;
                return binder;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.theRowidNullBinder);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Binder binder = this.theRowidNullBinder;
            return binder;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doLocalInitialization() {
        long __ol_nanos__ = 0L;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
                __ol_nanos__ = System.nanoTime();
            }
            super.doLocalInitialization();
            this.t4Connection.all8.bindChars = this.bindChars;
            this.t4Connection.all8.bindBytes = this.bindBytes;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit" + " [" + (double)(System.nanoTime() - __ol_nanos__) / 1000000.0 + "ms]");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CPreparedStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

